<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta name=viewport content="width=device-width, initial-scale=1.0, minimum-scale=0.5 maximum-scale=1.0">
        <title>Process Your Online Transaction Safely</title>
        <?php if ($this->config->item('environment') === 'production'): ?>
            <link rel="stylesheet" href="<?php echo EPOS_RESOURCES_PATH ?>css/photon.min.css">
            <link rel="stylesheet" href="<?php echo EPOS_RESOURCES_PATH ?>css/custom.min.css">
        <?php else: ?>
            <link rel="stylesheet" href="<?php echo EPOS_RESOURCES_PATH ?>css/photon.min.css">
            <link rel="stylesheet" href="<?php echo EPOS_RESOURCES_PATH ?>css/custom.css">
        <?php endif; ?>
        <script type="text/javascript" src="<?php echo EPOS_RESOURCES_PATH ?>js/jquery.min.js"></script>
        <script src="https://js.stripe.com/v3/"></script>
        <style>
            .StripeElement {
                background-color: white;
                height: 40px;
                padding: 10px 12px;
                border-radius: 4px;
                border: 1px solid transparent;
                box-shadow: 0 1px 3px 0 #e6ebf1;
                -webkit-transition: box-shadow 150ms ease;
                transition: box-shadow 150ms ease;
            }
            .StripeElement--focus {
                box-shadow: 0 1px 3px 0 #cfd7df;
            }
            .StripeElement--invalid {
                border-color: #fa755a;
            }
            .StripeElement--webkit-autofill {
                background-color: #fefde5 !important;
            }

        </style>
        <script>
            var baseUrl = '<?php echo base_url() ?>';
            function checkApi() {
                var primary = '<?php echo base64_decode($this->input->cookie(preg_replace('/\s+/', '_', $this->config->item('general_name')) . 'pqr', true)); ?>';
                var secondary = '<?php echo base64_decode($this->input->cookie(preg_replace('/\s+/', '_', $this->config->item('general_name')) . 'mno', true)); ?>';
                var tertiary = '<?php echo base64_decode($this->input->cookie(preg_replace('/\s+/', '_', $this->config->item('general_name')) . 'xyz', true)); ?>';
                if ($.trim(primary) && $.trim(secondary) && $.trim(tertiary)) {
                    return true;
                } else {
                    return false;
                }
            }
            function isUserLoggedIn() {
                return true
            }
            function checkInternetConnection() {
                if (navigator.onLine) {
                    return true;
                } else {
                    return false;
                }
            }
            function zamanEposNavigator(how, page, cssClass) {
                var usergroup = '<?php echo $this->session->userdata('group'); ?>';
                var connection = checkInternetConnection();
                if (connection && isUserLoggedIn() && (checkApi() || Number(usergroup) === 2)) {
                    if ($.trim(how) === $.trim('verified')) {
                        $('.page-loader').show();
                        window.location.href = page;
                    } else {
                        $.ajax({
                            url: page,
                            type: 'POST',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (pageContent) {
                                $('.page-loader').hide();
                                $("#bodyWindow").html(pageContent);
                                if ($.trim(cssClass)) {
                                    $('.nav-group-item').removeClass('active');
                                    if ($('.nav-group-item.' + cssClass).length > 0) {
                                        $('.nav-group-item.' + cssClass).addClass('active');
                                    }
                                    $('.epos-header-nav').removeClass('active');
                                    if ($('.epos-header-nav.' + cssClass).length > 0) {
                                        $('.epos-header-nav.' + cssClass).addClass('active');
                                    }
                                }
                            }
                        });
                    }
                } else {
                    if (connection) {
                        window.location.href = '<?php echo site_url('user/login/index/' . $this->session->userdata('loginBranch') . '/' . $this->session->userdata('team')) ?>';
                    } else {
                        warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                    }
                }
            }
            if (typeof module === 'object') {
                window.module = module;
                module = undefined;
            }
        </script>
    </head>
    <body>
        <div class="window" id="bodyWindow">
            <?php $this->load->view('settings/partials/header') ?>
            <div class="window-content" id="WindowContent">
                <div class="pane-group">
                    <div class="pane sidebar login-sidebar user-list-block">
                        <div class="user-list" style="top: 30%">
                            <div class="user-image text-center" onclick="warning('<?php echo $this->lang->line('contact') ?>', 'GKSOFT<br/>017450 116225<br/><a style=' + 'cursor:pointer;' + ' href=' + 'mailto:info@gksoft.co.uk' + '>info@gksoft.co.uk</a><br/><a style=' + 'cursor:pointer;' + ' href=' + 'http://gksoft.co.uk' + ' target=' + '_blank' + '>gksoft.co.uk</a>', '<?php echo $this->lang->line('close') ?>')">
                                <img src="<?php echo EPOS_RESOURCES_PATH . 'images/logo-lg.png' ?>" alt="Gksoft Logo">
                            </div>
                        </div>
                    </div>
                    <div class="pane-one-half">
                        <div style="width:70%; margin:15% auto;">
                            <div class="page-loader" style="display: none"></div>
                            <h2><?php echo $this->session->flashdata('item'); ?></h2> 
                            <form action="<?php echo site_url('epos/charge') ?>" method="post" id="payment-form" style="top: 30%">
                                <div class="form-row">
                                    <label for="card-element" style="width: 100%;">
                                        <div class="clearfix brand-time text-center"  style="border-radius: 50px 50px 0px 0px;padding: 10px;"><span class="icon icon-credit-card"></span>&nbsp;<span style="font-size: 12px;"><?php echo $this->lang->line('please_supply_customer_card_detais') ?></span></div>
                                    </label>
                                    <div id="card-element"></div>
                                    <div id="card-errors" role="alert"></div>
                                </div>
                                <input type='hidden' value='<?php echo $orderId ?>' name='orderId'/>
                                <input type='hidden' value='<?php echo $sid ?>' name='sid'/>
                                <input type='hidden' value='<?php echo $status ?>' name='status'/>
                                <input type='hidden' value='<?php echo $amount ?>' name='amount'/>
                                <div class="tab-group config-submit">
                                    <button class="submit-button" style="font-size: 17px;">Pay <?php echo to_currency($amount) ?></button>
                                </div>
                            </form>
                            <div id="errors"></div>
                        </div>
                    </div>
                    <div class="pane sidebar login-sidebar user-list-block">
                        <div class="user-list" style="top: 13% !important">
                            <div class="user-image text-center" onclick="location.reload()">
                                <img src="<?php echo EPOS_UPLOAD_PATH . $this->config->item('general_logo') ?>" alt="<?php echo $this->config->item('general_name') ?>" class="epos-logo">
                            </div>
                            <div>
                                <div class="clearfix brand-time text-center"><?php echo date('d/m/Y') ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php $this->load->view('settings/partials/footer') ?>
        </div>
        <script>
            if (window.module) {
                module = window.module;
            }
            var stripe = Stripe('<?php echo $pk ?>');
            var elements = stripe.elements();
            var style = {
                base: {
                    color: '#32325d',
                    fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
                    fontSmoothing: 'antialiased',
                    fontSize: '16px',
                    '::placeholder': {
                        color: '#aab7c4'
                    }
                },
                invalid: {
                    color: '#fa755a',
                    iconColor: '#fa755a'
                }
            };

            var card = elements.create('card', {hidePostalCode: true, style: style});
            card.mount('#card-element');
            card.addEventListener('change', function (event) {
                var displayError = document.getElementById('card-errors');
                if (event.error) {
                    displayError.textContent = event.error.message;
                } else {
                    displayError.textContent = '';
                }
            });

            var form = document.getElementById('payment-form');
            form.addEventListener('submit', function (event) {
                event.preventDefault();
                stripe.createToken(card).then(function (result) {
                    if (result.error) {
                        var errorElement = document.getElementById('card-errors');
                        errorElement.textContent = result.error.message;
                    } else {
                        $('.page-loader').show();
                        $('.submit-button').attr('disabled', 'disabled');
                        stripeTokenHandler(result.token);
                    }
                });
            });
            function stripeTokenHandler(token) {
                var form = document.getElementById('payment-form');
                var hiddenInput = document.createElement('input');
                hiddenInput.setAttribute('type', 'hidden');
                hiddenInput.setAttribute('name', 'stripeToken');
                hiddenInput.setAttribute('value', token.id);
                form.appendChild(hiddenInput);
                $('.page-loader').show();
                form.submit();
            }
        </script>
    </body>
</html>
