<table class="text-center report-table">
    <caption>Ref#<?php echo $theOrder['sid'] . '/' . $theOrder['orderId'] ?></caption>
    <tr>
        <td class="text-right" style="width: 50%">Source&nbsp;</td>
        <td class="text-left" style="width: 50%">&nbsp;<?php echo ucfirst($theOrder['source']) ?></td>
    </tr>
    <tr>
        <td class="text-right">Type&nbsp;</td>
        <td class="text-left">&nbsp;<?php echo ucfirst($theOrder['type']) ?></td>
    </tr>
    <tr>
        <td class="text-right">Customer&nbsp;</td>
        <td class="text-left">&nbsp;
            <?php
            $orderInfo = unserialize($theOrder['orderInfo']);
            if ($theOrder['type'] !== 'table') {
                echo ucfirst($orderInfo['name']);
            } else {
                echo ucfirst($theOrder['type']) . '-' . $orderInfo['tableNumber'];
            }
            ?>
        </td>
    </tr>
    <?php if ($theOrder['type'] !== 'table'): ?>
        <tr>
            <td class="text-right">Customer Phone&nbsp;</td>
            <td class="text-left">&nbsp; <?php echo ucfirst($orderInfo['phone']); ?></td>
        </tr>
    <?php endif; ?>
    <?php if ($theOrder['type'] === 'delivery'): ?>
        <?php
        $deliveryAddressStr = '';
        if (trim($orderInfo['building'])) {
            $deliveryAddressStr .= ucwords($orderInfo['building']) . ', ';
        }
        if (trim($orderInfo['sector'])) {
            $deliveryAddressStr .= ucwords($orderInfo['sector']) . ' ';
        }
        if (trim($orderInfo['street'])) {
            $deliveryAddressStr .= ucwords($orderInfo['street']) . ', ';
        }
        if (trim($orderInfo['city'])) {
            $deliveryAddressStr .= ucwords($orderInfo['city']) . ', ';
        }
        if (trim($orderInfo['postcode'])) {
            $deliveryAddressStr .= postcodeFormat($orderInfo['postcode']);
        }
        ?>
        <tr>
            <td class="text-right">Customer Address&nbsp;</td>
            <td class="text-left">&nbsp;<?php echo $deliveryAddressStr ?></td>
        </tr>
    <?php endif; ?>
    <?php if ($theOrder['type'] === 'collection'): ?>
        <tr>
            <td class="text-right">Collection Time&nbsp;</td>
            <td class="text-left">&nbsp;<?php echo $orderInfo['collectionTime'] ?></td>
        </tr>
    <?php endif; ?>
    <?php if ($theOrder['type'] === 'delivery'): ?>
        <tr>
            <td class="text-right">Delivery Time&nbsp;</td>
            <td class="text-left">&nbsp;<?php echo $orderInfo['deliveryTime'] ?></td>
        </tr>
    <?php endif; ?>
    <tr>
        <td colspan="2">
            <table class="text-center">
                <tr class="table-bg">
                    <th class="text-left" style="padding-left: 10px;"><strong><?php echo $this->lang->line('item') ?></strong></th>
                    <th><strong style="color: #eee"><?php echo $this->lang->line('price') ?></strong></th>
                    <th><strong style="color: #eee"><?php echo $this->lang->line('qty') ?></strong></th>
                    <th class="text-right"><strong style="padding-right: 10px;">Total</strong></th>
                </tr>
                <?php $cart = unserialize($theOrder['cart']); ?>
                <?php if (!empty($cart)): ?>
                    <?php foreach ($cart as $anItem): ?>
                        <tr>
                            <td class="text-left" style="padding-left: 10px;">
                                <?php echo trim($anItem['selectionTitle']) ? $anItem['selectionTitle'] . '-' . $anItem['menuTitle'] : $anItem['menuTitle'] ?>
                                <span style="font-size: 11px;"><?php
                                    if (!empty($anItem['Topping'])) {
                                        foreach ($anItem['Topping'] as $atopping) {
                                            echo '<br/><i>' . $atopping['qty'] . ' ' . $atopping['title'] . ' ' . to_currency($atopping['qty'] * $atopping['price']) . '</i>';
                                        }
                                    }
                                    ?>
                                </span>
                            </td>
                            <td><?php echo to_currency($anItem['price']) ?></td>
                            <td><?php echo $anItem['qty'] ?></td>
                            <td class="text-right" style="padding-right: 10px;"><?php echo to_currency($anItem['total']) ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
                <tr class="table-bg">
                    <th colspan="3" class="text-right" style="width: 90%;"><strong><?php echo $this->lang->line('subtotal') ?></strong>&nbsp;</th>
                    <th class="text-right" style="width: 10%; padding-right: 10px;">&nbsp;<strong><?php echo to_currency($theOrder['subTotal']); ?></strong></th>
                </tr>
                <?php if ($theOrder['tax'] > 0): ?>
                    <tr>
                        <td colspan="3" class="text-right" style="width: 90%"><?php echo $this->lang->line('tax') ?>&nbsp;</td>
                        <td class="text-right" style="width: 10%; padding-right: 10px;">&nbsp;<?php echo to_currency($theOrder['tax']); ?></td>
                    </tr>
                <?php endif; ?>
                <?php if ($theOrder['deliveryCharge'] > 0): ?>
                    <tr>
                        <td colspan="3" class="text-right" style="width: 90%"><?php echo $this->lang->line('delivery_charge') ?>&nbsp;</td>
                        <td class="text-right" style="width: 10%; padding-right: 10px;">&nbsp;<?php echo to_currency($theOrder['deliveryCharge']); ?></td>
                    </tr>
                <?php endif; ?>
                <?php if ($theOrder['serviceCharge'] > 0): ?>
                    <tr>
                        <td colspan="3" class="text-right" style="width: 90%"><?php echo $this->lang->line('service_charge') ?>&nbsp;</td>
                        <td class="text-right" style="width: 10%; padding-right: 10px;">&nbsp;<?php echo to_currency($theOrder['serviceCharge']); ?></td>
                    </tr>
                <?php endif; ?>
                <?php if ($theOrder['ccFee'] > 0): ?>
                    <tr>
                        <td colspan="3" class="text-right" style="width: 90%"><?php echo $this->lang->line('ccFee') ?>&nbsp;</td>
                        <td class="text-right" style="width: 10%; padding-right: 10px;">&nbsp;<?php echo to_currency($theOrder['ccFee']); ?></td>
                    </tr>
                <?php endif; ?>
                <?php if ($theOrder['cbFee'] > 0): ?>
                    <tr>
                        <td colspan="3" class="text-right" style="width: 90%"><?php echo $this->lang->line('cbFee') ?>&nbsp;</td>
                        <td class="text-right" style="width: 10%; padding-right: 10px;">&nbsp;<?php echo to_currency($theOrder['cbFee']); ?></td>
                    </tr>
                <?php endif; ?>

                <?php if ($theOrder['discount'] > 0): ?>
                    <tr>
                        <td colspan="3" class="text-right" style="width: 90%"><?php echo $this->lang->line('discount') ?>&nbsp;</td>
                        <td class="text-right" style="width: 10%; padding-right: 10px;">&nbsp;<?php echo to_currency($theOrder['discount']); ?></td>
                    </tr>
                <?php endif; ?>
                <?php if ($theOrder['promo'] > 0): ?>
                    <tr>
                        <td colspan="3" class="text-right" style="width: 90%"><?php echo $this->lang->line('promo') ?>&nbsp;</td>
                        <td class="text-right" style="width: 10%; padding-right: 10px;">&nbsp;<?php echo to_currency($theOrder['promo']); ?></td>
                    </tr>
                <?php endif; ?>
                <?php if ($theOrder['multiDiscount'] > 0): ?>
                    <tr>
                        <td colspan="3" class="text-right" style="width: 90%"><?php echo $this->lang->line('multi_discount') ?>&nbsp;</td>
                        <td class="text-right" style="width: 10%; padding-right: 10px;">&nbsp;<?php echo to_currency($theOrder['multiDiscount']); ?></td>
                    </tr>
                <?php endif; ?>
                <tr class="table-bg">
                    <th colspan="3" class="text-right" style="width: 90%;"><strong><?php echo $this->lang->line('total') ?></strong>&nbsp;</th>
                    <th class="text-right" style="width: 10%; padding-right: 10px; color: #eee;">&nbsp;<strong><?php echo to_currency($theOrder['grandTotal']); ?></strong></th>
                </tr>
            </table>
        </td>
    </tr>
</table>
<input type="hidden" id="remoteOrderDetailIdForSolo" value="<?php echo $theOrder['orderId'] ?>">
<input type="hidden" id="remoteOrderDetailSidForSolo" value="<?php echo $theOrder['sid'] ?>">
<input type="hidden" id="remoteOrderDetailGrandTotalForSolo" value="<?php echo to_currency_no_money($theOrder['grandTotal']); ?>">

