<div style="display: none;">
    <div id="ItemAttribute" class="popup-attributes">
        <div class="popup-header toolbar-header">
            <div class="popup-title"><span id="itemAttributeTitle"></span></div>
            <div class="popup-close-btn" onclick="zamanEposPopupcloser()"><span class="icon icon-cancel"></span></div>
        </div>
        <input type="hidden" id="attributesForMenuCategory">
        <input type="hidden" id="attributesForMenu">
        <input type="hidden" id="attributesForMenuSelection">
        <input type="hidden" id="attributesForMenuSet">
        <div class="popup-content">
            <div class="toppings-part">
                <div id="attributesToppingHead"></div>
                <div id="itemAttributeList"></div>
            </div>
            <div class="modifier-part">
                <div id="attributesModifierHead"></div>
                <div id="itemModifierList"></div>
            </div>
            <div class="selectedToppingPlaceHolder"></div>
            <div class="selectedModifierPlaceHolder"></div>
        </div>
        <div class="tab-group">
            <div class="tab-item zaman-epos-nav quantity-digit" onclick="addItemWithAttrAtCart()"><span class="icon icon-basket"> Add To Cart</span></div>
        </div>
    </div>
</div>
<script type="text/javascript">
    function zamanItemAttributeControllerPopup(category, menu, selection, set, title) {
        $.colorbox({
            inline: true,
            scrolling: false,
            href: "#ItemAttribute",
            width: '40%',
            height: 'auto',
            maxWidth: "100%",
            open: true,
            closeButton: false,
            transition: 'elastic',
            overlayClose: false,
            className: 'transparent-overlay',
            onOpen: function () {
                $('#ItemAttribute .popup-content').css({'height': '320', 'min-height': '300px'});
                $('#attributesToppingHead').text('').removeClass('caption');
                $('#itemAttributeList').html('');
                $('#attributesModifierHead').text('').removeClass('caption');
                $('#itemModifierList').html('');
                $('#DealSetHead').text('').removeClass('caption');
                $('#DealSetList').html('');
                $('#setAttributesToppingHead').text('').removeClass('caption');
                $('#setItemAttributeList').html('');
                $('#setAttributesModifierHead').text('').removeClass('caption');
                $('#setItemModifierList').html('');
                $('.selectedDealSetItemPlaceHolder').html('');
                $('.selectedToppingPlaceHolder').html('');
                $('.selectedModifierPlaceHolder').html('');
            },
            onLoad: function () {
                $('#attributesToppingHead').text(title + '-' + '<?php echo $this->lang->line('toppings') ?>');
                $('#itemAttributeTitle').text(title + '-' + 'attributes');
                $('#attributesForMenuCategory').val(category);
                $('#attributesForMenu').val(menu);
                $('#attributesForMenuSelection').val(selection);
                $('#attributesForMenuSet').val(set);
            },
            onComplete: function () {
                zamanEposDb.epos_menuattrcategory.where({'status': '3'}).filter(function (attrCat) {
                    return attrCat.category === category && attrCat.menu === menu && attrCat.selection === selection && attrCat.set === set;
                }).toArray().then(function (attrObject) {
                    if (attrObject.length > 0) {
                        var itemAttributeList = '';
                        attrObject.forEach(function (anAttr) {
                            zamanEposDb.epos_menuattr.where('menuttrcategory').equals(anAttr.id).toArray().then(function (items) {
                                if (items.length > 0) {
                                    itemAttributeList += '<div class="topping-cat-tab tab-group ' + anAttr.rel + '' + anAttr.rel_with + '" id="ToppingCategory-' + anAttr.id + '" onclick="zamanEposItemToppings(\'' + anAttr.id + '\',\'' + anAttr.title + '\',\'' + anAttr.rel + '' + anAttr.rel_with + '\',\'' + anAttr.min + '\',\'' + anAttr.max + '\',\'' + anAttr.free + '\',\'' + Number(0) + '\')">';
                                    itemAttributeList += '<div class="tab-item zaman-epos-nav quantity-digit">' + anAttr.title + '</div>';
                                    itemAttributeList += '</div>';
                                }
                                $('#itemAttributeList').html(itemAttributeList);
                                $('#attributesToppingHead').addClass('caption');
                                $('#colorbox').colorbox.resize({height: '400px'});
                            });
                        });
                    }
                });
                zamanEposDb.epos_modifiercategory.where({'status': '3'}).filter(function (modCat) {
                    return modCat.category === category && modCat.menu === menu && modCat.selection === selection && modCat.set === set;
                }).toArray().then(function (modObject) {
                    if (modObject.length > 0) {
                        $('#attributesModifierHead').text(title + '-' + '<?php echo $this->lang->line('modifiers') ?>');
                        var itemModifierList = '';
                        modObject.forEach(function (anModCat) {
                            itemModifierList += '<div class="tab-group clearfix" id="modifierCategory-' + anModCat.id + '" onclick="zamanEposItemModifier(\'' + anModCat.id + '\',\'' + anModCat.title + '\')">';
                            itemModifierList += '<div class="tab-item zaman-epos-nav quantity-digit">' + anModCat.title + '</div>';
                            itemModifierList += '</div>';
                        });
                        $('#itemModifierList').html(itemModifierList);
                        $('#attributesModifierHead').addClass('caption');
                        $('#colorbox').colorbox.resize({height: '400px'});
                    }
                });
            },
            onCleanup: function () {
                $('#attributesForMenuCategory').val('');
                $('#attributesForMenu').val('');
                $('#attributesForMenuSelection').val('');
            },
            onClosed: function () {
                $('#attributesToppingHead').text('').removeClass('caption');
                $('#itemAttributeList').html('');
                $('#attributesModifierHead').text('').removeClass('caption');
                $('#itemModifierList').html('');
                $('.selectedToppingPlaceHolder').html('');
                $('.selectedModifierPlaceHolder').html('');
            }
        });
    }
    function zamanEposItemToppings(topCat, title, rel, min, max, free, set) {
        if (rel.indexOf('mono') >= 0 && $('.' + rel).length > 1) {
            $('.' + rel).not('#ToppingCategory-' + topCat).remove();
        }
        zamanEposDb.epos_menuattr.where({'menuttrcategory': topCat}).filter(function (attrCat) {
            return attrCat.status === '3';
        }).toArray().then(function (attrObject) {
            if ($('#elementsForAttrCategory-' + topCat).length > 0) {
                $('#elementsForAttrCategory-' + topCat).remove();
            } else {
                var caption = Number(max) > 0 ? max + ' ' + '<?php echo $this->lang->line("item_select") ?>' + ' ' + title : '<?php echo $this->lang->line("item_select") ?>' + ' ' + title;
                var html = '<table class="attr-category-element-table table-bg" id="elementsForAttrCategory-' + topCat + '"><caption>' + caption + '</caption>';
                html += '<tr style="display:none;"><td colspan="4"><input type="hidden" id="attrMinForCat-' + topCat + '" value="' + min + '"><input type="hidden" id="attrMaxForCat-' + topCat + '" value="' + max + '"><input type="hidden" id="attrFreeForCat-' + topCat + '" value="' + free + '"><input type="hidden" id="attrCurrentQtyForCat-' + topCat + '" value="0"></td></tr>';
                attrObject.forEach(function (anAttr) {
                    html += '<tr id="category-' + topCat + '-Attr-' + anAttr.id + '" class="attr-row"><td><span id="attrTitle-' + anAttr.id + '">' + anAttr.title + '<span></td><td class="text-center"><span class="icon icon-minus btn btn-large btn-negative" onclick="decrementAttrQty(\'' + anAttr.id + '\',\'' + anAttr.menuttrcategory + '\',\'' + min + '\',\'' + max + '\',\'' + free + '\')"></span><span class="qty-box" id="attrQuantity-' + anAttr.id + '">' + anAttr.qty + '</span><span class="icon icon-plus btn btn-large btn-positive" onclick="incrementAttrQty(\'' + anAttr.id + '\',\'' + anAttr.menuttrcategory + '\',\'' + min + '\',\'' + max + '\',\'' + free + '\')"></span></td><td class="text-center"><span id="attrPrice-' + anAttr.id + '">' + toCurrency(anAttr.price) + '</span></td><td class="text-center"><span class=" icon icon-sho btn btn-large btn-negative" onclick="listingSelectedTopping(\'' + anAttr.id + '\',\'' + anAttr.menuttrcategory + '\',\'' + anAttr.price + '\',\'' + set + '\')">Add</span></td></tr>';
                });
                html += '</table>';
                $(html).insertAfter('#ToppingCategory-' + topCat);
                $('#colorbox').colorbox.resize({height: '400px'});
            }
            $('.attr-category-element-table').not('#elementsForAttrCategory-' + topCat).remove();
            $('#colorbox').colorbox.resize({height: '400px'});
        });
    }
    function decrementAttrQty(id, category, min, max, free) {
        var categoryCurrentQty = Number($('#attrCurrentQtyForCat-' + category).val());
        var attrCurrentQty = Number($('#attrQuantity-' + id).text());
        if (attrCurrentQty > 1 && categoryCurrentQty > 0) {
            $('#attrQuantity-' + id).text(attrCurrentQty - 1);
            $('#attrCurrentQtyForCat-' + category).val(categoryCurrentQty - 1);
        }
        categoryCurrentQty = parseInt(Number($('#attrCurrentQtyForCat-' + category).val()));
        attrCurrentQty = parseInt(Number($('#attrQuantity-' + id).text()));
        if (parseInt(Number(max)) > 0 && categoryCurrentQty >= parseInt(Number(max))) {
            $('#elementsForAttrCategory-' + category + ' .attr-row').not('#category-' + category + '-Attr-' + id).hide();
        } else {
            $('#elementsForAttrCategory-' + category + ' .attr-row').show();
        }
        $('#colorbox').colorbox.resize({height: '400px'});
    }
    function incrementAttrQty(id, category, min, max, free) {
        var categoryCurrentQty = parseInt(Number($('#attrCurrentQtyForCat-' + category).val()));
        var attrCurrentQty = parseInt(Number($('#attrQuantity-' + id).text()));
        if (parseInt(Number(max)) > 0 && (categoryCurrentQty + 1) < parseInt(Number(max))) {
            $('#attrQuantity-' + id).text(attrCurrentQty + 1);
            $('#attrCurrentQtyForCat-' + category).val(categoryCurrentQty + 1);
        } else if (parseInt(Number(max)) === 0 && attrCurrentQty >= 1) {
            $('#attrQuantity-' + id).text(attrCurrentQty + 1);
            $('#attrCurrentQtyForCat-' + category).val(categoryCurrentQty + 1);
        } else {
            console.log('nothing to happen');
        }
        attrCurrentQty = parseInt(Number($('#attrQuantity-' + id).text()));
        categoryCurrentQty = parseInt(Number($('#attrCurrentQtyForCat-' + category).val()));
        if (parseInt(Number(max)) > 0 && (categoryCurrentQty + 1) === parseInt(Number(max))) {
            $('#elementsForAttrCategory-' + category + ' .attr-row').not('#category-' + category + '-Attr-' + id).hide();
        } else {
            $('#elementsForAttrCategory-' + category + ' .attr-row').show();
        }
        $('#colorbox').colorbox.resize({height: '400px'});
    }
    function listingSelectedTopping(attrId, attrCategory, price, set) {
        zamanEposDb.epos_menuattrcategory.get({'id': attrCategory}).then(function (attrCategoryObj) {
            var attrTitle = $('#attrTitle-' + attrId).text();
            var attrQty = parseInt(Number($('#attrQuantity-' + attrId).text()));
            if (typeof (attrCategoryObj) !== 'undefined') {
                var AttrArray = zamanEposCart.listItemTopping();
                var attrTotalQty = 0;
                if (AttrArray.length > 0) {
                    for (var i in AttrArray) {
                        if (AttrArray[i].category === Number(attrCategory)) {
                            attrTotalQty += parseInt(Number(AttrArray[i].qty));
                        }
                    }
                }
                if (Number(attrCategoryObj.max) > 0) {
                    if (Number(attrCategoryObj.max) >= attrTotalQty + Number(attrQty)) {
                        addInToppingListing(attrId, attrTitle, attrQty, price, attrCategory, set);
                        removeToppingCategoryRow(attrTotalQty + Number(attrQty), Number(attrCategoryObj.max), attrCategoryObj.id, attrId, set);
                        displayItemAttr();
                        $('#colorbox').colorbox.resize({height: '400px'});
                    } else {
                        alert('you can select maximum ' + attrCategoryObj.max + ' toppings from ' + attrCategoryObj.title);
                    }
                } else {
                    addInToppingListing(attrId, attrTitle, attrQty, price, attrCategory, set);
                    removeToppingCategoryRow(attrTotalQty + Number(attrQty), Number(attrCategoryObj.max), attrCategoryObj.id, attrId, set);
                    displayItemAttr();
                    $('#colorbox').colorbox.resize({height: '400px'});
                }
            }
        });
    }
    function removeToppingCategoryRow(attrTotalQty, attrCategoryObjMax, attrCategory, attrId, set) {
        if (attrCategoryObjMax > 0) {
            if (parseInt(Number(attrTotalQty)) >= attrCategoryObjMax) {
                $('#elementsForAttrCategory-' + attrCategory).remove();
                $('#ToppingCategory-' + attrCategory).remove();
                if ($('#itemAttributeList').children().length <= 0) {
                    $('#attributesToppingHead').text('');
                    $('#attributesToppingHead').removeClass('caption');
                }
                if ($('#setItemAttributeList').children().length <= 0) {
                    $('#setAttributesToppingHead').text('');
                    $('#setAttributesToppingHead').removeClass('caption');
                }
                if ($('.has-set-topping').children().length <= 0) {
                    $('.has-set-topping').remove();
                    $('.set-wise-topping-head').remove();
                    $('.set-wise-topping-head').removeClass('caption');
                }
                if (Number(set) > 0) {
                    if ($('#ToppingOfTheSet-' + set).length > 0 && $('#ToppingOfTheSet-' + set).children().length <= 0) {
                        $('#setWiseTopingHead-' + set).closest('br').remove();
                        $('#setWiseTopingHead-' + set).remove();
                        $('#ToppingOfTheSet-' + set).remove();
                    }
                }
                $('#colorbox').colorbox.resize({height: '400px'});
            }
        }
        $('#category-' + attrCategory + '-Attr-' + attrId).remove();
        $('#colorbox').colorbox.resize({height: '400px'});
    }
    function addInToppingListing(id, title, qty, price, category, set) {
        var itemAttrData = new Array();
        itemAttrData.id = Number(id);
        itemAttrData.title = title;
        itemAttrData.qty = qty;
        itemAttrData.price = price;
        itemAttrData.category = Number(category);
        itemAttrData.set = set;
        zamanEposCart.addItemTopping(itemAttrData);
    }

    function displayItemAttr() {
        var AttrArray = zamanEposCart.listItemTopping();
        if (AttrArray.length > 0) {
            var html = '<table class="display-attr-category-element-table collection-bg">';
            html += '<div class="caption">Selected Toppings</div>';
            for (var i in AttrArray) {
                html += '<tr><td>' + AttrArray[i].qty + '</td><td>' + AttrArray[i].title + '</td><td>' + toCurrency(AttrArray[i].price) + '</td><td>' + toCurrency(AttrArray[i].total) + '</td></tr>';
            }
            html += '</table>';
            $('.selectedToppingPlaceHolder').html(html);
        } else {
            $('.selectedToppingPlaceHolder').html('');
        }

    }
    function zamanEposItemModifier(modCat, modCatTitle) {
        zamanEposDb.epos_modifiermenu.where({'modcategory': modCat}).filter(function (mod) {
            return mod.status === '3';
        }).toArray().then(function (allMods) {
            if (allMods.length > 0) {
                if ($('#elementsForModifierCategory-' + modCat).length > 0) {
                    $('#elementsForModifierCategory-' + modCat).remove();
                } else {
                    var html = '<table class="attr-category-element-table" id="elementsForModifierCategory-' + modCat + '"><tr><td>';
                    html += '<div class="menu-list special-modify-btn-groups">';
                    allMods.forEach(function (aMod) {
                        html += '<div class="menu-button" onclick="listingSelectedModifier(\'' + aMod.id + '\',\'' + aMod.modcategory + '\',\'' + aMod.title + '\',\'' + modCatTitle + '\')">';
                        html += '<div class="menu-button-inner">' + aMod.title + '</div>';
                        html += '</div>';
                    });
                    html += '</div>';
                    html += '</td></tr></table>';
                    $(html).insertAfter('#modifierCategory-' + modCat);
                    $('#colorbox').colorbox.resize({height: '400px'});
                }
                $('.attr-category-element-table').not('#elementsForModifierCategory-' + modCat).remove();
                $('#colorbox').colorbox.resize({height: '400px'});
            }
        });
    }
    function listingSelectedModifier(id, cat, title, catTitle) {
        if (id) {
            var itemModData = new Array();
            itemModData.title = catTitle + ' ' + title;
            zamanEposCart.addItemModifier(itemModData);
            $('#elementsForModifierCategory-' + cat).remove();
            $('#modifierCategory-' + cat).remove();
            if ($('#itemModifierList').children().length <= 0) {
                $('#attributesModifierHead').text('');
                $('#attributesModifierHead').removeClass('caption');
            }
            if ($('#setItemModifierList').children().length <= 0) {
                $('#setAttributesModifierHead').text('');
                $('#setAttributesModifierHead').removeClass('caption');
            }
            if ($('.has-set-modifier').children().length <= 0) {
                $('.has-set-modifier').remove();
                $('.set-wise-modifier-head').remove();
                $('.set-wise-modifier-head').removeClass('caption');
            }
            $('#colorbox').colorbox.resize({height: '400px'});
            displayItemModifier();
        }
    }
    function displayItemModifier() {
        var AttrArray = zamanEposCart.listItemModifier();
        if (AttrArray.length > 0) {
            var html = '<table class="display-attr-category-element-table collection-bg">';
            html += '<div class="caption">Selected Modifier</div>';
            for (var i in AttrArray) {
                html += '<tr><td>' + AttrArray[i].title + '</td></tr>';
            }
            html += '</table>';
            $('.selectedModifierPlaceHolder').html(html);
            $('#colorbox').colorbox.resize({height: '400px'});
        } else {
            $('.selectedToppingPlaceHolder').html('');
            $('#colorbox').colorbox.resize({height: '400px'});
        }

    }
    function addItemWithAttrAtCart() {
        var category = $('#attributesForMenuCategory').val();
        var menu = $('#attributesForMenu').val();
        var selection = $('#attributesForMenuSelection').val();
        if (selection > 0) {
            zamanEposDb.transaction('rw', [zamanEposDb.epos_branch, zamanEposDb.epos_order, zamanEposDb.epos_menucategory, zamanEposDb.epos_menu, zamanEposDb.epos_menuselection, zamanEposDb.epos_configuration, zamanEposDb.epos_discountplan, zamanEposDb.epos_discountmulti, zamanEposDb.epos_menuattrcategory, zamanEposDb.epos_menuattr], function () {
                zamanEposDb.epos_menucategory.get({id: category}).then(function (categoryObject) {
                    zamanEposDb.epos_menu.get({id: menu}).then(function (menuObject) {
                        zamanEposDb.epos_menuselection.get({id: selection}).then(function (selectionObject) {
                            precheckAttributesMinmumRequirements(categoryObject, menuObject, selectionObject);
                        });
                    });
                });
            });
        } else {
            zamanEposDb.transaction('rw', [zamanEposDb.epos_branch, zamanEposDb.epos_order, zamanEposDb.epos_menucategory, zamanEposDb.epos_menu,zamanEposDb.epos_menuselection, zamanEposDb.epos_configuration, zamanEposDb.epos_discountplan, zamanEposDb.epos_discountmulti, zamanEposDb.epos_menuattrcategory, zamanEposDb.epos_menuattr], function () {
                zamanEposDb.epos_menucategory.get({id: category}).then(function (categoryObject) {
                    zamanEposDb.epos_menu.get({id: menu}).then(function (menuObject) {
                        precheckAttributesMinmumRequirements(categoryObject, menuObject, {});
                    });
                });
            });
        }
    }
    function precheckAttributesMinmumRequirements(categoryObject, menuObject, selectionObject) {
        var selection = !jQuery.isEmptyObject(selectionObject) ? selectionObject.id : '0';
        zamanEposDb.epos_menuattrcategory.where({'status': '3'}).filter(function (attrCat) {
            return attrCat.category === categoryObject.id && attrCat.menu === menuObject.id && attrCat.selection === selection && attrCat.set === '0' && Number(attrCat.min) > 0;
        }).toArray().then(function (attrCats) {
            if (attrCats.length > 0) {
                var result = manageToppionsMinRequirement('0', attrCats);
                setTimeout(function () {
                    if (result) {
                        addToCart(categoryObject, menuObject, selectionObject);
                    }
                }, 20);
            } else {
                addToCart(categoryObject, menuObject, selectionObject);
            }
        });
    }
</script>