<div class="tab-group quantity-digit-pad">
    <?php if ($this->session->userdata('eposStyle') === 'LTR'): ?>
        <div class="tab-item cart-header-nav" style="padding: 12.5px 0px !important" onclick="zamanCustomQuantityControllerPopup()"><span class="text-uppercase"><?php echo $this->lang->line('qty') ?></span>&nbsp;<span class="qty-badge" id="quantityBadge">1</span></div>
        <div class="tab-item cart-header-nav" style="padding: 12.5px 0px !important" onclick="zamanOrderInfoControllerPopup()"><span id='loadedOrderInformation' style="color: #ddfc0d;"><?php echo $this->lang->line('void_order') ?></span></div>
        <div class="tab-item cart-header-nav" style="padding: 12.5px 0px !important" onclick="zamanOrderKitchenTextControllerPopup()"><i class="icon icon-pencil"></i>&nbsp;<?php echo $this->lang->line('kt') ?></div>
        <div class="tab-item cart-header-nav" style="padding: 12.5px 0px !important" onclick="zamanDeleteCartVoidOrder()"><i class="icon icon-trash"></i>&nbsp;<?php echo $this->lang->line('delete') ?></div>

    <?php else: ?>
        <div class="tab-item cart-header-nav" style="padding: 12.5px 0px !important" onclick="zamanDeleteCartVoidOrder()"><i class="icon icon-trash"></i>&nbsp;<?php echo $this->lang->line('delete') ?></div>
        <div class="tab-item cart-header-nav" style="padding: 12.5px 0px !important" onclick="zamanOrderKitchenTextControllerPopup()"><i class="icon icon-pencil"></i>&nbsp;<?php echo $this->lang->line('kt') ?></div>        
        <div class="tab-item cart-header-nav" style="padding: 12.5px 0px !important" onclick="zamanOrderInfoControllerPopup()"><span id='loadedOrderInformation' style="color: #ddfc0d;"><?php echo $this->lang->line('void_order') ?></span></div>
        <div class="tab-item cart-header-nav" style="padding: 12.5px 0px !important" onclick="zamanCustomQuantityControllerPopup()"><span class="text-uppercase"><?php echo $this->lang->line('qty') ?></span>&nbsp;<span class="qty-badge" id="quantityBadge">1</span> <?php echo $this->lang->line('or') ?> </div>
    <?php endif; ?>
</div>
<?php if ($this->session->userdata('eposStyle') === 'RTL'): ?>
    <div style="width: 20%;float: left">
        <div class="tab-group cart-nav">
            <div class="tab-item zaman-epos-nav" onclick="incrementEposCartItem()"><span class="icon icon-plus"></span></div>
        </div>
        <div class="tab-group cart-nav">
            <div class="tab-item zaman-epos-nav" onclick="decrementEposCartItem()"><span class="icon icon-minus"></span></div>
        </div>
        <!--
        <div class="tab-group cart-nav">
            <div class="tab-item zaman-epos-nav" onclick="removeEposCartItem()"><span class="icon icon-cancel"></span></div>
        </div>
        
        <div class="tab-group cart-nav">
            <div class="tab-item zaman-epos-nav" onclick="zamanOrderCartEditControllerPopup()"><span class="icon icon-pencil"></span></div>
        </div>
        -->
        <div class="tab-group cart-nav">
            <div class="tab-item zaman-epos-nav text-uppercase" onclick="zamanOrderToppingControllerPopup()"><span class="icon icon-plus"></span>&nbsp;<?php echo $this->lang->line('top') ?></div>
        </div>
        <div class="tab-group cart-nav">
            <div class="tab-item zaman-epos-nav text-uppercase" onclick="zamanOrderItemModifyControllerPopup()"><span class="icon icon-plus text-uppercase"></span>&nbsp;<?php echo $this->lang->line('mod') ?></div>
        </div>
        <div class="tab-group cart-nav">
            <div class="tab-item zaman-epos-nav text-capitalize" onclick="zamanOrderMiscItemInfoControllerPopup()"><?php echo $this->lang->line('misc') ?></div>
        </div>
        <?php if ($branch['default_ccFee'] > 0) : ?>
            <div class="tab-group cart-nav">
                <div class="tab-item zaman-epos-nav" onclick="zamanOrderCCFeeInfoControllerPopup()"><?php echo $this->lang->line('ccFee') ?></div>
            </div>
        <?php endif; ?>
        <div class="tab-group cart-nav">
            <div class="tab-item zaman-epos-nav" onclick="zamanOrderServiceChargeControllerPopup()"><?php echo $this->lang->line('ser_ch') ?></div>
        </div>
        <!--
        <div class="tab-group cart-nav">
            <div class="tab-item zaman-epos-nav" onclick="zamanOrderDeliveryChargeInfoControllerPopup()"><?php echo $this->lang->line('del_ch') ?></div>
        </div>
        <div class="tab-group cart-nav">
            <div class="tab-item zaman-epos-nav" onclick="zamanOrderCBFeeInfoControllerPopup()"><?php echo $this->lang->line('cbFee') ?></div>
        </div>
        -->
        <div class="tab-group cart-nav">
            <div class="tab-item zaman-epos-nav" onclick="zamanOrderSpecialDiscountControllerPopup()"><?php echo $this->lang->line('disc') ?></div>
        </div>
        <div class="tab-group cart-nav">
            <div class="tab-item zaman-epos-nav" onclick="showItemInfo()" id="itemInfoShower"><span class="icon icon-info"></span>&nbsp;<?php echo $this->lang->line('info') ?></div>
        </div>
        <?php if ($branch['default_ccFee'] <= 0) : ?>
            <div class="tab-group cart-nav">
                <div class="tab-item zaman-epos-nav" onclick="settleDownNewOrderOption()" style="color: #ddfc0d; font-weight: bold; background-image: linear-gradient(to bottom,#006f8d 0,#2f3030 100%); "><span class="icon icon-basket" style="color: #ddfc0d!important;"> New</span></div>
            </div>
        <?php endif; ?>
    </div>
<?php endif ?>
<div style="width: 80%; float: left;">
    <div class="order-cart">
        <div class="cart-items food-cart">
            <ul class="cart-list clearfix" id="zamanEposFoodCart"></ul>
        </div>
        <div class="cart-items non-food-cart">
            <!--
            <div class="tab-group">
                <div class="tab-item zaman-epos-nav quantity-digit" style="padding: 4px"><span class="icon icon-up-bold">&nbsp;</span><?php echo $this->lang->line('kitchen') ?></div>
                <div class="tab-item zaman-epos-nav quantity-digit" style="padding: 4px" onclick="clearEposCart()"><span class="icon icon-cancel">&nbsp;</span>Empty Cart</div>
                <div class="tab-item zaman-epos-nav quantity-digit" style="padding: 4px"><span class="icon icon-down-bold">&nbsp;</span><?php echo $this->lang->line('others') ?></div>
            </div>
            -->
            <div class="tab-group">
                <div class="tab-item zaman-epos-nav quantity-digit" style="padding: 4px; background:none;">&nbsp;</div>
            </div>
            <ul class="cart-list" id="zamanEposNonFoodCart"></ul>
        </div>
        <div class="tab-group">
            <div id="onlyForDeliveryOrderBlock" class="tab-item zaman-epos-nav quantity-digit total" style="display:none; color: #ddfc0d;"><?php echo $this->lang->line('minimum') ?>&nbsp;<span id="MinimumDeliveryAmount"></span></div>
            <div class="tab-item zaman-epos-nav quantity-digit total" style="font-size: 13px; font-weight: bold; "><?php echo $this->lang->line('subtotal') ?> <span id="SubTotalCalculationField"></span></div>
        </div>
        <div class="cart-items calculation-cart">
            <ul class="cart-list" id="cartCalculationList">
                <li class="cart-item clearfix">
                    <div class="item-part"><?php echo $this->lang->line('tax') ?></div>
                    <div class="item-attr-part calculation-field" id="taxCalculationField"></div>
                </li>
                <li class="cart-item clearfix" id="deliveryChargeCalculationFieldArea" style="display: none;">
                    <div class="item-part"><?php echo $this->lang->line('delivery_charge') ?></div>
                    <div class="item-attr-part calculation-field" id="deliveryChargeCalculationField"></div>
                </li>
                <li class="cart-item clearfix" id="ServiceChargeCalculationFieldArea" style="display: none;">
                    <div class="item-part"><?php echo $this->lang->line('service_charge') ?></div>
                    <div class="item-attr-part calculation-field" id="ServiceChargeCalculationField"></div>
                </li>
                <li class="cart-item clearfix" id="ccFeeCalculationFieldArea" style="display: none;">
                    <div class="item-part"><?php echo $this->lang->line('ccFee') ?></div>
                    <div class="item-attr-part calculation-field" id="ccFeeCalculationField"></div>
                </li>

                <li class="cart-item clearfix" id="cbFeeCalculationFieldArea" style="display: none;">
                    <div class="item-part"><?php echo $this->lang->line('cbFee') ?></div>
                    <div class="item-attr-part calculation-field" id="cbFeeCalculationField"></div>
                </li>
                <li class="cart-item clearfix" id="discountCalculationFieldArea">
                    <div class="item-part"><?php echo $this->lang->line('discount') ?></div>
                    <div class="item-attr-part calculation-field" id="discountCalculationField"></div>
                </li>
                <li class="cart-item clearfix" id="promoCalculationFieldArea" style="display: none;">
                    <div class="item-part"><?php echo $this->lang->line('promo') ?></div>
                    <div class="item-attr-part calculation-field" id="promoCalculationField" ></div>
                </li>
                <li class="cart-item clearfix" id="multiDiscountCalculationFieldArea" style="display: none;">
                    <div class="item-part"><?php echo $this->lang->line('multi_discount') ?></div>
                    <div class="item-attr-part calculation-field" id="multiDiscountCalculationField"></div>
                </li>
            </ul>
            <div class="tab-group clearfix" style="border-left: 1px solid #9ca5a0;border-right: 1px solid #9ca5a0">
                <div class="tab-item zaman-epos-nav quantity-digit total" style="padding: 8px 10px;"><span style="color: #00dd1c;font-weight: bolder;font-size: 17px;" id="isOrderAlreadyPaid"></span><span style="color: #ddfc0d; font-size: 20px; font-weight: bold;"><?php echo $this->lang->line('total') ?>: <span id="totalCalculationField"></span></span></div>
            </div>
        </div>
    </div>
    <div class="cartPragramData">
        <input type="hidden" id="cartSelectedLine">
        <input type="hidden" id="showItemInfo" value="no">
    </div>
</div>
<?php if ($this->session->userdata('eposStyle') === 'LTR'): ?>
    <div style="width: 20%;float: right">
        <div class="tab-group cart-nav">
            <div class="tab-item zaman-epos-nav" onclick="incrementEposCartItem()"><span class="icon icon-plus"></span></div>
        </div>
        <div class="tab-group cart-nav">
            <div class="tab-item zaman-epos-nav" onclick="decrementEposCartItem()"><span class="icon icon-minus"></span></div>
        </div>
        <!--
        <div class="tab-group cart-nav">
            <div class="tab-item zaman-epos-nav" onclick="removeEposCartItem()"><span class="icon icon-cancel"></span></div>
        </div>
        <div class="tab-group cart-nav">
            <div class="tab-item zaman-epos-nav" onclick="zamanOrderCartEditControllerPopup()"><span class="icon icon-pencil"></span></div>
        </div>
        --->
        <div class="tab-group cart-nav">
            <div class="tab-item zaman-epos-nav text-uppercase" onclick="zamanOrderToppingControllerPopup()"><span class="icon icon-plus"></span>&nbsp;<?php echo $this->lang->line('top') ?></div>
        </div>
        <div class="tab-group cart-nav">
            <div class="tab-item zaman-epos-nav text-uppercase" onclick="zamanOrderItemModifyControllerPopup()"><span class="icon icon-plus"></span>&nbsp;<?php echo $this->lang->line('mod') ?></div>
        </div>
        <div class="tab-group cart-nav">
            <div class="tab-item zaman-epos-nav text-capitalize" onclick="zamanOrderMiscItemInfoControllerPopup()"><?php echo $this->lang->line('misc') ?></div>
        </div>
        <?php if ($branch['default_ccFee'] > 0) : ?>
            <div class="tab-group cart-nav">
                <div class="tab-item zaman-epos-nav" onclick="zamanOrderCCFeeInfoControllerPopup()"><?php echo $this->lang->line('ccFee') ?></div>
            </div>
        <?php endif; ?>
        <div class="tab-group cart-nav">
            <div class="tab-item zaman-epos-nav" onclick="zamanOrderServiceChargeControllerPopup()"><?php echo $this->lang->line('ser_ch') ?></div>
        </div>
        <!--
        <div class="tab-group cart-nav">
            <div class="tab-item zaman-epos-nav" onclick="zamanOrderDeliveryChargeInfoControllerPopup()"><?php echo $this->lang->line('del_ch') ?></div>
        </div>
        <div class="tab-group cart-nav">
            <div class="tab-item zaman-epos-nav" onclick="zamanOrderCBFeeInfoControllerPopup()"><?php echo $this->lang->line('cbFee') ?></div>
        </div>
        --->
        <div class="tab-group cart-nav">
            <div class="tab-item zaman-epos-nav" onclick="zamanOrderSpecialDiscountControllerPopup()">Disc</div>
        </div>
        <div class="tab-group cart-nav">
            <div class="tab-item zaman-epos-nav" onclick="showItemInfo()" id="itemInfoShower"><span class="icon icon-info"></span>&nbsp;<?php echo $this->lang->line('info') ?></div>
        </div>
        <?php if ($branch['default_ccFee'] <= 0) : ?>
            <div class="tab-group cart-nav">
                <div class="tab-item zaman-epos-nav" onclick="settleDownNewOrderOption()" style="color: #ddfc0d; font-weight: bold; background-image: linear-gradient(to bottom,#006f8d 0,#2f3030 100%); "><span class="icon icon-basket" style="color: #ddfc0d!important;"> New</span></div>
            </div>
        <?php endif; ?>
    </div>
<?php endif; ?>
<div class="tab-group footer-sticky" style="bottom: 0px; position: fixed; width: 33.5%; padding-right: 3px;">
    <?php if ($this->session->userdata('eposStyle') === 'LTR'): ?>
        <div class="tab-item zaman-epos-nav" onclick="sendCartForProcessing()" style="color: #ddfc0d;"><span style="color: #ddfc0d" class="icon icon-air"></span>&nbsp;<?php echo $this->lang->line('send') ?></div>
        <div class="tab-item zaman-epos-nav" onclick="billPrinter()" style="color: #ddfc0d;"><span style="color: #ddfc0d" class="icon icon-print"></span>&nbsp;<?php echo $this->lang->line('print') ?></div>
        <?php if ($this->session->userdata('group') === '5'): ?>
            <div class="tab-item zaman-epos-nav new-order-tab-btn" onclick="zamanOrderPayAndCloseControllerPopup()" style="color: #ddfc0d;"><?php echo $this->lang->line('pay_and_close') ?></div>
        <?php else: ?>
            <div class="tab-item zaman-epos-nav new-order-tab-btn" onclick="orderPayAndCloseOption()" style="color: #ddfc0d;"><?php echo $this->lang->line('pay_and_close') ?></div>
        <?php endif; ?>
        <?php if ($this->session->userdata('group') === '5' && isDevice('Electron')): ?>
            <div class="tab-item zaman-epos-nav" onclick="sendCommandToEpos('openCashDrawer')"><?php echo $this->lang->line('till') ?></div>
            <div class="tab-item zaman-epos-nav" onclick="sendCommandToEpos('exitApp')"><?php echo $this->lang->line('exit') ?></div>
        <?php endif; ?>
    <?php else: ?>
        <?php if ($this->session->userdata('group') === '5' && isDevice('Electron')): ?>
            <div class="tab-item zaman-epos-nav" onclick="sendCommandToEpos('exitApp')"><?php echo $this->lang->line('exit') ?></div>
            <div class="tab-item zaman-epos-nav" onclick="sendCommandToEpos('openCashDrawer')"><?php echo $this->lang->line('till') ?></div>
        <?php endif; ?>
        <?php if ($this->session->userdata('group') === '5'): ?>
            <div class="tab-item zaman-epos-nav new-order-tab-btn" onclick="zamanOrderPayAndCloseControllerPopup()" style="color: #ddfc0d;"><?php echo $this->lang->line('pay_and_close') ?></div>
        <?php else: ?>
            <div class="tab-item zaman-epos-nav new-order-tab-btn" onclick="orderPayAndCloseOption()" style="color: #ddfc0d;"><?php echo $this->lang->line('pay_and_close') ?></div>
        <?php endif; ?>

        <div class="tab-item zaman-epos-nav" onclick="billPrinter()" style="color: #ddfc0d;"><span style="color: #ddfc0d" class="icon icon-print"></span>&nbsp;<?php echo $this->lang->line('print') ?></div>
        <div class="tab-item zaman-epos-nav" onclick="sendCartForProcessing()" style="color: #ddfc0d;"><span style="color: #ddfc0d" class="icon icon-air"></span>&nbsp;<?php echo $this->lang->line('send') ?></div>
    <?php endif; ?>
</div>
<script type="text/javascript">
    $(document).ready(function () {
        var paymentData = JSON.parse('<?php echo json_encode($this->session->flashdata('paymentData')) ?>');
        var isTheOnlineOrderPaid = '<?php $this->session->userdata('isTheOnlineOrderPaid') ? print 'no' : print'yes' ?>';
        updateOrderOnOnlinePaymentCompletion(paymentData, isTheOnlineOrderPaid);
    });
    function updateOrderOnOnlinePaymentCompletion(paymentData, isTheOnlineOrderPaid) {
        if (!jQuery.isEmptyObject(paymentData)) {
            if (paymentData.remote === 'yes') {
                remoteAppOrderPayAndClose(Number(paymentData.orderId), Number(paymentData.orderSid), Number(paymentData.hasBillPrint), paymentData);
            } else {
                updateOrderStatusOnOnlinePaymentCompletion(paymentData);
            }

        } else {
            if (isTheOnlineOrderPaid === 'no') {
                var orderReference = '<?php print $this->session->userdata('orderReference') ?>';
                var orderIdsFromFailed = orderReference.split("#");
                var failedEposOrderId = orderIdsFromFailed[0];
                var failedEposSid = orderIdsFromFailed[1];
                zamanEposDb.epos_order.get({orderId: Number(failedEposOrderId), sid: Number(failedEposSid)}).then(function (anOrder) {
                    if (typeof (anOrder) !== 'undefined') {
                        if (Number(anOrder.status) <= 1) {
                            zamanEposDb.epos_order.where("orderId").equals(Number(failedEposOrderId)).modify({
                                status: 1,
                                isPaid: 2,
                                payment: [],
                                onlinePaymentDetails: []
                            }).then(function (status) {
                                if (status) {
                                    zamanEposCart.clearOnPayAndCloseForUnsentOrder();
                                }
                            }).then(function () {
                                manageOrderListDisplay(anOrder, true);
                            });
                        } else {
                            zamanEposDb.epos_order.where("orderId").equals(Number(failedEposOrderId)).modify({
                                status: Number(anOrder.status) === 2 ? 2 : 3,
                                isPaid: 2,
                                payment: [],
                                onlinePaymentDetails: []
                            }).then(function (status) {
                                if (status) {
                                    zamanEposCart.clearOnPayAndCloseForSentInOrder();
                                }
                            }).then(function () {
                                manageOrderListDisplay(anOrder, true);
                            });
                        }
                    }
                });
            }
        }
    }
    function updateOrderStatusOnOnlinePaymentCompletion(paymentData) {
        zamanEposDb.epos_order.where("orderId").equals(Number(paymentData.orderId)).modify({
            isPaid: 3,
            onlinePaymentDetails: paymentData
        }).then(function (status) {
            if (status) {
                Number(paymentData.orderStatus) > 1 ? zamanEposCart.clearOnPayAndCloseForSentInOrder() : zamanEposCart.clearOnPayAndCloseForUnsentOrder();
            }
        }).then(function () {
            zamanEposDb.epos_order.get({orderId: Number(paymentData.orderId)}).then(function (anOrder) {
                if (Number(anOrder.status) > 1) {
                    remotePayAndClose(anOrder);
                } else {
                    manageOrderListDisplay(anOrder, true);
                }
            });
        });
    }
    function showItemInfo() {
        var value = $('#showItemInfo').val();
        if (value === 'no') {
            $('#showItemInfo').val('yes');
            $('#itemInfoShower').addClass('active');
            playBeepSound();
        } else {
            $('#showItemInfo').val('no');
            $('#itemInfoShower').removeClass('active');
        }
    }
    function setBadgeQty(qty) {
        $('#quantityBadge').text(qty);
    }
    function addToCart(categoryObject, menuObject, selectionObject) {
        var currentOrderId = zamanEposCart.getEposCurrentId();
        zamanEposDb.epos_order.get({orderId: Number(currentOrderId)}).then(function (anOrder) {
            if (typeof (anOrder) === 'undefinded' || jQuery.isEmptyObject(anOrder)) {
                settleDownNewOrderOption();
            } else {
                var userData = zamanEposCart.getUserData();
                zamanEposDb.epos_branch.get({'id': userData.branch}).then(function (branchObj) {
                    if (typeof (branchObj) !== 'undefined') {
                        var cartData = new Array();
                        cartData.category = Number(categoryObject.id);
                        cartData.categoryTitle = categoryObject.title;
                        cartData.type = categoryObject.type;
                        cartData.menu = Number(menuObject.id);
                        cartData.menuTitle = menuObject.title;
                        cartData.selection = !jQuery.isEmptyObject(selectionObject) ? selectionObject.id : 0;
                        cartData.selectionTitle = !jQuery.isEmptyObject(selectionObject) ? selectionObject.title : '';
                        if (anOrder.type === 'table' || anOrder.type === 'bar') {
                            if (!jQuery.isEmptyObject(selectionObject)) {
                                cartData.price = Number(selectionObject.in_price) > 0 ? parseFloat(Number(selectionObject.in_price)) : parseFloat(Number(selectionObject.base_price));
                            } else {
                                cartData.price = Number(menuObject.in_price) > 0 ? parseFloat(Number(menuObject.in_price)) : parseFloat(Number(menuObject.base_price));
                            }
                        } else {
                            if (!jQuery.isEmptyObject(selectionObject)) {
                                cartData.price = Number(selectionObject.out_price) > 0 ? parseFloat(Number(selectionObject.out_price)) : parseFloat(Number(selectionObject.base_price));
                            } else {
                                cartData.price = Number(menuObject.out_price) > 0 ? parseFloat(Number(menuObject.out_price)) : parseFloat(Number(menuObject.base_price));
                            }
                        }
                        if (branchObj.taxIsIncluded === 'yes') {
                            cartData.tax = 0;
                            cartData.taxOption = 2;
                            cartData.taxPercent = 0;
                            cartData.taxIncluded = 'yes';
                        } else {
                            cartData.tax = parseFloat(Number(!jQuery.isEmptyObject(selectionObject) ? selectionObject.tax : menuObject.tax));
                            cartData.taxOption = !jQuery.isEmptyObject(selectionObject) ? selectionObject.tax_option : menuObject.tax_option;
                            var taxOption = '';
                            if (!jQuery.isEmptyObject(selectionObject)) {
                                taxOption = selectionObject.tax_option;
                            } else {
                                taxOption = menuObject.tax_option;
                            }
                            var taxPercent = 0;
                            if (Number(taxOption) >= 2) {
                                if (Number(taxOption) === 2) {
                                    taxPercent = branchObj.default_tax;
                                } else if (Number(taxOption) === 3) {
                                    taxPercent = categoryObject.tax;
                                } else if (Number(taxOption) === 4) {
                                    taxPercent = menuObject.tax;
                                } else if (Number(taxOption) === 5) {
                                    taxPercent = selectionObject.tax;
                                } else {
                                    taxPercent = 0;
                                }
                            }
                            cartData.taxPercent = parseFloat(Number(taxPercent));
                            cartData.taxIncluded = 'no';
                        }
                        cartData.discountOption = Number(!jQuery.isEmptyObject(selectionObject) ? selectionObject.discount_option : menuObject.discount_option);
                        if (cartData.discountOption === 2) {
                            cartData.discount = Number(branchObj.default_discount);
                        } else if (cartData.discountOption === 3) {
                            cartData.discount = Number(0);
                        } else if (cartData.discountOption === 4) {
                            cartData.discount = Number(categoryObject.discount);
                        } else {
                            if (cartData.discountOption === 5) {
                                cartData.discount = Number(menuObject.discount);
                            } else if (!jQuery.isEmptyObject(selectionObject) && cartData.discountOption === 6) {
                                cartData.discount = Number(selectionObject.discount);
                            } else {
                                cartData.discount = 0;
                            }
                        }
                        cartData.qty = parseInt(Number($('#quantityBadge').text()));
                        cartData.setItem = zamanEposCart.listSetItem();
                        cartData.Topping = zamanEposCart.listItemTopping();
                        cartData.modifier = zamanEposCart.listItemModifier();
                        cartData.sent = 'no';
                        cartData.newQty = anOrder.status === '2' ? 0 : parseInt(Number($('#quantityBadge').text()));
                        var exitingCart = anOrder.cart;
                        if (exitingCart.length > 0 && anOrder.status === '2') {
                            for (var i in exitingCart) {
                                if (exitingCart[i].category === cartData.category && exitingCart[i].menu === cartData.menu && exitingCart[i].selection === cartData.selection) {
                                    cartData.sent = 'yes';
                                    cartData.newQty = parseInt(Number($('#quantityBadge').text()));
                                    break;
                                } else {
                                    continue;
                                }
                            }
                        }
                        cartData.basePrice = Number(!jQuery.isEmptyObject(selectionObject) ? selectionObject.base_price : menuObject.base_price);
                        cartData.inPrice = Number(!jQuery.isEmptyObject(selectionObject) ? selectionObject.in_price : menuObject.in_price);
                        cartData.outPrice = Number(!jQuery.isEmptyObject(selectionObject) ? selectionObject.out_price : menuObject.out_price);
                        cartData.printat = Number(!jQuery.isEmptyObject(selectionObject) ? selectionObject.printat : menuObject.printat);
                        cartData.isFree = 'no';
                        cartData.isFreeRule = 0;
                        var cartLine = zamanEposCart.addItem(cartData);
                        zamanEposCart.setEposCartNewQty(currentOrderId, cartData.newQty);
                        clearAllOptions();
                        $('#quantityBadge').text('1');
                        zamanEposPopupcloser();
                        displayEposCart();
                        setCartLine(cartLine);
                        initiateCartItemOffer(zamanEposCart.cartSubtotal());
                    }
                });
            }
        });
    }
    function clearAllOptions() {
        zamanEposCart.clearSetItem();
        zamanEposCart.clearItemTopping();
        zamanEposCart.clearItemModifier();
    }
    function toCurrency(number) {
        var currencySymbol = '<?php echo $this->config->item('locale_currencysymbol') ?>';
        var localeCurrencyside = '<?php echo $this->config->item('locale_currencyside') ?>';
        var currencyIcon = '<?php echo $this->config->item('locale_currencyicon') ?>';
        if ($.trim(currencyIcon)) {
            if ($.trim(localeCurrencyside) === $.trim('left')) {
                return currencyIcon + '' + Number(number).toFixed(2);
            } else {
                return Number(number).toFixed(2) + '' + currencyIcon;
            }
        } else {
            if ($.trim(localeCurrencyside) === $.trim('left')) {
                return currencySymbol + '' + Number(number).toFixed(2);
            } else {
                return Number(number).toFixed(2) + '' + currencySymbol;
            }
        }
    }
    function toCurrencyNoMoney(number) {
        return  Number(number).toFixed(2);
    }
    function displayEposCart() {
        zamanEposDb.epos_order.get({'orderId': Number(zamanEposCart.getEposCurrentId())}).then(function (theOrder) {
            var cartCalculator = zamanEposCart.cartCalculator();
            if (typeof (theOrder) !== 'undefined') {
                if (theOrder.type === 'delivery' && Number(theOrder.orderInfo.minOrderAmount) > Number(cartCalculator.cartSubtotal)) {
                    $('#onlyForDeliveryOrderBlock').show();
                    if ($('#onlyForDeliveryOrderBlock').length > 0) {
                        $('#MinimumDeliveryAmount').text(toCurrency(theOrder.orderInfo.minOrderAmount));
                    }
                } else {
                    $('#onlyForDeliveryOrderBlock').hide();
                }
                renderEposCart(cartCalculator, theOrder);
                if (Number(theOrder.isPaid) === 3) {
                    $('#isOrderAlreadyPaid').text('(<?php echo $this->lang->line('paid') ?>)');
                } else {
                    $('#isOrderAlreadyPaid').text('');
                }

            } else {
                zamanEposCart.clearOnPayAndClose();
                renderEposCart(cartCalculator, theOrder);
                $('#isOrderAlreadyPaid').text('');
            }
            updateScroll();
        });
    }
    function renderEposCart(cartCalculator, theOrder) {
        var cartArray = zamanEposCart.listCart();
        var zamanEposFoodCart = '';
        var zamanEposNonFoodCart = '';
        for (var i in cartArray) {
            if (cartArray[i].type === 'kitchen' || cartArray[i].type === 'bakery') {
                if (Number(cartArray[i].newQty) > 0) {
                    zamanEposFoodCart += '<li class="cart-item clearfix item-sent-no cart-item-' + i + '" onclick="setCartLine(\'' + i + '\')">';
                } else {
                    zamanEposFoodCart += '<li class="cart-item clearfix item-sent-' + cartArray[i].sent + ' cart-item-' + i + '" onclick="setCartLine(\'' + i + '\')">';
                }
                zamanEposFoodCart += '<div class="item-part" style="width:80%">';
                zamanEposFoodCart += '<span class="cart-item-menu text-capitalize">' + cartArray[i].qty + '&nbsp;&nbsp;';
                if ($.trim(cartArray[i].selectionTitle)) {
                    zamanEposFoodCart += cartArray[i].selectionTitle + '-' + cartArray[i].menuTitle;
                } else {
                    zamanEposFoodCart += cartArray[i].menuTitle;
                }
                if (cartArray[i].setItem) {
                    var setItemList = cartArray[i].setItem;
                    if (setItemList.length > 0) {
                        zamanEposFoodCart += '<br/><span class="cart-item-set-items text-capitalize">Items:</span>';
                        setItemList.forEach(function (asetItem) {
                            zamanEposFoodCart += '<br/><span class="cart-item-set-items">' + asetItem.qty + ' ' + asetItem.title + '</span>';
                        });
                    }
                }
                if (cartArray[i].Topping) {
                    var itemToppingsList = cartArray[i].Topping;
                    if (itemToppingsList.length > 0) {
                        zamanEposFoodCart += '<br/><span class="cart-item-toppings text-capitalize">With=></span>';
                        itemToppingsList.forEach(function (atopping) {
                            zamanEposFoodCart += '<br/><span class="cart-item-toppings">' + atopping.qty + ' ' + atopping.title + '</span>';
                            if (atopping.price > 0) {
                                zamanEposFoodCart += '<span>&nbsp;[ + ' + toCurrency(atopping.price * atopping.qty) + ' ]</span>';
                            }
                        });
                    }
                }
                if (cartArray[i].modifier) {
                    var itemModifierList = cartArray[i].modifier;
                    if (itemModifierList.length > 0) {
                        zamanEposFoodCart += '<br/><span class="cart-item-modifier text-capitalize">Modify=></span>';
                        itemModifierList.forEach(function (amod) {
                            zamanEposFoodCart += '<br/><span class="cart-item-modifier">' + amod.title + '</span>';
                        });
                    }
                }
                zamanEposFoodCart += '</span>';
                zamanEposFoodCart += '</div>';
                zamanEposFoodCart += '<div class="item-attr-part" style="width:20%">';
                zamanEposFoodCart += '<div class="unit-price-part" style="display:none">' + toCurrency(cartArray[i].price) + '</div>';
                zamanEposFoodCart += '<div class="qty-part" style="display:none">' + cartArray[i].qty + '</div>';
                zamanEposFoodCart += '<div class="price-part" style="width:100%">' + toCurrency(cartArray[i].total) + '</div>';
                zamanEposFoodCart += '</div>';
                zamanEposFoodCart += '</li>';
            } else {
                zamanEposNonFoodCart += '<li class="cart-item clearfix item-sent-' + cartArray[i].sent + ' cart-item-' + i + '" onclick="setCartLine(\'' + i + '\')">';
                zamanEposNonFoodCart += '<div class="item-part" style="width:80%">';
                zamanEposNonFoodCart += '<span class="cart-item-menu text-capitalize">' + cartArray[i].qty + '&nbsp;&nbsp;';
                if ($.trim(cartArray[i].selectionTitle)) {
                    zamanEposNonFoodCart += cartArray[i].selectionTitle + '-' + cartArray[i].menuTitle;
                } else {
                    zamanEposNonFoodCart += cartArray[i].menuTitle;
                }
                if (cartArray[i].setItem) {
                    var setItemList = cartArray[i].setItem;
                    if (setItemList.length > 0) {
                        zamanEposNonFoodCart += '<br/><span class="cart-item-set-items text-capitalize">Items:</span>';
                        setItemList.forEach(function (asetItem) {
                            zamanEposNonFoodCart += '<br/><span class="cart-item-set-items">' + asetItem.qty + ' ' + asetItem.title + '</span>';
                        });
                    }
                }
                if (cartArray[i].Topping) {
                    var itemToppingsList = cartArray[i].Topping;
                    if (itemToppingsList.length > 0) {
                        zamanEposNonFoodCart += '<br/><span class="cart-item-toppings text-capitalize">T/s:</span>';
                        itemToppingsList.forEach(function (atopping) {
                            zamanEposNonFoodCart += '<br/><span class="cart-item-toppings">' + atopping.qty + ' ' + atopping.title + '<span>&nbsp;[' + toCurrency(atopping.price * atopping.qty) + ']</span></span>';
                        });
                    }
                }
                if (cartArray[i].modifier) {
                    var itemModifierList = cartArray[i].modifier;
                    if (itemModifierList.length > 0) {
                        zamanEposNonFoodCart += '<br/><span class="cart-item-modifier">Modify:</span>';
                        itemModifierList.forEach(function (amod) {
                            zamanEposNonFoodCart += '<br/><span class="cart-item-modifier">' + amod.title + '</span>';
                        });
                    }
                }
                zamanEposNonFoodCart += '</span>';
                zamanEposNonFoodCart += '</div>';
                zamanEposNonFoodCart += '<div class="item-attr-part" style="width:20%">';
                zamanEposNonFoodCart += '<div class="unit-price-part" style="display:none">' + toCurrency(cartArray[i].price) + '</div>';
                zamanEposNonFoodCart += '<div class="qty-part" style="display:none">' + cartArray[i].qty + '</div>';
                zamanEposNonFoodCart += '<div class="price-part" style="width:100%">' + toCurrency(cartArray[i].total) + '</div>';
                zamanEposNonFoodCart += '</div>';
                zamanEposNonFoodCart += '</li>';
            }
        }
        $("#zamanEposFoodCart").html(zamanEposFoodCart);
        $("#zamanEposNonFoodCart").html(zamanEposNonFoodCart);
        cartCalculationFieldSetup(cartCalculator, theOrder);
    }
    function cartCalculationFieldSetup(cartCalculator, theOrder) {
        $('#SubTotalCalculationField').text(toCurrency(cartCalculator.cartSubtotal));
        if (typeof (theOrder) !== 'undefined' && theOrder.taxIsIncluded === 'yes') {
            $('#taxCalculationField').text(theOrder.taxIncludedPercent + '% Included');
        } else {
            $('#taxCalculationField').text(toCurrency(cartCalculator.cartTaxTotal));
        }
        if (Number(cartCalculator.deliveryCharge > 0)) {
            $('#deliveryChargeCalculationFieldArea').show(10, function () {
                $('#deliveryChargeCalculationField').text(toCurrency(cartCalculator.deliveryCharge));
            });
        } else {
            $('#deliveryChargeCalculationFieldArea').hide(10, function () {
                $('#deliveryChargeCalculationField').text(toCurrency(0));
            });
        }
        if (Number(cartCalculator.serviceCharge > 0)) {
            $('#ServiceChargeCalculationFieldArea').show(10, function () {
                $('#ServiceChargeCalculationField').text(toCurrency(cartCalculator.serviceCharge));
            });
        } else {
            $('#ServiceChargeCalculationFieldArea').hide(10, function () {
                $('#ServiceChargeCalculationField').text(toCurrency(0));
            });
        }

        if (Number(cartCalculator.cartccFee > 0)) {
            $('#ccFeeCalculationFieldArea').show(10, function () {
                $('#ccFeeCalculationField').text(toCurrency(cartCalculator.cartccFee));
            });
        } else {
            $('#ccFeeCalculationFieldArea').hide(10, function () {
                $('#ccFeeCalculationField').text(toCurrency(0));
            });
        }
        if (Number(cartCalculator.cartcbFee > 0)) {
            $('#cbFeeCalculationFieldArea').show(0, function () {
                $('#cbFeeCalculationField').text(toCurrency(cartCalculator.cartcbFee));
            });
        } else {
            $('#cbFeeCalculationFieldArea').hide(0, function () {
                $('#cbFeeCalculationField').text(toCurrency(0));
            });
        }
        if (Number(cartCalculator.cartPromoDiscountAmount > 0)) {
            $('#discountCalculationFieldArea').show(0, function () {
                $('#discountCalculationField').text(toCurrency(cartCalculator.cartPromoDiscountAmount));
            });
        } else {
            $('#discountCalculationFieldArea').hide(0, function () {
                $('#discountCalculationField').text(toCurrency(0));
            });
        }
        if (Number(cartCalculator.specialDiscount > 0)) {
            $('#promoCalculationFieldArea').show(0, function () {
                $('#promoCalculationField').text(toCurrency(cartCalculator.specialDiscount));
            });
        } else {
            $('#promoCalculationFieldArea').hide(0, function () {
                $('#promoCalculationField').text(toCurrency(0));
            });
        }
        if (Number(cartCalculator.cartMultiDiscountAmount > 0)) {
            $('#multiDiscountCalculationFieldArea').show(0, function () {
                $('#multiDiscountCalculationField').text(toCurrency(cartCalculator.cartMultiDiscountAmount));
            });
        } else {
            $('#multiDiscountCalculationFieldArea').hide(0, function () {
                $('#multiDiscountCalculationField').text(toCurrency(0));
            });
        }
        $('#totalCalculationField').text(toCurrency(cartCalculator.Total));
    }
    function initiateCartItemOffer(subtotal) {
        var itemOfferList = zamanEposCart.getItemOffer();
        var ruleToApply = null;
        if (itemOfferList.length > 0 && Number(subtotal > 0)) {
            for (var i in itemOfferList) {
                if (Number(subtotal) >= Number(itemOfferList[i].order)) {
                    ruleToApply = itemOfferList[i];
                    break
                }
            }
        }
        if (ruleToApply) {
            var itemOfferExitParam = zamanEposCart.getItemOfferExitParam();
            var itemOfferExitParamFreeQty = zamanEposCart.getItemOfferFreeItem();
            if (!jQuery.isEmptyObject(itemOfferExitParam)) {
                if (Number(itemOfferExitParam.order) === Number(ruleToApply.order)) {
                    var totalFreeQty = itemOfferExitParam.qty;
                    if (Number(totalFreeQty) > Number(itemOfferExitParamFreeQty)) {
                        manageFreeItemPopup(ruleToApply);
                    }
                } else {
                    var data = {};
                    data.order = Number(ruleToApply.order);
                    data.qty = Number(ruleToApply.qty);
                    zamanEposCart.setItemOfferExitParam(data);
                    manageFreeItemPopup(ruleToApply);
                }
            } else {
                var data = {};
                data.order = Number(ruleToApply.order);
                data.qty = Number(ruleToApply.qty);
                zamanEposCart.setItemOfferExitParam(data);
                manageFreeItemPopup(ruleToApply);
            }
        }
    }
    function manageFreeItemPopup(ruleToApply) {
        zamanOrderCartFreeItemControllerPopup(ruleToApply);
    }
    function setCartLine(line) {
        $('.cart-item').removeClass('active');
        $('#cartSelectedLine').val(line);
        window.setTimeout(function () {
            $('.cart-item-' + line).addClass('active');
        }, 50);
        playBeepSound();
    }
    function incrementEposCartItem() {
        zamanEposDb.epos_order.get({orderId: Number(zamanEposCart.getEposCurrentId())}).then(function (anOrder) {
            if (typeof (anOrder) !== 'undefined') {
                if (Number(anOrder.isPaid === 3)) {
                    orderPaymentPreProcessor(anOrder);
                } else {
                    var line = $('#cartSelectedLine').val();
                    if (line && Number(line) >= 0) {
                        var qty = parseInt(Number($('#quantityBadge').text()));
                        var activeLine = zamanEposCart.plusItem(line, qty);
                        displayEposCart();
                        setCartLine(activeLine);
                        $('#quantityBadge').text('1');
                    }
                }
            }
        });
    }
    function decrementEposCartItem() {
        zamanEposDb.epos_order.get({orderId: Number(zamanEposCart.getEposCurrentId())}).then(function (anOrder) {
            if (typeof (anOrder) !== 'undefined') {
                if (Number(anOrder.isPaid === 3)) {
                    orderPaymentPreProcessor(anOrder);
                } else {
                    var line = $('#cartSelectedLine').val();
                    if (line && Number(line) >= 0) {
                        var lineItem = zamanEposCart.getLineItem(Number(line));
                        if (Number(lineItem.newQty) <= 0 && lineItem.sent === 'yes') {
                            zamanOrderItemDeletePasscodeControllerPopup(Number(line), 'yes', 'minus');
                        } else {
                            var activeLine = zamanEposCart.minusItem(line, 'no');
                        }
                        displayEposCart();
                        setCartLine(activeLine);
                    }
                }
            }
        });
    }
    function removeEposCartItem() {
        zamanEposDb.epos_order.get({orderId: Number(zamanEposCart.getEposCurrentId())}).then(function (anOrder) {
            if (typeof (anOrder) !== 'undefined') {
                if (Number(anOrder.isPaid === 3)) {
                    orderPaymentPreProcessor(anOrder);
                } else {
                    var line = $('#cartSelectedLine').val();
                    if (line && Number(line) >= 0) {
                        var lineItem = zamanEposCart.getLineItem(Number(line));
                        if (Number(lineItem.newQty) <= 0 && lineItem.sent === 'yes') {
                            zamanOrderItemDeletePasscodeControllerPopup(Number(line), 'yes', 'remove');
                        } else {
                            zamanEposCart.deleteItem(line, 'no');
                        }
                        $('#cartSelectedLine').val('');
                        displayEposCart();
                        playBeepSound();
                    }
                }
            }
        });
    }
    function clearEposCart() {
        zamanEposDb.epos_order.get({orderId: Number(zamanEposCart.getEposCurrentId())}).then(function (anOrder) {
            if (typeof (anOrder) !== 'undefined') {
                if (Number(anOrder.isPaid === 3)) {
                    orderPaymentPreProcessor(anOrder);
                } else {
                    if (zamanEposCart.listCart().length > 0) {
                        zamanEposCart.clearCart();
                        displayEposCart();
                        playBeepSound();
                    }
                }
                $('#cartSelectedLine').val('');
            }
        });
    }
    function zamanDeleteCartVoidOrder() {
        zamanEposDb.epos_order.get({'orderId': Number(zamanEposCart.getEposCurrentId())}).then(function (theOrder) {
            if (typeof (theOrder) !== 'undefined') {
                if (Number(theOrder.status) === 1) {
                    if (Number(theOrder.isPaid) === 3) {
                        if (Number(zamanEposCart.getUserData().group) <= 4) {
                            zamanDeleteCartVoidOrderConfirm(theOrder);
                        } else {
                            warning('<?php echo $this->lang->line('warning') ?>', '<?php echo $this->lang->line('no_privilege_to_delete_order') ?>', '<?php echo $this->lang->line('close') ?>');
                        }
                    } else {
                        zamanDeleteCartVoidOrderConfirm(theOrder);
                    }
                } else {
                    warning('<?php echo $this->lang->line('warning') ?>', '<?php echo $this->lang->line('order_in_processing_stage_not_delete') ?>', '<?php echo $this->lang->line('ok') ?>');
                }
            } else {
                warning('<?php echo $this->lang->line('warning') ?>', '<?php echo $this->lang->line('load_order_in_cart') ?>', '<?php echo $this->lang->line('close') ?>');
            }
        });
    }
    function zamanDeleteCartVoidOrderConfirm(theOrder) {
        $.confirm({
            title: '<?php echo $this->lang->line('warning') ?>',
            message: '<?php echo $this->lang->line('delete_order_msg') ?>',
            buttons: {
                '<span class="icon icon-check">&nbsp;<?php echo $this->lang->line('yes') ?></span>': {
                    'class': 'positive',
                    'action': function () {
                        if (theOrder.type === 'table') {
                            zamanEposDb.epos_table.where("tableNumber").equals(theOrder.orderInfo.tableNumber).modify({
                                status: '2'
                            });
                        }
                        zamanEposDb.epos_order.delete(theOrder.orderId).then(function () {
                            zamanEposCart.clearOnPayAndClose();
                            var isTrue = false;
                            var isToShowAllOrders = $('#isToShowAllOrders').val();
                            if (isToShowAllOrders === 'yes') {
                                auxiliaryFunctionToShowAllTypeOrders(theOrder, isTrue);
                            } else {
                                auxiliaryFunctionToShowMonoTypeOrders(theOrder, isTrue);
                            }
                            auxiliaryFunctionForShowLoadedOrderInfo(theOrder, isTrue);
                            displayEposCart();
                        });
                    }
                },
                '<span class="icon icon-cancel">&nbsp;<?php echo $this->lang->line('no') ?></span>': {
                    'class': 'negative',
                    'action': function () {}
                }
            }
        });



    }
    function updateScroll() {
        var foodElement = document.getElementById("zamanEposFoodCart");
        var nonFoodElement = document.getElementById("zamanEposNonFoodCart");
        var cartCalculationList = document.getElementById("cartCalculationList");
        foodElement.scrollTop = foodElement.scrollHeight;
        nonFoodElement.scrollTop = nonFoodElement.scrollHeight;
        cartCalculationList.scrollTop = cartCalculationList.scrollHeight;
    }
    function sendCartForProcessing() {
        $('.page-loader').show();
        var currentOrderId = zamanEposCart.getEposCurrentId();
        var cart = zamanEposCart.listCart();
        var getEposCartNewQty = zamanEposCart.getEposCartNewQty(currentOrderId);
        if (cart.length <= 0) {
            $('.page-loader').hide();
            warning('<?php echo $this->lang->line('warning') ?>', '<?php echo $this->lang->line('load_order_in_cart') ?>', '<?php echo $this->lang->line('ok') ?>');
        } else {
            zamanEposDb.epos_order.get({orderId: Number(currentOrderId)}).then(function (anOrder) {
                if (anOrder.type === 'delivery') {
                    if (Number(anOrder.orderInfo.minOrderAmount) > Number(zamanEposCart.cartCalculator().cartSubtotal)) {
                        $('.page-loader').hide();
                        warning('<?php echo $this->lang->line('delivery') . ' ' . $this->lang->line('warning') ?>', '<?php echo $this->lang->line('required_minimum_delivery_amount') ?>' + toCurrency(anOrder.orderInfo.minOrderAmount), '<?php echo $this->lang->line('ok') ?>');
                    } else {
                        processCartForSending(currentOrderId, anOrder, cart, getEposCartNewQty);
                    }
                } else {
                    processCartForSending(currentOrderId, anOrder, cart, getEposCartNewQty);
                }
            });
        }
    }
    function processCartForSending(currentOrderId, anOrder, cart, getEposCartNewQty) {
        var numberOfUnsentItem = 0;
        cart.forEach(function (item) {
            if (item.sent === 'no') {
                numberOfUnsentItem += Number(item.qty);
            }
        });
        if (anOrder.status >= 2 && anOrder.cart.length > 0 && Number(getEposCartNewQty) <= 0 && numberOfUnsentItem <= 0) {
            resentCart(currentOrderId, cart, '<?php echo $this->lang->line('resend_cart') ?>', '<?php echo $this->lang->line('resend_cart_msg') ?>');
        } else if (anOrder.status === '2' && anOrder.cart.length >= 1 && (Number(getEposCartNewQty) >= 1 || numberOfUnsentItem > 0)) {
            sendConfirmation(anOrder.orderId, cart);
        } else {
            zamanEposDb.epos_order.where("orderId").equals(anOrder.orderId).modify({
                firstTakenAt: new Date().toLocaleTimeString(),
                status: '2'
            }).then(function () {
                updateCartOnSent(anOrder.orderId, cart, '2', '2');
            });
        }
    }
    function updateCartOnSent(lid, cart, typeOption, sentOption) {
        var cartCalculator = zamanEposCart.cartCalculator();
        zamanEposDb.epos_order.where("orderId").equals(Number(lid)).modify({
            cart: cart,
            subTotal: cartCalculator.cartSubtotal,
            tax: cartCalculator.cartTaxTotal,
            serviceCharge: cartCalculator.serviceCharge,
            deliveryCharge: cartCalculator.deliveryCharge,
            ccFee: cartCalculator.cartccFee,
            cbFee: cartCalculator.cartcbFee,
            discount: cartCalculator.cartPromoDiscountAmount,
            promo: cartCalculator.specialDiscount,
            multiDiscount: cartCalculator.cartMultiDiscountAmount,
            grandTotal: cartCalculator.Total,
            lastTakenAt: new Date().toLocaleTimeString()
        }).then(function () {
            zamanEposDb.epos_order.get({
                orderId: Number(lid)
            }).then(function (theOrder) {
                updateRemote(theOrder, typeOption, sentOption);
            });
        });
    }
    function sendConfirmation(lid, cart) {
        $.confirm({
            title: '<?php echo $this->lang->line('send_options') ?>',
            message: '<?php echo $this->lang->line('send_options_msg') ?>',
            buttons: {
                '<?php echo $this->lang->line('send_new') ?>': {
                    'class': 'primary',
                    'action': function () {
                        updateCartOnSent(lid, cart, '2', '3');
                    }
                },
                '<?php echo $this->lang->line('send_all') ?>': {
                    'class': 'positive',
                    'action': function () {
                        updateCartOnSent(lid, cart, '2', '2');
                    }
                },
                '<?php echo $this->lang->line('cancel') ?>': {
                    'class': 'negative',
                    'action': function () {
                        playBeepSound();
                        $.confirm.hide();
                    }
                }
            }
        });
        $('.page-loader').hide();
        playBeepSound();
    }
    function resentCart(lid, cart, title, message) {
        $.confirm({
            title: title,
            message: message,
            buttons: {
                '<span calss="icon icon-check">&nbsp;<?php echo $this->lang->line('yes') ?></span>': {
                    'class': 'positive',
                    'action': function () {
                        updateCartOnSent(lid, cart, '2', '2');
                    }
                },
                '<span calss="icon icon-cancel">&nbsp;<?php echo $this->lang->line('cancel') ?></span>': {
                    'class': 'negative',
                    'action': function () {
                        playBeepSound();
                        $.confirm.hide();
                    }
                }
            }
        });
        $('.page-loader').hide();
        playBeepSound();
    }
    function updateRemote(theOrder, typeOption, sentOption) {
        $('.page-loader').show();
        if (checkInternetConnection()) {
            return new Promise(function (resolve, reject) {
                $.ajax('<?php echo site_url('api/epos_order') ?>', {
                    type: 'post',
                    dataType: 'json',
                    data: {
                        theOrder: theOrder,
                        type: typeOption,
                        sent: sentOption
                    },
                    error: function (xhr, textStatus) {
                        reject(textStatus);
                    },
                    success: function (data) {
                        resolve(data);
                    }
                });
            }).then(function (data) {
                return zamanEposDb.transaction('rw', zamanEposDb.epos_order, function () {
                    zamanEposDb.epos_order.where("orderId").equals(theOrder.orderId).modify({sid: data.sid, cid: data.customer}).then(function () {
                        clearCartSentParam();
                        manageOrderListDisplay(theOrder, true);
                    });
                });
            });
        } else {
            manageOrderListDisplay(theOrder, true);
            newItemKitchenCopy(theOrder, typeOption, sentOption);
            clearCartSentParam();
        }

    }
    function clearCartSentParam() {
        zamanEposCart.clearCartSentParam();
    }
    function sortCartItem() {
        var newItemCart = zamanEposCart.listCart();
        newItemCart.sort(function (a, b) {
            if (a.category <= b.category)
                return -1;
            if (a.category > b.category)
                return 1;
            return 0;
        });
        return newItemCart;
    }
    function billPrinter() {
        var currentOrderId = zamanEposCart.getEposCurrentId();
        zamanEposDb.epos_order.get({orderId: Number(currentOrderId)}).then(function (anOrder) {
            if (typeof (anOrder) !== 'undefined') {
                var hasNewQty = zamanEposCart.getEposCartNewQty(currentOrderId);
                var cart = zamanEposCart.listCart();
                if (cart.length >= 1) {
                    if (Number(anOrder.status) >= 2) {
                        var numberOfUnsentItem = 0;
                        cart.forEach(function (item) {
                            if (item.sent === 'no') {
                                numberOfUnsentItem += Number(item.qty);
                            }
                        });
                        if (hasNewQty > 0 || numberOfUnsentItem > 0) {
                            $.confirm({
                                title: Number(anOrder.isPaid) === 3 ? '<?php echo $this->lang->line('order_paid') ?>' : '<?php echo $this->lang->line('warning') ?>',
                                message: Number(anOrder.isPaid) === 3 ? '<?php echo $this->lang->line('sent_paid_order_msg') ?>' : '<?php echo $this->lang->line('cart_has_unsent_items') . ' ' . $this->lang->line('send_it_now') ?>',
                                buttons: {
                                    '<span class="icon icon-check">&nbsp;<?php echo $this->lang->line('yes') ?></span>': {
                                        'class': 'positive',
                                        'action': function () {
                                            $('.page-loader').hide();
                                            sendCartForProcessing();
                                        }
                                    },
                                    '<span class="icon icon-cancel">&nbsp;<?php echo $this->lang->line('no') ?></span>': {
                                        'class': 'negative',
                                        'action': function () {
                                            $('.page-loader').hide();
                                            $.confirm.hide();
                                        }
                                    }
                                }
                            });
                        } else {
                            $('.page-loader').hide();
                            cartBillPrinterPrintNow(anOrder);
                        }
                    } else {
                        $('.page-loader').hide();
                        orderPaymentPreProcessor(anOrder);
                    }
                } else {
                    $('.page-loader').hide();
                    warning('<?php echo $this->lang->line('warning') ?>', '<?php echo $this->lang->line('load_order_in_cart') ?>', '<?php echo $this->lang->line('ok') ?>');
                }
            } else {
                $('.page-loader').hide();
                warning('<?php echo $this->lang->line('warning') ?>', '<?php echo $this->lang->line('load_order_in_cart') ?>', '<?php echo $this->lang->line('ok') ?>');
            }
        });

    }
    function cartBillPrinterPrintNow(anOrder) {
        if (checkInternetConnection()) {
            return new Promise(function (resolve, reject) {
                $.ajax('<?php echo site_url('api/printer') ?>', {
                    type: 'post',
                    dataType: 'json',
                    data: {
                        sid: anOrder.sid,
                        type: 4,
                        orderStatus: 4
                    },
                    error: function (xhr, textStatus) {
                        reject(textStatus);
                        manageOrderListDisplay(anOrder, true);
                    },
                    success: function (data) {
                        $('.page-loader').hide();
                        resolve(data);
                    }
                });
            }).then(function (data) {
                if (data.status) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_order, function () {
                        zamanEposDb.epos_order.where("orderId").equals(anOrder.orderId).modify({status: 4}).then(function () {
                            $('.page-loader').hide();
                            manageOrderListDisplay(anOrder, true);
                        });
                    });
                } else {
                    manageOrderListDisplay(anOrder, true);
                }
            });
        } else {
            //activate offline Printer
            newItemKitchenCopy('theOrder', 'typeOption', 'sentOption');
            $('.page-loader').hide();
        }
    }
    function newItemKitchenCopy(theOrder, typeOption, setOption) {
        $("#newItemKitchenCopy").printThis({
            printContainer: false,
            importCSS: false,
            loadCSS: '<?php echo EPOS_RESOURCES_PATH . "css/print.css" ?>',
            header: '<h3 style="text-align:center; font-size:2em">Kitchen Copy</h3>',
            footer: '<h4 style="text-align:center;"><-----------------End----------------></h4>'
        });
    }
    function orderPayAndCloseOption() {
        var accessPreveleges = true;
        zamanEposDb.epos_order.get({orderId: Number(zamanEposCart.getEposCurrentId())}).then(function (anOrder) {
            if (typeof (anOrder) !== 'undefined') {
                var hasNewQty = zamanEposCart.getEposCartNewQty(zamanEposCart.getEposCurrentId());
                var cart = zamanEposCart.listCart();
                if (cart.length <= 0) {
                    warning('<?php echo $this->lang->line('empty_cart') ?>', '<?php echo $this->lang->line('empty_cart_msg') ?>', '<?php echo $this->lang->line('close') ?>');
                } else {
                    if (anOrder.isPaid === 3) {
                        zamanOrderPayAndCloseControllerPopup();
                    } else {
                        if (anOrder.type === 'delivery') {
                            if (Number(anOrder.orderInfo.minOrderAmount) > Number(zamanEposCart.cartCalculator().cartSubtotal)) {
                                accessPreveleges = false;
                                warning('<?php echo $this->lang->line('delivery') . ' ' . $this->lang->line('warning') ?>', '<?php echo $this->lang->line('required_minimum_delivery_amount') ?>' + toCurrency(anOrder.orderInfo.minOrderAmount), '<?php echo $this->lang->line('ok') ?>');
                            }
                        }
                        if (Number(anOrder.status) >= 2) {
                            var numberOfUnsentItem = 0;
                            cart.forEach(function (item) {
                                if (item.sent === 'no') {
                                    numberOfUnsentItem += Number(item.qty);
                                }
                            });
                            if (Number(hasNewQty) > 0 || numberOfUnsentItem > 0) {
                                sendCartForProcessing();
                                accessPreveleges = false;
                            }
                        }
                        if (true === accessPreveleges) {
                            $.confirm({
                                title: 'Option',
                                message: 'Choose an option',
                                buttons: {
                                    '<span class="some-1"><?php echo $this->lang->line('receive_payment') ?></span>': {
                                        'class': 'positive',
                                        'action': function () {
                                            zamanOrderPayAndCloseControllerPopup();
                                        }
                                    },
                                    '<span class="some-2"><?php echo $this->lang->line('push_at_epos') ?></span>': {
                                        'class': 'positive',
                                        'action': function () {
                                            if (anOrder.status >= 2) {
                                                var hasNewQty = zamanEposCart.getEposCartNewQty(zamanEposCart.getEposCurrentId());
                                                var numberOfUnsentItem = 0;
                                                cart.forEach(function (item) {
                                                    if (item.sent === 'no') {
                                                        numberOfUnsentItem += Number(item.qty);
                                                    }
                                                });
                                                if (Number(hasNewQty) > 0 || numberOfUnsentItem > 0) {
                                                    warning('<?php echo $this->lang->line('warning') ?>', '<?php echo $this->lang->line('cart_has_unsent_items') ?>', '<?php echo $this->lang->line('close') ?>');
                                                } else {
                                                    pushOrderAtEpos(anOrder.orderId, anOrder.sid, anOrder);
                                                }
                                            } else {
                                                warning('<?php echo $this->lang->line('warning') ?>', '<?php echo $this->lang->line('cart_has_unsent_items') ?>', '<?php echo $this->lang->line('close') ?>');
                                            }
                                        }
                                    },
                                    '<span class="some-3"><?php echo $this->lang->line('cancel') ?></span>': {
                                        'class': 'positive',
                                        'action': function () {}
                                    }
                                }
                            });
                        }
                    }
                }
            } else {
                zamanOrderPayAndCloseControllerPopup();
            }
        });
    }
    function pushOrderAtEpos(lid, sid, theOrder) {
        if (checkInternetConnection()) {
            $.ajax({
                url: '<?php echo site_url('api/pushOrderAtEpos') ?>',
                dataType: 'json',
                type: 'POST',
                data: {lid: lid, sid: sid},
                beforeSend: function (xhr) {
                    $('.page-loader').show();
                },
                success: function (response) {
                    $('.page-loader').hide();
                    if (response.status) {
                        if (theOrder.type === 'table') {
                            zamanEposDb.epos_table.where("tableNumber").equals(theOrder.orderInfo.tableNumber).modify({
                                status: '2'
                            });
                        }
                        zamanEposCart.clearOnPayAndClose();
                        zamanEposDb.epos_order.delete(lid);
                        $('#loadedOrderInformation').text('<?php echo $this->lang->line('void_order') ?>');
                        manageOrderListDisplay(theOrder, false);
                    } else {
                        warning('<?php echo $this->lang->line('warning') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                    }
                }
            });
        } else {
            warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
        }
    }
</script>
<?php if (isDevice('Android')): ?>
    <style>
        .tab-group.cart-nav .tab-item {
            border-radius: 0px;
            border: none;
            margin: 0 auto;
            padding: 10px 2px;
            font-size: 10px;
            height: 34px;
            font-weight: bold;
            text-align: center;
        }
        .non-food-cart .cart-list {
            height: 14vh;
        }
        .food-cart .cart-list {
            height: 35vh;
        }
        .tab-group.cart-nav .tab-item img{
            max-height: 30px;
            max-width: 30px
        }
    </style>
<?php else: ?>
    <style>
        .tab-group.cart-nav .tab-item {padding: 30.5px 0px;height: auto;}
        .non-food-cart .cart-list {height: 18vh;}
        .food-cart .cart-list {height: 42vh;}
    </style>
<?php endif; ?>

