<style>
    .icon.icon-star.icon-stat-gold {color: gold;}
    .review-list .block-inner{padding: 5px; background: #fff; margin: 5px;}
    .rating {float:left;}
    .rating:not(:checked) > input {position:absolute;top:-9999px;clip:rect(0,0,0,0);}
    .rating:not(:checked) > label {float:right;width:1em;padding:0 .1em;overflow:hidden;white-space:nowrap;cursor:pointer;font-size:200%;line-height:1.2;color:#ddd;text-shadow:1px 1px #bbb, 2px 2px #666, .1em .1em .2em rgba(0,0,0,.5);}
    .rating:not(:checked) > label:before {content: '★ ';}
    .rating > input:checked ~ label {color: #f70;text-shadow:1px 1px #c60, 2px 2px #940, .1em .1em .2em rgba(0,0,0,.5);}
    .rating:not(:checked) > label:hover,.rating:not(:checked) > label:hover ~ label {color: gold;text-shadow:1px 1px goldenrod, 2px 2px #B57340, .1em .1em .2em rgba(0,0,0,.5);}
    .rating > input:checked + label:hover,.rating > input:checked + label:hover ~ label,.rating > input:checked ~ label:hover, .rating > input:checked ~ label:hover ~ label, .rating > label:hover ~ input:checked ~ label {color: #ea0; text-shadow:1px 1px goldenrod, 2px 2px #B57340, .1em .1em .2em rgba(0,0,0,.5);}
    .rating > label:active {position:relative; top:2px;left:2px;}
</style>
<div class="content">
    <section class="banner-2" id="pageHeaderBanner">
        <div class="container text-center banner-content ">
            <h1 class="text-uppercase common-page-heading page-title-2"><?php echo $current_section ?></h1>
        </div>
    </section>
    <?php if (trim($content)): ?>
        <section class="section-content-half">
            <div class="container">
                <div class="half-page-design">
                    <?php echo $content ?>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <section  id="review" class="common-page-bg">
        <div class="container">
            <?php if (!$this->session->userdata('customerId')): ?>
                <div class="text-center"><a href="<?php echo site_url('customer-login') ?>" class="btn btn-b btn-fb">Please rate us</a></div>
            <?php endif; ?>
            <?php if ($this->session->userdata('customerId')): ?>
                <div class="action-form">
                    <div class="msg" id="successMessage" style="display: none"></div>
                    <div> <?php $this->session->flashdata('success') ? print '<span class="success">' . $this->session->flashdata('success') . '</span>' : '' ?></div>
                    <fieldset class="fieldset">
                        <legend>Please rate us</legend>
                        <?php echo form_open('takeaway/review_submit', array('id' => 'reviewForm')); ?>
                        <div class="rating">
                            <input data-error="#ratingError" type="radio" id="star5" name="rating" value="5" /><label for="star5" title="Rocks!">5 stars</label>
                            <input data-error="#ratingError" type="radio" id="star4" name="rating" value="4" /><label for="star4" title="Pretty good">4 stars</label>
                            <input data-error="#ratingError" type="radio" id="star3" name="rating" value="3" /><label for="star3" title="Meh">3 stars</label>
                            <input data-error="#ratingError" type="radio" id="star2" name="rating" value="2" /><label for="star2" title="Kinda bad">2 stars</label>
                            <input data-error="#ratingError" type="radio" id="star1" name="rating" value="1" /><label for="star1" title="Sucks big time">1 star</label>
                        </div>
                        <div class="clearfix"></div>
                        <div class="error tab-group" id="ratingError"></div>
                        <div class="form-group">
                            <label class="btn-block">Your Message</label>
                            <div class="tab-group"><textarea data-error="#messageError" class="smooth" name="message"></textarea></div>
                            <div class="error tab-group" id="messageError"></div>
                        </div>
                        <div class="form-group">
                            <button type="submit" class="btn  btn-c btn-lg btn-block text-center" onclick="submitRatting('reviewForm')">Submit</button>
                        </div>
                        <?php echo form_close(); ?>
                    </fieldset>
                </div>
            <?php endif; ?>
            <div class="review-list action-form">
                <div class="row">
                    <?php if (!empty($reviews)): ?>
                        <?php foreach ($reviews as $review): ?>
                            <div class="col c6 item-block">
                                <div class="block-inner">
                                    <div class="review-person-and-ratting"><span><?php echo $review->name ?></span>&nbsp;
                                        <?php $rating = $review->rating ?>
                                        <?php for ($i = 1; $i <= 5; $i++): ?>
                                            <span class="icon icon-star <?php $rating >= $i ? print'icon-stat-gold' : '' ?>"></span>
                                        <?php endfor; ?>
                                    </div>
                                    <div class="review-date"><span class="icon icon-clock">&nbsp;</span><?php echo date('d/m/Y h:i A', strtotime($review->date)) ?></div>
                                    <div class="review-person-message"><?php echo $review->message ?></div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>
</div>
<script type="text/javascript">
    function submitRatting(formId) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        if (response.status) {
                            window.location.href = "<?php echo site_url('review') ?>";
                        } else {
                            $('#successMessage').text(response.message).show();
                        }
                    }
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {
                rating: {required: true},
                message: {required: true}
            },
            messages: {
                rating: "Your ratting is required",
                message: 'Please write something valid as message'
            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }
    $(document).ready(function () {
        resetForm('customerLoginForm');
    });
</script>