<div style="display: none;">
    <div id="itemtAttributesPopup">
        <div class="popup-info-block">
            <div class="popup-container">
                <div class="text-capitalize text-center popup-title" id="attributePopupTitle"></div>
                <div class="text-left popup-description" id="attributePopupDescription"></div>
            </div>
        </div>
        <div class="popup-container">
            <div class="msg set-items text-uppercase"></div>
            <div class="msg attr-items text-uppercase"></div>
            <div class="popup-content-area" id="attributePopupContentHolder"></div>
            <div class="add-attributes" id="addAttrubitesAtCart">
                <div class="tab-item btn btn-c btn-sm" onclick="submitItemAttributes()">Add to cart</div>&nbsp;
            </div>
            <input type="hidden" id="itemCategoryFromAttrPopup">
            <input type="hidden" id="itemMenuFromAttrFormPopup">
            <input type="hidden" id="itemSelectionFromAttrPopup">
        </div>
    </div>
</div>
<script type="text/javascript">
    function itemAttributesPopupController(c, m, s) {
        $.ajax({
            url: '<?php echo site_url('cart/getItemAttributes') ?>',
            type: 'POST',
            dataType: 'json',
            data: {c: c, m: m, s: s},
            success: function (response) {
                if (typeof (response.attrCats) !== 'undefined' || typeof (response.itemSet) !== 'undefined') {
                    $('#attributePopupTitle').text(response.itemTitle);
                    $('#attributePopupDescription').show();
                    if ($.trim(response.content)) {
                        $('#attributePopupDescription').text(response.content);
                    } else {
                        $('#attributePopupDescription').hide();
                    }
                    if (typeof (response.itemSet) !== 'undefined') {
                        renderItemSet(response);
                    } else {
                        if (typeof (response.attrCats) !== 'undefined') {
                            renderItemAttribute(response);
                        }
                    }
                    $.colorbox({inline: true, scrolling: false, href: "#itemtAttributesPopup", width: '460px', height: 'auto', maxWidth: "100%", top: 0, open: true, closeButton: true, transition: 'none', overlayClose: false, className: 'transparent-overlay',
                        onOpen: function () {
                            $('#itemCategoryFromAttrPopup').val(c);
                            $('#itemMenuFromAttrFormPopup').val(m);
                            $('#itemSelectionFromAttrPopup').val(s);
                            zamanOnlineCart.clearTopping();
                            zamanOnlineCart.clearSetItem();
                            displaySetItems();
                            displayItemAttributes();
                            $('#addAttrubitesAtCart .btn').show();
                        },
                        onClosed: function () {
                            zamanOnlineCart.clearTopping();
                            zamanOnlineCart.clearSetItem();
                            $('.loader').hide();
                        }
                    });
                } else {
                    addToCart(c, m, s);
                }
            }
        });
    }
    function renderItemSet(response) {
        var attrHtml = '';
        response.itemSet.forEach(function (aSet) {
            if (response.setItems[aSet.id].length > 0) {
                attrHtml += '<div class="item-attribute ' + aSet.rel + ' set-rel-with' + aSet.rel_with + '" id="' + aSet.id + '">';
                attrHtml += '<div class="tab-group"><div class="tab-item text-left" onclick="itemSetBlockHideOpener(\'' + aSet.id + '\')"><span id="itemSet-' + aSet.id + '" class="icon icon-down-open-big"></span>&nbsp;&nbsp;<span id="itemSetTitle-' + aSet.id + '">' + aSet.title + '</span></div></div>';
                attrHtml += '<div id="setBlock-' + aSet.id + '" style="display: none;">';
                attrHtml += '<input type="hidden" id=maxNumSetItem-' + aSet.id + ' value="' + aSet.max + '">';
                attrHtml += '<input type="hidden" id=minNumsetItem-' + aSet.id + ' value="' + aSet.min + '">';
                response.setItems[aSet.id].forEach(function (aSetItem) {
                    attrHtml += '<div class="attribute-container" id="itemAttribute_' + aSetItem.set + '_' + aSetItem.id + '">';
                    attrHtml += '<div class="attribute-container-inner">';
                    attrHtml += '<div class="item-attribute-string-part"><span class="set-attr-title">' + aSetItem.title + '</span></div>';
                    attrHtml += '<div class="item-attribute-price-part">&nbsp;</div>';
                    attrHtml += `<div><span class="icon icon-plus item-attribute-add-to-cart-btn" onclick="addSetItem('` + aSetItem.set + `','` + aSetItem.id + `','` + aSet.max + `')"></span></div>`;
                    attrHtml += '</div>';
                    attrHtml += `<div class="attribute-container-inner attribute-container-inner-detail">
                                        <div class="attribute-remove"><span class="icon icon-minus remove-qty" onclick="removeSetItem('` + aSetItem.set + `','` + aSetItem.id + `')"></span>&nbsp;<span class="set-attr-qty">0</span></div>
                                        <div class="item-attribute-calcualte-price text-right">&nbsp;</div>
                                    </div>`;
                    attrHtml += '</div>';
                });
                attrHtml += '</div>';
                attrHtml += '</div>';
            }
            if (typeof (response.setAttrCat) !== 'undefined') {
                if (response.setAttrCat[aSet.id].length > 0) {
                    response.setAttrCat[aSet.id].forEach(function (topCat) {
                        if (response.setAttrCatItem[aSet.id][topCat.id].length > 0) {
                            attrHtml += '<div class="item-attribute ' + topCat.rel + ' rel-with' + topCat.rel_with + '" id="' + topCat.id + '">';
                            attrHtml += '<div class="tab-group"><div class="tab-item text-left" onclick="itemAttributesBlockHideOpener(\'' + topCat.id + '\')"><span id="topCat-' + topCat.id + '" class="icon icon-down-open-big"></span>&nbsp;&nbsp;<span id="topCatTitle-' + topCat.id + '">' + topCat.title + '</span></div></div>';
                            attrHtml += '<div id="toppingBlock-' + topCat.id + '" style="display: none;">';
                            attrHtml += '<input type="hidden" id=maxNumToppings-' + topCat.id + ' value="' + topCat.max + '">';
                            attrHtml += '<input type="hidden" id=minNumToppings-' + topCat.id + ' value="' + topCat.min + '">';
                            response.setAttrCatItem[aSet.id][topCat.id].forEach(function (anAttr) {
                                attrHtml += '<div class="attribute-container" id="itemAttribute_' + anAttr.menuttrcategory + '_' + anAttr.id + '">';
                                attrHtml += '<div class="attribute-container-inner">';
                                attrHtml += '<div class="item-attribute-string-part"><span class="attr-title">' + anAttr.title + '</span></div>';
                                attrHtml += '<div class="item-attribute-price-part"><span><?php echo $this->config->item('locale_currencyicon') ?></span><span class="attr-unit-price">' + toCurrencyNoMoney(anAttr.price) + '</span></div>';
                                attrHtml += `<div><span class="icon icon-plus item-attribute-add-to-cart-btn" onclick="addItemAttribute('` + anAttr.menuttrcategory + `','` + anAttr.id + `','` + topCat.max + `')"></span></div>`;
                                attrHtml += '</div>';
                                attrHtml += `<div class="attribute-container-inner attribute-container-inner-detail">
                                        <div class="attribute-remove"><span class="icon icon-minus remove-qty" onclick="removeItemAttribute('` + anAttr.menuttrcategory + `','` + anAttr.id + `')"></span>&nbsp;<span class="attr-qty">0</span></div>
                                        <div class="item-attribute-calcualte-price text-right"><span><?php echo $this->config->item('locale_currencyicon') ?></span><span class="attr-total-price">0</span></div>
                                    </div>`;
                                attrHtml += '</div>';
                            });
                            attrHtml += '</div>';
                            attrHtml += '</div>';
                        }
                    });
                }
            }
        });
        if (typeof (response.attrCats) !== 'undefined') {
            response.attrCats.forEach(function (topCat) {
                if (response.attr[topCat.id].length > 0) {
                    attrHtml += '<div class="item-attribute ' + topCat.rel + ' rel-with' + topCat.rel_with + '" id="' + topCat.id + '">';
                    attrHtml += '<div class="tab-group"><div class="tab-item text-left" onclick="itemAttributesBlockHideOpener(\'' + topCat.id + '\')"><span id="topCat-' + topCat.id + '" class="icon icon-down-open-big"></span>&nbsp;&nbsp;<span id="topCatTitle-' + topCat.id + '">' + topCat.title + '</span></div></div>';
                    attrHtml += '<div id="toppingBlock-' + topCat.id + '" style="display: none;">';
                    attrHtml += '<input type="hidden" id=maxNumToppings-' + topCat.id + ' value="' + topCat.max + '">';
                    attrHtml += '<input type="hidden" id=minNumToppings-' + topCat.id + ' value="' + topCat.min + '">';
                    response.attr[topCat.id].forEach(function (anAttr) {
                        attrHtml += '<div class="attribute-container" id="itemAttribute_' + anAttr.menuttrcategory + '_' + anAttr.id + '">';
                        attrHtml += '<div class="attribute-container-inner">';
                        attrHtml += '<div class="item-attribute-string-part"><span class="attr-title">' + anAttr.title + '</span></div>';
                        attrHtml += '<div class="item-attribute-price-part"><span><?php echo $this->config->item('locale_currencyicon') ?></span><span class="attr-unit-price">' + toCurrencyNoMoney(anAttr.price) + '</span></div>';
                        attrHtml += `<div><span class="icon icon-plus item-attribute-add-to-cart-btn" onclick="addItemAttribute('` + anAttr.menuttrcategory + `','` + anAttr.id + `','` + topCat.max + `')"></span></div>`;
                        attrHtml += '</div>';
                        attrHtml += `<div class="attribute-container-inner attribute-container-inner-detail">
                                        <div class="attribute-remove"><span class="icon icon-minus remove-qty" onclick="removeItemAttribute('` + anAttr.menuttrcategory + `','` + anAttr.id + `')"></span>&nbsp;<span class="attr-qty">0</span></div>
                                        <div class="item-attribute-calcualte-price text-right"><span><?php echo $this->config->item('locale_currencyicon') ?></span><span class="attr-total-price">0</span></div>
                                    </div>`;
                        attrHtml += '</div>';
                    });
                    attrHtml += '</div>';
                    attrHtml += '</div>';
                }
            });
        }
        $('#attributePopupContentHolder').html(attrHtml);
    }
    function renderItemAttribute(response) {
        var attrHtml = '';
        response.attrCats.forEach(function (topCat) {
            if (response.attr[topCat.id].length > 0) {
                attrHtml += '<div class="item-attribute ' + topCat.rel + ' rel-with' + topCat.rel_with + '" id="' + topCat.id + '">';
                attrHtml += '<div class="tab-group"><div class="tab-item text-left" onclick="itemAttributesBlockHideOpener(\'' + topCat.id + '\')"><span id="topCat-' + topCat.id + '" class="icon icon-down-open-big"></span>&nbsp;&nbsp;<span id="topCatTitle-' + topCat.id + '">' + topCat.title + '</span></div></div>';
                attrHtml += '<div id="toppingBlock-' + topCat.id + '" style="display: none;">';
                attrHtml += '<input type="hidden" id=maxNumToppings-' + topCat.id + ' value="' + topCat.max + '">';
                attrHtml += '<input type="hidden" id=minNumToppings-' + topCat.id + ' value="' + topCat.min + '">';
                response.attr[topCat.id].forEach(function (anAttr) {
                    attrHtml += '<div class="attribute-container" id="itemAttribute_' + anAttr.menuttrcategory + '_' + anAttr.id + '">';
                    attrHtml += '<div class="attribute-container-inner">';
                    attrHtml += '<div class="item-attribute-string-part"><span class="attr-title">' + anAttr.title + '</span></div>';
                    attrHtml += '<div class="item-attribute-price-part"><span><?php echo $this->config->item('locale_currencyicon') ?></span><span class="attr-unit-price">' + toCurrencyNoMoney(anAttr.price) + '</span></div>';
                    attrHtml += `<div><span class="icon icon-plus item-attribute-add-to-cart-btn" onclick="addItemAttribute('` + anAttr.menuttrcategory + `','` + anAttr.id + `','` + topCat.max + `')"></span></div>`;
                    attrHtml += '</div>';
                    attrHtml += `<div class="attribute-container-inner attribute-container-inner-detail">
                                        <div class="attribute-remove"><span class="icon icon-minus remove-qty" onclick="removeItemAttribute('` + anAttr.menuttrcategory + `','` + anAttr.id + `')"></span>&nbsp;<span class="attr-qty">0</span></div>
                                        <div class="item-attribute-calcualte-price text-right"><span><?php echo $this->config->item('locale_currencyicon') ?></span><span class="attr-total-price">0</span></div>
                                    </div>`;
                    attrHtml += '</div>';
                });
                attrHtml += '</div>';
                attrHtml += '</div>';
            }
        });
        $('#attributePopupContentHolder').html(attrHtml);
    }
    function itemAttributesBlockHideOpener(id) {
        var elmClass = $('#' + id).attr('class');
        if (elmClass.indexOf('mono') >= 0) {
            var elmClassArray = elmClass.split(' ');
            $('.' + elmClassArray[2]).not('#' + id).remove();
        }
        if ($('#topCat-' + id + '.icon').hasClass('icon-down-open-big')) {
            $('#topCat-' + id + '.icon').removeClass('icon-down-open-big');
            $('#topCat-' + id + '.icon').addClass('icon-up-open-big');
        } else {
            $('#topCat-' + id + '.icon').removeClass('icon-up-open-big');
            $('#topCat-' + id + '.icon').addClass('icon-down-open-big');
        }
        $('#toppingBlock-' + id).toggle();
        $('#colorbox').colorbox.resize();
    }
    function addItemAttribute(attrCat, attr, catMax) {
        var toppingList = zamanOnlineCart.listTopping();
        var existingItemNumber = 0;
        if (toppingList.length > 0) {
            for (var i in toppingList) {
                if (Number(toppingList[i].category) === Number(attrCat)) {
                    existingItemNumber += Number(toppingList[i].qty);
                }
            }
        }
        if (Number(catMax) > 0 && Number(catMax) === Number(existingItemNumber)) {
            displayItemAttributes();
            itemAttributesBlockHideOpener(attrCat);
        } else {
            var elm = 'itemAttribute_' + attrCat + '_' + attr;
            var data = new Array();
            data.id = attr;
            data.title = $('#' + elm).find('.attr-title').text();
            data.qty = Number($('#' + elm).find('.attr-qty').text());
            data.category = attrCat;
            data.price = Number($('#' + elm).find('.attr-unit-price').text());
            data.set = '0';
            data.qty += 1;
            data.total = data.price * data.qty;
            zamanOnlineCart.addTopping(data);
            $('#' + elm + ' .attribute-container-inner-detail').show();
            $('#' + elm).find('.attr-qty').text(data.qty);
            $('#' + elm).find('.attr-total-price').text(toCurrencyNoMoney(data.total));
            var toppingList = zamanOnlineCart.listTopping();
            var existingItemNumber = 0;
            if (toppingList.length > 0) {
                for (var i in toppingList) {
                    if (Number(toppingList[i].category) === Number(attrCat)) {
                        existingItemNumber += Number(toppingList[i].qty);
                    }
                }
            }
            if (Number(catMax) > 0 && Number(catMax) <= existingItemNumber) {
                itemAttributesBlockHideOpener(attrCat);
            }
            displayItemAttributes();
            $('#colorbox').colorbox.resize();
        }

    }
    function removeItemAttribute(attrCat, attr) {
        var elm = 'itemAttribute_' + attrCat + '_' + attr;
        var data = new Array();
        data.id = attr;
        data.title = $('#' + elm).find('.attr-title').text();
        data.qty = Number($('#' + elm).find('.attr-qty').text());
        data.category = attrCat;
        data.price = Number($('#' + elm).find('.attr-unit-price').text());
        data.set = '0';
        data.qty -= 1;
        data.total = data.price * data.qty;
        zamanOnlineCart.deleteTopping(data);
        $('#' + elm + ' .attribute-container-inner-detail').show();
        $('#' + elm).find('.attr-qty').text(data.qty);
        $('#' + elm).find('.attr-total-price').text(toCurrencyNoMoney(data.total));
        if (data.qty <= 0) {
            $('#' + elm + ' .attribute-container-inner-detail').hide();
            $('#colorbox').colorbox.resize();
        }
        displayItemAttributes();
    }
    function displayItemAttributes() {
        var toppingList = zamanOnlineCart.listTopping();
        if (toppingList.length > 0) {
            var toppingString = '';
            for (var i in toppingList) {
                toppingString += toppingList[i].qty + ' ' + toppingList[i].title + ',';
            }
            $('.msg.attr-items').text(toppingString.substring(0, toppingString.length - 1)).show();
        } else {
            $('.msg.attr-items').hide();
        }
    }
    function submitItemAttributes() {
        if (checkForItemmAttrinuteMinimumRequirement()) {
            $.ajax({
                url: '<?php echo site_url('cart/addItemAttributes') ?>',
                type: 'post',
                dataType: 'json',
                data: {'Topping': zamanOnlineCart.listTopping(), setItem: zamanOnlineCart.listSetItem()},
                beforeSend: function (xhr) {
                    $('.msg').text('').hide();
                    $('#attributePopupContentHolder').html('');
                    $('.msg.set-items').text('Please wait, processing...').show();
                    $('#addAttrubitesAtCart .btn').hide();
                    $('#colorbox').colorbox.resize();
                },
                success: function (response) {
                    if (response.status) {
                        addToCart($('#itemCategoryFromAttrPopup').val(), $('#itemMenuFromAttrFormPopup').val(), $('#itemSelectionFromAttrPopup').val());
                    }
                }
            });
        }
    }
    function checkForItemmAttrinuteMinimumRequirement() {
        var activeCategoryIds = getActiveAttributeCategoryIds();
        var minCondition = true;
        for (var i in activeCategoryIds) {
            if ($('#minNumsetItem-' + activeCategoryIds[i]).length > 0) {
                var min = $('#minNumsetItem-' + activeCategoryIds[i]).val();
                var existingSetItem = 0;
                var listSetItem = zamanOnlineCart.listSetItem();
                if (listSetItem.length > 0) {
                    for (var index in listSetItem) {
                        if (Number(listSetItem[index].set) === Number(activeCategoryIds[i])) {
                            existingSetItem += Number(listSetItem[index].qty);
                        }
                    }
                }
                if (Number(min) > 0 && existingSetItem < min) {
                    var msg = 'Minimum ' + min + ' item is required from ' + $('#itemSetTitle-' + activeCategoryIds[i]).text();
                    $('.msg.set-items').text(msg).show();
                    minCondition = false;
                    break;
                } else {
                    continue;
                }
            }
            if ($('#minNumToppings-' + activeCategoryIds[i]).length > 0) {
                var min = $('#minNumToppings-' + activeCategoryIds[i]).val();
                var existingTop = 0;
                var toppingList = zamanOnlineCart.listTopping();
                if (toppingList.length > 0) {
                    for (var index in toppingList) {
                        if (Number(toppingList[index].category) === Number(activeCategoryIds[i])) {
                            existingTop += Number(toppingList[index].qty);
                        }
                    }
                }
                if (Number(min) > 0 && existingTop < min) {
                    var msg = 'Minimum ' + min + ' item is required from ' + $('#topCatTitle-' + activeCategoryIds[i]).text();
                    $('.msg.attr-items').text(msg).show();
                    minCondition = false;
                    break;
                } else {
                    continue;
                }
            }

        }
        return minCondition;
    }
    function getActiveAttributeCategoryIds() {
        var retval = [];
        $('.item-attribute').each(function () {
            retval.push($(this).attr('id'));
        });
        console.log(retval);
        return retval;
    }
    function itemSetBlockHideOpener(id) {
        var elmClass = $('#' + id).attr('class');
        if (elmClass.indexOf('mono') >= 0) {
            var elmClassArray = elmClass.split(' ');
            $('.' + elmClassArray[2]).not('#' + id).remove();
        }
        if ($('#itemSet-' + id + '.icon').hasClass('icon-down-open-big')) {
            $('#itemSet-' + id + '.icon').removeClass('icon-down-open-big');
            $('#itemSet-' + id + '.icon').addClass('icon-up-open-big');
        } else {
            $('#itemSet-' + id + '.icon').removeClass('icon-up-open-big');
            $('#itemSet-' + id + '.icon').addClass('icon-down-open-big');
        }
        $('#setBlock-' + id).toggle();
        $('#colorbox').colorbox.resize();
    }
    function addSetItem(attrCat, attr, catMax) {
        var listSetItem = zamanOnlineCart.listSetItem();
        var existingItemNumber = 0;
        if (listSetItem.length > 0) {
            for (var i in listSetItem) {
                if (Number(listSetItem[i].set) === Number(attrCat)) {
                    existingItemNumber += Number(listSetItem[i].qty);
                }
            }
        }
        if (Number(catMax) > 0 && Number(catMax) <= Number(existingItemNumber)) {
            displaySetItems();
            itemSetBlockHideOpener(attrCat);
        } else {
            var elm = 'itemAttribute_' + attrCat + '_' + attr;
            var data = new Array();
            data.id = attr;
            data.title = $('#' + elm).find('.set-attr-title').text();
            data.qty = Number($('#' + elm).find('.set-attr-qty').text());
            data.set = attrCat;
            data.setTitle = $('#itemSetTitle-' + attrCat).text();
            data.qty += 1;
            zamanOnlineCart.addSetItem(data);
            $('#' + elm + ' .attribute-container-inner-detail').show();
            $('#' + elm).find('.set-attr-qty').text(data.qty);
            var listSetItem = zamanOnlineCart.listSetItem();
            var existingItemNumber = 0;
            if (listSetItem.length > 0) {
                for (var i in listSetItem) {
                    if (Number(listSetItem[i].set) === Number(attrCat)) {
                        existingItemNumber += Number(listSetItem[i].qty);
                    }
                }
            }
            if (Number(catMax) > 0 && Number(catMax) <= existingItemNumber) {
                itemSetBlockHideOpener(attrCat);
            }
            displaySetItems();
            $('#colorbox').colorbox.resize();
        }

    }
    function removeSetItem(attrCat, attr) {
        var elm = 'itemAttribute_' + attrCat + '_' + attr;
        var data = new Array();
        data.id = attr;
        data.title = $('#' + elm).find('.set-attr-title').text();
        data.qty = Number($('#' + elm).find('.set-attr-qty').text());
        data.set = attrCat;
        data.setTitle = $('#itemSetTitle-' + attrCat).text();
        data.qty -= 1;
        zamanOnlineCart.deleteSetItem(data);
        $('#' + elm + ' .attribute-container-inner-detail').show();
        $('#' + elm).find('.set-attr-qty').text(data.qty);
        if (data.qty <= 0) {
            $('#' + elm + ' .attribute-container-inner-detail').hide();
            $('#colorbox').colorbox.resize();
        }
        displaySetItems();
    }
    function displaySetItems() {
        var listSetItem = zamanOnlineCart.listSetItem();
        if (listSetItem.length > 0) {
            var setItemString = '';
            for (var i in listSetItem) {
                setItemString += listSetItem[i].qty + ' ' + listSetItem[i].title + ',';
            }
            $('.msg.set-items').text(setItemString.substring(0, setItemString.length - 1)).show();
        } else {
            $('.msg.set-items').hide();
        }
    }

</script>