<div style="display: none;">
    <div id="orderTypeSelectionPopup">
        <div class="popup-container" id="orderTypePopup" >
            <?php echo form_open('cart/choose_order_type', array('id' => 'checkOrderTypeForm')); ?>
            <div class="tab-group keypad" >
                <div class="tab-item tab-item-title" id="orderTypeTitle"><span >Choose Order Type</span></div>
            </div>
            <div class="form-group">
                <div style="margin-left: 100px">
                      <div class="loader-delivery-type" style="display: none; color: #f3e337">processing please wait...</div>
                    <?php if ($hasCollection || $this->session->userdata('onlineOrderType') == 'collection'): ?>
                        <p id="orderType"><label><input type="radio" style="-ms-transform: scale(2);-webkit-transform: scale(2);transform: scale(2)" value="collection" data-error="#orderTypeChosenError" name="type">&nbsp;&nbsp;Collection</label></p>
                    <?php endif ?>
                    <?php if ($hasDelivery || $this->session->userdata('onlineOrderType') == 'delivery'): ?>
                        <p id="orderType"><label><input type="radio" style="-ms-transform: scale(2);-webkit-transform: scale(2);transform: scale(2)" value="delivery"  data-error="#orderTypeChosenError" id="deliveryOrderType"  name="type">&nbsp;&nbsp;Delivery</label></p>
                    <?php endif; ?>
                    <div id="orderTypeChosenError" style="color:red"></div>
                    <div class="form-group" style="display: none;" id="deliveryPostcodeBlock">
                        <label style="font-size: 17px;color:red;font-weight: bold">Your delivery postcode</label>
                        <input type="text" name="postcode" data-error="#orderTypeSelectionPopupPostcodeError" class="form-control text-uppercase" placeholder="AB1 2BC" style="width: 55%; border-radius: 3px;">
                        <div id="orderTypeSelectionPopupPostcodeError" style="color:red"></div>
                    </div>
                    <div><button type="submit" class="btn btn-fb btn-lg btn-block" id="orderTypeSubmitButton" onclick="submit_order_type('checkOrderTypeForm')">Submit</button></div>
                </div>
            </div>
            <?php echo form_close() ?>
        </div>
    </div>
</div>
<script type="text/javascript">
    function orderTypeSelectionPopup() {
        $.colorbox({
            inline: true,
            scrolling: false,
            href: "#orderTypeSelectionPopup",
            width: '420px',
            height: 'auto',
            maxWidth: "100%",
            open: true,
            closeButton: false,
            transition: 'none',
            overlayClose: false,
            className: 'transparent-overlay',
            onOpen: function () {
                $('#colorbox').colorbox.resize();
            },
            onLoad: function () {

            },
            onComplete: function () {
            },
            onCleanup: function () {

            },
            onClosed: function () {
                window.location.reload();
            }
        });
    }
    function submit_order_type(formId) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function () {
                        $('.loader-delivery-type').show();
                        $('#colorbox').colorbox.resize();
                    },
                    success: function (response) {
                        response.status ? closePopup() : $('#orderTypeSelectionPopupPostcodeError').text(response.message);
                        response.status ? $('.loader-delivery-type').show() : $('.loader-delivery-type').hide();
                    }
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {
                postcode: {required: true, postcodeUK: true},
                type: {required: true}
            },
            messages: {
                postcode: 'Please enter valid uk postcode',
                type: 'Please select order type'
            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
                $('#colorbox').colorbox.resize();
            }
        });
    }
    $(function () {
        $('#orderTypeSelectionPopup input[name="type"]').change(function () {
            var value = $(this).val();
            value === "delivery" ? $("#deliveryPostcodeBlock").show() : $("#deliveryPostcodeBlock").hide();
            $('#colorbox').colorbox.resize();
        });
    });
</script>