<div class="content">
    <section class="banner-2" id="pageHeaderBanner">
        <div class="container text-center banner-content ">
            <h1 class="text-uppercase common-page-heading page-title-2"><?php echo $current_section ?></h1>
        </div>
    </section>
    <section id="customerAccountIndex" class="common-page-bg">
        <div class="container">
            <div class="row">
                <div class="col c3">
                    <?php echo $this->load->view('myaccount/nav') ?>
                </div>
                <div class="col c9">
                    <div class="block-form">
                        <div class="tab-item heading text-left"><span class="icon icon-user">&nbsp;</span>Profile Information</div>
                        <?php if (empty($primaryAddress)): ?>
                            <div class="msg">Please provide your location information, it is required while you place your delivery order</div>
                        <?php endif; ?>
                        <?php echo form_open('my-account/profile', array('id' => 'CustomerProfileInfoForm')); ?>
                        <div class="form-group">
                            <label class="btn-block">Name</label>
                            <div class="tab-group"><input value="<?php echo $customer['name'] ?>" data-error="#nameError" type="text" name="name" placeholder="Name" class="smooth"></div>
                            <div class="error tab-group" id="nameError"></div>
                        </div>
                        <div class="form-group">
                            <label class="btn-block">Email Address</label>
                            <div class="tab-group"><input value="<?php echo $customer['email'] ?>" data-error="#emailError" type="text" name="email" placeholder="Email Address" class="smooth" disabled="disabled"></div>
                            <div class="error tab-group" id="emailError"></div>
                        </div>
                        <div class="form-group">
                            <label class="btn-block">Phone</label>
                            <div class="tab-group"><input value="<?php echo $customer['phone'] ?>" data-error="#phoneError" type="text" name="phone" placeholder="Phone" disabled="disabled" class="smooth"></div>
                            <div class="error tab-group" id="phoneError"></div>
                        </div>
                        <div class="row">
                            <div class="">Location information</div>
                            <div class="col c3">
                                <div class="form-group">
                                    <div class="tab-group"><input value="<?php echo isset($primaryAddress['building']) ? $primaryAddress['building'] : '' ?>" data-error="#buildingError" type="text" name="building" placeholder="House Name" class="smooth"></div>
                                    <div class="error tab-group" id="buildingError"></div>
                                </div>
                            </div>
                            <div class="col c3">
                                <div class="form-group">
                                    <div class="tab-group"><input value="<?php echo isset($primaryAddress['sector']) ? $primaryAddress['sector'] : '' ?>" data-error="#sectorError" type="text" name="sector" placeholder="House No" class="smooth"></div>
                                    <div class="error tab-group" id="sectorError"></div>
                                </div>
                            </div>
                            <div class="col c3">
                                <div class="form-group">
                                    <div class="tab-group"><input value="<?php echo isset($primaryAddress['street']) ? $primaryAddress['street'] : '' ?>" data-error="#streetError" type="text" name="street" placeholder="Street Name" class="smooth"></div>
                                    <div class="error tab-group" id="streetError"></div>
                                </div>
                            </div>
                            <div class="col c3">
                                <div class="form-group">
                                    <div class="tab-group"><input value="<?php echo isset($primaryAddress['postcode']) ? $primaryAddress['postcode'] : '' ?>" data-error="#postcodeError" type="text" name="postcode" placeholder="Postcode" class="text-capitalize smooth"></div>
                                    <div class="error tab-group" id="postcodeError"></div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="btn-block">City</label>
                            <div class="tab-group"><input value="<?php isset($thisAddress) ? print $thisAddress['city'] : print'' ?>" data-error="#cityError" type="text" name="city" placeholder="City" class="smooth text-capitalize"></div>
                            <!--<div class="tab-group">
                                <select class="smooth" name="city" data-error="#cityError">
                                    <option value="0">Select city</option>
                                    <?php if (!empty($cityList)): ?>
                                        <?php foreach ($cityList as $aCity): ?>
                                            <option value="<?php echo $aCity->title ?>" <?php isset($primaryAddress['city']) && $primaryAddress['city'] === $aCity->title ? print 'selected="selected"' : '' ?>><?php echo $aCity->title ?></option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>-->
                            <div class="error tab-group" id="cityError"></div>
                        </div>
                        <div class="msg" id="successMessage" style="display: none;"></div>
                        <div class="join-row-column">
                            <div class="form-group">
                                <button type="submit" class="btn btn-add-to-cart btn-c btn-lg btn-block text-center" onclick="validateCustomerProfileInfo('CustomerProfileInfoForm')">Submit</button>
                            </div>
                        </div>
                        <?php echo form_close() ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="v-gap-20"></div>
    </section>
</div>
<script type="text/javascript">
    function validateCustomerProfileInfo(formId) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        if (!response.success) {
                            $('#successMessage').text(response.message).show();
                        } else {
                            $('#successMessage').text(response.message).show();
                        }
                    }
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {
                name: {required: true, alphaonly: true},
                email: {required: true, email: true},
                phone: {required: true, phone: true},
                sector: {required: true},
                street: {required: true},
                postcode: {required: true, postcodeUK: true},
                city: {required: true, alphaonly: true}
            },
            messages: {
                name: "Your account name is required",
                email: "Your account email address is required",
                phone: 'Your account phone number is required',
                sector: "road number required",
                street: "Street required",
                postcode: 'Valid UK Postcode required',
                city: 'Your city is required'
            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }
</script>