<!--<link rel="stylesheet" href="<?php echo ONLINE_RESOURCES_PATH ?>stripe/normalize.css">-->
<link rel="stylesheet" href="<?php echo ONLINE_RESOURCES_PATH ?>stripe/global.css">
<script src="https://js.stripe.com/v3/"></script>
<div class="content">
    <section class="banner-2" id="pageHeaderBanner">
        <div class="v-gap-10"></div>
        <div class="container text-center banner-content ">
            <h1 class="text-uppercase common-page-heading page-title-2"><?php echo $current_section ?></h1>
        </div>
    </section>
    <section id="customerAccountIndex" class="common-page-bg-no">
        <div class="container">
            <div class="sr-root">
                <div class="sr-main">
                    <form id="payment-form" class="sr-payment-form">
                        <div class="sr-combo-inputs-row">
                            <div class="sr-input sr-card-element" id="card-element"></div>
                        </div>
                        <div class="sr-field-error" id="card-errors" role="alert"></div>
                        <button id="submit">
                            <div class="spinner hidden" id="spinner"></div>
                            <span id="button-text">Pay <?php echo to_currency($grandTotal) ?></span><span id="order-amount"></span>
                        </button>
                    </form>
                    <div class="sr-result hidden">
                        <p>Payment completed<br /></p>
                        <pre>
                            <code></code>
                        </pre>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<script>
// A reference to Stripe.js
    var stripe;
    var orderData = {
        items: [{id: "photo-subscription"}],
        currency: "usd"
    };
// Disable the button until we have Stripe set up on the page
    document.querySelector("button").disabled = true;
    fetch("<?php echo site_url('my-account/create-payment-intent') ?>", {
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        body: JSON.stringify(orderData)
    }).then(function (result) {
        return result.json();
    }).then(function (data) {
        return setupElements(data);
    }).then(function ( { stripe, card, clientSecret }) {
        document.querySelector("button").disabled = false;
        // Handle form submission.
        var form = document.getElementById("payment-form");
        form.addEventListener("submit", function (event) {
            event.preventDefault();
            // Initiate payment when the submit button is clicked
            pay(stripe, card, clientSecret);
        });
    });

// Set up Stripe.js and Elements to use in checkout form
    var setupElements = function (data) {
        stripe = Stripe(data.publishableKey);
        var elements = stripe.elements();
        var style = {
            base: {
                color: "#32325d",
                fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
                fontSmoothing: "antialiased",
                fontSize: "16px",
                "::placeholder": {
                    color: "#aab7c4"
                }
            },
            invalid: {
                color: "#fa755a",
                iconColor: "#fa755a"
            }
        };
        var card = elements.create("card", {style: style});
        card.mount("#card-element");
        return {
            stripe: stripe,
            card: card,
            clientSecret: data.clientSecret
        };
    };
    /*
     * Calls stripe.confirmCardPayment which creates a pop-up modal to
     * prompt the user to enter extra authentication details without leaving your page
     */
    var pay = function (stripe, card, clientSecret) {
        changeLoadingState(true);
        // Initiate the payment.
        // If authentication is required, confirmCardPayment will automatically display a modal
        stripe.confirmCardPayment(clientSecret, {
            payment_method: {
                card: card
            }
        }).then(function (result) {
            if (result.error) {
                // Show error to your customer
                showError(result.error.message);
            } else {
                // The payment has been processed!
                orderComplete(clientSecret);
            }
        });
    };

    /* ------- Post-payment helpers ------- */

    /* Shows a success / error message when the payment is complete */
    var orderComplete = function (clientSecret) {
        stripe.retrievePaymentIntent(clientSecret).then(function (result) {
            var paymentIntent = result.paymentIntent;
            $.ajax({
                method: "POST",
                url: "<?php echo site_url('myaccount/charge')?>",
                data: paymentIntent
            }).done(function (id) {
                location.href="<?php echo site_url('my-account/order-confirmation/')?>"+id;
                changeLoadingState(false);
            });
        });
    };

    var showError = function (errorMsgText) {
        changeLoadingState(false);
        var errorMsg = document.querySelector(".sr-field-error");
        errorMsg.textContent = errorMsgText;
        setTimeout(function () {
            errorMsg.textContent = "";
        }, 4000);
    };
// Show a spinner on payment submission
    var changeLoadingState = function (isLoading) {
        if (isLoading) {
            document.querySelector("button").disabled = true;
            document.querySelector("#spinner").classList.remove("hidden");
            document.querySelector("#button-text").classList.add("hidden");
        } else {
            document.querySelector("button").disabled = false;
            document.querySelector("#spinner").classList.add("hidden");
            document.querySelector("#button-text").classList.remove("hidden");
        }
    };

</script>





