<script src="https://js.stripe.com/v3/"></script>
<style>
    .StripeElement {background-color: white;padding: 10px 12px;border-radius: 4px;border: 1px solid transparent;box-shadow: 0 1px 3px 0 #e6ebf1;-webkit-transition: box-shadow 150ms ease;transition: box-shadow 150ms ease;}
    .StripeElement--focus {box-shadow: 0 1px 3px 0 #cfd7df;}
    .StripeElement--invalid {border-color: #fa755a;}
    .StripeElement--webkit-autofill {background-color: #fefde5 !important;}
    .online-payment-form {margin: 0 auto;padding: 17px 10px 1px 10px;background: #fff;border-radius: 10px;}
</style>
<div class="content">
    <section class="banner-2" id="pageHeaderBanner">
        <div class="v-gap-10"></div>
        <div class="container text-center banner-content ">
            <h1 class="text-uppercase common-page-heading page-title-2"><?php echo $current_section ?></h1>
        </div>
    </section>
    <section id="customerAccountIndex" class="common-page-bg-no">
        <div class="container">
            <div class="v-gap-40"></div>
            <div class="online-payment-form">
                <form action="<?php echo site_url('myaccount/charge') ?>" method="post" id="payment-form" style="top: 30%">
                    <div class="form-row">Please insert your credit/debit card details</div>
                    <div class="form-row">
                        <div id="card-element"></div>
                        <div id="card-errors" role="alert"></div>
                    </div>
                    <div class="tab-group config-submit">
                        <button class="submit-button btn btn-b" style="font-size: 17px;">Pay <?php echo to_currency($grandTotal) ?></button>
                    </div>
                </form>
            </div>
            <div class="v-gap-40"></div>
        </div>
    </section>
</div>
<script>
    if (window.module) {
        module = window.module;
    }
    var stripe = Stripe('<?php echo $pk ?>');
    var elements = stripe.elements();
    var style = {base: {color: '#32325d', fontFamily: '"Helvetica Neue", Helvetica, sans-serif', fontSmoothing: 'antialiased', fontSize: '16px', '::placeholder': {color: '#aab7c4'}}, invalid: {color: '#fa755a', iconColor: '#fa755a'}};
    var card = elements.create('card', {hidePostalCode: true, style: style});
    card.mount('#card-element');
    card.addEventListener('change', function (event) {
        var displayError = document.getElementById('card-errors');
        if (event.error) {
            displayError.textContent = event.error.message;
        } else {
            displayError.textContent = '';
        }
    });
    var form = document.getElementById('payment-form');
    form.addEventListener('submit', function (event) {
        event.preventDefault();
        stripe.createToken(card).then(function (result) {
            if (result.error) {
                var errorElement = document.getElementById('card-errors');
                errorElement.textContent = result.error.message;
            } else {
                $('.page-loader').show();
                $('.submit-button').attr('disabled', 'disabled');
                stripeTokenHandler(result.token);
            }
        });
    });
    function stripeTokenHandler(token) {
        var form = document.getElementById('payment-form');
        var hiddenInput = document.createElement('input');
        hiddenInput.setAttribute('type', 'hidden');
        hiddenInput.setAttribute('name', 'stripeToken');
        hiddenInput.setAttribute('value', token.id);
        form.appendChild(hiddenInput);
        form.submit();
    }
</script>