<div class="content">
    <section class="banner-2" id="pageHeaderBanner">
        <div class="container text-center banner-content ">
            <h1 class="text-uppercase common-page-heading page-title-2"><?php echo $current_section ?></h1>
        </div>
    </section>
    <section id="customerAccountIndex" class="common-page-bg-no">
        <div class="container">
            <div class="row">
                <div class="col c3">
                    <?php echo $this->load->view('myaccount/nav') ?>
                </div>
                <div class="col c9">
                    <div class="block-form">
                        <div class="tab-item heading text-left"><span class="icon icon-location"></span>Order Summary</div>
                        <div class="address-list">
                            <?php if (!empty($orders)): ?>
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Ref.#</th>
                                            <th class="hide-xs">Date Time</th>
                                            <th>Total</th>
                                            <th>Status</th>
                                            <th class="hide-xs">Type</th>
                                            <th>View</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $orderStatus = array('2' => 'Pending', '3' => 'Accepted', '4' => 'Rejected') ?>
                                        <?php $orderStatusColor = array('2' => '#f900ff', '3' => '#009e12', '4' => '#ff0000') ?>
                                        <?php foreach ($orders as $order): ?>
                                            <tr>
                                                <td><?php echo $order->sid . '/' . $order->orderId ?></td>
                                                <td class="hide-xs"><?php echo date('d/m/Y h:i a', strtotime($order->created_at)) ?></td>
                                                <td><?php echo to_currency($order->grandTotal) ?></td>
                                                <td class="text-capitalize">
                                                    <span style="color: <?php echo $orderStatusColor[$order->status_online] ?>"><?php echo $orderStatus[$order->status_online] ?></span>
                                                    <?php if ($order->status_online == '3'): ?>
                                                        <?php $orderInfo = unserialize($order->orderInfo) ?>
                                                        &nbsp;<span class="text-lowercase">[<?php $order->type === 'collection' ? print $orderInfo['collectionTime'] : print $orderInfo['deliveryTime'] ?>]</span>
                                                    <?php endif; ?>
                                                </td>
                                                </td>
                                                <td class="text-capitalize hide-xs"><?php echo $order->type ?></td>
                                                <td><a href="<?php echo site_url('my-account/orderdetail/' . $order->sid) ?>"><span style="color:#000" class="icon icon-eye"></span></a></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            <?php else: ?>
                                <div class="text-center">No orders found</div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="v-gap-20"></div>
    </section>
</div>
