<div class="content">
    <section class="banner-2" id="pageHeaderBanner">
        <div class="container text-center banner-content ">
            <h1 class="text-uppercase common-page-heading page-title-2"><?php echo $current_section ?></h1>
        </div>
    </section>
    <section id="customerAccountIndex" class="common-page-bg-no">
        <div class="container checkout">
            <div class="row">
                <div class="col c4 checkout">
                    <?php echo $this->load->view('myaccount/cart') ?>
                </div>
                <div class="col c8">
                    <?php echo form_open('myaccount/processingCheckout', array('id' => 'CustomerCheckoutProcessingForm')); ?>
                    <fieldset class="checkout-root-fieldset">
                        <legend class="order-cart-head">Checkout information form</legend>
                        <div class="customer-content-area">
                            <fieldset>
                                <legend>Customer Account information</legend>
                                <div class="form-group">
                                    <label class="btn-block">Name</label>
                                    <div class="tab-group"><input value="<?php echo $customer['name'] ?>" type="text" disabled="disabled" class="smooth"></div>
                                </div>
                                <div class="form-group">
                                    <label class="btn-block">Phone</label>
                                    <div class="tab-group"><input value="<?php echo $customer['phone'] ?>" type="text" disabled="disabled" class="smooth"></div>
                                </div>
                                <div class="form-group">
                                    <label class="btn-block">Email Address</label>
                                    <div class="tab-group"><input value="<?php echo $customer['email'] ?>" type="text" disabled="disabled" class="smooth"></div>
                                </div>
                            </fieldset>
                            <div class="join-row-column">
                                <fieldset class="fieldset">
                                    <legend>Receiving date and time</legend>
                                    <div class="col c6">
                                        <div class="form-group first">
                                            <label class="btn-block">Date</label>
                                            <div class="tab-group"><input value="<?php echo date('d/m/Y') ?>" type="text" readonly="readonly" class="smooth"></div>
                                        </div>
                                    </div>
                                    <div class="col c6">
                                        <div class="form-group second">
                                            <label class="btn-block">Time</label>
                                            <div class="tab-group">
                                                <select class="smooth" name="<?php ($this->session->userdata('onlineOrderType') === 'collection') ? print 'collectionTime' : print 'deliveryTime' ?>">
                                                    <?php if (!empty($timeSlot)): ?>
                                                        <?php foreach ($timeSlot as $aSlot): ?>
                                                            <option value="<?php echo $aSlot ?>"><?php echo $aSlot ?></option>
                                                        <?php endforeach; ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </fieldset>  
                            </div>
                            <div class="row">
                                <div class="col c6">
                                    <fieldset class="fieldset">
                                        <legend><?php ($this->session->userdata('onlineOrderType') === 'collection') ? print 'Collection' : print 'Delivery' ?> Receiver</legend>
                                        <div class="form-group">
                                            <label class="btn-block">Name</label>
                                            <div class="tab-group"><input value="<?php echo $customer['name'] ?>" data-error="#nameError" type="text" name="name" placeholder="Name" class="smooth"></div>
                                            <div class="error tab-group" id="nameError"></div>
                                        </div>
                                        <div class="form-group">
                                            <label class="btn-block">Phone</label>
                                            <div class="tab-group"><input value="<?php echo $customer['phone'] ?>" data-error="#phoneError" type="text" name="phone" placeholder="Phone" class="smooth"></div>
                                            <div class="error tab-group" id="phoneError"></div>
                                        </div>
                                        <?php if ($this->session->userdata('onlineOrderType') === 'delivery'): ?>
                                            <div class="form-group">
                                                <label class="btn-block">Use preset address/Add new one</label>
                                                <div class="tab-group">
                                                    <select class="smooth text-capitalize" id="addressBook" name="addressType" data-error="#addressTypeError">
                                                        <?php if (!empty($address)): ?>
                                                            <?php foreach ($address as $add): ?>
                                                                <option value="<?php echo $add->type ?>" <?php !empty($activeAddress) && $activeAddress['type'] == $add->type ? print'selected="selected"' : '' ?>><?php echo $add->type ?></option>
                                                            <?php endforeach; ?>
                                                        <?php endif; ?>
                                                        <option value="addnew"<?php !empty($activeAddress) && $activeAddress['type'] == "addnew" ? print'selected="selected"' : '' ?>>Add new</option>       
                                                    </select>
                                                </div>
                                                <div class="error tab-group" id="addressTypeError"></div>
                                            </div>
                                        <?php endif; ?>
                                    </fieldset>
                                </div>
                                <div class="col c6">
                                    <fieldset class="fieldset">
                                        <legend><?php ($this->session->userdata('onlineOrderType') === 'collection') ? print 'Collect From' : print 'Delivery Address Detail' ?> </legend>
                                        <?php if ($this->session->userdata('onlineOrderType') === 'collection'): ?>
                                            <div class="collection-address">
                                                <div class="restaurant-name"><strong><?php echo $this->config->item('general_name') ?></strong></div>
                                                <div><span class="icon icon-location"></span> <?php echo $restaurantInfo['address_street'] ?>, <?php echo $restaurantInfo['address_city'] ?>, <?php echo $restaurantInfo['address_postcode'] ?></div>
                                                <div><span class="icon icon-phone"></span>&nbsp;<?php echo $restaurantInfo['general_phone'] ?></div> 
                                            </div>
                                        <?php else: ?>
                                            <div class="delivery-address">
                                                <div class="join-row-column">
                                                    <div class="col c6">
                                                        <div class="form-group first">
                                                            <div class="clearfix">
                                                                <label class="btn-block">House Info</label>
                                                                <div class="tab-group"><input value="<?php !empty($activeAddress) ? print $activeAddress['building'] : '' ?>" data-error="#buildingError" type="text" name="building" placeholder="House Info" class="smooth"></div>
                                                            </div>
                                                            <div class="error tab-group" id="buildingError"></div>
                                                        </div></div>
                                                    <div class="col c6">
                                                        <div class="form-group second">
                                                            <div class="clearfix">
                                                                <label class="btn-block">Street No</label>
                                                                <div class="tab-group"><input value="<?php !empty($activeAddress) ? print $activeAddress['sector'] : '' ?>" data-error="#sectorError" type="text" name="sector" placeholder="Street No" class="smooth" <?php !empty($activeAddress) && trim($activeAddress['sector']) ? print 'readonly="readonly"' : '' ?>></div>
                                                            </div>
                                                            <div class="error tab-group" id="sectorError"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="join-row-column">
                                                    <div class="col c6">
                                                        <div class="form-group first">
                                                            <div class="clearfix">
                                                                <label class="btn-block">Street Name</label>
                                                                <div class="tab-group"><input value="<?php !empty($activeAddress) ? print $activeAddress['street'] : '' ?>" data-error="#streetError" type="text" name="street" placeholder="Street Name" class="smooth" <?php !empty($activeAddress) && trim($activeAddress['street']) ? print 'readonly="readonly"' : '' ?>></div>
                                                            </div>
                                                            <div class="error tab-group" id="streetError"></div>
                                                        </div></div>
                                                    <div class="col c6">
                                                        <div class="form-group second">
                                                            <div class="clearfix">
                                                                <label class="btn-block">Postcode</label>
                                                                <div class="tab-group"><input value="<?php !empty($activeAddress) ? print $activeAddress['postcode'] : '' ?>" data-error="#postcodeError" type="text" name="postcode" placeholder="Postcode" class="smooth" <?php !empty($activeAddress) && trim($activeAddress['postcode']) ? print 'readonly="readonly"' : '' ?>></div>
                                                            </div>
                                                            <div class="error tab-group" id="postcodeError"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <div class="clearfix">
                                                        <label class="btn-block">City</label>
                                                        <div class="tab-group"><input data-error="#cityError" name="city" value="<?php !empty($activeAddress) ? print $activeAddress['city'] : '' ?>"  type="text" class="smooth" placeholder="City" <?php !empty($activeAddress) && trim($activeAddress['city']) ? print 'readonly="readonly"' : '' ?>></div>
                                                    </div>
                                                    <div class="error tab-group" id="cityError"></div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </fieldset>
                                </div>
                            </div>
                            <div class="join-row-column" style="font-size: 18px; color: #d33;">
                                <div class="clearfix">
                                    <div class="form-group"><label><input type="checkbox" id="promoBlockChanger" <?php $this->session->userdata('promoDiscountPlan') ? print'checked="checked"' : '' ?>>&nbsp;I have a promo code</label></div>
                                    <div id="promoBlock" class="tab-group"style="border: none; <?php $this->session->userdata('promoDiscountPlan') ? '' : print'display: none;' ?>;"><input value="<?php $this->session->userdata('promoDiscountPlan') ? print $this->session->userdata('promoDiscountPlan')['promocode'] : '' ?>" data-error="#promocodeError" type="text" name="promocode" id="promoCode" class="smooth" placeholder="Your promo code"><span class="addon"><a href="javascript:void(0)" onclick="<?php $this->session->userdata('promoDiscountPlan') ? print'removePromocode()' : print'applyPromocode()' ?>"><?php $this->session->userdata('promoDiscountPlan') ? print 'Remove' : print 'Apply' ?></a></span></div>
                                </div>
                                <div class="error tab-group" id="promocodeError"></div>
                            </div>
                            <div class="join-row-column" style="font-size: 18px; color: #d33;">
                                <div class="clearfix">
                                    <div class="form-group"><label><input type="checkbox" id="noteBlockChanger">&nbsp;Any Special Information </label></div>
                                    <div id="noteBlock" class="tab-group"style="border: none; display: none;"><textarea data-error="#noteError" name="note" class="smooth"></textarea></div>
                                </div>
                                <div class="error tab-group" id="noteError"></div>
                            </div>
                            <div class="row">
                                <fieldset style="font-size: 18px; color: #d33;">
                                    <legend>Choose Payment Type</legend>
                                    <div class="form-group clearfix">
                                        <label><input <?php empty($stripe) ? print 'checked="checked"' : '' ?> type="radio" data-error="#paymentError" name="payment" value="cash"><span>&nbsp;</span><span>Cash</span></label>
                                        <?php if (!empty($stripe)): ?>
                                            <label><input type="radio" data-error="#paymentError" name="payment" value="card"><span>&nbsp;</span><span>Card</span></label>
                                        <?php endif; ?>
                                    </div>
                                    <div class="error tab-group" id="paymentError"></div>
                                </fieldset>
                            </div>
                            <div class="row">
                                <button type="submit" class="btn btn-fb" onclick="submitCheckoutInformation('CustomerCheckoutProcessingForm')">Confirm Order</button>
                                &nbsp;&nbsp;&nbsp; <a  href="<?php echo site_url('online-order') ?>" class="btn">Cancel</a>
                            </div>
                        </div>
                    </fieldset>
                    <?php echo form_close() ?>
                </div>
            </div>
        </div>
    </section>
</div>
<?php echo $this->load->view('myaccount/checkoutjs') ?>
<?php echo $this->load->view('onlineorder/postcode') ?>
<script>
    function submitCheckoutInformation(formId) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        if (!response.status) {
                            window.location.reload();
                        } else {
                            window.location.href = '<?php echo base_url() ?>' + response.urlToRedirect;
                        }
                    }
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {
                name: {required: true},
                phone: {required: true},
                promocode: {required: $('#promoBlockChanger').is(':checked') ? true : false},
                note: {required: $('#noteBlockChanger').is(':checked') ? true : false},
                addressType: {required: true},
                sector: {required: true},
                street: {required: true},
                postcode: {required: true},
                city: {required: true},
                payment: {required: true}
            },
            messages: {
                name: "Receiver name is rwuired",
                phone: "Receiver phone is required",
                promocode: 'Please proivide promo code',
                note: 'Please specify something on note',
                sector: 'Street no?',
                street: 'Strteet name?',
                postcode: 'Your Postcodde?',
                city: 'City name',
                payment: 'Please choose your payment type'
            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }
    function applyPromocode() {
        var promocode = $('#promoCode').val();
        if (!$.trim(promocode)) {
            $('#promocodeError').text('Please provide promo code then apply');
        } else {
            $.ajax({
                url: '<?php echo site_url('myaccount/applypromocode') ?>',
                type: 'post',
                dataType: 'json',
                data: {promocode: promocode},
                success: function (response) {
                    if (!response.status) {
                        $('#promocodeError').text(response.message);
                    } else {
                        window.location.reload();
                    }
                }
            });
        }
    }
    function removePromocode() {
        $.ajax({
            url: '<?php echo site_url('myaccount/removepromocode') ?>',
            type: 'post',
            dataType: 'json',
            success: function (response) {
                if (response.status) {
                    window.location.reload();
                } else {
                    window.location.reload();
                }
            }
        });
    }
</script>


