<div class="content">
    <section class="banner-2" id="pageHeaderBanner">
        <div class="container text-center banner-content ">
            <h1 class="text-uppercase common-page-heading page-title-2"><?php echo $current_section ?></h1>
        </div>
    </section>
    <section id="customerAccountIndex" class="common-page-bg-no">
        <div class="container">
            <div class="row">
                <div class="col c3">
                    <?php echo $this->load->view('myaccount/nav') ?>
                </div>
                <div class="col c9">
                    <div class="block-form">
                        <div class="tab-item heading text-left"><span class="icon icon-location"></span>Address Book</div>
                        <div class="address-list">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Label</th>
                                        <th>House Name</th>
                                        <th>House No</th>
                                        <th>Street Name</th>
                                        <th>Postcode</th>
                                        <th>City</th>
                                        <th>Edit</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (!empty($address)): ?>
                                        <?php foreach ($address as $anAddress): ?>
                                            <tr>
                                                <td><?php echo $anAddress->type ?></td>
                                                <td><?php echo $anAddress->building ?></td>
                                                <td><?php echo $anAddress->sector ?></td>
                                                <td><?php echo $anAddress->street ?></td>
                                                <td><?php echo $anAddress->postcode ?></td>
                                                <td><?php echo $anAddress->city ?></td>
                                                <td><a href="<?php echo site_url('my-account/address/' . $anAddress->id) ?>"><span style="color:#000" class="icon icon-pencil"></span></a></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        <?php echo form_open('myaccount/address', array('id' => 'CustomerAddressForm')); ?>
                        <div class="caption">Add New address/Update An Address</div>
                        <div class="row">
                            <div class="col c2">
                                <div class="form-group">
                                    <label class="btn-block">Label</label>
                                    <div class="tab-group"><input value="<?php isset($thisAddress) ? print $thisAddress['type'] : print'' ?>" data-error="#typeError" type="text" id="addressLabel" name="type" placeholder="Label" class="smooth" <?php isset($thisAddress) && $thisAddress['type'] === 'primary' ? print 'disabled="disabled"' : print'' ?>></div>
                                    <div class="error tab-group" id="typeError"></div>
                                </div>
                            </div>
                            <div class="col c2">
                                <div class="form-group">
                                    <label class="btn-block">House Name</label>
                                    <div class="tab-group"><input value="<?php isset($thisAddress) ? print $thisAddress['building'] : print'' ?>" data-error="#buildingError" type="text" name="building" placeholder="House Name" class="smooth"></div>
                                    <div class="error tab-group" id="buildingError"></div>
                                </div>
                            </div>
                            <div class="col c2">
                                <div class="form-group">
                                    <label class="btn-block">House No</label>
                                    <div class="tab-group"><input value="<?php isset($thisAddress) ? print $thisAddress['sector'] : print'' ?>" data-error="#sectorError" type="text" name="sector" placeholder="House No" class="smooth"></div>
                                    <div class="error tab-group" id="sectorError"></div>
                                </div>
                            </div>
                            <div class="col c2">
                                <div class="form-group">
                                    <label class="btn-block">Street Name</label>
                                    <div class="tab-group"><input value="<?php isset($thisAddress) ? print $thisAddress['street'] : print'' ?>" data-error="#streetError" type="text" name="street" placeholder="Street Name" class="smooth"></div>
                                    <div class="error tab-group" id="streetError"></div>
                                </div>
                            </div>
                            <div class="col c2">
                                <div class="form-group">
                                    <label class="btn-block">Postcode</label>
                                    <div class="tab-group"><input value="<?php isset($thisAddress) ? print $thisAddress['postcode'] : print'' ?>" data-error="#postcodeError" type="text" name="postcode" placeholder="Postcode" class="smooth text-capitalize"></div>
                                    <div class="error tab-group" id="postcodeError"></div>
                                </div>
                            </div>
                            <div class="col c2">
                                <div class="form-group">
                                    <label class="btn-block">City</label>
                                     <div class="tab-group"><input value="<?php isset($thisAddress) ? print $thisAddress['city'] : print'' ?>" data-error="#cityError" type="text" name="city" placeholder="City" class="smooth text-capitalize"></div>
                                    <!--<div class="tab-group">
                                        <select class="smooth" name="city" data-error="#cityError">
                                            <option value="0">Select city</option>
                                            <?php if (!empty($cityList)): ?>
                                                <?php foreach ($cityList as $aCity): ?>
                                                    <option value="<?php echo $aCity->title ?>" <?php isset($thisAddress) && $thisAddress['city'] === $aCity->title ? print 'selected="selected"' : '' ?>><?php echo $aCity->title ?></option>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </select>
                                    </div>-->
                                    <div class="error tab-group" id="cityError"></div>
                                </div>
                            </div>
                        </div>
                        <div class="msg" id="successMessage" style="display: none;"></div>
                        <div class="join-row-column">
                            <div class="form-group">
                                <?php if (isset($thisAddress)): ?>
                                    <input type="hidden" name="id" value="<?php echo $thisAddress['id'] ?>">
                                    <input type="hidden" id="oldAddressLabel" value="<?php echo $thisAddress['type'] ?>">
                                <?php endif; ?>
                                <button type="submit" class="btn btn-add-to-cart btn-c btn-lg btn-block text-center" onclick="validateCustomerAddress('CustomerAddressForm')">Submit</button>
                            </div>
                        </div>
                        <?php echo form_close() ?>
                    </div>

                </div>
            </div>
        </div>
    </section>
</div>
<script type="text/javascript">
    function validateCustomerAddress(formId) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        if (!response.success) {
                            $('#successMessage').text(response.message).show();
                        } else {
                            $('#successMessage').text(response.message).show();
                            window.location.reload();
                        }
                    }
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {
                type: {
                    required: true,
                    alphaonly: true,
                    remote: {
                        url: "<?php echo site_url('myaccount/checkAddressType') ?>",
                        type: "post",
                        data: {
                            value: function () {
                                return $("#addressLabel").val();
                            },
                            column: 'type',
                            old: function () {
                                if ($('#oldAddressLabel').length > 0) {
                                    return $('#oldAddressLabel').val();
                                } else {
                                    return 'none';
                                }
                            },
                            update: function () {
                                if ($('#oldAddressLabel').length > 0) {
                                    return 'yes';
                                } else {
                                    return 'no';
                                }
                            }
                        }
                    }
                },
                sector: {required: true},
                street: {required: true},
                postcode: {required: true, postcodeUK: true},
                city: {required: true, alphaonly: true}
            },
            messages: {
                sector: "road number required",
                street: "Street required",
                postcode: 'Valid UK Postcode required',
                city: 'Your city is required'
            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }
</script>