<div class="content">
    <section class="banner-2" id="pageHeaderBanner">
        <div class="container text-center banner-content ">
            <h1 class="text-uppercase common-page-heading page-title-2"><?php echo $current_section ?></h1>
        </div>
    </section>
    <?php if (trim($content)): ?>
        <section class="section-content-half">
            <div class="container">
                <div class="half-page-design">
                    <?php echo $content ?>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <section id="signup" class="common-page-bg-no">
        <div class="container">
            <div class="v-gap-10"></div>
            <div class="signup-form action-form lg-view">
                <div class="msg" id="successMessage" style="display: none"></div>
                <?php echo form_open('takeaway/customer_signup_validation', array('id' => 'customerSigingupForm')); ?>
                <div class="form-group">
                    <label class="btn-block">Name</label>
                    <div class="tab-group"><input data-error="#nameError" type="text" value="<?php isset($name) ? print $name : '' ?>"  name="name" placeholder="Name" class="smooth"></div>
                    <div class="error tab-group" id="nameError"><?php $this->session->flashdata('name') ? print $this->session->flashdata('name') : '' ?></div>
                </div>
                <div class="form-group">
                    <label class="btn-block">Email Address</label>
                    <div class="tab-group"><input data-error="#emailError" type="text" value="<?php isset($email) ? print $email : '' ?>"  name="email" placeholder="Email Address" class="smooth"></div>
                    <div class="error tab-group" id="emailError"><?php $this->session->flashdata('email') ? print $this->session->flashdata('email') : '' ?></div>
                </div>
                <div class="form-group">
                    <label class="btn-block">Phone</label>
                    <div class="tab-group"><input data-error="#phoneError" type="text" name="phone" placeholder="Phone" class="smooth"></div>
                    <div class="error tab-group" id="phoneError"><?php $this->session->flashdata('phone') ? print $this->session->flashdata('phone') : '' ?></div>
                </div>
                <div class="form-group first">
                    <label class="btn-block">Password</label>
                    <div class="tab-group"><input data-error="#passwordError" type="password"  name="password" placeholder="Password" id="userPassword" class="smooth"></div>
                    <div class="error tab-group" id="passwordError"><?php $this->session->flashdata('password') ? print $this->session->flashdata('password') : '' ?></div>
                </div>
                <div class="form-group second">
                    <label class="btn-block">Confirm Password</label>
                    <div class="tab-group"><input data-error="#confirmPasswordError" type="password" name="confirm_password" placeholder="Confirm Password" class="smooth"></div>
                    <div class="error tab-group" id="confirmPasswordError"><?php $this->session->flashdata('confirm_password') ? print $this->session->flashdata('confirm_password') : '' ?></div>
                </div>
                <div class="form-group">
                    <div class="tab-group"><label><input data-error="#termsConditionError" type="checkbox" name="termscon">&nbsp;I agree with the <a href="#">terms and conditions</a></label></div>
                    <div class="error tab-group" id="termsConditionError"></div>
                </div>
                <div class="form-group">
                    <div class="g-recaptcha btn-block" data-sitekey="<?php echo $restaurantInfo['captchaSiteKey'] ?>"></div>
                    <div class="error" id="grecaptcharesponseError"><?php $this->session->flashdata('g-recaptcha-response') ? print $this->session->flashdata('g-recaptcha-response') : '' ?></div>
                </div>

                <div class="join-row-column">
                    <div class="form-group">
                        <button type="submit" class="btn btn-add-to-cart btn-c btn-lg btn-block text-center" onclick="validateCustomerSigningUpInfo('customerSigingupForm')">Submit</button>
                    </div>
                </div>
                <?php echo form_close() ?>
                <div class="row">Already you have an account? <a href="<?php echo site_url('customer-login') ?>">Login</a></div>
            </div>
        </div>
    </section>
</div>
<script type="text/javascript">
    function validateCustomerSigningUpInfo(formId) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        if (!response.success) {
                            if (response.errors.name !== 'undefined') {
                                $('#nameError').text(response.errors.name);
                            }
                            if (response.errors.email !== 'undefined') {
                                $('#emailError').text(response.errors.email);
                            }
                            if (response.errors.phone !== 'undefined') {
                                $('#phoneError').text(response.errors.phone);
                            }
                            if (response.errors.grecaptcharesponse !== 'undefined') {
                                $('#grecaptcharesponseError').text(response.errors.grecaptcharesponse);
                            }
                        } else {
                            $('#successMessage').text(response.success_msg).show();
                            sleep(1000).then(function () {
                                window.location.href = "<?php echo site_url('customer-login') ?>";
                            });
                        }
                    }
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {
                name: {required: true, alphaonly: true},
                email: {required: true, email: true},
                phone: {required: true, phone: true},
                password: {required: true},
                confirm_password: {equalTo: "#userPassword"},
                termscon: {required: true}
            },
            messages: {
                name: 'You name please',
                email: "Your valid email address",
                phone: 'Your valid phone number',
                password: 'Your account password',
                termscon: 'Need to agree with our terms and conditions',
                confirm_password: 'Password not matched'
            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }
    $(document).ready(function () {
        resetForm('customerSigingupForm');
    });
</script>

