<div class="content">
    <section class="banner-2" id="pageHeaderBanner">
        <div class="container text-center banner-content ">
            <h1 class="text-uppercase common-page-heading page-title-2"><?php echo $current_section ?></h1>
        </div>
    </section>
    <?php if (trim($content)): ?>
        <section class="section-content-half">
            <div class="container">
                <div class="half-page-design text-center">
                    <?php echo $content ?>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <section id="login" class="common-page-bg-no">
        <div class="container">
            <div class="v-gap-10"></div>
            <div class="login-form action-form lg-view">
                <div class="msg" id="successMessage" style="display: none"></div>
                <?php echo form_open('takeaway/customer_login_validation', array('id' => 'customerLoginForm')); ?>
                <div class="form-group">
                    <label class="btn-block">Email Address</label>
                    <div class="tab-group"><input data-error="#emailError" type="text" name="email" placeholder="Email Address" class="smooth"></div>
                    <div class="error tab-group" id="emailError"></div>
                </div>
                <div class="form-group">
                    <label class="btn-block">Password</label>
                    <div class="tab-group"> <input data-error="#PasswordError" type="password" name="password" placeholder="Password" class="smooth"></div>
                    <div class="error tab-group" id="PasswordError"></div>
                </div>
                <div class="join-row-column">
                    <div class="form-group">
                        <button type="submit" class="btn  btn-c btn-lg btn-block text-center" onclick="validateCustomerLoginInfo('customerLoginForm')">Submit</button>
                    </div>
                </div>
                <?php echo form_close() ?>
                <div class="row"><a href="<?php echo site_url('account-recovery') ?>">Forgot Password?</a> &nbsp; Don't have account yet? <a href="<?php echo site_url('customer-signup') ?>">Sign Up</a></div>
            </div>
        </div>
    </section>
</div>
<script type="text/javascript">
    function validateCustomerLoginInfo(formId) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        if (!response.success) {
                            $('#successMessage').text(response.message).show();
                        } else {
                            $('#successMessage').text('Please wait...').show();
                            window.location.href = "<?php echo site_url('customer-login') ?>";
                        }
                    }
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {
                email: {required: true, email: true},
                password: {required: true}
            },
            messages: {
                email: "Your account email address is required",
                password: 'Your account password is required'
            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }
    $(document).ready(function () {
        resetForm('customerLoginForm');
    });
</script>
