<div class="content">
    <section class="banner-2" id="pageHeaderBanner">
        <div class="container text-center banner-content ">
            <h1 class="text-uppercase common-page-heading page-title-2"><?php echo $current_section ?></h1>
        </div>
    </section>
    <?php if (trim($content)): ?>
        <section class="section-content-half">
            <div class="container">
                <div class="half-page-design">
                    <?php echo $content ?>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <section id="contact" class="common-page-bg-no">
        <div class="container">
            <div class="row">
                <div class="col c8">
                    <div class="sidebar page-left">
                        <article class="text-center action-form contact-info">
                            <div><?php echo $restaurantInfo['address_street'] ?>, <?php echo $restaurantInfo['address_city'] ?>, <?php echo $restaurantInfo['address_postcode'] ?></div>
                            <div>Phone&nbsp;:&nbsp;<?php echo $restaurantInfo['general_phone'] ?><?php echo trim($restaurantInfo['general_mobile']) ? '&nbsp;/&nbsp;' . $restaurantInfo['general_mobile'] : '' ?></div>
                            <div>Email&nbsp;:&nbsp;<span class="text-lowercase"><?php echo $restaurantInfo['general_email'] ?></span></div>

                        </article>
                        <div class="action-form map">
                            <div class="map-inner">
                                <div class="text-center">Our Location Map</div>
                                <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2463.954378628356!2d-2.2089962841022475!3d51.86178939255024!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x487105b84b4e9f89%3A0x8f977936ed1a7c57!2sSpice%20House!5e0!3m2!1sen!2sbd!4v1593364412039!5m2!1sen!2sbd" width="100%" height="450" frameborder="0" style="border:0;" allowfullscreen="" aria-hidden="false" tabindex="0"></iframe>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col c4">
                    <div class="sidebar page-right">
                        <div class="contact-form action-form">
                            <div class="opening-hour-box">
                                <div class="tab-item" onclick="showHideTodaysHours()" style='background:#82636394;font-size: 20px;'>Today's Hours</div>
                                <div class="todays-openingTime">
                                    <table class="table table-striped" id='todaysOpeningHour' style='background: transparent; color:#0cb043'>
                                        <?php foreach (serviceTime() as $key => $serviceTimeHead): ?>
                                            <tr style='background: transparent; color:#0cb043'>
                                                <td style='background: transparent'><?php echo $key ?></td>
                                                <?php foreach ($serviceTimeHead as $day => $timeSlot): ?>
                                                    <?php if ($day === date('D')): ?>
                                                        <td style='background: transparent'><?php $timeSlot->opened == '3' ? print strtoupper($timeSlot->start . ' - ' . $timeSlot->end) : print 'Closed' ?></td>
                                                    <?php endif; ?>
                                                <?php endforeach; ?>
                                            </tr>
                                        <?php endforeach; ?>
                                    </table>
                                </div>
                                <div class="tab-item" onclick="showHideOpeningTimeTable()" style='background:#82636394;font-size: 20px;border: none;'>Show All Days</div>
                                <div id='openingTimeTable' style='display: none;'>
                                    <?php echo $this->load->view('components/opening_time') ?>
                                </div>
                            </div>
                            <div><?php $this->session->flashdata('success') ? print '<span class="success">' . $this->session->flashdata('success') . '</span>' : print '<span style="font-size:14px;">Please feel free to send us your query</span>' ?></div>
                            <form method="post" action="<?php echo site_url('takeaway/contact_sent') ?>" id="contactForm">
                                <div class="form-group">
                                    <label class="btn-block">Name</label>
                                    <div class="tab-group"><input data-error="#nameError" type="text" value="<?php isset($name) ? print $name : '' ?>"  name="name" placeholder="First name" class="smooth"></div>
                                    <div class="error tab-group" id="nameError"></div>
                                </div>
                                <div class="form-group">
                                    <label class="btn-block">Email Address</label>
                                    <div class="tab-group"><input data-error="#emailError" type="text" value="<?php isset($email) ? print $email : '' ?>"  name="email" placeholder="Email Address" class="smooth"></div>
                                    <div class="error tab-group" id="emailError"><?php $this->session->flashdata('email') ? print $this->session->flashdata('email') : '' ?></div>
                                </div>
                                <div class="form-group">
                                    <label class="btn-block">Phone</label>
                                    <div class="tab-group"><input data-error="#phoneError" type="text" value="<?php isset($phone) ? print $phone : '' ?>"  name="phone" placeholder="Phone" class="smooth"></div>
                                    <div class="error tab-group" id="phoneError"><?php $this->session->flashdata('phone') ? print $this->session->flashdata('phone') : '' ?></div>
                                </div>
                                <div class="form-group">
                                    <label class="btn-block">Message</label>
                                    <div class="tab-group"><textarea data-error="#messageError" rows="2" name="message" class="smooth"><?php isset($message) ? print $message : '' ?></textarea></div>
                                    <div class="error tab-group" id="messageError"></div>
                                </div>
                                <div class="form-group">
                                    <div class="tab-group"><div class="g-recaptcha btn-block" data-sitekey="<?php echo $restaurantInfo['captchaSiteKey'] ?>"></div></div>
                                    <div class="error tab-group" id="grecaptcharesponseError"></div>
                                </div>
                                <div class="join-row-column clearfix">
                                    <div class="form-group">
                                        <button type="submit" class="btn  btn-c btn-lg btn-block text-center" onclick="submitContact('contactForm')">Submit</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<script type="text/javascript">
    function submitContact(formId) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        if (!response.success) {
                            if (response.errors.name !== 'undefined') {
                                $('#nameError').text(response.errors.name);
                            }
                            if (response.errors.email !== 'undefined') {
                                $('#emailError').text(response.errors.email);
                            }
                            if (response.errors.phone !== 'undefined') {
                                $('#phoneError').text(response.errors.phone);
                            }
                            if (response.errors.note !== 'undefined') {
                                $('#messageError').text(response.errors.message);
                            }
                            if (response.errors.grecaptcharesponse !== 'undefined') {
                                $('#grecaptcharesponseError').text(response.errors.grecaptcharesponse);
                            }
                        } else {
                            window.location.href = "<?php echo site_url('contact') ?>";
                        }
                    }
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {
                name: {required: true, alphaonly: true},
                email: {required: true, email: true},
                phone: {required: true, phone: true},
                message: {required: true, alphanumeric: true}
            },
            messages: {
                name: "Your valid name is required",
                email: "Provide your valid email address",
                phone: 'Your valid phone number',
                message: 'Please write something valid as message'
            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }

    function showHideTodaysHours() {
        $('#openingTimeTable').hide();
        $('#todaysOpeningHour').slideToggle('slow');
    }
    function showHideOpeningTimeTable() {
        $('#todaysOpeningHour').hide();
        $('#openingTimeTable').slideToggle('slow');
    }
</script>