<?php if (!empty(getFeaturedItems()['menus'])): ?>
    <?php
    $specialItems = getFeaturedItems();
    $specialMenus = $specialItems['menus'];
    $specialSelections = isset($specialItems['selections']) ? $specialItems['selections'] : array();
    ?>
    <section id="specialOffer">
        <div class="v-gap-10"></div>
        <div class="container">
            <h1 class="text-center page-title">Special Offers</h1>
            <div class="row">
                <div class="col c12 feature-menus">
                    <?php foreach ($specialMenus as $item): ?>
                        <?php if (!empty($specialSelections) && !empty($specialSelections[$item->id])): ?>
                            <?php foreach ($specialSelections[$item->id] as $itemSelection): ?>
                                <div class="col c3">
                                    <div class="block">
                                        <div class="block-inner">
                                            <div class="block-image"><span class="circle-price"><?php echo getItemPrice($itemSelection) ?></span><img src="<?php echo EPOS_UPLOAD_PATH . 'menuselection/' . $itemSelection->image ?>"/></div>
                                            <div class="block-title text-center item-title"><?php echo $itemSelection->title . '-' . $item->title ?></div>
                                            <div class="block-description text-center item-description"><?php trim($itemSelection->content) ? print $itemSelection->content : print'&nbsp;' ?></div>
                                            <div class="block-btn text-center"><a href="<?php echo site_url('online-order#categoryTab' . $itemSelection->category . 'Content') ?>" class="btn btn-sm btn-c btn-block btn-add-to-cart">Order Now</a></div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <div class="col c3">
                                <div class="block">
                                    <div class="block-inner">
                                        <div class="block-image"><span class="circle-price"><?php echo getItemPrice($item) ?></span><img src="<?php echo EPOS_UPLOAD_PATH . 'menu/' . $item->image ?>"/></div>
                                        <div class="block-title text-center item-title"><?php echo $item->title ?></div>
                                        <div class="block-description text-center item-description"><?php trim($item->content) ? $item->content : print'&nbsp;' ?></div>
                                        <div class="block-btn text-center"><a href="<?php echo site_url('online-order#categoryTab' . $item->category . 'Content') ?>" class="btn btn-sm btn-c btn-block btn-add-to-cart">Order Now</a></div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <div class="v-gap-10"></div>
    </section>
<?php endif; ?>