<div class="content">
    <section class="banner-2" id="pageHeaderBanner">
        <div class="container text-center banner-content ">
            <h1 class="text-uppercase common-page-heading title"><?php echo $current_section ?></h1>
        </div>
    </section>
    <section id="login" class="common-page-bg-no">
        <div class="container">
            <div class="v-gap-20"></div>
            <div class="login-form action-form lg-view">
                <div class="msg" id="successMessage" style="display: none"></div>
                <?php echo form_open('takeaway/change_password', array('id' => 'customerChangePasswordForm')); ?>
                <div class="form-group">
                    <label class="btn-block">Password</label>
                    <div class="tab-group"> <input data-error="#PasswordError" id='userPassword' type="password" name="password" placeholder="Password" class="smooth"></div>
                    <div class="error tab-group" id="PasswordError"></div>
                </div>
                <div class="form-group">
                    <label class="btn-block">Confirm Password</label>
                    <div class="tab-group"> <input data-error="#confirmPasswordError" type="password" name="confirm_password" placeholder="Password" class="smooth"></div>
                    <div class="error tab-group" id="confirmPasswordError"></div>
                </div>
                <div class="join-row-column">
                    <div class="form-group">
                        <button type="submit" class="btn  btn-c btn-lg btn-block text-center" onclick="validateChangePassword('customerChangePasswordForm')">Submit</button>
                    </div>
                </div>
                <?php echo form_close() ?>
            </div>
        </div>
    </section>
</div>

<script type="text/javascript">
    function validateChangePassword(formId) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        window.location.href = "<?php echo site_url('customer-login') ?>";
                    }
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {
                password: {required: true},
                confirm_password: {equalTo: "#userPassword"},
            },
            messages: {
                password: 'Your account password is required'
            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }
</script>
