<div class="content">
    <section class="banner-2" id="pageHeaderBanner">
        <div class="container text-center banner-content ">
            <h1 class="text-uppercase common-page-heading title"><?php echo $current_section ?></h1>
        </div>
    </section>
    <section id="login" class="common-page-bg-no">
        <div class="container">
            <div class="v-gap-20"></div>
            <div class="login-form action-form lg-view">
                <?php if ($this->session->flashdata('verificationEmailMsg')): ?>
                    <div class="msg"><?php echo $this->session->flashdata('verificationEmailMsg') ?></div>
                    <br/>
                    <?php echo form_open('takeaway/verify_account_recovery_code', array('id' => 'customerAccountRecoveryCode')); ?>
                    <div class="form-group">
                        <div class="tab-group"><input data-error="#verificationCodeError" type="text" name="code" placeholder="Verfication code" class="smooth"></div>
                        <div class="error tab-group" id="verificationCodeError"></div>
                    </div>
                    <div class="join-row-column">
                        <div class="form-group">
                            <button type="submit" class="btn  btn-c btn-lg btn-block text-center" onclick="veryfyCustomerAccountRecoveryCode('customerAccountRecoveryCode')">Submit</button>
                        </div>
                    </div>
                    <?php echo form_close() ?>
                <?php else: ?>
                    <div class="msg" id="successMessage" style="display: none"></div>
                    <?php echo form_open('takeaway/validate_account_recovery', array('id' => 'customerAccountRecoveryForm')); ?>
                    <div class="form-group">
                        <label class="btn-block">Recovery account email address</label>
                        <div class="tab-group"><input data-error="#emailError" type="text" name="email" placeholder="Email address" class="smooth"></div>
                        <div class="error tab-group" id="emailError"></div>
                    </div>
                    <div class="join-row-column">
                        <div class="form-group">
                            <button type="submit" class="btn  btn-c btn-lg btn-block text-center" onclick="customerAccountRecovery('customerAccountRecoveryForm')">Submit</button>
                        </div>
                    </div>
                    <?php echo form_close() ?>
                <?php endif; ?>
            </div>
        </div>
    </section>
</div>


<script type="text/javascript">
    function customerAccountRecovery(formId) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        if (!response.success) {
                            $('#emailError').text(response.message).show();
                        } else {
                            window.location.href = "<?php echo site_url('account-recovery') ?>";
                        }
                    }
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {email: {required: true, email: true}},
            messages: {
                email: "Your account email address is required",
            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }
    function veryfyCustomerAccountRecoveryCode(formId) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        if (response.status) {
                            window.location.href = "<?php echo site_url('change-account-password/') ?>" + response.code;
                        } else {
                            $('#verificationCodeError').text('Code does not match');
                        }
                    }
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {code: {required: true}},
            messages: {code: "Your verfication code is required"},
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }
</script>
