<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane content-configuration"  style="margin: 0 auto">
            <div class="caption" style="border-radius: 0; padding: 2.5px;">
                <?php $this->load->view('nav') ?>
            </div>
            <?php echo form_open('user/saveuserteam', array('id' => 'userTeamForm')); ?>
            <div class="manager-entry-block">
                <div class="pane-one-half"> 
                    <div class="form-group">
                        <label><?php echo $this->lang->line('branch') ?></label>
                        <select name="branch" class="form-control">
                            <?php if (!empty($branches)): ?>
                                <?php foreach ($branches as $aBranch): ?>
                                    <option value="<?php echo $aBranch->id ?>" <?php (isset($thisManager) && $aBranch->id === $thisManager['branch']) ? print 'selected="selected"' : print 'selected="selected"' ?>><?php echo $aBranch->title ?></option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                    </div>
                </div>
                <div class="pane-one-half"> 
                    <div class="form-group">
                        <label><?php echo $this->lang->line('team') ?></label>
                        <?php if (!empty($thisManager)): ?>
                            <input type="hidden" name="id" value='<?php echo $thisManager['id'] ?>' />
                            <input type="hidden" id="updateDepartmentTitle" value="yes">
                            <input type="hidden" id="oldDepartmentTitle" value="<?php echo $thisManager['title'] ?>">
                            <input name="title"  id="departmentTitle" value="<?php echo $thisManager['title'] ?>" type="text" class="form-control" placeholder="<?php echo $this->lang->line('team') ?>">
                        <?php else: ?>
                            <input name="title" id="departmentTitle" type="text" class="form-control" placeholder="<?php echo $this->lang->line('team') ?>">
                        <?php endif; ?>
                    </div>
                </div>
            </div>    
            <div class="tab-group config-submit">
                <button type="submit" onclick="saveUserTeam('userTeamForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
            </div>
            <?php echo form_close(); ?>


            <table class="report-table text-center">
                <thead class="table-bg">
                    <tr>
                        <?php if ($this->session->userdata('group') === '2'): ?>
                            <th><?php echo $this->lang->line('id') ?></th>
                        <?php endif; ?>
                        <th><?php echo $this->lang->line('team') ?></th>
                        <th><?php echo $this->lang->line('branch') ?></th>
                        <th><?php echo $this->lang->line('action') ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($managers)): ?>
                        <?php foreach ($managers as $aDeptManager): ?>
                            <tr>
                                <?php if ($this->session->userdata('group') === '2'): ?>
                                    <td><?php echo $aDeptManager->id ?></td>
                                <?php endif; ?>
                                <td><?php echo $aDeptManager->title ?></td>
                                <td><?php echo get_title('branch', array('id' => $aDeptManager->branch)) ?></td>
                                <td><span class="icon icon-pencil" onclick="zamanEposNavigator('', '<?php echo site_url('user/team/' . $aDeptManager->id) ?>', 'userIndex')"></span></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4"><?php echo sprintf($this->lang->line('not_found'), $this->lang->line('team')) ?></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
            <div class="setting-general-keyboard text-center"></div>
            <div class="clearfix padded-top-more text-right"><span class="icon icon-keyboard btn-keyboard-close" onclick="zamanToogleEposVirtualKeyboard('setting-general-keyboard')">&nbsp;<?php echo $this->lang->line('open_virtual_keyboard') ?></span></div>
        </div>
    </div>
</div>
<?php $this->load->view('settings/partials/footer') ?>
<script type="text/javascript">
    function saveUserTeam(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                $('.page-loader').hide();
                                if (response.status) {
                                    zamanEposNavigator('', '<?php echo site_url('user/team') ?>', 'userIndex');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                }
                            }
                        });
                    } else {
                        warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                    }
                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                ignore: ":hidden",
                rules: {
                    title: {required: true, alphanumeric: true},
                    branch: {required: true, number: true, min: 1}
                },
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
</script>