<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane content-configuration"  style="margin: 0 auto">
            <div class="caption" style="border-radius: 0; padding: 2.5px;">
                <?php $this->load->view('user/nav') ?>
            </div>
            <?php echo form_open('user/save', array('id' => 'userEntryForm')); ?>
            <?php if (isset($thisUser) && $thisUser['id']): ?>
                <input type="hidden" name="id" id="thisUserId" value="<?php echo $thisUser['id'] ?>">
            <?php endif; ?>
            <div class="pane-one-fourth block">
                <div class="block-inner">
                    <div class="form-group">
                        <label><?php echo $this->lang->line('branch') ?></label>
                        <select name="branch" class="form-control" <?php !empty($thisUser) && isset($thisUser['branch']) ? print 'disabled="disabled"' : '' ?>>
                            <?php if (isset($thisUser) && $thisUser['id']): ?>
                                <option value="<?php echo $thisUser['branch'] ?>"><?php echo get_title('branch', array('id' => $thisUser['branch'])) ?></option>
                            <?php else: ?>
                                <?php if (!empty($branches)): ?>
                                    <?php foreach ($branches as $abranch): ?>
                                        <option value="<?php echo $abranch->id ?>"><?php echo $abranch->title ?></option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            <?php endif ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('username') ?></label>
                        <input type="text" class="form-control" name="username" placeholder="Username" value="<?php isset($thisUser) && $thisUser['username'] ? print$thisUser['username'] : '' ?>">
                    </div>
                    <?php if ($this->session->userdata('group') === '2'): ?>
                        <label><?php echo $this->lang->line('service') ?>&nbsp;:&nbsp;</label>
                    <?php endif; ?>
                </div>
            </div>
            <div class="pane-one-fourth block">
                <div class="block-inner">
                    <div class="form-group">
                        <label><?php echo $this->lang->line('team') ?></label>
                        <select name="team" class="form-control" <?php !empty($thisUser) && isset($thisUser['team']) ? print 'disabled="disabled"' : '' ?>>
                            <option value="0"><?php echo $this->lang->line('select_team') ?></option>
                            <?php if (!empty($teams)): ?>
                                <?php foreach ($teams as $aTeam): ?>
                                    <option value="<?php echo $aTeam->id ?>" <?php isset($thisUser) && $thisUser['team'] === $aTeam->id ? print'selected="selected"' : '' ?>><?php echo $aTeam->title ?></option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('password') ?></label>
                        <input type="password" id="registerFormPassword" class="form-control" name="password" placeholder="<?php echo $this->lang->line('password') ?>">
                    </div>

                </div>
            </div>
            <div class="pane-one-fourth block">
                <div class="block-inner">
                    <div class="form-group">
                        <label><?php echo $this->lang->line('select_employee_as_user') ?></label>
                        <select name="employee" class="form-control" <?php !empty($thisUser) && isset($thisUser['employee']) ? print 'disabled="disabled"' : '' ?>>
                            <?php if (isset($thisUser) && $thisUser['id']): ?>
                                <?php $employee = get_single_record('employee', array('id' => $thisUser['employee']), array('id', 'first_name', 'last_name')) ?>
                                <option value="<?php echo $thisUser['employee'] ?>"><?php echo $employee ? $employee->first_name . ' ' . $employee->last_name : '' ?></option>
                            <?php else: ?>
                                <option value="0"><?php echo $this->lang->line('select_employee_as_user') ?></option>
                                <?php if (!empty($employees)): ?>
                                    <?php foreach ($employees as $anEployee): ?>
                                        <option value="<?php echo $anEployee->id ?>"><?php echo $anEployee->first_name . ' ' . $anEployee->last_name ?></option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('confirm_password') ?></label>
                        <input type="password" name="confirmedPassword" id="confirmPaswword" class="form-control" placeholder="<?php echo $this->lang->line('confirm_password') ?>">
                    </div>

                </div>
            </div>
            <div class="pane-one-fourth block">
                <div class="block-inner">
                    <div class="form-group">
                        <label><?php echo $this->lang->line('display') . ' ' . $this->lang->line('name') ?></label>
                        <input type="text" class="form-control" name="display" placeholder="<?php echo $this->lang->line('display') . ' ' . $this->lang->line('name') ?>" value="<?php isset($thisUser) && $thisUser['display'] ? print$thisUser['display'] : '' ?>">
                    </div>
                    <?php if ($this->session->userdata('group') === '2'): ?>
                        <div class="form-group">
                            <label><?php echo $this->lang->line('user_type') ?>&nbsp;:&nbsp;</label>
                            <select name="group" id="userGroupType" class="form-control">
                                <option><?php echo $this->lang->line('select') ?></option>
                                <option value="2" <?php isset($thisUser) && $thisUser['group'] === '2' ? print'selected="selected"' : print'' ?>><?php echo $this->lang->line('super_admin') ?></option>
                                <option value="3" <?php isset($thisUser) && $thisUser['group'] === '3' ? print'selected="selected"' : print'' ?>><?php echo $this->lang->line('owner_account') ?></option>
                                <option value="4" <?php isset($thisUser) && $thisUser['group'] === '4' ? print'selected="selected"' : print'' ?>><?php echo $this->lang->line('branch_manager') ?></option>
                                <option value="5" <?php isset($thisUser) && $thisUser['group'] === '5' ? print'selected="selected"' : print'' ?>><?php echo $this->lang->line('team_manager') ?></option>
                                <option value="6" <?php isset($thisUser) && $thisUser['group'] === '6' ? print'selected="selected"' : print'' ?>><?php echo $this->lang->line('table_handler') ?></option>
                                <option value="7" <?php isset($thisUser) && $thisUser['group'] === '7' ? print'selected="selected"' : print'' ?>><?php echo $this->lang->line('waiting_terminal') ?></option>
                                <option value="8" <?php isset($thisUser) && $thisUser['group'] === '8' ? print'selected="selected"' : print'' ?>><?php echo $this->lang->line('bar_terminal') ?></option>
                                <option value="9" <?php isset($thisUser) && $thisUser['group'] === '9' ? print'selected="selected"' : print'' ?>><?php echo $this->lang->line('bakery_terminal') ?></option>
                                <option value="10" <?php isset($thisUser) && $thisUser['group'] === '10' ? print'selected="selected"' : print'' ?>><?php echo $this->lang->line('drinks_terminal') ?></option>
                                <option value="11" <?php isset($thisUser) && $thisUser['group'] === '11' ? print'selected="selected"' : print'' ?>><?php echo $this->lang->line('collection_point') ?></option>
                                <option value="12" <?php isset($thisUser) && $thisUser['group'] === '12' ? print'selected="selected"' : print'' ?>><?php echo $this->lang->line('kitchen_terminal') ?></option>
                                <option value="13" <?php isset($thisUser) && $thisUser['group'] === '13' ? print'selected="selected"' : print'' ?>><?php echo $this->lang->line('driver_account') ?></option>
                                <option value="15" <?php isset($thisUser) && $thisUser['group'] === '15' ? print'selected="selected"' : print'' ?>><?php echo $this->lang->line('web_admin') ?></option>
                            </select>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="clearfix"></div>   
            <?php if ($this->session->userdata('group') === '2'): ?>
                <div class="form-group">
                    <?php $onapp = !empty($thisUser) ? unserialize($thisUser['onapp']) : array(); ?>
                    <label><?php echo $this->lang->line('services') ?></label>
                    <?php if ($services['table'] === '3'): ?>   
                        <label><input data-error="#userPlanFormOnapp" type="checkbox" name="onapp[]" value="table" <?php !empty($onapp) && in_array('table', $onapp) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('table') ?></label>
                    <?php endif; ?>
                    <?php if ($services['waiting'] === '3'): ?>      
                        <label><input data-error="#userPlanFormOnapp" type="checkbox" name="onapp[]" value="waiting"  <?php !empty($onapp) && in_array('waiting', $onapp) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('waiting') ?></label>
                    <?php endif; ?>
                    <?php if ($services['bar'] === '3'): ?>      
                        <label><input data-error="#userPlanFormOnapp" type="checkbox" name="onapp[]" value="bar"  <?php !empty($onapp) && in_array('bar', $onapp) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('bar') ?></label>
                    <?php endif; ?>
                    <?php if ($services['collection'] === '3'): ?>         
                        <label><input data-error="#userPlanFormOnapp" type="checkbox" name="onapp[]" value="collection"  <?php !empty($onapp) && in_array('collection', $onapp) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('collection') ?></label>
                    <?php endif; ?>
                    <?php if ($services['delivery'] === '3'): ?>            
                        <label><input data-error="#userPlanFormOnapp" type="checkbox" name="onapp[]" value="delivery"  <?php !empty($onapp) && in_array('delivery', $onapp) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('delivery') ?></label>
                    <?php endif; ?>
                    <?php if ($services['online'] === '3'): ?>    
                        <label><input data-error="#userPlanFormOnapp" type="checkbox" name="onapp[]" value="online"  <?php !empty($onapp) && in_array('online', $onapp) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('online') ?></label>
                    <?php endif; ?>
                    <?php if ($services['booking'] === '3'): ?>    
                        <label><input data-error="#userPlanFormOnapp" type="checkbox" name="onapp[]" value="booking"  <?php !empty($onapp) && in_array('booking', $onapp) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('booking') ?></label>
                    <?php endif; ?>
                    <?php if ($services['callerId'] === '3'): ?>    
                        <label><input data-error="#userPlanFormOnapp" type="checkbox" name="onapp[]" value="callerId"  <?php !empty($onapp) && in_array('callerId', $onapp) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('caller_device') ?></label>
                    <?php endif; ?>
                    <?php if ($services['appReceiver'] === '3'): ?>    
                        <label><input data-error="#userPlanFormOnapp" type="checkbox" name="onapp[]" value="appReceiver"  <?php !empty($onapp) && in_array('appReceiver', $onapp) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('app_receiver') ?></label>
                    <?php endif; ?>
                    <div id="userPlanFormOnapp"></div>
                </div>
            <?php endif; ?>
            <div class="form-group">
                <label><?php echo $this->lang->line('status') ?></label>
                <div class="form-actions">
                    <label><input data-error="#userEntryFormStatuError" type="radio" name="status" value="3" <?php isset($thisUser) && $thisUser['status'] == '3' ? print 'checked="checked"' : '' ?> >&nbsp;<?php echo $this->lang->line('active') ?></label>
                    <label><input data-error="#userEntryFormStatuError" type="radio" name="status" value="2" <?php isset($thisUser) && $thisUser['status'] == '2' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('inactive') ?></label>
                </div>
            </div>
            <div class="clearfix"></div>
            <div class="tab-group config-submit">
                <button type="submit" onclick="saveEposUser('userEntryForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
            </div>
            <?php echo form_close() ?>
            <div class="setting-general-keyboard text-center"></div>
            <div class="clearfix padded-top-more text-right"><span class="icon icon-keyboard btn-keyboard-close" onclick="zamanToogleEposVirtualKeyboard('setting-general-keyboard')">&nbsp;<?php echo $this->lang->line('open_virtual_keyboard') ?></span></div>
        </div>
    </div>
</div>
<?php $this->load->view('settings/partials/footer') ?>
<script type="text/javascript">
    function saveEposUser(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                $('.page-loader').hide();
                                if (response.status) {
                                    resetForm(formId);
                                    zamanEposNavigator('user', '<?php echo site_url('user/index') ?>', 'userIndex');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                                }
                            }
                        });
                    } else {
                        warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                    }
                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                rules: {
                    branch: {required: true, min: 1},
                    team: {required: true, min: 1},
                    username: {required: true},
                    password: {number: true, required: function () {
                            return $('#thisUserId').length > 0 ? false : true;
                        }},
                    group: {number: true, required: true, min: 1},
                    'onapp[]': {required: true},
                    status: {required: true},
                    confirmedPassword: {equalTo: "#registerFormPassword"}
                },
                messages: {
                    branch: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('branch')) ?>',
                    team: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('team')) ?>',
                    username: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('username')) ?>',
                    password: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('password')) ?>',
                    group: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('user_type')) ?>',
                    status: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('status')) ?>',
                    'onapp[]': '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('service')) ?>'
                },
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
</script>
