<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class User_Model extends MY_Model {

    function __construct() {
        parent::__construct();
        $this->_table_name = 'user';
        $this->_primary_key = 'id';
    }

    public function employeeYetToUser($branch) {
        $employees = $this->get_list('employee', array('branch' => $branch), array('id', 'first_name', 'last_name'))->result();
        if (!empty($employees)) {
            foreach ($employees as $key => $employee)
                if ($this->exists('user', 'employee', $employee->id)) {
                    unset($employees[$key]);
                }
        }
        return $employees;
    }

    public function save($data, $id = NULL) {
        if ($id !== NULL && $id > 0) {
            $data['updated_by'] = 1;
        } else {
            $data['created_by'] = 1;
        }
        return parent::save($data, $id);
    }

    public function saveuserteam($data, $id = NULL) {
        $this->_table_name = 'userteam';
        $this->_primary_key = 'id';
        if ($id !== NULL && $id > 0) {
            $data['updated_by'] = 1;
        } else {
            $data['created_by'] = 1;
        }
        return parent::save($data, $id);
    }

    public function eposUserLogs($data, $id = null) {
        $this->_table_name = 'userlogtime';
        $this->_primary_key = 'id';
        return $this->save($data, $id);
    }

    public function getEposLogtime($start, $end) {
        $this->db->select('LT.id aslogtime_id,LT.user, LT.branch,LT.login,LT.logout,LT.ip,US.username,US.display,US.id');
        $this->db->from('userlogtime as LT');
        $this->db->join('user US', 'US.id=LT.user', 'inner');
        $this->db->where('LT.login BETWEEN ' . $this->db->escape($start) . ' AND ' . $this->db->escape($end));
        if ($this->session->userdata('group') >= 4) {
            $this->db->where('LT.branch', $this->session->userdata('branch'));
        }
        $this->db->group_by('LT.id');
        $this->db->order_by('LT.created_at', 'DESC');
        $data = $this->db->get('userlogtime')->result();
        return $data;
    }

    public function getActivity($start, $end) {
        $this->db->where('access_time BETWEEN ' . $this->db->escape($start) . ' AND ' . $this->db->escape($end));
        if ($this->session->userdata('group') == 4) {
            $this->db->where('branch', $this->session->userdata('branch'));
        }
        $this->db->group_by('id');
        $this->db->order_by('access_time', 'DESC');
        $data = $this->db->get('useractivity')->result();
        return $data;
    }

}
