<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane content-configuration">
            <div class="pane">
                <div class="caption">
                    <div class="caption-inner" style="padding: 9px;"><?php echo $this->lang->line('pagination') ?></div>
                </div>
                <?php echo form_open('settings/save', array('id' => 'paginationSetting')); ?>
                <div class="form-group">
                    <label><?php echo $this->lang->line('report') ?> (<?php echo sprintf($this->lang->line('min_dynamic'), '10') ?> <?php echo sprintf($this->lang->line('max_dynamic_dynamic'), '50') ?>)</label>
                    <input  type="text" name="pagination_report" value="<?php echo $this->config->item('pagination_report') ?>" class="form-control" placeholder="<?php echo $this->lang->line('report') ?>">
                </div>
                <div class="form-group">
                    <label><?php echo $this->lang->line('menu') . ' ' . $this->lang->line('category') ?>  (<?php echo sprintf($this->lang->line('min_dynamic'), '5') ?> <?php echo sprintf($this->lang->line('max_dynamic'), $this->config->item('30')) ?>)</label>
                    <input type="text" name="pagination_category" value="<?php echo $this->config->item('pagination_category') ?>" class="form-control" placeholder="Menu category">
                </div>
                <div class="form-group">
                    <label><?php echo $this->lang->line('menu') ?>  (<?php echo sprintf($this->lang->line('min_dynamic'), '10') ?> <?php echo sprintf($this->lang->line('max_dynamic'), '50') ?>)</label>
                    <input type="text" name="pagination_menu" value="<?php echo $this->config->item('pagination_menu') ?>" class="form-control" placeholder="Menu">
                </div>
                <div class="form-group">
                    <label><?php echo $this->lang->line('menu') . ' ' . $this->lang->line('selection') ?>  (<?php echo sprintf($this->lang->line('min_dynamic'), '10') ?> <?php echo sprintf($this->lang->line('max_dynamic'), '50') ?>)</label>
                    <input type="text" name="pagination_selection" value="<?php echo $this->config->item('pagination_selection') ?>" class="form-control" placeholder="Menu Selection">
                </div>
                <div class="tab-group config-submit">
                    <button type="submit" onclick="paginationSetting('paginationSetting')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
                </div>
                <?php echo form_close() ?>
            </div>
            <div class="setting-pagination-keyboard text-center"></div>
            <div class="clearfix padded-top-more text-right"><span class="icon icon-keyboard btn-keyboard-close" onclick="zamanToogleEposVirtualKeyboard('setting-pagination-keyboard')">&nbsp;<?php echo $this->lang->line('open_virtual_keyboard') ?></span></div>
        </div>
    </div>
</div>
<?php $this->load->view('settings/partials/footer') ?>
<script type="text/javascript">
    function paginationSetting(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                if (response.status) {
                                    zamanDbEposConfiguration();
                                    $('.page-loader').hide();
                                    zamanEposNavigator('pagination', '<?php echo site_url('settings/pagination') ?>', 'pagination');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                }
                            }
                        });
                    }
                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                rules: {
                    pagination_report: {required: true, number: true, min: 10, max: 50},
                    pagination_category: {required: true, number: true, min: 10, max: 30},
                    pagination_menu: {required: true, number: true, min: 10, max: 50},
                    pagination_selection: {required: true, number: true, min: 10, max: 50}
                },
                messages: {
                    pagination_report: '<?php echo sprintf($this->lang->line('invalid_value'), $this->lang->line('report')) ?>',
                    pagination_category: '<?php echo sprintf($this->lang->line('invalid_value'), $this->lang->line('menu') . ' ' . $this->lang->line('category')) ?>',
                    pagination_menu: '<?php echo sprintf($this->lang->line('invalid_value'), $this->lang->line('menu')) ?>',
                    pagination_selection: '<?php echo sprintf($this->lang->line('invalid_value'), $this->lang->line('menu') . ' ' . $this->lang->line('selection')) ?>'
                },
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
</script>