<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane content-configuration">
            <div class="caption">
                <div class="caption-inner"><?php echo $this->lang->line('localization') ?></div>
            </div>
            <?php echo form_open('settings/save', array('id' => 'localizationSetting')); ?>
            <div class="pane-one-third block">
                <div class="block-inner">
                    <div class="form-group">
                        <label><?php echo $this->lang->line('language') ?></label>
                        <select class="form-control" name="locale_lang">
                            <?php if (!empty($languages)): ?>
                                <?php foreach ($languages as $alang): ?>
                                    <option value="<?php echo preg_replace('/\\\\/', '', $alang) ?>" <?php preg_replace('/\\\\/', '', $alang) == $this->config->item('locale_lang') ? print 'selected' : '' ?> ><?php echo ucwords(preg_replace('/\\\\/', '', $alang)) ?></option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('timezone') ?></label>
                        <select class="form-control" name="locale_timezone">
                            <?php if (!empty($timezones)): ?>
                                <?php foreach ($timezones as $azone): ?>
                                    <option value="<?php echo $azone['zone'] ?>" <?php $azone['zone'] == $this->config->item('locale_timezone') ? print 'selected' : '' ?>><?php echo $azone['zone'] . '&nbsp;(' . $azone['diff_from_GMT'] . ')' ?></option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('date_format') ?></label>
                        <?php echo form_dropdown('locale_dateformat', array('d/m/Y' => 'dd/mm/yyyy', 'd.m.Y' => 'dd.mm.yyyy', 'm/d/Y' => 'mm/dd/yyyy', 'Y/m/d' => 'yyyy/mm/dd', 'd/m/y' => 'dd/mm/yy', 'm/d/y' => 'mm/dd/yy', 'y/m/d' => 'yy/mm/dd'), $this->config->item('locale_dateformat'), array('class' => 'form-control')); ?>
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('time_format') ?></label>
                        <?php echo form_dropdown('locale_timeformat', array('H:i:s' => 'hh:mm:ss (24h)', 'h:i:s a' => 'hh:mm:ss am/pm', 'h:i:s A' => 'hh:mm:ss AM/PM'), $this->config->item('locale_timeformat'), array('class' => 'form-control')); ?>
                    </div>
                </div>
            </div>
            <div class="pane-one-third block">
                <div class="block-inner">
                    <div class="form-group">
                        <label><?php echo $this->lang->line('currency') ?></label>
                        <select class="form-control" name="locale_currencysymbol" onchange="getCurrencySymbol(this.value)">
                            <?php if (!empty($currencies)): ?>
                                <?php foreach ($currencies as $key => $acurrency): ?>
                                    <option value="<?php echo $key ?>" <?php $key == $this->config->item('locale_currencysymbol') ? print 'selected' : '' ?>><?php echo $acurrency ?></option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('currency_symbol') ?></label>
                        <input class="form-control" name="locale_currencyicon" value="<?php echo $this->config->item('locale_currencyicon') ?>" id="currencyIcon">
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('position') ?></label>
                        <?php echo form_dropdown('locale_currencyside', array('left' => 'Left', 'right' => 'Right'), $this->config->item('locale_currencyside'), array('class' => 'form-control')); ?>
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('currency_decimals') ?></label>
                        <select class="form-control" name="locale_currencydecimal">
                            <option value="0" <?php '0' == $this->config->item('locale_currencydecimal') ? print 'selected' : '' ?>>0</option>
                            <option value="1" <?php '1' == $this->config->item('locale_currencydecimal') ? print 'selected' : '' ?>>1</option>
                            <option value="2" <?php '2' == $this->config->item('locale_currencydecimal') ? print 'selected' : '' ?>>2</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="pane-one-third block">
                <div class="block-inner">
                    <div class="form-group">
                        <label><?php echo $this->lang->line('tax_decimal') ?></label>
                        <select class="form-control" name="locale_taxdecimal">
                            <option value="0" <?php '0' == $this->config->item('locale_taxdecimal') ? print 'selected' : '' ?>>0</option>
                            <option value="1" <?php '1' == $this->config->item('locale_taxdecimal') ? print 'selected' : '' ?>>1</option>
                            <option value="2" <?php '2' == $this->config->item('locale_taxdecimal') ? print 'selected' : '' ?>>2</option>
                            <option value="3" <?php '3' == $this->config->item('locale_taxdecimal') ? print 'selected' : '' ?>>3</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('quantity_decimal') ?></label>
                        <select class="form-control" name="locale_quantitydecimal">
                            <option value="0" <?php '0' == $this->config->item('locale_quantitydecimal') ? print 'selected' : '' ?>>0</option>
                            <option value="1" <?php '1' == $this->config->item('locale_quantitydecimal') ? print 'selected' : '' ?>>1</option>
                            <option value="2" <?php '2' == $this->config->item('locale_quantitydecimal') ? print 'selected' : '' ?>>2</option>
                            <option value="3" <?php '3' == $this->config->item('locale_quantitydecimal') ? print 'selected' : '' ?>>3</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('decimal_point') ?></label>
                        <select class="form-control" name="locale_decimalpoint">
                            <option value="," <?php ',' == $this->config->item('locale_decimalpoint') ? print 'selected' : '' ?>>,</option>
                            <option value="." <?php '.' == $this->config->item('locale_decimalpoint') ? print 'selected' : '' ?>>.</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('thousand_separator') ?></label>
                        <select class="form-control" name="locale_thouandseparator">
                            <option value="&apos;" <?php '&apos;' == $this->config->item('locale_thouandseparator') ? print 'selected' : '' ?>>&apos;</option>
                            <option value="," <?php ',' == $this->config->item('locale_thouandseparator') ? print 'selected' : '' ?>>,</option>
                            <option value="." <?php '.' == $this->config->item('locale_thouandseparator') ? print 'selected' : '' ?>>.</option>
                            <option value=""<?php '' == $this->config->item('locale_thouandseparator') ? print 'selected' : '' ?>>none</option>
                        </select>
                    </div>

                </div>
            </div>
            <div class="clearfix"></div>
            <div class="tab-group config-submit">
                <button type="submit" onclick="localizationSetting('localizationSetting')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
            </div>
            <?php echo form_close() ?>
        </div>
    </div>
</div>
<?php $this->load->view('settings/partials/footer') ?>
<script type="text/javascript">
    function getCurrencySymbol(currency) {
        var currency_symbols = {
            'BDT': '৳',
            'GBP': '£',
            'USD': 'USD'
        };
        $('#currencyIcon').val(currency_symbols[currency]);
    }
    function localizationSetting(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                $('.page-loader').hide();
                                if (response.status) {
                                    zamanEposNavigator('', '<?php echo site_url('settings/localization') ?>', 'settingIndex');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                }
                            }
                        });
                    } else {
                        warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                    }
                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                rules: {
                    locale_lang: {required: true},
                    locale_timezone: {required: true},
                    locale_dateformat: {required: true},
                    locale_timeformat: {required: true},
                    locale_currencysymbol: {required: true},
                    locale_currencyicon: {required: true},
                    locale_currencyside: {required: true},
                    locale_currencydecimal: {required: true},
                    locale_taxdecimal: {required: true}
                },
                messages: {
                    locale_lang: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('language')) ?>',
                    locale_timezone: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('timezone')) ?>',
                    locale_dateformat: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('date_format')) ?>',
                    locale_timeformat: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('time_format')) ?>',
                    locale_currencysymbol: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('currency')) ?>',
                    locale_currencyicon: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('currency_symbol')) ?>',
                    locale_currencyside: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('position')) ?>',
                    locale_currencydecimal: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('currency_decimals')) ?>',
                    locale_taxdecimal: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('tax_decimal')) ?>'
                },
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }

</script>