<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane">
            <table>
                <?php if ($this->session->userdata('group') <= 5): ?>
                    <caption style="padding: 15px;" onclick="zamanEposNavigator('itemdiscount', '<?php echo site_url('settings/itemOffer') ?>', 'itemdiscount')"><span class="icon icon-list"></span>&nbsp;<?php echo $this->lang->line('item_offer') ?></caption>
                <?php else: ?>
                    <caption style="padding: 15px;"><span class="icon icon-list"></span>&nbsp;<?php echo $this->lang->line('item_offer') ?></caption>
                <?php endif; ?>
            </table>
            <?php echo form_open('settings/saveItemOffer', array('id' => 'itemOfferForm')); ?>
            <?php if (!empty($thisOffer['id'])): ?>
                <input type="hidden" name="id" value="<?php echo $thisOffer['id'] ?>">
            <?php endif; ?>
            <div class="pane">
                <div class="pane-one-fourth form-group collection-bg" style="float: left; padding: 0px 1px 0px 0px;">
                    <div class="form-group">
                        <label><?php echo $this->lang->line('title') ?></label>
                        <input type="text" value="<?php !empty($thisOffer['title']) ? print $thisOffer['title'] : '' ?>" name="title" placeholder="<?php echo $this->lang->line('title') ?>" class="form-control">
                    </div>
                </div>
                <div class="pane-one-fourth form-group collection-bg" style="float: left; padding: 0px 1px 0px 0px;">
                    <div class="form-group">
                        <label><?php echo $this->lang->line('minimum_order_amount') ?></label>
                        <input type="text" name="order" value="<?php !empty($thisOffer['order']) ? print $thisOffer['order'] : '' ?>" placeholder="<?php echo $this->lang->line('minimum_order_amount') ?>" class="form-control">
                    </div>
                </div>
                <div class="pane-one-fourth form-group collection-bg" style="float: left; padding: 0px 1px 0px 0px;">
                    <div class="pane-one-half" style="float: left; width: 46%">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('qty') ?></label>
                            <input type="text" name="qty" value="<?php !empty($thisOffer['qty']) ? print $thisOffer['qty'] : '' ?>"  placeholder="<?php echo $this->lang->line('qty') ?>" class="form-control">
                        </div>
                    </div>
                    <div class="pane-one-half" style="float: right">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('status'); ?></label>
                            <select name="status" class="form-control">
                                <option value="3" <?php !empty($thisOffer['status']) && $thisOffer['status'] == '3' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('active') ?></option>
                                <option value="2" <?php !empty($thisOffer['status']) && $thisOffer['status'] == '2' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('inactive') ?></option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="pane-one-fourth collection-bg" style="float: left; padding: 0px 1px 0px 0px;">
                    <div class="form-group">
                        <label><?php echo $this->lang->line('plan_applicable_order_types') ?></label>
                        <div class="checkbox-group">
                            <label><input type="checkbox" data-error="#itemOfferFormOrderType" value="table" <?php !empty($thisOffer['type']) && strpos($thisOffer['type'], 'table') ? print'checked="checked"' : '' ?> name="type[]"><?php echo $this->lang->line('table') ?></label>
                            <label><input type="checkbox" data-error="#itemOfferFormOrderType" value="waiting" <?php !empty($thisOffer['type']) && strpos($thisOffer['type'], 'waiting') ? print'checked="checked"' : '' ?> name="type[]"><?php echo $this->lang->line('waiting') ?></label>
                            <label><input type="checkbox" data-error="#itemOfferFormOrderType" value="collection" <?php !empty($thisOffer['type']) && strpos($thisOffer['type'], 'collection') ? print'checked="checked"' : '' ?> name="type[]"><?php echo $this->lang->line('collection') ?></label>
                            <label><input type="checkbox" data-error="#itemOfferFormOrderType" value="delivery" <?php !empty($thisOffer['type']) && strpos($thisOffer['type'], 'delivery') ? print'checked="checked"' : '' ?> name="type[]"><?php echo $this->lang->line('delivery') ?></label>
                            <label><input type="checkbox" data-error="#itemOfferFormOrderType" value="bar" <?php !empty($thisOffer['type']) && strpos($thisOffer['type'], 'bar') ? print'checked="checked"' : '' ?> name="type[]"><?php echo $this->lang->line('bar') ?></label>
                        </div>
                    </div>
                </div>
            </div>
            <div id="itemOfferFormOrderType" class="pane">
                <?php if (!empty($thisOffer['item'])): ?>
                    <div class="category-block">
                        <div class="clearfix set-category-item">
                            <?php $selectedItems = unserialize($thisOffer['item']) ?>
                            <?php foreach ($selectedItems as $anItem): ?>
                                <?php $explodeItem = explode('_', $anItem) ?>
                                <?php $itemString = $explodeItem[2] > 0 ? get_title('menuselection', array('id' => $explodeItem[2])) . '-' . get_title('menu', array('id' => $explodeItem[1])) : get_title('menu', array('id' => $explodeItem[1])); ?>
                                <div class="pane-one-fourth"><input type="checkbox" checked="checked" name="items[]" value="<?php echo $explodeItem[0] . '_' . $explodeItem[1] . '_' . $explodeItem[2] ?>">&nbsp;<?php echo $itemString ?></div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <div class="pane">
                <div class="form-group">
                    <label><?php echo $this->lang->line('select_category') ?></label>
                    <select class="form-control" onchange="getcategoryItemsByCategory(this.value)">
                        <option value="0"><?php echo $this->lang->line('select') ?></option>
                        <?php if (!empty($menucategory)): ?>
                            <?php foreach ($menucategory as $amenucategory): ?>
                                <option value="<?php echo $amenucategory->id ?>"><?php echo ucwords($amenucategory->title) ?></option>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </select>
                </div>
            </div>
            <div class="pane">
                <div id="categoryItemsPlacedBlock"></div>
                <div></div>
            </div>
            <div class="tab-group config-submit">
                <button type="submit" onclick="saveItemOffer('itemOfferForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>
<script>
    function saveItemOffer(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                if (response.status) {
                                    $('.page-loader').hide();
                                    zamanEposNavigator('itemdiscount', '<?php echo site_url('settings/itemOfferAdd/') ?>' + response.status, 'itemdiscount');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                }
                            }
                        });
                    }
                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                rules: {
                    title: {required: true},
                    order: {required: true, number: true, min: 1},
                    qty: {required: true, number: true, min: 1},
                    'type[]': {required: true},
                    'items[]': {required: true}
                },
                messages: {
                    title: '<?php echo sprintf($this->lang->line('invalid_value'), $this->lang->line('title')) ?>',
                    order: '<?php echo sprintf($this->lang->line('invalid_value'), $this->lang->line('order') . ' ' . $this->lang->line('amount')) ?>',
                    qty: '<?php echo sprintf($this->lang->line('invalid_value'), $this->lang->line('qty')) ?>',
                    type: '<?php echo sprintf($this->lang->line('invalid_value'), $this->lang->line('type')) ?>'
                },
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
    function getcategoryItemsByCategory(category) {
        if (!$('.page-loader').is(":visible")) {
            if ($.trim(category) !== '0') {
                if (checkInternetConnection()) {
                    $.ajax({
                        url: '<?php echo site_url('menu/getmenusetitems/') ?>' + category,
                        type: 'GET',
                        beforeSend: function () {
                            $('.page-loader').show();
                        },
                        success: function (response) {
                            $('#categoryItemsPlacedBlock').append(response);
                            $('.page-loader').hide();
                        }
                    });
                } else {
                    warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                }
            }
        }
    }
</script>

<?php $this->load->view('settings/partials/footer') ?>
