<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane">
            <table class="report-table text-center">
                <?php if ($this->session->userdata('group') <= 5): ?>
                    <caption style="padding: 15px;" onclick="zamanEposNavigator('itemdiscount', '<?php echo site_url('settings/itemOfferAdd') ?>', 'itemdiscount')"><span class="icon icon-plus"></span>&nbsp;<?php echo $this->lang->line('add_item_offer') ?></caption>
                <?php else: ?>
                    <caption style="padding: 15px;"><span class="icon icon-list"></span>&nbsp;<?php echo $this->lang->line('item_offer') ?></caption>
                <?php endif; ?>
                <tr class="table-bg">
                    <th><?php echo $this->lang->line('title') ?></th>
                    <th><?php echo $this->lang->line('minimum_order_amount') ?></th>
                    <th><?php echo $this->lang->line('qty') ?></th>
                    <th><?php echo $this->lang->line('type') ?></th>
                    <th><?php echo $this->lang->line('items') ?></th>
                    <th><?php echo $this->lang->line('action') ?></th>
                </tr>
                <?php if (!empty($itemOffers)): ?>
                    <?php foreach ($itemOffers as $anOffer): ?>
                        <tr>
                            <td><?php echo $anOffer->title ?></td>
                            <td><?php echo to_currency($anOffer->order) ?></td>
                            <td><?php echo $anOffer->qty ?></td>
                            <td>
                                <?php
                                $typeString = '';
                                $types = unserialize($anOffer->type);
                                foreach ($types as $aType) {
                                    $typeString .= $aType . " ";
                                }
                                echo $typeString;
                                ?>
                            </td>
                            <td>
                                <?php
                                $ItemString = '';
                                $items = unserialize($anOffer->item);
                                foreach ($items as $key => $anItem) {
                                    $item = explode('_', $anItem);
                                    if ($item[2] > 0) {
                                        $ItemString .= get_title('menuselection', array('id' => $item[2])) . '-' . get_title('menu', array('id' => $item[1]));
                                    } else {
                                        $ItemString .= get_title('menu', array('id' => $item[1]));
                                    }
                                    if ($key != count($items) - 1) {
                                        $ItemString .= '<br/>';
                                    }
                                }
                                echo $ItemString;
                                ?>
                            </td>
                            <td><span class="icon icon-pencil" onclick="zamanEposNavigator('itemdiscount', '<?php echo site_url('settings/itemOfferAdd/' . $anOffer->id) ?>', 'itemdiscount')"></span>&nbsp; | &nbsp; <span class="icon icon-trash" style="color: #ff0000" onclick="deleteItemOffer('<?php echo $anOffer->id ?>')"></span></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="5" class="text-center">No Item offers found</td>
                    </tr>
                <?php endif; ?>
            </table>
        </div>
    </div>
</div>
<?php $this->load->view('settings/partials/footer') ?>
<script type="text/javascript">
    function deleteItemOffer(id) {
        $.ajax({
            url: '<?php echo site_url('settings/deleteItemOffer/') ?>' + id,
            type: 'GET',
            dataType: 'json',
            beforeSend: function (xhr) {
                $('.page-loader').show();
            },
            success: function (response) {
                $('.page-loader').hide();
                if (response.status) {
                    zamanEposNavigator('itemdiscount', '<?php echo site_url('settings/itemOffer') ?>', 'itemdiscount');
                } else {
                    alert('there some problem')
                }

            }
        });
    }
</script>