<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane content-configuration">
            <?php if ($this->session->userdata('group') <= 3): ?>
                <div class="caption">
                    <div class="caption-inner" style="padding: 9px"><span class="icon icon-info">&nbsp;<?php echo $this->lang->line('owner_info') ?></div>
                </div>
                <?php echo form_open('settings/save', array('id' => 'generalSetting', 'enctype' => 'multipart/form-data')); ?>
                <div class="clearfix"></div>
                <div class="employee-add-block">
                    <div class="one-fifth">
                        <div class="block-inner" style="padding: 0px 2px;">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('restaurant_name') ?></label>
                                <input name="general_name" value="<?php echo $this->config->item('general_name') ?>" type="text" class="form-control" placeholder="<?php echo $this->lang->line('restaurant_name') ?>">
                            </div>
                        </div>
                    </div>
                    <div class="one-fifth">
                        <div class="block-inner" style="padding: 0px 2px;">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('owner_name') ?></label>
                                <input type="text" name="general_ownername" value="<?php echo $this->config->item('general_ownername') ?>"  class="form-control" placeholder="<?php echo $this->lang->line('owner_name') ?>">
                            </div>
                        </div>
                    </div>
                    <div class="one-fifth">
                        <div class="block-inner" style="padding: 0px 2px;">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('owner_contact_no') ?></label>
                                <input type="text" name="general_ownercontact" value="<?php echo $this->config->item('general_ownercontact') ?>"  class="form-control" placeholder="<?php echo $this->lang->line('owner_contact_no') ?>">
                            </div>
                        </div>
                    </div>
                    <div class="one-fifth">
                        <div class="block-inner" style="padding: 0px 2px;">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('email_address') ?></label>
                                <input type="email" name="general_email"  value="<?php echo $this->config->item('general_email') ?>" class="form-control" placeholder="<?php echo $this->lang->line('email_address') ?>">
                            </div>
                        </div>
                    </div>
                    <div class="one-fifth">
                        <div class="block-inner" style="padding: 0px 2px;">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('phone') ?></label>
                                <input type="text" name="general_phone" value="<?php echo $this->config->item('general_phone') ?>" class="form-control" placeholder="<?php echo $this->lang->line('phone') ?>">
                            </div>
                        </div>
                    </div>
                    <div class="one-fifth">
                        <div class="block-inner" style="padding: 0px 2px;">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('mobile') ?></label>
                                <input type="text" name="general_mobile" value="<?php echo $this->config->item('general_phone') ?>" class="form-control" placeholder="<?php echo $this->lang->line('mobile') ?>">
                            </div>
                        </div>
                    </div>
                    <div class="one-fifth">
                        <div class="block-inner" style="padding: 0px 2px;">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('website') ?></label>
                                <input type="text" name="general_website" value="<?php echo $this->config->item('general_website') ?>" class="form-control" placeholder="<?php echo $this->lang->line('website') ?>">
                            </div>
                        </div>
                    </div>
                    <div class="one-fifth">
                        <div class="block-inner" style="padding: 0px 2px;">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('tagline') ?></label>
                                <input type="text" name="general_slogan" value="<?php echo $this->config->item('general_slogan') ?>" class="form-control" placeholder="<?php echo $this->lang->line('tagline') ?>">
                            </div>
                        </div>
                    </div>

                    <div class="one-fifth">
                        <div class="block-inner" style="padding: 0px 2px;">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('fax') ?></label>
                                <input type="text" name="general_fax" value="<?php echo $this->config->item('general_fax') ?>"  class="form-control" placeholder="<?php echo $this->lang->line('fax') ?>">
                            </div>
                        </div>
                    </div>
                    <div class="one-fifth">
                        <div class="block-inner" style="padding: 0px 2px;">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('tin') ?></label>
                                <input type="text" name="default_tinnumber" value="<?php echo $this->config->item('default_tinnumber') ?>" class="form-control" placeholder="<?php echo $this->lang->line('tax_indentification_number') ?>">
                            </div>
                        </div>
                    </div>
                    <div class="one-fifth">
                        <div class="block-inner" style="padding: 0px 2px;">
                            <div class="form-group ">
                                <label><?php echo $this->lang->line('logo') ?></label>
                                <input type="file" name="general_logo" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="one-fifth">
                        <div class="block-inner" style="padding: 0px 2px;">
                            <div class="form-group ">
                                <div class="block thumbnail text-center">
                                    <?php if (trim($this->config->item('general_logo')) != null): ?>
                                        <img src="<?php echo EPOS_UPLOAD_PATH . $this->config->item('general_logo') ?>" alt="<?php echo $this->config->item('general_name') ?>">
                                        <span class="icon icon-trash text-right clearfix" onclick="removeLogo('general_logo', '<?php echo $this->config->item('general_logo') ?>', 'configuration', './uploads/', '<?php echo site_url('settings/remove_logo') ?>')">&nbsp;<?php echo $this->lang->line('remove') ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="clearfix"></div>
                <div class="tab-group config-submit">
                    <button type="submit" onclick="generalSetting('generalSetting')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') . ' ' . $this->lang->line('owner_info') ?></button>
                </div>
                <br/>
                <?php echo form_close() ?>
                <script type="text/javascript">
                    function generalSetting(formId) {
                        if (!$('.page-loader').is(":visible")) {
                            $('#' + formId).validate({
                                submitHandler: function () {
                                    var myform = document.getElementById(formId);
                                    var formdata = new FormData(myform);
                                    if (checkInternetConnection()) {
                                        $.ajax({
                                            url: $('#' + formId).attr('action'),
                                            data: formdata,
                                            cache: false,
                                            processData: false,
                                            contentType: false,
                                            type: 'POST',
                                            dataType: 'json',
                                            success: function (response) {
                                                if (response.status) {
                                                    zamanEposNavigator('settingGeneral', '<?php echo site_url('settings/general') ?>', 'settingGeneral');
                                                } else {
                                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                                }
                                            }
                                        });
                                    } else {
                                        warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('closse') ?>');
                                    }
                                },
                                errorClass: "has-error",
                                highlight: function (e) {
                                    $(e).closest('.form-group').addClass('has-error');
                                },
                                unhighlight: function (e) {
                                    $(e).closest('.form-group').removeClass('has-error');
                                },
                                rules: {
                                    general_name: {required: true},
                                    general_email: {required: true},
                                    general_phone: {required: true},
                                    general_mobile: {required: true},
                                },
                                messages: {
                                    general_name: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('restaurant_name')) ?>',
                                    general_email: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('email_address')) ?>',
                                    general_phone: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('phone')) ?>',
                                    general_mobile: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('mobile')) ?>'
                                },
                                errorPlacement: function (error, element) {
                                    errorPlacement(error, element);
                                }
                            });

                        }
                    }
                    function removeLogo(dbkey, dbimage, dbtable, path, url) {
                        if (!$('.page-loader').is(":visible")) {
                            if (checkInternetConnection()) {
                                $.ajax({
                                    url: url,
                                    data: {dbkey: dbkey, image: dbimage, dbtable: dbtable, path: path},
                                    type: 'POST',
                                    dataType: 'json',
                                    success: function (response) {
                                        if (response.status) {
                                            if (checkInternetConnection()) {
                                                zamanDbEposConfiguration();
                                            }
                                            zamanEposNavigator('settingGeneral', '<?php echo site_url('settings/general') ?>', 'settingGeneral');
                                        } else {
                                            warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('close') ?>');
                                        }
                                    }
                                });
                            } else {
                                warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('closse') ?>');
                            }
                        }
                    }
                </script>
            <?php endif; ?>
            <?php if (!empty($loaded_plan)): ?>    
                <div class="my-branch">
                    <div class="caption">
                        <div class="caption-inner" style="padding: 9px;"><span class="icon icon-tools">&nbsp;&nbsp;</span><?php echo $this->lang->line('restaurant_setup') . ' - ' . $loaded_plan ['title'] ?></div>
                    </div>
                    <?php echo form_open('settings/save_branch', array('id' => 'branchInfoForm')); ?>
                    <?php if (!empty($loaded_plan)): ?>
                        <input type="hidden" name="id" value="<?php echo $loaded_plan['id'] ?>">
                    <?php endif; ?>
                    <div class="pane-one-fourth block">
                        <div class="caption">
                            <div class="caption-inner"></i><?php echo $this->lang->line('general') ?>&nbsp;<i class="icon icon-down-dir"></i></div>
                        </div>
                        <div class="block-inner">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('branch') . ' ' . $this->lang->line('name') ?></label>
                                <input type="text" name="title" value="<?php !empty($loaded_plan) ? print $loaded_plan ['title'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('branch') . ' ' . $this->lang->line('name') ?>" <?php $this->session->userdata('group') > 4 ? print'disabled="disabled"' : '' ?>>
                            </div>
                            <div class="form-group">
                                <label><?php echo $this->lang->line('branch') . ' ' . $this->lang->line('email_address') ?></label>
                                <input type="text" name="general_email" value="<?php !empty($loaded_plan) ? print $loaded_plan ['general_email'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('branch') . ' ' . $this->lang->line('email_address') ?>" <?php $this->session->userdata('group') > 4 ? print'disabled="disabled"' : '' ?>>
                            </div>
                            <div class="form-group">
                                <label><?php echo $this->lang->line('branch') . ' ' . $this->lang->line('phone') ?></label>
                                <input type="text" name="general_phone" value="<?php !empty($loaded_plan) ? print$loaded_plan ['general_phone'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('branch') . ' ' . $this->lang->line('phone') ?>" <?php $this->session->userdata('group') > 4 ? print'disabled="disabled"' : '' ?>>
                            </div>
                            <div class="form-group">
                                <label><?php echo $this->lang->line('branch') . ' ' . $this->lang->line('mobile') ?></label>
                                <input type="text" name="general_mobile" value="<?php !empty($loaded_plan) ? print$loaded_plan ['general_mobile'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('branch') . ' ' . $this->lang->line('mobile') ?>" <?php $this->session->userdata('group') > 4 ? print'disabled="disabled"' : '' ?>>
                            </div>
                            <div class="form-group">
                                <label><?php echo $this->lang->line('receipt_terms') ?></label>
                                <textarea name="receipt_law" class="form-control" style="height: 82px;" <?php $this->session->userdata('group') > 4 ? print'disabled="disabled"' : '' ?>><?php echo!empty($loaded_plan) ? $loaded_plan['receipt_law'] : '' ?></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="pane-one-fourth block">
                        <div class="caption">
                            <div class="caption-inner"><?php echo $this->lang->line('address') ?>&nbsp;<i class="icon icon-down-dir"></i></div>
                        </div>
                        <div class="block-inner">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('country') ?></label>
                                <input name="address_country" class="form-control"  value="<?php echo $loaded_plan['address_country'] ?>" disabled="disabled">
                            </div>
                            <div class="form-group">
                                <label><?php echo $this->lang->line('region') ?></label>
                                <input name="address_region" class="form-control"  value="<?php echo $loaded_plan['address_region'] ?>" disabled="disabled">
                            </div>
                            <div class="form-group">
                                <label><?php echo $this->lang->line('city') ?></label>
                                <input name="address_city" class="form-control"  value="<?php echo $loaded_plan['address_city'] ?>" disabled="disabled">
                            </div>
                            <div class="form-group">
                                <label><?php echo $this->lang->line('area') ?></label>
                                <input name="address_area" class="form-control"  value="<?php echo $loaded_plan['address_area'] ?>" disabled="disabled">
                            </div>
                            <div class="form-group">
                                <label><?php echo $this->lang->line('sector_word_street') ?></label>
                                <input type="text" name="address_street" value="<?php !empty($loaded_plan) ? print$loaded_plan ['address_street'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('sector_word_street') ?>" <?php !empty($loaded_plan) && trim($loaded_plan['address_street']) != null ? print'disabled="disabled"' : '' ?>>
                            </div>
                            <div class="form-group">
                                <label><?php echo $this->lang->line('postcode') ?></label>
                                <input type="text" name="address_postcode" id="deliveryPlanPostcode" value="<?php !empty($loaded_plan) ? print$loaded_plan ['address_postcode'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('postcode') ?>" <?php !empty($loaded_plan) && trim($loaded_plan['address_postcode']) != null ? print'disabled="disabled"' : '' ?>>
                            </div>
                        </div>
                    </div>
                    <div class="pane-one-fourth block">
                        <div class="caption">
                            <div class="caption-inner"><?php echo $this->lang->line('service_processing_time') ?>&nbsp;<i class="icon icon-down-dir"></i></div>
                        </div>
                        <div class="block-inner">
                            <div class="form-group clearfix">
                                <label><?php echo sprintf($this->lang->line('default_processing_time'), $this->lang->line('table')) ?></label>
                                <input type="text" name="default_time_table" value="<?php !empty($loaded_plan) ? print$loaded_plan ['default_time_table'] : print $this->config->item('default_time_table') ?>" class="form-control" placeholder="Default Table Time" <?php $this->session->userdata('group') > 4 ? print'disabled="disabled"' : '' ?>>
                            </div>
                            <div class="form-group clearfix">
                                <label><?php echo sprintf($this->lang->line('default_processing_time'), $this->lang->line('bar')) ?></label>
                                <input type="text" name="default_time_bar" value="<?php !empty($loaded_plan) ? print$loaded_plan ['default_time_bar'] : print $this->config->item('default_time_bar') ?>" class="form-control" placeholder="Default Waiting Time" <?php $this->session->userdata('group') > 4 ? print'disabled="disabled"' : '' ?>>
                            </div>
                            <div class="form-group clearfix">
                                <label><?php echo sprintf($this->lang->line('default_processing_time'), $this->lang->line('waiting')) ?></label>
                                <input type="text" name="default_time_waiting" value="<?php !empty($loaded_plan) ? print$loaded_plan ['default_time_waiting'] : print $this->config->item('default_time_waiting') ?>" class="form-control" placeholder="Default Waiting Time" <?php $this->session->userdata('group') > 4 ? print'disabled="disabled"' : '' ?>>
                            </div>
                            <div class="form-group clearfix">
                                <label><?php echo sprintf($this->lang->line('default_processing_time'), $this->lang->line('collection')) ?></label>
                                <input type="text" name="default_time_collection" value="<?php !empty($loaded_plan) ? print$loaded_plan ['default_time_collection'] : print $this->config->item('default_time_collection') ?>" class="form-control" placeholder="Default Collection Time" <?php $this->session->userdata('group') > 4 ? print'disabled="disabled"' : '' ?>>
                            </div>
                            <div class="form-group clearfix">
                                <label><?php echo sprintf($this->lang->line('default_processing_time'), $this->lang->line('delivery')) ?></label>
                                <input type="text" name="default_time_delivery" value="<?php !empty($loaded_plan) ? print$loaded_plan ['default_time_delivery'] : print $this->config->item('default_time_delivery') ?>" class="form-control" placeholder="Default Delivery Time" <?php $this->session->userdata('group') > 4 ? print'disabled="disabled"' : '' ?>>
                            </div>
                            <div>
                                <div style="width: 50%; float: left; padding-right: 1px; ">
                                    <div class="form-group clearfix">
                                        <label>Discount Plan</label>
                                        <select class="form-control" name="discount_option" id="discountPlanList">
                                            <option value='-1'>Select Plan</option>
                                            <option value='0' <?php $loaded_plan['discount_option'] === '0' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('no_plan') ?></option>
                                            <option value='4' <?php $loaded_plan['discount_option'] === '4' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('category_plan') ?></option>
                                            <option value='3' <?php $loaded_plan['discount_option'] === '3' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('discount_plan') ?></option>
                                            <option value='2' <?php $loaded_plan['discount_option'] === '2' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('default_plan') ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div style="width: 50%; float: left;padding-left: 1px; ">
                                    <div class="form-group clearfix">
                                        <label>Tax Plan</label>
                                        <select class="form-control" name="tax_option" id="taxPlanList">
                                            <option value='-1'>Select Plan</option>
                                            <option value='0' <?php $loaded_plan['tax_option'] === '0' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('no_plan') ?></option>
                                            <option value='3' <?php $loaded_plan['tax_option'] === '3' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('category_plan') ?></option>
                                            <option value='2' <?php $loaded_plan['tax_option'] === '2' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('default_plan') ?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="pane-one-fourth block">
                        <div class="caption">
                            <div class="caption-inner"><?php echo $this->lang->line('charges') ?>&nbsp;<i class="icon icon-down-dir"></i></div>
                        </div>
                        <div class="block-inner">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('tin') ?></label>
                                <input type="text" name="default_tinnumber" value="<?php !empty($loaded_plan) ? print $loaded_plan ['default_tinnumber'] : print $this->config->item('default_tinnumber') ?>" class="form-control" placeholder="<?php echo $this->lang->line('tax_indentification_number') ?>" <?php $this->session->userdata('group') > 4 ? print'disabled="disabled"' : '' ?>>
                            </div>
                            <div class="form-group">
                                <label><?php echo $this->lang->line('default_tax') ?> (<?php echo $this->lang->line('percent') ?>) &nbsp;&nbsp;|&nbsp;&nbsp;is included?</label>
                                <div>
                                    <input style="width: 50%" type="text" name="default_tax" value="<?php !empty($loaded_plan) ? print $loaded_plan ['default_tax'] : print $this->config->item('default_tax') ?>" class="form-control" placeholder="<?php echo $this->lang->line('default_tax') ?>" <?php $this->session->userdata('group') > 4 ? print'disabled="disabled"' : '' ?>>
                                    <span style="width: 50%">&nbsp;&nbsp;|&nbsp;&nbsp;<input type="radio" name="taxIsIncluded" value="yes" <?php !empty($loaded_plan) && $loaded_plan['taxIsIncluded'] == 'yes' ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('yes')?>&nbsp;&nbsp;<input name="taxIsIncluded" value="no" type="radio" <?php !empty($loaded_plan) && $loaded_plan['taxIsIncluded'] == 'no' ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('no')?> </span>
                                </div>
                            </div>
                            <div class="form-group">
                                <label><?php echo $this->lang->line('default_discount') ?>  (<?php echo $this->lang->line('percent') ?>)</label>
                                <input type="text" name="default_discount" value="<?php !empty($loaded_plan) ? print$loaded_plan ['default_discount'] : print $this->config->item('default_discount') ?>" class="form-control" placeholder="<?php echo $this->lang->line('default_discount') ?>" <?php $this->session->userdata('group') > 4 ? print'disabled="disabled"' : '' ?>>
                            </div>
                            <div class="form-group">
                                <label><?php echo $this->lang->line('service_charge') ?> (<?php echo $this->lang->line('percent') ?>)</label>
                                <input type="text" name="default_sercharge" value="<?php !empty($loaded_plan) ? print$loaded_plan ['default_sercharge'] : print $this->config->item('default_sercharge') ?>" class="form-control" placeholder="<?php echo $this->lang->line('service_charge') ?>" <?php $this->session->userdata('group') > 4 ? print'disabled="disabled"' : '' ?>>
                            </div>
                            <div class="form-group">
                                <label><?php echo $this->lang->line('default_ccFee') ?> (<?php echo $this->lang->line('amount') ?> )</label>
                                <input type="text" name="default_ccFee" value="<?php !empty($loaded_plan) ? print$loaded_plan ['default_ccFee'] : print $this->config->item('default_ccFee') ?>" class="form-control" placeholder="<?php echo $this->lang->line('default_ccFee') ?>" <?php $this->session->userdata('group') > 4 ? print'disabled="disabled"' : '' ?>>
                            </div>
                            <div class="form-group">
                                <label><?php echo $this->lang->line('cbFee') ?> (<?php echo $this->lang->line('amount') ?> )</label>
                                <input type="text" name="default_cbFee" value="<?php !empty($loaded_plan) ? print$loaded_plan ['default_cbFee'] : print $this->config->item('default_ccFee') ?>" class="form-control" placeholder="<?php echo $this->lang->line('cbFee') ?>" <?php $this->session->userdata('group') > 4 ? print'disabled="disabled"' : '' ?>>
                            </div>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                    <div class="employee-add-block">
                        <div class="caption">
                            <div class="caption-inner"><?php echo $this->lang->line('pagination') ?>&nbsp;<i class="icon icon-down-dir"></i></div>
                        </div>
                        <div class="one-fifth">
                            <div class="block-inner" style="padding: 0px 2px;">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('report') ?> (<?php echo sprintf($this->lang->line('min_dynamic'), '10') ?> <?php echo sprintf($this->lang->line('max_dynamic'), '50') ?>)</label>
                                    <input type="text" name="pagination_report" value="<?php !empty($loaded_plan) ? print $loaded_plan ['pagination_report'] : print $this->config->item('pagination_report') ?>" class="form-control" placeholder="<?php echo $this->lang->line('report') ?>" <?php $this->session->userdata('group') > 4 ? print'disabled="disabled"' : '' ?>>
                                </div>
                            </div>
                        </div>
                        <div class="one-fifth">
                            <div class="block-inner" style="padding: 0px 2px;">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('menu') . ' ' . $this->lang->line('category') ?>  (<?php echo sprintf($this->lang->line('min_dynamic'), '5') ?> <?php echo sprintf($this->lang->line('max_dynamic'), '30') ?>)</label>
                                    <input type="text" name="pagination_category" value="<?php !empty($loaded_plan) ? print $loaded_plan ['pagination_category'] : print $this->config->item('pagination_category') ?>" class="form-control" placeholder="Menu category" <?php $this->session->userdata('group') > 4 ? print'disabled="disabled"' : '' ?>>
                                </div>
                            </div>
                        </div>
                        <div class="one-fifth">
                            <div class="block-inner" style="padding: 0px 2px;">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('menu') ?>  (<?php echo sprintf($this->lang->line('min_dynamic'), '10') ?> <?php echo sprintf($this->lang->line('max_dynamic'), '50') ?>)</label>
                                    <input type="text" name="pagination_menu" value="<?php !empty($loaded_plan) ? print $loaded_plan ['pagination_menu'] : print $this->config->item('pagination_menu') ?>" class="form-control" placeholder="Menu" <?php $this->session->userdata('group') > 4 ? print'disabled="disabled"' : '' ?>>
                                </div>
                            </div>
                        </div>
                        <div class="one-fifth">
                            <div class="block-inner" style="padding: 0px 2px;">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('menu') . ' ' . $this->lang->line('selection') ?>  (<?php echo sprintf($this->lang->line('min_dynamic'), '10') ?> <?php echo sprintf($this->lang->line('max_dynamic'), '50') ?>)</label>
                                    <input type="text" name="pagination_selection" value="<?php !empty($loaded_plan) ? print $loaded_plan ['pagination_selection'] : print $this->config->item('pagination_selection') ?>" class="form-control" placeholder="Menu Selection" <?php $this->session->userdata('group') > 4 ? print'disabled="disabled"' : '' ?>>
                                </div>
                            </div>
                        </div>
                    </div>  
                    <div class="clearfix"></div>
                    <?php if ($this->session->userdata('group') <= 4): ?>
                        <div class="tab-group config-submit">
                            <button type="submit" onclick="saveBranchInfo('branchInfoForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
                        </div>
                    <?php endif; ?>
                    <?php echo form_close() ?>
                </div>
                <script type="text/javascript">
                    function saveBranchInfo(formId) {
                        if (!$('.page-loader').is(":visible")) {
                            $('#' + formId).validate({
                                submitHandler: function () {
                                    var myform = document.getElementById(formId);
                                    var formdata = new FormData(myform);
                                    if (checkInternetConnection()) {
                                        $.ajax({
                                            url: $('#' + formId).attr('action'),
                                            data: formdata,
                                            cache: false,
                                            processData: false,
                                            contentType: false,
                                            type: 'POST',
                                            dataType: 'json',
                                            beforeSend: function () {
                                                $('.page-loader').show();
                                            },
                                            success: function (response) {
                                                $('.page-loader').hide();
                                                if (response.status) {
                                                    zamanEposNavigator('', '<?php echo site_url('settings/general') ?>')
                                                } else {
                                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                                }
                                            }
                                        });
                                    } else {
                                        warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                                    }

                                },
                                errorClass: "has-error",
                                highlight: function (e) {
                                    $(e).closest('.form-group').addClass('has-error');
                                },
                                unhighlight: function (e) {
                                    $(e).closest('.form-group').removeClass('has-error');
                                },
                                ignore: ":hidden",
                                rules: {
                                    title: {required: true},
                                    default_time_table: {number: true, min: 1, required: true},
                                    default_time_bar: {number: true, min: 1, required: true},
                                    default_time_waiting: {number: true, min: 1, required: true},
                                    default_time_collection: {number: true, min: 1, required: true},
                                    default_time_delivery: {number: true, min: 1, required: true},
                                    address_street: {required: true},
                                    address_country: {required: true},
                                    address_region: {required: true},
                                    address_city: {required: true},
                                    address_area: {required: true},
                                    address_postcode: {postcodeUK: true},
                                    general_email: {email: true, required: true},
                                    general_phone: {number: true, required: true},
                                    general_mobile: {number: true},
                                    default_tax: {number: true},
                                    default_discount: {number: true},
                                    service_charge: {number: true},
                                    default_ccFee: {number: true},
                                    status: {required: true}
                                },
                                messages: {
                                    address_country: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('country')) ?>',
                                    address_region: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('region')) ?>',
                                    address_city: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('city')) ?>',
                                    address_area: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('area')) ?>',
                                    address_postcode: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('postcode')) ?>',
                                    title: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('branch') . ' ' . $this->lang->line('name')) ?>',
                                    general_email: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('email_address')) ?>',
                                    general_phone: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('phone')) ?>',
                                    general_mobile: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('mobile')) ?>',
                                    address_street: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('street')) ?>'
                                },
                                errorPlacement: function (error, element) {
                                    errorPlacement(error, element);
                                }
                            });
                        }
                    }
                </script>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $this->load->view('settings/partials/footer') ?>

