<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane content-configuration">
            <div class="caption" onclick="zamanEposNavigator('', '<?php echo site_url('settings/branch') ?>', '')">
                <div class="caption-inner" style="padding: 9px;"><i class="icon icon-tools"></i>&nbsp;<?php echo $this->lang->line('setting') ?></div>
            </div>
            <?php echo form_open('settings/save_branch', array('id' => 'branchInfoForm')); ?>
            <?php if (!empty($loaded_plan)): ?>
                <input type="hidden" name="id" value="<?php echo $loaded_plan['id'] ?>">
            <?php endif; ?>
            <div class="pane-one-fourth block">
                <div class="caption">
                    <div class="caption-inner"></i><?php echo $this->lang->line('general') ?>&nbsp;<i class="icon icon-down-dir"></i></div>
                </div>
                <div class="block-inner">
                    <div class="form-group">
                        <label><?php echo $this->lang->line('branch') . ' ' . $this->lang->line('name') ?></label>
                        <input type="text" name="title" value="<?php !empty($loaded_plan) ? print$loaded_plan ['title'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('branch') . ' ' . $this->lang->line('name') ?>" <?php !empty($loaded_plan) && trim($loaded_plan['title']) != null ? print'disabled="disabled"' : '' ?>>
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('branch') . ' ' . $this->lang->line('email_address') ?></label>
                        <input type="text" name="general_email" value="<?php !empty($loaded_plan) ? print$loaded_plan ['general_email'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('branch') . ' ' . $this->lang->line('email_address') ?>" <?php !empty($loaded_plan) && trim($loaded_plan['general_email']) != null ? print'disabled="disabled"' : '' ?>>
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('branch') . ' ' . $this->lang->line('phone') ?></label>
                        <input type="text" name="general_phone" value="<?php !empty($loaded_plan) ? print$loaded_plan ['general_phone'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('branch') . ' ' . $this->lang->line('phone') ?>" <?php !empty($loaded_plan) && trim($loaded_plan['general_phone']) != null ? print'disabled="disabled"' : '' ?>>
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('branch') . ' ' . $this->lang->line('mobile') ?></label>
                        <input type="text" name="general_mobile" value="<?php !empty($loaded_plan) ? print$loaded_plan ['general_mobile'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('branch') . ' ' . $this->lang->line('mobile') ?>" <?php !empty($loaded_plan) && trim($loaded_plan['general_mobile']) != null ? print'disabled="disabled"' : '' ?>>
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('receipt_terms') ?></label>
                        <textarea name="receipt_law" class="form-control" style="height: 82px;"><?php echo!empty($loaded_plan) ? $loaded_plan['receipt_law'] : '' ?></textarea>
                    </div>
                </div>
            </div>
            <div class="pane-one-fourth block">
                <div class="caption">
                    <div class="caption-inner"><?php echo $this->lang->line('address') ?>&nbsp;<i class="icon icon-down-dir"></i></div>
                </div>
                <div class="block-inner">
                    <div class="form-group">
                        <label><?php echo $this->lang->line('country') ?></label>
                        <select class="form-control" onchange="getRegions(this.value)" name="address_country" <?php !empty($loaded_plan) && trim($loaded_plan['address_country']) != null ? print'disabled="disabled"' : '' ?>>
                            <?php if (!empty($countries)): ?>
                                <?php if (!empty($loaded_plan)): ?>
                                    <option value="<?php echo $loaded_plan['address_country'] ?>" selected="selected"><?php echo $loaded_plan['address_country'] ?></option>
                                <?php else: ?>
                                    <?php foreach ($countries as $aCountry): ?>
                                        <option value="<?php echo $aCountry->title ?>"><?php echo $aCountry->title ?></option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('region') ?></label>
                        <select class="form-control" id="branchRegion" onchange="getCities(this.value)" name="address_region" onchange="getCities(this.value)" id="branchRegion" <?php !empty($loaded_plan) && trim($loaded_plan['address_region']) != null ? print'disabled="disabled"' : '' ?>>
                            <?php if (!empty($regions)): ?>
                                <?php if (!empty($loaded_plan)): ?>
                                    <option value="<?php echo $loaded_plan['address_region'] ?>" selected="selected"><?php echo $loaded_plan['address_region'] ?></option>
                                <?php else: ?>
                                    <option value="0">Select Region</option>
                                    <?php foreach ($regions as $aRegion): ?>
                                        <option value="<?php echo $aRegion->title ?>"><?php echo $aRegion->title ?></option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('city') ?></label>
                        <select class="form-control" name="address_city" onchange="getAreas(this.value)" id="branchCity" <?php !empty($loaded_plan) && $loaded_plan['address_city'] != null ? print'disabled="disabled"' : '' ?>>
                            <?php if (!empty($loaded_plan)): ?>
                                <option value="<?php echo $loaded_plan['address_city'] ?>" selected="selected"><?php echo $loaded_plan['address_city'] ?></option>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('area') ?></label>
                        <select class="form-control" name="address_area" id="branchArea" <?php !empty($loaded_plan) && $loaded_plan['address_area'] != null ? print'disabled="disabled"' : '' ?>>
                            <?php if (!empty($loaded_plan)): ?>
                                <option value="<?php echo $loaded_plan['address_area'] ?>" selected="selected"><?php echo $loaded_plan['address_area'] ?></option>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('sector_word_street') ?></label>
                        <input type="text" name="address_street" value="<?php !empty($loaded_plan) ? print$loaded_plan ['address_street'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('sector_word_street') ?>" <?php !empty($loaded_plan) && trim($loaded_plan['address_street']) != null ? print'disabled="disabled"' : '' ?>>
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('postcode') ?></label>
                        <input type="text" name="address_postcode" id="deliveryPlanPostcode" value="<?php !empty($loaded_plan) ? print$loaded_plan ['address_postcode'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('postcode') ?>" <?php !empty($loaded_plan) && trim($loaded_plan['address_postcode']) != null ? print'disabled="disabled"' : '' ?>>
                    </div>
                </div>
            </div>
            <div class="pane-one-fourth block">
                <div class="caption">
                    <div class="caption-inner"><?php echo $this->lang->line('service_processing_time') ?>&nbsp;<i class="icon icon-down-dir"></i></div>
                </div>
                <div class="block-inner">
                    <div class="form-group clearfix">
                        <label><?php echo sprintf($this->lang->line('default_processing_time'), $this->lang->line('table')) ?></label>
                        <input type="text" name="default_time_table" value="<?php !empty($loaded_plan) ? print$loaded_plan ['default_time_table'] : print $this->config->item('default_time_table') ?>" class="form-control" placeholder="Default Table Time">
                    </div>
                    <div class="form-group clearfix">
                        <label><?php echo sprintf($this->lang->line('default_processing_time'), $this->lang->line('bar')) ?></label>
                        <input type="text" name="default_time_bar" value="<?php !empty($loaded_plan) ? print$loaded_plan ['default_time_bar'] : print $this->config->item('default_time_bar') ?>" class="form-control" placeholder="Default Waiting Time">
                    </div>
                    <div class="form-group clearfix">
                        <label><?php echo sprintf($this->lang->line('default_processing_time'), $this->lang->line('waiting')) ?></label>
                        <input type="text" name="default_time_waiting" value="<?php !empty($loaded_plan) ? print$loaded_plan ['default_time_waiting'] : print $this->config->item('default_time_waiting') ?>" class="form-control" placeholder="Default Waiting Time">
                    </div>
                    <div class="form-group clearfix">
                        <label><?php echo sprintf($this->lang->line('default_processing_time'), $this->lang->line('collection')) ?></label>
                        <input type="text" name="default_time_collection" value="<?php !empty($loaded_plan) ? print$loaded_plan ['default_time_collection'] : print $this->config->item('default_time_collection') ?>" class="form-control" placeholder="Default Collection Time">
                    </div>
                    <div class="form-group clearfix">
                        <label><?php echo sprintf($this->lang->line('default_processing_time'), $this->lang->line('delivery')) ?></label>
                        <input type="text" name="default_time_delivery" value="<?php !empty($loaded_plan) ? print$loaded_plan ['default_time_delivery'] : print $this->config->item('default_time_delivery') ?>" class="form-control" placeholder="Default Delivery Time">
                    </div>
                    <div class="form-group clearfix">
                        <label><?php echo sprintf($this->lang->line('website'), $this->lang->line('branch')) ?></label>
                        <input type="text" name="general_website" value="<?php !empty($loaded_plan) ? print site_url('user/login/index/' . $loaded_plan['id']) : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('website') ?>" readonly="true" oncopy="return true;" autocomplete="off">
                    </div>
                </div>
            </div>
            <div class="pane-one-fourth block">
                <div class="caption">
                    <div class="caption-inner"><?php echo $this->lang->line('charges') ?>&nbsp;<i class="icon icon-down-dir"></i></div>
                </div>
                <div class="block-inner">
                    <div class="form-group">
                        <label><?php echo $this->lang->line('tin') ?></label>
                        <input type="text" name="default_tinnumber" value="<?php !empty($loaded_plan) ? print$loaded_plan ['default_tinnumber'] : print $this->config->item('default_tinnumber') ?>" class="form-control" placeholder="<?php echo $this->lang->line('tax_indentification_number') ?>">
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('default_tax') ?> (<?php echo $this->lang->line('percent') ?>)</label>
                        <input type="text" name="default_tax" value="<?php !empty($loaded_plan) ? print$loaded_plan ['default_tax'] : print $this->config->item('default_tax') ?>" class="form-control" placeholder="<?php echo $this->lang->line('default_tax') ?>">
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('default_discount') ?>  (<?php echo $this->lang->line('percent') ?>)</label>
                        <input type="text" name="default_discount" value="<?php !empty($loaded_plan) ? print$loaded_plan ['default_discount'] : print $this->config->item('default_discount') ?>" class="form-control" placeholder="<?php echo $this->lang->line('default_discount') ?>">
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('service_charge') ?> (<?php echo $this->lang->line('percent') ?>)</label>
                        <input type="text" name="default_sercharge" value="<?php !empty($loaded_plan) ? print$loaded_plan ['default_sercharge'] : print $this->config->item('default_sercharge') ?>" class="form-control" placeholder="<?php echo $this->lang->line('service_charge') ?>">
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('default_ccFee') ?> (<?php echo $this->lang->line('amount') ?> )</label>
                        <input type="text" name="default_ccFee" value="<?php !empty($loaded_plan) ? print$loaded_plan ['default_ccFee'] : print $this->config->item('default_ccFee') ?>" class="form-control" placeholder="<?php echo $this->lang->line('default_ccFee') ?>">
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('status') ?></label>
                        <select class="form-control" name="status">
                            <option value="3" <?php !empty($loaded_plan) && $loaded_plan['status'] === '3' ? print'selected=selected' : '' ?>><?php echo $this->lang->line('active') ?></option>
                            <option value="2" <?php !empty($loaded_plan) && $loaded_plan['status'] === '2' ? print'selected=selected' : '' ?>><?php echo $this->lang->line('inactive') ?></option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="clearfix"></div>
            <div class="employee-add-block">
                <div class="caption">
                    <div class="caption-inner"><?php echo $this->lang->line('pagination') ?></div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner" style="padding: 0px 2px;">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('report') ?> (<?php echo sprintf($this->lang->line('min_dynamic'), '10') ?> <?php echo sprintf($this->lang->line('max_dynamic'), '50') ?>)</label>
                            <input type="text" name="pagination_report" value="<?php !empty($loaded_plan) ? print $loaded_plan ['pagination_report'] : print $this->config->item('pagination_report') ?>" class="form-control" placeholder="<?php echo $this->lang->line('report') ?>">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner" style="padding: 0px 2px;">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('menu') . ' ' . $this->lang->line('category') ?>  (<?php echo sprintf($this->lang->line('min_dynamic'), '5') ?> <?php echo sprintf($this->lang->line('max_dynamic'), '30') ?>)</label>
                            <input type="text" name="pagination_category" value="<?php !empty($loaded_plan) ? print $loaded_plan ['pagination_category'] : print $this->config->item('pagination_category') ?>" class="form-control" placeholder="Menu category">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner" style="padding: 0px 2px;">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('menu') ?>  (<?php echo sprintf($this->lang->line('min_dynamic'), '10') ?> <?php echo sprintf($this->lang->line('max_dynamic'), '50') ?>)</label>
                            <input type="text" name="pagination_menu" value="<?php !empty($loaded_plan) ? print $loaded_plan ['pagination_menu'] : print $this->config->item('pagination_menu') ?>" class="form-control" placeholder="Menu">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner" style="padding: 0px 2px;">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('menu') . ' ' . $this->lang->line('selection') ?>  (<?php echo sprintf($this->lang->line('min_dynamic'), '10') ?> <?php echo sprintf($this->lang->line('max_dynamic'), '50') ?>)</label>
                            <input type="text" name="pagination_selection" value="<?php !empty($loaded_plan) ? print $loaded_plan ['pagination_selection'] : print $this->config->item('pagination_selection') ?>" class="form-control" placeholder="Menu Selection">
                        </div>
                    </div>
                </div>
            </div>  
            <div class="clearfix"></div>
            <div class="employee-add-block">
                <div class="caption">
                    <div class="caption-inner"><?php echo $this->lang->line('currency') . ' ' . $this->lang->line('setup') ?></div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner" style="padding: 0px 2px;">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('currency') ?></label>
                            <select class="form-control" name="locale_currencysymbol" onchange="getCurrencySymbol(this.value)">
                                <?php if (!empty($currencies)): ?>
                                    <?php foreach ($currencies as $key => $acurrency): ?>
                                        <option value="<?php echo $key ?>" <?php $key == !empty($loaded_plan) && $loaded_plan['locale_currencysymbol'] || $this->config->item('locale_currencysymbol') ? print 'selected' : '' ?>><?php echo $acurrency ?></option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner" style="padding: 0px 2px;">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('currency_symbol') ?></label>
                            <input class="form-control" name="locale_currencyicon" value="<?php !empty($loaded_plan) ? print $loaded_plan['locale_currencyicon'] : print $this->config->item('locale_currencyicon') ?>" id="currencyIcon">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner" style="padding: 0px 2px;">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('position') ?></label>
                            <?php echo form_dropdown('locale_currencyside', array('left' => 'Left', 'right' => 'Right'), !empty($loaded_plan) ? $loaded_plan['locale_currencyside'] : $this->config->item('locale_currencyside'), array('class' => 'form-control')); ?>
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner" style="padding: 0px 2px;">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('kitchen_printer_ip') ?></label>
                            <input class="form-control" name="kitchenPrinterIp" value="<?php !empty($loaded_plan['kitchenPrinterIp']) ? print $loaded_plan['kitchenPrinterIp'] : print '' ?>" id="kitchenPrinterIp">
                        </div>
                    </div>
                </div>
            </div>
            <div class="clearfix"></div>
            <div class="caption">
                <div class="caption-inner"><?php echo $this->lang->line('branch_terminals') ?></div>
            </div>
            <?php $terminals = !empty($loaded_plan) && isset($loaded_plan['terminal']) ? unserialize($loaded_plan['terminal']) : array() ?>
            <div class="checkbox-group" style="width: 100%">
                <label><input data-error="#branchTerminalError" type="checkbox" name="terminal[]" value="kitchen" <?php !empty($terminals) && in_array('kitchen', $terminals) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('kitchen') ?>&nbsp;</label>
                <label><input data-error="#branchTerminalError" type="checkbox" name="terminal[]" value="bar" <?php !empty($terminals) && in_array('bar', $terminals) ? print'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('bar') ?>&nbsp;</label>
                <label><input data-error="#branchTerminalError" type="checkbox" name="terminal[]" value="bakery" <?php !empty($terminals) && in_array('bakery', $terminals) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('bakery') ?>&nbsp;</label>
                <label><input data-error="#branchTerminalError" type="checkbox" name="terminal[]" value="drinks" <?php !empty($terminals) && in_array('drinks', $terminals) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('drinks') ?>&nbsp;</label>
                <label><input data-error="#branchTerminalError" type="checkbox" name="terminal[]" value="waiting" <?php !empty($terminals) && in_array('waiting', $terminals) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('waiting') ?>&nbsp;</label>
                <label><input data-error="#branchTerminalError" type="checkbox" name="terminal[]" value="collection" <?php !empty($terminals) && in_array('collection', $terminals) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('collection') ?>&nbsp;</label>
                <label><input data-error="#branchTerminalError" type="checkbox" name="terminal[]" value="delivery" <?php !empty($terminals) && in_array('delivery', $terminals) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('delivery') ?>&nbsp;</label>
                <label><input data-error="#branchTerminalError" type="checkbox" name="terminal[]" value="callerDevice" <?php !empty($terminals) && in_array('callerDevice', $terminals) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('caller_device') ?>&nbsp;</label>
                <label><input data-error="#branchTerminalError" type="checkbox" name="terminal[]" value="appReceiver" <?php !empty($terminals) && in_array('appReceiver', $terminals) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('app_receiver') ?>&nbsp;</label>
                <label><input data-error="#branchTerminalError" type="checkbox" name="terminal[]" value="itemScanner" <?php !empty($terminals) && in_array('itemScanner', $terminals) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('item_scanner') ?>&nbsp;</label>
            </div>   
            <div id="branchTerminalError"></div>
            <div class="one-fifth">
                <div class="block-inner" style="padding: 0px 2px;">
                    <div class="form-group">
                        <label><?php echo $this->lang->line('caller_device_style') ?></label>
                        <span><input type="radio" name="callerDeviceStyle" <?php !empty($loaded_plan['callerDeviceStyle']) && $loaded_plan['callerDeviceStyle'] === 'no' ? print 'checked="checked"' : '' ?> value="no"><?php echo $this->lang->line('no') ?></span>
                        <span><input type="radio" name="callerDeviceStyle" <?php !empty($loaded_plan['callerDeviceStyle']) && $loaded_plan['callerDeviceStyle'] === 'yes' ? print 'checked="checked"' : '' ?> value="yes"><?php echo $this->lang->line('yes') ?></span>
                    </div>
                </div>
            </div>
            <div class="one-fifth">
                <div class="block-inner" style="padding: 0px 2px;">
                    <div class="form-group">
                        <label>Drinks Print</label>
                        <span><input type="radio" name="print_drinks" <?php !empty($loaded_plan['print_drinks']) && $loaded_plan['print_drinks'] === 'no' ? print 'checked="checked"' : '' ?> value="no"><?php echo $this->lang->line('no') ?></span>
                        <span><input type="radio" name="print_drinks" <?php !empty($loaded_plan['print_drinks']) && $loaded_plan['print_drinks'] === 'yes' ? print 'checked="checked"' : '' ?> value="yes"><?php echo $this->lang->line('yes') ?></span>
                    </div>
                </div>
            </div>

            <div class="tab-group config-submit">
                <button type="submit" onclick="saveBranchInfo('branchInfoForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
            </div>
            <?php echo form_close() ?>
            <div class="setting-general-keyboard text-center"></div>
            <div class="clearfix padded-top-more text-right"><span class="icon icon-keyboard btn-keyboard-close" onclick="zamanToogleEposVirtualKeyboard('setting-general-keyboard')">&nbsp;<?php echo $this->lang->line('open_virtual_keyboard') ?></span></div>
        </div>
    </div>
</div>
<script type="text/javascript">
    function getCurrencySymbol(currency) {
        var currency_symbols = {
            'BDT': '৳',
            'GBP': '£',
            'USD': 'USD'
        };
        $('#currencyIcon').val(currency_symbols[currency]);
    }
    function saveBranchInfo(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                $('.page-loader').hide();
                                if (response.status) {
                                    warning('<?php echo $this->lang->line('success') ?>', response.message, '<?php echo $this->lang->line('close') ?>');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                }
                            }
                        });
                    } else {
                        warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                    }

                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                ignore: ":hidden",
                rules: {
                    title: {required: true},
                    default_time_table: {number: true, min: 1, required: true},
                    default_time_bar: {number: true, min: 1, required: true},
                    default_time_waiting: {number: true, min: 1, required: true},
                    default_time_collection: {number: true, min: 1, required: true},
                    default_time_delivery: {number: true, min: 1, required: true},
                    address_street: {required: true},
                    address_country: {required: true},
                    address_region: {required: true},
                    address_city: {required: true},
                    address_area: {required: true},
                    address_postcode: {postcodeUK: true},
                    general_email: {email: true, required: true},
                    general_phone: {number: true, required: true},
                    general_mobile: {number: true},
                    default_tax: {number: true},
                    default_discount: {number: true},
                    service_charge: {number: true},
                    default_ccFee: {number: true},
                    status: {required: true},
                    'terminal[]': {required: true}
                },
                messages: {
                    address_country: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('country')) ?>',
                    address_region: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('region')) ?>',
                    address_city: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('city')) ?>',
                    address_area: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('area')) ?>',
                    address_postcode: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('postcode')) ?>',
                    title: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('branch') . ' ' . $this->lang->line('name')) ?>',
                    general_email: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('email_address')) ?>',
                    general_phone: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('phone')) ?>',
                    general_mobile: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('mobile')) ?>',
                    address_street: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('street')) ?>',
                    'terminal[]': '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('branch_terminals')) ?>'
                },
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
    function getRegions(country) {
        if (!$('.page-loader').is(":visible")) {
            $('#branchRegion').html('');
            if ($.trim(country)) {
                if (checkInternetConnection()) {
                    $.ajax({
                        url: '<?php echo site_url('settings/getCountryRegions') ?>',
                        type: 'post',
                        dataType: 'json',
                        data: {
                            country: country
                        },
                        beforeSend: function (xhr) {
                            $('.page-loader').show();
                        },
                        success: function (response) {
                            $('.page-loader').hide();
                            if (response.status) {
                                var items = response.regions;
                                var html = '<option value=""><?php echo $this->lang->line('select') ?></option>';
                                items.forEach(function (item) {
                                    html += '<option value="' + item.title + '">' + item.title + '</option>';
                                });
                                $('#branchRegion').html(html);
                            }
                        }
                    });
                } else {
                    warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                }
            } else {
                var html = '<option value="0"><?php echo sprintf($this->lang->line('not_found'), $this->lang->line('region')) ?></option>';
                $('#branchRegion').html(html);
            }
        }
    }
    function getCities(regionId) {
        if (!$('.page-loader').is(":visible")) {
            $('#branchArea').html('');
            if ($.trim(regionId)) {
                if (checkInternetConnection()) {
                    $.ajax({
                        url: '<?php echo site_url('settings/getRegionCities') ?>',
                        type: 'post',
                        dataType: 'json',
                        data: {
                            region: regionId
                        },
                        beforeSend: function (xhr) {
                            $('.page-loader').show();
                        },
                        success: function (response) {
                            $('.page-loader').hide();
                            if (response.status) {
                                var items = response.cities;
                                var html = '<option value=""><?php echo $this->lang->line('select') ?></option>';
                                items.forEach(function (item) {
                                    html += '<option value="' + item.title + '">' + item.title + '</option>';
                                });
                                $('#branchCity').html(html);
                            }
                        }
                    });
                } else {
                    warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                }
            } else {
                var html = '<option value="0"><?php echo sprintf($this->lang->line('not_found'), $this->lang->line('city')) ?></option>';
                $('#branchCity').html(html);
            }
        }
    }
    function getAreas(city) {
        if (!$('.page-loader').is(":visible")) {
            $('#branchArea').html('');
            if ($.trim(city)) {
                if (checkInternetConnection()) {
                    $.ajax({
                        url: '<?php echo site_url('settings/getCityAreas') ?>',
                        type: 'post',
                        dataType: 'json',
                        data: {
                            city: city
                        },
                        beforeSend: function (xhr) {
                            $('.page-loader').show();
                        },
                        success: function (response) {
                            $('.page-loader').hide();
                            if (response.status) {
                                var items = response.areas;
                                var html = '<option value=""><?php echo $this->lang->line('select') ?></option>';
                                items.forEach(function (item) {
                                    html += '<option value="' + item.title + '">' + item.title + '</option>';
                                });
                                $('#branchArea').html(html);
                            }
                        }
                    });
                } else {
                    warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                }
            } else {
                var html = '<option value="0"><?php echo sprintf($this->lang->line('not_found'), $this->lang->line('area')) ?></option>';
                $('#branchArea').html(html);
            }
        }
    }
</script>
<?php $this->load->view('settings/partials/footer') ?>