<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane  content-configuration">
            <?php echo form_open('settings/api_save', array('id' => 'apiSettingForm')); ?>
            <?php if (!empty($thisBranchApi)): ?>
                <input type="hidden" name="id" value="<?php echo $thisBranchApi['id'] ?>">
            <?php endif; ?>
            <div class="employee-add-block">
                <div class="caption">
                    <div class="caption-inner"><?php echo $this->lang->line('auto_delviery_setup') ?>&nbsp;<i class="icon icon-down-dir"></i></div>
                </div>
                <div class="pane-one-third">
                    <div class="block-inner" style="padding: 0px 2px;">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('delivery_radius') ?></label>
                            <input class="form-control" name="radius" value="<?php !empty($thisBranchApi) ? print $thisBranchApi['radius'] : '' ?>" placeholder="<?php echo $this->lang->line('delivery_radius') ?>">
                        </div>
                    </div>
                </div>
                <div class="pane-one-third">
                    <div class="block-inner" style="padding: 0px 2px;">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('free_delivery_radius') ?></label>
                            <input class="form-control" name="freeRadius" value="<?php !empty($thisBranchApi) ? print $thisBranchApi['freeRadius'] : '' ?>" placeholder="<?php echo $this->lang->line('free_delivery_radius') ?>">
                        </div>
                    </div>
                </div>
                <div class="pane-one-third">
                    <div class="block-inner" style="padding: 0px 2px;">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('delivery_cost_per_mile') ?></label>
                            <input class="form-control" name="costPerMile" value="<?php !empty($thisBranchApi) ? print $thisBranchApi['costPerMile'] : '' ?>" placeholder="<?php echo $this->lang->line('delivery_cost_per_mile') ?>">
                        </div>
                    </div>
                </div>
            </div>
            <div class="clearfix"></div>
            <div class="employee-add-block">
                <div class="caption">
                    <div class="caption-inner"><?php echo $this->lang->line('api_settings') ?>&nbsp;<i class="icon icon-down-dir"></i></div>
                </div>
                <div class="pane-one-third">
                    <div class="block-inner" style="padding: 0px 2px;">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('api_key') ?></label>
                            <input class="form-control" name="apiKey" value="<?php !empty($thisBranchApi) ? print $thisBranchApi['apiKey'] : '' ?>" placeholder="<?php echo $this->lang->line('api_key') ?>">
                        </div>
                    </div>
                </div>
                <div class="pane-one-third">
                    <div class="block-inner" style="padding: 0px 2px;">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('captcha_site_key') ?></label>
                            <input class="form-control" name="captchaSiteKey" value="<?php !empty($thisBranchApi) ? print $thisBranchApi['captchaSiteKey'] : '' ?>"  placeholder="<?php echo $this->lang->line('captcha_site_key') ?>">
                        </div>
                    </div>
                </div>
                <div class="pane-one-third">
                    <div class="block-inner" style="padding: 0px 2px;">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('captcha_secret_key') ?></label>
                            <input class="form-control" name="captchaSecretKey" value="<?php !empty($thisBranchApi) ? print $thisBranchApi['captchaSecretKey'] : '' ?>"  placeholder="<?php echo $this->lang->line('captcha_secret_key') ?>">
                        </div>
                    </div>
                </div>
            </div>
            <div class="clearfix"></div>
            <div class="tab-group config-submit">
                <button type="submit" onclick="saveApiSetting('apiSettingForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
            </div>
            <?php echo form_close() ?>
        </div>
    </div>
</div>
<?php $this->load->view('settings/partials/footer') ?>
<script type="text/javascript">
    function saveApiSetting(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                if (response.status) {
                                    $('.page-loader').hide();
                                    warning('<?php echo $this->lang->line('success') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                }
                            }
                        });
                    }
                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                rules: {
                    radius: {required: true, number: true, min: 1},
                    freeRadius: {required: true, number: true, min: 0},
                    costPerMile: {required: true, number: true, min: 0},
                    apiKey: {required: true},
                    captchaSiteKey: {required: true},
                    captchaSecretKey: {required: true}
                },
                messages: {
                    radius: '<?php echo sprintf($this->lang->line('item_required_in_number'), $this->lang->line('delivery_radius')) ?>',
                    freeRadius: '<?php echo sprintf($this->lang->line('item_required_in_number'), $this->lang->line('free_delivery_radius')) ?>',
                    costPerMile: '<?php echo sprintf($this->lang->line('item_required_in_number'), $this->lang->line('delivery_cost_per_mile')) ?>',
                    apiKey: '<?php echo sprintf($this->lang->line('invalid_value'), $this->lang->line('api_key')) ?>',
                    captchaSiteKey: '<?php echo sprintf($this->lang->line('invalid_value'), $this->lang->line('captcha_site_key')) ?>',
                    captchaSecretKey: '<?php echo sprintf($this->lang->line('invalid_value'), $this->lang->line('captchaSecretKey')) ?>'

                },
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
</script>
