<?php if (!empty($loaded_country)): ?>
    <div class="pane">
        <div class="caption"><span class="icon icon-list-add"></span>&nbsp;<?php echo $this->lang->line('add_region') ?> - <?php echo $loaded_country['title'] ?></div>
        <?php echo form_open('settings/location/save_region/' . $loaded_country['id'], array('id' => 'locationRegionForm')); ?>
        <?php if (!empty($loaded_region)): ?>
            <div><span class="btn btn-positive" style="width: 100%" onclick="resetForm('locationRegionForm')"><?php echo $this->lang->line('clear_form_add_new') ?></span></div>
            <input type="hidden" name="id" value="<?php echo $loaded_region['id'] ?>">
            <input type="hidden" id="updateRegion" value="yes">
            <input type="hidden" id="oldRegionTitle" value="<?php echo $loaded_region['title'] ?>">
        <?php endif; ?>
        <div class="form-group">
            <input class="form-control" id="regionTitle" name="title" value="<?php !empty($loaded_region) ? print $loaded_region['title'] : '' ?>" type="text">
        </div>
        <div class="tab-group config-submit">
            <button type="submit" onclick="saveLocationRegion('locationRegionForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
        </div>
        <?php echo form_close() ?>
        <?php if (!empty($loaded_country_region)): ?>
            <div class="clearfix">
                <table class="collection-bg">
                    <caption><?php echo $loaded_country['title'] . ' ' . $this->lang->line('region_list') ?></caption>
                    <tr>
                        <th class="text-center"><?php echo $this->lang->line('name') ?></th>
                        <th class="text-center"><?php echo $this->lang->line('up_down') ?></th>
                        <th class="text-center"><?php echo $this->lang->line('action') ?></th>
                    </tr>
                    <?php foreach ($loaded_country_region as $aregion): ?>
                        <tr>
                            <td class="text-center"><?php echo $aregion->title ?></td>
                            <td class="text-center"><span class="icon icon-up-open-big btn btn-positive" onclick="sortRegion('<?php echo $aregion->id ?>', '<?php echo $aregion->position ?>', '<?php echo 'down' ?>')"></span>&nbsp;&nbsp;<span class="icon icon-down-open-big btn btn-positive" onclick="sortRegion('<?php echo $aregion->id ?>', '<?php echo $aregion->position ?>', '<?php echo 'up' ?>')"></span></td>
                            <td class="text-center">
                                <span class="icon icon-pencil" onclick="zamanEposNavigator('', '<?php echo site_url('settings/location/index/' . $loaded_country['id'] . '/' . $aregion->id) ?>', 'location')"></span>
                                <?php if ($this->session->userdata('group') === '2'): ?>
                                    &nbsp;&nbsp;&nbsp;<span class="icon icon-trash" onclick="deleteRegionById('<?php echo $aregion->id ?>')"></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </table>
            </div>
        <?php endif; ?>
    </div>
<?php endif; ?>
<script type="text/javascript">
    function saveLocationRegion(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                $('.page-loader').hide();
                                if (response.status) {
                                    zamanEposNavigator('', '<?php echo site_url('settings/location/index/') ?>' + response.country + '/' + response.region, 'location');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                }
                            }
                        });
                    } else {
                        warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                    }
                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                rules: {
                    title: {
                        required: true,
                        alphaonly: true,
                        remote: {
                            url: "<?php echo site_url('settings/location/checkregion') ?>",
                            type: "post",
                            data: {
                                value: function () {
                                    return $("#regionTitle").val();
                                },
                                column: 'title',
                                old: function () {
                                    if ($('#oldRegionTitle').length > 0) {
                                        return $('#oldRegionTitle').val();
                                    } else {
                                        return 'none';
                                    }
                                },
                                update: function () {
                                    if ($('#updateRegion').length > 0) {
                                        return 'yes';
                                    } else {
                                        return 'no';
                                    }
                                },
                                country: '<?php echo $loaded_country['id'] ?>'
                            }
                        }
                    }
                },
                messages: {
                    title: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('region')) ?>'
                },
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
    function sortRegion(id, position, func) {
        if (!$('.page-loader').is(":visible")) {
            if (checkInternetConnection()) {
                $.ajax({
                    url: '<?php echo site_url('settings/location/sortregion') ?>',
                    type: 'post',
                    dataType: 'json',
                    data: {
                        id: id,
                        position: position,
                        func: func
                    },
                    beforeSend: function () {
                        $('.page-loader').show();
                    },
                    success: function (response) {
                        $('.page-loader').hide();
                        if (response.status) {
                            zamanEposNavigator('', '<?php echo site_url('settings/location/index/' . $loaded_country['id']) ?>', 'location');
                        } else {
                            warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                        }
                    }
                });
            } else {
                warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
            }
        }
    }
    function deleteRegionById(id) {
        if (!$('.page-loader').is(":visible")) {
            if (checkInternetConnection()) {
                $.confirm({
                    title: '<?php echo $this->lang->line('warning') ?>',
                    message: '<?php echo $this->lang->line('delete_warning_message') ?>',
                    buttons: {
                        '<span class="icon icon-check">&nbsp;<?php echo $this->lang->line('yes') ?></span>': {
                            'class': 'positive',
                            'action': function () {
                                playBeepSound();
                                $.ajax({
                                    url: '<?php echo site_url('settings/location/deleteRegionById/') ?>' + id + '/yes',
                                    type: 'GET',
                                    dataType: 'json',
                                    beforeSend: function () {
                                        $('.page-loader').show();
                                    },
                                    success: function (response) {
                                        $('.page-loader').hide();
                                        if (response.status) {
                                            zamanEposNavigator('location', '<?php echo site_url('settings/location/index/') ?>', 'location');
                                        }
                                    }
                                });
                            }
                        },
                        '<span class="icon icon-cancel">&nbsp;<?php echo $this->lang->line('no') ?></span>': {
                            'class': 'negative',
                            'action': function () {
                                playBeepSound();
                                $.confirm.hide();
                            }
                        }
                    }
                });
            } else {
                warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
            }
        }
    }
</script>