<div class="pane">
    <div class="caption"><span class="icon icon-list-add"></span>&nbsp;<?php echo $this->lang->line('add_country') ?></div>
    <?php echo form_open('settings/location/save_country', array('id' => 'locationCountryForm')); ?>
    <?php if (!empty($loaded_country)): ?>
        <div><span class="btn btn-positive" style="width: 100%" onclick="resetForm('locationCountryForm')"><?php echo $this->lang->line('clear_form_add_new') ?></span></div>
        <input type="hidden" name="id" value="<?php echo $loaded_country['id'] ?>">
        <input type="hidden" id="updateCountry" value="yes">
        <input type="hidden" id="oldCountryTitle" value="<?php echo $loaded_country['title'] ?>">
    <?php endif; ?>
    <div class="form-group">
        <input class="form-control" value="<?php !empty($loaded_country) ? print $loaded_country['title'] : '' ?>" name="title" type="text" id="countryTitle">
    </div>
    <div class="tab-group config-submit">
        <button type="submit" onclick="saveLocationCountry('locationCountryForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
    </div>
    <?php echo form_close() ?>
    <?php if (!empty($countries)): ?>
        <div class="clearfix">
            <table class="collection-bg">
                <caption><?php echo $this->lang->line('country_list') ?></caption>
                <tr>
                    <th class="text-center"><?php echo $this->lang->line('name') ?></th>
                    <th class="text-center"><?php echo $this->lang->line('up_down') ?></th>
                    <th class="text-center"><?php echo $this->lang->line('action') ?></th>
                </tr>
                <?php foreach ($countries as $acountry): ?>
                    <tr>
                        <td class="text-center" style="width: 60%"><?php echo $acountry->title ?></td>
                        <td class="text-center" style="width: 20%"><span class="icon icon-up-open-big btn btn-positive" onclick="sortCountry('<?php echo $acountry->id ?>', '<?php echo $acountry->position ?>', '<?php echo 'down' ?>')"></span>&nbsp;&nbsp;<span class="icon icon-down-open-big btn btn-positive" onclick="sortCountry('<?php echo $acountry->id ?>', '<?php echo $acountry->position ?>', '<?php echo 'up' ?>')"></span></td>
                        <td class="text-center" style="width: 20%">
                            <span class="icon icon-pencil" onclick="zamanEposNavigator('', '<?php echo site_url('settings/location/index/' . $acountry->id) ?>', 'location')"></span>
                            <?php if ($this->session->userdata('group') === '2'): ?>
                                &nbsp;&nbsp;&nbsp;<span class="icon icon-trash" onclick="deleteCountryById('<?php echo $acountry->id ?>')"></span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </table>
        </div>
    <?php endif; ?>
</div>
<script type="text/javascript">
    function saveLocationCountry(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                $('.page-loader').hide();
                                if (response.status) {
                                    zamanEposNavigator('', '<?php echo site_url('settings/location/index/') ?>' + response.country, 'location');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                }
                            }
                        });
                    } else {
                        warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                    }
                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                rules: {
                    title: {
                        required: true,
                        alphaonly: true,
                        remote: {
                            url: "<?php echo site_url('settings/location/checkcountry') ?>",
                            type: "post",
                            data: {
                                value: function () {
                                    return $("#countryTitle").val();
                                },
                                column: 'title',
                                old: function () {
                                    if ($('#oldCountryTitle').length > 0) {
                                        return $('#oldCountryTitle').val();
                                    } else {
                                        return 'none';
                                    }
                                },
                                update: function () {
                                    if ($('#updateCountry').length > 0) {
                                        return 'yes';
                                    } else {
                                        return 'no';
                                    }
                                }
                            }
                        }
                    }
                },
                messages: {title: 'Please, specify Country Name'},
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
    function sortCountry(id, position, func) {
        if (!$('.page-loader').is(":visible")) {
            if (checkInternetConnection()) {
                $.ajax({
                    url: '<?php echo site_url('settings/location/sortcountry') ?>',
                    type: 'post',
                    dataType: 'json',
                    data: {
                        id: id,
                        position: position,
                        func: func
                    },
                    beforeSend: function () {
                        $('.page-loader').show();
                    },
                    success: function (response) {
                        $('.page-loader').hide();
                        if (response.status) {
                            zamanEposNavigator('', '<?php echo site_url('settings/location/index/') ?>', 'location');
                        } else {
                            warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                        }
                    }
                });
            } else {
                warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
            }
        }
    }
    function deleteCountryById(id) {
        if (!$('.page-loader').is(":visible")) {
            if (checkInternetConnection()) {
                $.confirm({
                    title: '<?php echo $this->lang->line('warning') ?>',
                    message: '<?php echo $this->lang->line('delete_warning_message') ?>',
                    buttons: {
                        '<span class="icon icon-check">&nbsp;<?php echo $this->lang->line('yes') ?></span>': {
                            'class': 'positive',
                            'action': function () {
                                playBeepSound();
                                $.ajax({
                                    url: '<?php echo site_url('settings/location/deleteCountryById/') ?>' + id + '/yes',
                                    type: 'GET',
                                    dataType: 'json',
                                    beforeSend: function () {
                                        $('.page-loader').show();
                                    },
                                    success: function (response) {
                                        $('.page-loader').hide();
                                        if (response.status) {
                                            zamanEposNavigator('location', '<?php echo site_url('settings/location/index/') ?>', 'location');
                                        }
                                    }
                                });
                            }
                        },
                        '<span class="icon icon-cancel">&nbsp;<?php echo $this->lang->line('no') ?></span>': {
                            'class': 'negative',
                            'action': function () {
                                playBeepSound();
                                $.confirm.hide();
                            }
                        }
                    }
                });
            } else {
                warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
            }
        }
    }
</script>