<?php $this->load->view('settings/partials/header') ?>
<div class="window-content" id="WindowContent">
    <div class="page-loader" style="display: none;"></div>
    <div style="width: 100%;">
        <table class="text-center report-table" id="printReportEntire">
            <thead class="table-bg">
                <tr class="no-print">
                    <?php if (count($branches) > 1 && $this->session->userdata('group') <= 3): ?>
                        <th colspan="2">
                            <select class="form-control" id="reportBranch">
                                <?php foreach ($branches as $aBranch): ?>
                                    <option value="<?php echo $aBranch->id ?>" <?php trim($filterData[6] && $filterData[6] === $aBranch->id) ? print 'selected="selected"' : '' ?>><?php echo $aBranch->title . ' - ' . $this->config->item('general_name') ?></option>
                                <?php endforeach; ?>
                            </select>
                        </th>
                    <?php endif ?>
                    <th colspan="<?php count($branches) > 1 && $this->session->userdata('group') <= 3 ? print'1' : print'2' ?>"><input type="text" id="reportDateFrom" class="form-control" placeholder="<?php echo $this->lang->line('date_from') ?>" value="<?php !empty($filterData) && ($filterData[0]) ? print $filterData[0] : '' ?>"></th>
                    <th colspan="<?php count($branches) > 1 && $this->session->userdata('group') <= 3 ? print'1' : print'2' ?>"><input type="text" id="reportDateTo" class="form-control" placeholder="<?php echo $this->lang->line('date_to') ?>" value="<?php !empty($filterData) && ($filterData[1]) ? print $filterData[1] : '' ?>"></th>
                    <th colspan="1"><input type="text" id='reportReference' class="form-control" placeholder="<?php echo $this->lang->line('ref') ?>" value="<?php !empty($filterData) && ($filterData[2]) ? print $filterData[2] : '' ?>"></th>
                    <th colspan="2">
                        <select id='reportOrderSource' class="form-control">
                            <option value='0'><?php echo $this->lang->line('source') ?></option>
                            <option value='epos' <?php isset($filterData) && $filterData[3] == 'epos' ? print'selected="selected"' : '' ?>><?php echo $this->lang->line('epos') ?></option>
                            <option value='online' <?php isset($filterData) && $filterData[3] == 'online' ? print'selected="selected"' : '' ?>><?php echo $this->lang->line('online') ?></option>
                        </select>
                    </th>
                    <th colspan="1">
                        <select id='reportOrderType' class="form-control">
                            <option value="0"><?php echo $this->lang->line('type') ?></option>
                            <option value='table' <?php isset($filterData) && $filterData[4] == 'table' ? print'selected="selected"' : '' ?>><?php echo $this->lang->line('table') ?></option>
                            <option value='bar' <?php isset($filterData) && $filterData[4] == 'bar' ? print'selected="selected"' : '' ?>><?php echo $this->lang->line('bar') ?></option>
                            <option value='waiting' <?php isset($filterData) && $filterData[4] == 'waiting' ? print'selected="selected"' : '' ?>><?php echo $this->lang->line('waiting') ?></option>
                            <option value='collection' <?php isset($filterData) && $filterData[4] == 'collection' ? print'selected="selected"' : '' ?>><?php echo $this->lang->line('collection') ?></option>
                            <option value='delivery' <?php isset($filterData) && $filterData[4] == 'delivery' ? print'selected="selected"' : '' ?>><?php echo $this->lang->line('delivery') ?></option>
                        </select>
                    </th>
                    <th colspan="1">
                        <select id='reportOrderPayment' class="form-control">
                            <option value='0'><?php echo $this->lang->line('payment_type') ?></option>
                            <option value='Cash' <?php isset($filterData) && $filterData[5] == 'Cash' ? print'selected="selected"' : '' ?>><?php echo $this->lang->line('cash') ?></option>
                            <option value='EFT' <?php isset($filterData) && $filterData[5] == 'EFT' ? print'selected="selected"' : '' ?>><?php echo $this->lang->line('eft') ?></option>
                            <option value='Online' <?php isset($filterData) && $filterData[5] == 'Online' ? print'selected="selected"' : '' ?>><?php echo $this->lang->line('online') ?></option>
                            <option value='Cheque' <?php isset($filterData) && $filterData[5] == 'Cheque' ? print'selected="selected"' : '' ?>><?php echo $this->lang->line('cheque') ?></option>
                            <option value='Voucher' <?php isset($filterData) && $filterData[5] == 'Voucher' ? print'selected="selected"' : '' ?>><?php echo $this->lang->line('voucher') ?></option>
                        </select>
                    </th>
                    <th colspan="1"><button type="submit" class="btn btn-primary btn-large" style="width: 100%" onclick="filterReport()"><i class="icon icon-search text-center" ></i>&nbsp;<?php echo sprintf($this->lang->line('dash_report'), $this->lang->line('filter')) ?></button></th>
                    <th colspan="2"><button type="submit" class="btn btn-primary btn-large" style="width: 100%" onclick="printSelectedArea('printReportEntire')"><i class="icon icon-print text-center" ></i>&nbsp;<?php echo sprintf($this->lang->line('dash_report'), $this->lang->line('print')) ?></button></th>
                </tr>
                <tr>
                    <th onclick="getDeletedOrderList()" style="padding-left: 5px;"><?php echo $this->lang->line('id') ?>&nbsp;<span style="color: #f7fc00">[Delete]</span></th>
                    <th><?php echo $this->lang->line('customer') ?></th>
                    <th><?php echo $this->lang->line('source') ?></th>
                    <th><?php echo $this->lang->line('type') ?></th>
                    <th><?php echo $this->lang->line('date') ?></th>
                    <th style="width: 10%"><?php echo $this->lang->line('total') ?></th>
                    <th style="width: 10%"><?php echo $this->lang->line('cash') ?></th>
                    <th style="width: 10%"><?php echo $this->lang->line('eft') ?></th>
                    <th style="width: 10%"><?php echo $this->lang->line('online') ?></th>
                    <th style="width: 10%"><?php echo $this->lang->line('cheque') ?></th>
                    <th><?php echo $this->lang->line('voucher') ?></th>
                    <!--<th><?php echo $this->lang->line('cash_tips') ?></th>
                    <th><?php echo $this->lang->line('card_tips') ?></th>
                    <th><?php echo $this->lang->line('paid_back') ?></th>
                    <th><?php echo $this->lang->line('ccFee') ?></th>
                    <th><?php echo $this->lang->line('cbFee') ?></th>
                    <th>Disc</th>
                    <th><?php echo $this->lang->line('ser_ch') ?></th>
                    <th><?php echo $this->lang->line('tax') ?></th>-->
                    <th class="no-print" style="width: 60px;"><?php echo $this->lang->line('action') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php
                $aggregateGrandTotal = 0;
                $aggregatePaymentCashTotal = 0;
                $aggregatePaymentEFTTotal = 0;
                $aggregatePaymentChequeTotal = 0;
                $aggregatePaymentVoucherTotal = 0;
                $aggregatePaymentWebTotal = 0;
                $aggregateCashTipsTotal = 0;
                $aggregateCardTipsTotal = 0;
                $aggregatePaidBackTotal = 0;
                $aggregateccFeeTotal = 0;
                $aggregatecbFeeTotal = 0;
                $aggregateTaxTotal = 0;
                $aggregateDiscountTotal = 0;
                $aggregateServiceChargeTotal = 0;
                //---------------------------
                $aggregate_table = 0;
                $aggregate_table_amount = 0;
                $aggregate_table_guest = 0;
                $aggregate_table_cash = 0;
                $aggregate_table_tips = 0;
                $aggregate_table_paid_back = 0;
                $aggregate_table_eft = 0;
                $aggregate_table_web = 0;
                $aggregate_table_cheque = 0;
                $aggregate_table_voucher = 0;
                //----------------------------
                $aggregate_waiting = 0;
                $aggregate_waiting_amount = 0;
                $aggregate_waiting_guest = 0;
                $aggregate_waiting_cash = 0;
                $aggregate_waiting_tips = 0;
                $aggregate_waiting_paid_back = 0;
                $aggregate_waiting_eft = 0;
                $aggregate_waiting_web = 0;
                $aggregate_waiting_cheque = 0;
                $aggregate_waiting_voucher = 0;
                //----------------------------
                $aggregate_bar = 0;
                $aggregate_bar_amount = 0;
                $aggregate_bar_guest = 0;
                $aggregate_bar_cash = 0;
                $aggregate_bar_tips = 0;
                $aggregate_bar_paid_back = 0;
                $aggregate_bar_eft = 0;
                $aggregate_bar_web = 0;
                $aggregate_bar_cheque = 0;
                $aggregate_bar_voucher = 0;
                //----------------------------
                $aggregate_collection = 0;
                $aggregate_collection_amount = 0;
                $aggregate_collection_guest = 0;
                $aggregate_collection_cash = 0;
                $aggregate_collection_tips = 0;
                $aggregate_collection_paid_back = 0;
                $aggregate_collection_eft = 0;
                $aggregate_collection_web = 0;
                $aggregate_collection_cheque = 0;
                $aggregate_collection_voucher = 0;
                //----------------------------
                $aggregate_delivery = 0;
                $aggregate_delivery_amount = 0;
                $aggregate_delivery_guest = 0;
                $aggregate_delivery_cash = 0;
                $aggregate_delivery_tips = 0;
                $aggregate_delivery_paid_back = 0;
                $aggregate_delivery_eft = 0;
                $aggregate_delivery_web = 0;
                $aggregate_delivery_cheque = 0;
                $aggregate_delivery_voucher = 0;
                //----------------------------
                $aggregate_online = 0;
                $aggregate_online_amount = 0;
                $aggregate_online_guest = 0;
                $aggregate_online_cash = 0;
                $aggregate_online_tips = 0;
                $aggregate_online_paid_back = 0;
                $aggregate_online_eft = 0;
                $aggregate_online_web = 0;
                $aggregate_online_cheque = 0;
                $aggregate_online_voucher = 0;
                ?>
                <?php if (!empty($orderList)): ?>
                    <?php foreach ($orderList as $anOrder): ?>
                        <?php
                        $payments = unserialize($anOrder->payment);
                        $paymentArray = array();
                        if (count($payments) > 0) {
                            foreach ($payments as $aPayment) {
                                $paymentArray [$aPayment['type']] = $aPayment['amount'];
                            }
                        }
                        if ($anOrder->source === 'online') {
                            $aggregate_online += 1;
                            $aggregate_online_amount += to_currency_no_money($anOrder->grandTotal);
                            if (array_key_exists('Cash', $paymentArray)) {
                                $aggregate_online_cash += to_currency_no_money($paymentArray['Cash']);
                            }
                            if (array_key_exists('EFT', $paymentArray)) {
                                $aggregate_online_eft += !empty($paymentArray['EFT']) ? to_currency_no_money($paymentArray['EFT']) : 0;
                            }
                            if (array_key_exists('Online', $paymentArray)) {
                                $aggregate_online_web += !empty($paymentArray['Online']) ? to_currency_no_money($paymentArray['Online']) : 0;
                            }
                            if (array_key_exists('Cheque', $paymentArray)) {
                                $aggregate_online_cheque += to_currency_no_money($paymentArray['Cheque']);
                            }
                            if (array_key_exists('Voucher', $paymentArray)) {
                                $aggregate_online_voucher += to_currency_no_money($paymentArray['Voucher']);
                            }
                            if ((double) $anOrder->changeAmount < 0 && $anOrder->changeAsTips === '3') {
                                $aggregate_online_tips += to_currency_no_money(abs($anOrder->changeAmount));
                            } else {
                                $aggregate_online_paid_back += to_currency_no_money(abs($anOrder->changeAmount));
                            }
                        } else {
                            if ($anOrder->type === 'table') {
                                $aggregate_table += 1;
                                $aggregate_table_amount += to_currency_no_money($anOrder->grandTotal);
                                $orderInfo = unserialize($anOrder->orderInfo);
                                $aggregate_table_guest += $orderInfo['guestQty'];
                                if (array_key_exists('Cash', $paymentArray)) {
                                    $aggregate_table_cash += to_currency_no_money($paymentArray['Cash']);
                                }
                                if (array_key_exists('EFT', $paymentArray)) {
                                    $aggregate_table_eft += !empty($paymentArray['EFT']) ? to_currency_no_money($paymentArray['EFT']) : 0;
                                }
                                if (array_key_exists('Online', $paymentArray)) {
                                    $aggregate_table_web += !empty($paymentArray['Online']) ? to_currency_no_money($paymentArray['Online']) : 0;
                                }
                                if (array_key_exists('Cheque', $paymentArray)) {
                                    $aggregate_table_cheque += to_currency_no_money($paymentArray['Cheque']);
                                }
                                if (array_key_exists('Voucher', $paymentArray)) {
                                    $aggregate_table_voucher += to_currency_no_money($paymentArray['Voucher']);
                                }
                                if ((double) $anOrder->changeAmount < 0 && $anOrder->changeAsTips === '3') {
                                    $aggregate_table_tips += to_currency_no_money(abs($anOrder->changeAmount));
                                } else {
                                    $aggregate_table_paid_back += to_currency_no_money(abs($anOrder->changeAmount));
                                }
                            }
                            if ($anOrder->type === 'bar') {
                                $aggregate_bar += 1;
                                $aggregate_bar_amount += to_currency_no_money($anOrder->grandTotal);
                                if (array_key_exists('Cash', $paymentArray)) {
                                    $aggregate_bar_cash += to_currency_no_money($paymentArray['Cash']);
                                }
                                if (array_key_exists('EFT', $paymentArray)) {
                                    $aggregate_bar_eft += !empty($paymentArray['EFT']) ? to_currency_no_money($paymentArray['EFT']) : 0;
                                }
                                if (array_key_exists('Online', $paymentArray)) {
                                    $aggregate_bar_web += !empty($paymentArray['Online']) ? to_currency_no_money($paymentArray['Online']) : 0;
                                }
                                if (array_key_exists('Cheque', $paymentArray)) {
                                    $aggregate_bar_cheque += to_currency_no_money($paymentArray['Cheque']);
                                }
                                if (array_key_exists('Voucher', $paymentArray)) {
                                    $aggregate_bar_voucher += to_currency_no_money($paymentArray['Voucher']);
                                }
                                if ((double) $anOrder->changeAmount < 0 && $anOrder->changeAsTips === '3') {
                                    $aggregate_bar_tips += to_currency_no_money(abs($anOrder->changeAmount));
                                } else {
                                    $aggregate_bar_paid_back += to_currency_no_money(abs($anOrder->changeAmount));
                                }
                            }
                            if ($anOrder->type === 'waiting') {
                                $aggregate_waiting += 1;
                                $aggregate_waiting_amount += to_currency_no_money($anOrder->grandTotal);
                                if (array_key_exists('Cash', $paymentArray)) {
                                    $aggregate_waiting_cash += to_currency_no_money($paymentArray['Cash']);
                                }
                                if (array_key_exists('EFT', $paymentArray) || array_key_exists('Online', $paymentArray)) {
                                    $aggregate_waiting_eft += !empty($paymentArray['EFT']) ? to_currency_no_money($paymentArray['EFT']) : 0;
                                    $aggregate_waiting_eft += !empty($paymentArray['Online']) ? to_currency_no_money($paymentArray['Online']) : 0;
                                }
                                if (array_key_exists('Online', $paymentArray)) {
                                    $aggregate_waiting_web += !empty($paymentArray['Online']) ? to_currency_no_money($paymentArray['Online']) : 0;
                                }
                                if (array_key_exists('Cheque', $paymentArray)) {
                                    $aggregate_waiting_cheque += to_currency_no_money($paymentArray['Cheque']);
                                }
                                if (array_key_exists('Voucher', $paymentArray)) {
                                    $aggregate_waiting_voucher += to_currency_no_money($paymentArray['Voucher']);
                                }
                                if ((double) $anOrder->changeAmount < 0 && $anOrder->changeAsTips === '3') {
                                    $aggregate_waiting_tips += to_currency_no_money(abs($anOrder->changeAmount));
                                } else {
                                    $aggregate_waiting_paid_back += to_currency_no_money(abs($anOrder->changeAmount));
                                }
                            }
                            if ($anOrder->type === 'collection') {
                                $aggregate_collection += 1;
                                $aggregate_collection_amount += to_currency_no_money($anOrder->grandTotal);
                                if (array_key_exists('Cash', $paymentArray)) {
                                    $aggregate_collection_cash += to_currency_no_money($paymentArray['Cash']);
                                }
                                if (array_key_exists('EFT', $paymentArray)) {
                                    $aggregate_collection_eft += !empty($paymentArray['EFT']) ? to_currency_no_money($paymentArray['EFT']) : 0;
                                }
                                if (array_key_exists('Online', $paymentArray)) {
                                    $aggregate_collection_web += !empty($paymentArray['Online']) ? to_currency_no_money($paymentArray['Online']) : 0;
                                }
                                if (array_key_exists('Cheque', $paymentArray)) {
                                    $aggregate_collection_cheque += to_currency_no_money($paymentArray['Cheque']);
                                }
                                if (array_key_exists('Voucher', $paymentArray)) {
                                    $aggregate_collection_voucher += to_currency_no_money($paymentArray['Voucher']);
                                }
                                if ((double) $anOrder->changeAmount < 0 && $anOrder->changeAsTips === '3') {
                                    $aggregate_collection_tips += to_currency_no_money(abs($anOrder->changeAmount));
                                } else {
                                    $aggregate_collection_paid_back += to_currency_no_money(abs($anOrder->changeAmount));
                                }
                            }
                            if ($anOrder->type === 'delivery') {
                                $aggregate_delivery += 1;
                                $aggregate_delivery_amount += $anOrder->grandTotal;
                                if (array_key_exists('Cash', $paymentArray)) {
                                    $aggregate_delivery_cash += to_currency_no_money($paymentArray['Cash']);
                                }
                                if (array_key_exists('EFT', $paymentArray)) {
                                    $aggregate_delivery_eft += !empty($paymentArray['EFT']) ? to_currency_no_money($paymentArray['EFT']) : 0;
                                }
                                if (array_key_exists('Online', $paymentArray)) {
                                    $aggregate_delivery_web += !empty($paymentArray['Online']) ? to_currency_no_money($paymentArray['Online']) : 0;
                                }
                                if (array_key_exists('Cheque', $paymentArray)) {
                                    $aggregate_delivery_cheque += to_currency_no_money($paymentArray['Cheque']);
                                }
                                if (array_key_exists('Voucher', $paymentArray)) {
                                    $aggregate_delivery_voucher += to_currency_no_money($paymentArray['Voucher']);
                                }
                                if ((double) $anOrder->changeAmount < 0 && $anOrder->changeAsTips === '3') {
                                    $aggregate_delivery_tips += to_currency_no_money(abs($anOrder->changeAmount));
                                } else {
                                    $aggregate_delivery_paid_back += to_currency_no_money(abs($anOrder->changeAmount));
                                }
                            }
                        }
                        ?>
                        <tr>
                            <td class="text-left">&nbsp;<label><input type="checkbox" name="ids[]" class="is-order-checked" value="<?php echo $anOrder->sid ?>">&nbsp;<?php echo $anOrder->sid . '/' . $anOrder->orderId ?></label></td>
                            <td>
                                <?php $customerInfo = unserialize($anOrder->orderInfo) ?>
                                <?php echo $anOrder->type === 'table' ? 'Table-' . $customerInfo['tableNumber'] : ucfirst($customerInfo['name']) ?>
                            </td>
                            <td><?php echo $anOrder->source ?></td>
                            <td><?php echo ucfirst($anOrder->type) ?></td>
                            <td><?php echo date('d/m/Y', strtotime($anOrder->closingData)) ?></td>
                            <td>
                                <?php
                                $aggregateGrandTotal += to_currency_no_money($anOrder->grandTotal);
                                echo to_currency($anOrder->grandTotal);
                                ?>
                            </td>
                            <?php if (array_key_exists('Cash', $paymentArray)): ?>
                                <td>
                                    <?php
                                    $aggregatePaymentCashTotal += to_currency_no_money($paymentArray['Cash']);
                                    echo to_currency($paymentArray['Cash'])
                                    ?>
                                </td>
                            <?php else: ?>
                                <td><?php echo to_currency(0) ?></td>
                            <?php endif; ?>
                            <?php if (array_key_exists('EFT', $paymentArray)): ?>
                                <?php $aggregatePaymentEFTTotal += to_currency_no_money($paymentArray['EFT']) ?>
                                <td><?php echo to_currency($paymentArray['EFT']) ?></td>
                            <?php else: ?>
                                <td><?php echo to_currency(0) ?></td>
                            <?php endif; ?>

                            <?php if (array_key_exists('Online', $paymentArray)): ?>
                                <?php
                                $aggregatePaymentWebTotal += to_currency_no_money($paymentArray['Online']);
                                $onlinePaymentDetails = unserialize($anOrder->onlinePaymentDetails);
                                ?>
                                <td><?php echo to_currency($paymentArray['Online']) ?>&nbsp;<span class="icon icon-level-up" onclick="refundOnlinePayment('<?php echo $onlinePaymentDetails['reference_id'] ?>', '<?php echo $anOrder->sid ?>')"></span></td>
                            <?php else: ?>
                                <td><?php echo to_currency(0) ?></td>
                            <?php endif; ?>

                            <?php if (array_key_exists('Cheque', $paymentArray)): ?>
                                <?php $aggregatePaymentChequeTotal += to_currency_no_money($paymentArray['Cheque']) ?>
                                <td><?php echo to_currency($paymentArray['Cheque']) ?></td>
                            <?php else: ?>
                                <td><?php echo to_currency(0) ?></td>
                            <?php endif; ?>

                            <?php if (array_key_exists('Voucher', $paymentArray)): ?>
                                <?php $aggregatePaymentVoucherTotal += to_currency_no_money($paymentArray['Voucher']) ?>
                                <td><?php echo to_currency($paymentArray['Voucher']) ?></td>
                            <?php else: ?>
                                <td><?php echo to_currency(0) ?></td>
                            <?php endif; ?>
        <!--<td>-->
                            <?php
                            if ((double) $anOrder->changeAmount < 0) {
                                if ($anOrder->changeAsTips === '3') {
                                    if (array_key_exists('Cash', $paymentArray)) {
                                        $aggregateCashTipsTotal += to_currency_no_money(abs($anOrder->changeAmount));
                                        //echo to_currency(abs($anOrder->changeAmount));
                                    } else {
                                        //echo to_currency(0);
                                    }
                                } else {
                                    //echo to_currency(0);
                                }
                            } else {
                                //echo to_currency(0);
                            }
                            ?>
                            <!--</td>-->
                            <!--<td>--->
                            <?php
                            if ((double) $anOrder->changeAmount < 0) {
                                if ($anOrder->changeAsTips === '3') {
                                    if (!array_key_exists('Cash', $paymentArray)) {
                                        $aggregateCardTipsTotal += to_currency_no_money(abs($anOrder->changeAmount));
                                        //echo to_currency(abs($anOrder->changeAmount));
                                    } else {
                                        //echo to_currency(0);
                                    }
                                } else {
                                    //echo to_currency(0);
                                }
                            } else {
                                //echo to_currency(0);
                            }
                            ?>
                            <!--</td>-->
                            <!--<td>-->
                            <?php
                            if ((double) $anOrder->changeAmount < 0 && $anOrder->changeAsTips === '2') {
                                $aggregatePaidBackTotal += to_currency_no_money(abs($anOrder->changeAmount));
                                echo to_currency(abs($anOrder->changeAmount));
                            } else {
                                //echo to_currency(0);
                            }
                            ?>
                            <!--</td>-->
                            <!--<td>-->
                            <?php
                            $aggregateccFeeTotal += to_currency_no_money($anOrder->ccFee);
                            //echo to_currency($anOrder->ccFee);
                            ?>
                            <!--</td>-->
                            <!--<td>-->
                            <?php
                            $aggregatecbFeeTotal += to_currency_no_money($anOrder->cbFee);
                            //echo to_currency($anOrder->cbFee);
                            ?>
                            <!--</td>-->
                            <!--<td>--->
                            <?php
                            $itemDiscount = to_currency_no_money($anOrder->discount) + to_currency_no_money($anOrder->promo) + to_currency_no_money($anOrder->multiDiscount);
                            $aggregateDiscountTotal += $itemDiscount;
                            //echo to_currency($itemDiscount);
                            ?>
                            <!--</td>-->
                            <!--<td>-->
                            <?php
                            $aggregateServiceChargeTotal += to_currency_no_money($anOrder->serviceCharge);
                            //echo to_currency($anOrder->serviceCharge)
                            ?>
                            <!---</td>--->
                            <!--<td>--->
                            <?php
                            $aggregateTaxTotal += to_currency_no_money($anOrder->tax);
                            //echo to_currency($anOrder->tax)
                            ?>
                            <!--</td>-->
                            <td onclick="zamanOrderDetailPopupController('<?php echo $anOrder->sid ?>')" class="no-print" style="width: 60px; font-size: 20px;"><span class="icon icon-eye"></span></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="18"><?php echo sprintf($this->lang->line('not_found'), $this->lang->line('order')) ?></td>
                    </tr>
                <?php endif; ?>
                <tr class="table-bg">
                    <th>&nbsp;</th>
                    <th>&nbsp;</th>
                    <th>&nbsp;</th>
                    <th>&nbsp;</th>
                    <th><strong><?php echo $this->lang->line('all_total') ?></strong></th>
                    <th><strong><?php echo $this->lang->line('grand_total') ?><br/><span><?php echo to_currency($aggregateGrandTotal); ?></span></strong></th>
                    <th><strong><?php echo $this->lang->line('cash') ?><br/><span><?php echo to_currency($aggregatePaymentCashTotal); ?></span></strong></th>
                    <th><strong><?php echo $this->lang->line('eft') ?><br/><span><?php echo to_currency($aggregatePaymentEFTTotal); ?></span></strong></th>
                    <th><strong><?php echo $this->lang->line('online') ?><br/><span><?php echo to_currency($aggregatePaymentWebTotal); ?></span></strong></th>
                    <th><strong><?php echo $this->lang->line('cheque') ?><br/><span><?php echo to_currency($aggregatePaymentChequeTotal); ?></span></strong></th>
                    <th><strong><?php echo $this->lang->line('voucher') ?><br/><span><?php echo to_currency($aggregatePaymentVoucherTotal); ?></span></strong></th>
                    <!--<th><strong><?php echo $this->lang->line('cash_tips') ?><br/><span><?php echo to_currency($aggregateCashTipsTotal); ?></span></strong></th>
                    <th><strong><?php echo $this->lang->line('card_tips') ?><br/><span><?php echo to_currency($aggregateCardTipsTotal); ?></span></strong></th>
                    <th><strong><?php echo $this->lang->line('paid_back') ?><br/><span><?php echo to_currency($aggregatePaidBackTotal); ?></span></strong></th>
                    <th><strong><?php echo $this->lang->line('ccFee') ?><br/><span><?php echo to_currency($aggregateccFeeTotal); ?></span></strong></th>
                    <th><strong><?php echo $this->lang->line('cbFee') ?><br/><span><?php echo to_currency($aggregatecbFeeTotal); ?></span></strong></th>
                    <th><strong>Disc<br/><?php echo to_currency($aggregateDiscountTotal) ?></strong></th>
                    <th><strong><?php echo $this->lang->line('ser_ch') ?><br/><?php echo to_currency($aggregateServiceChargeTotal) ?></strong></th>
                    <th><strong> <?php echo $this->lang->line('tax') ?><br/><?php echo to_currency($aggregateTaxTotal); ?></strong></th>-->
                    <th>&nbsp;</th>
                </tr>
                <tr>
                    <td colspan="12" style="border: none">
                        <div class="tab-group">
                            <div class="tab-item" style="padding: 10px;" onclick="zamanEposBlockHideAndShow('reportBusinessTotal')">Business Summary</div>
                            <div class="tab-item" style="padding: 10px;" onclick="zamanEposBlockHideAndShow('accountSummary')">Account Summary</div>
                        </div>
                        <table class="text-center" id="reportBusinessTotal" style="display: none;">
                            <tr class="table-bg">
                                <th><?php echo $this->lang->line('type') ?></th>
                                <th><?php echo $this->lang->line('served') ?></th>
                                <th><?php echo $this->lang->line('guest') ?></th>
                                <th><?php echo $this->lang->line('business') ?></th>
                                <th><?php echo $this->lang->line('cash') ?></th>
                                <th><?php echo $this->lang->line('eft') ?></th>
                                <th><?php echo $this->lang->line('online') ?></th>
                                <th><?php echo $this->lang->line('cheque') ?></th>
                                <th><?php echo $this->lang->line('voucher') ?></th>
                                <!--<th><?php echo $this->lang->line('tips') ?></th>
                                <th><?php echo $this->lang->line('paid_back') ?></th>-->
                            </tr>
                            <tr>
                                <td><strong><?php echo $this->lang->line('table') ?></strong></td>
                                <td><?php echo $aggregate_table ?></td>
                                <td><?php echo $aggregate_table_guest ?></td>
                                <td><?php echo to_currency($aggregate_table_amount) ?></td>
                                <td><?php echo to_currency($aggregate_table_cash) ?></td>
                                <td><?php echo to_currency($aggregate_table_eft) ?></td>
                                <td><?php echo to_currency($aggregate_table_web) ?></td>
                                <td><?php echo to_currency($aggregate_table_cheque) ?></td>
                                <td><?php echo to_currency($aggregate_table_voucher) ?></td>
                                <!--<td><?php //echo to_currency($aggregate_table_tips)                                          ?></td>
                                <td><?php //echo to_currency($aggregate_table_paid_back)                                          ?></td>-->
                            </tr>
                            <tr>
                                <td><strong><?php echo $this->lang->line('waiting') ?></strong></td>
                                <td><?php echo $aggregate_waiting ?></td>
                                <td><?php echo $aggregate_waiting_guest ?></td>
                                <td><?php echo to_currency($aggregate_waiting_amount) ?></td>
                                <td><?php echo to_currency($aggregate_waiting_cash) ?></td>
                                <td><?php echo to_currency($aggregate_waiting_eft) ?></td>
                                <td><?php echo to_currency($aggregate_waiting_web) ?></td>
                                <td><?php echo to_currency($aggregate_waiting_cheque) ?></td>
                                <td><?php echo to_currency($aggregate_waiting_voucher) ?></td>
                                <!--<td><?php echo to_currency($aggregate_waiting_tips) ?></td>
                                <td><?php echo to_currency($aggregate_waiting_paid_back) ?></td>-->
                            </tr>
                            <tr>
                                <td><strong><?php echo $this->lang->line('bar') ?></strong></td>
                                <td><?php echo $aggregate_bar ?></td>
                                <td><?php echo $aggregate_bar_guest ?></td>
                                <td><?php echo to_currency($aggregate_bar_amount) ?></td>
                                <td><?php echo to_currency($aggregate_bar_cash) ?></td>
                                <td><?php echo to_currency($aggregate_bar_eft) ?></td>
                                <td><?php echo to_currency($aggregate_bar_web) ?></td>
                                <td><?php echo to_currency($aggregate_bar_cheque) ?></td>
                                <td><?php echo to_currency($aggregate_bar_voucher) ?></td>
                                <!--<td><?php echo to_currency($aggregate_bar_tips) ?></td>
                                <td><?php echo to_currency($aggregate_bar_paid_back) ?></td>-->
                            </tr>
                            <tr>
                                <td><strong><?php echo $this->lang->line('collection') ?></strong></td>
                                <td><?php echo $aggregate_collection ?></td>
                                <td><?php echo $aggregate_collection_guest ?></td>
                                <td><?php echo to_currency($aggregate_collection_amount) ?></td>
                                <td><?php echo to_currency($aggregate_collection_cash) ?></td>
                                <td><?php echo to_currency($aggregate_collection_eft) ?></td>
                                <td><?php echo to_currency($aggregate_collection_web) ?></td>
                                <td><?php echo to_currency($aggregate_collection_cheque) ?></td>
                                <td><?php echo to_currency($aggregate_collection_voucher) ?></td>
                                <!--<td><?php echo to_currency($aggregate_collection_tips) ?></td>
                                <td><?php echo to_currency($aggregate_collection_paid_back) ?></td>-->
                            </tr>
                            <tr>
                                <td><strong><?php echo $this->lang->line('delivery') ?></strong></td>
                                <td><?php echo $aggregate_delivery ?></td>
                                <td><?php echo $aggregate_delivery_guest ?></td>
                                <td><?php echo to_currency($aggregate_delivery_amount) ?></td>
                                <td><?php echo to_currency($aggregate_delivery_cash) ?></td>
                                <td><?php echo to_currency($aggregate_delivery_eft) ?></td>
                                <td><?php echo to_currency($aggregate_delivery_web) ?></td>
                                <td><?php echo to_currency($aggregate_delivery_cheque) ?></td>
                                <td><?php echo to_currency($aggregate_delivery_voucher) ?></td>
                                <!--<td><?php echo to_currency($aggregate_delivery_tips) ?></td>
                                <td><?php echo to_currency($aggregate_delivery_paid_back) ?></td>-->
                            </tr>
                            <tr>
                                <td><strong><?php echo $this->lang->line('online') ?></strong></td>
                                <td><?php echo $aggregate_online ?></td>
                                <td><?php echo $aggregate_online_guest ?></td>
                                <td><?php echo to_currency($aggregate_online_amount) ?></td>
                                <td><?php echo to_currency($aggregate_online_cash) ?></td>
                                <td><?php echo to_currency($aggregate_online_eft) ?></td>
                                <td><?php echo to_currency($aggregate_online_web) ?></td>
                                <td><?php echo to_currency($aggregate_online_cheque) ?></td>
                                <td><?php echo to_currency($aggregate_online_voucher) ?></td>
                                <!--<td><?php echo to_currency($aggregate_online_tips) ?></td>
                                <td><?php echo to_currency($aggregate_online_paid_back) ?></td>-->
                            </tr>
                            <tr class="table-bg">
                                <td style="color: #eee;border-bottom: 3px double;"><strong>Aggregated</strong></td>
                                <td style="color: #eee;border-bottom: 3px double;"><strong><?php echo $aggregate_online + $aggregate_table + $aggregate_waiting + $aggregate_bar + $aggregate_collection + $aggregate_delivery ?></strong></td>
                                <td style="color: #eee;border-bottom: 3px double;"><strong><?php echo $aggregate_online_guest + $aggregate_table_guest + $aggregate_waiting_guest + $aggregate_bar_guest + $aggregate_collection_guest + $aggregate_delivery_guest ?></strong></td>
                                <td style="color: #eee;border-bottom: 3px double;"><strong>
                                        <?php
                                        $aggregatedBusinessDone = $aggregate_online_amount + $aggregate_table_amount + $aggregate_waiting_amount + $aggregate_bar_amount + $aggregate_collection_amount + $aggregate_delivery_amount;
                                        echo to_currency($aggregatedBusinessDone)
                                        ?>
                                    </strong>
                                </td>
                                <td style="color: #eee;border-bottom: 3px double;"><strong>
                                        <?php
                                        $aggregatedCashEarned = $aggregate_online_cash + $aggregate_table_cash + $aggregate_waiting_cash + $aggregate_bar_cash + $aggregate_collection_cash + $aggregate_delivery_cash;
                                        echo to_currency($aggregatedCashEarned)
                                        ?>
                                    </strong>
                                </td>
                                <td style="color: #eee;border-bottom: 3px double;"><strong>
                                        <?php
                                        $aggregatedEFTEarned = $aggregate_online_eft + $aggregate_table_eft + $aggregate_waiting_eft + $aggregate_bar_eft + $aggregate_collection_eft + $aggregate_delivery_eft;
                                        echo to_currency($aggregatedEFTEarned)
                                        ?>
                                    </strong>
                                </td>
                                <td style="color: #eee;border-bottom: 3px double;"><strong>
                                        <?php
                                        $aggregatedWebEarned = $aggregate_online_web + $aggregate_table_web + $aggregate_waiting_web + $aggregate_bar_web + $aggregate_collection_web + $aggregate_delivery_web;
                                        echo to_currency($aggregatedWebEarned)
                                        ?>
                                    </strong>
                                </td>
                                <td style="color: #eee;border-bottom: 3px double;"><strong>
                                        <?php
                                        $aggregatedChequeEarned = $aggregate_online_cheque + $aggregate_table_cheque + $aggregate_waiting_cheque + $aggregate_bar_cheque + $aggregate_collection_cheque + $aggregate_delivery_cheque;
                                        echo to_currency($aggregatedChequeEarned);
                                        ?>
                                    </strong>
                                </td>
                                <td style="color: #eee;border-bottom: 3px double;"><strong>
                                        <?php
                                        $aggregatedVoucherDisposed = $aggregate_online_voucher + $aggregate_table_voucher + $aggregate_waiting_voucher + $aggregate_bar_voucher + $aggregate_collection_voucher + $aggregate_delivery_voucher;
                                        echo to_currency($aggregatedVoucherDisposed)
                                        ?>
                                    </strong>
                                </td>
                                <!--<td style="color: #eee;border-bottom: 3px double;"><strong>
                                <?php echo to_currency($aggregate_online_tips + $aggregate_table_tips + $aggregate_waiting_tips + $aggregate_bar_tips + $aggregate_collection_tips + $aggregate_delivery_tips) ?>
                                    </strong>
                                </td>-->
                                <!--<td style="color: #eee;border-bottom: 3px double;"><strong>-->
                                <?php
                                $aggregatedCashOut = $aggregate_online_paid_back + $aggregate_table_paid_back + $aggregate_waiting_paid_back + $aggregate_bar_paid_back + $aggregate_collection_paid_back + $aggregate_delivery_paid_back;
                                //echo to_currency($aggregatedCashOut)
                                ?>
                                <!--</strong>-->
                                <!--</td>-->
                            </tr>
                            <tr><td colspan="9" class="collection-bg" style="padding: 7px; border-radius: 0px 0px 50px 50px; color: #fff;" onclick="printSelectedArea('reportBusinessTotal')">Print Business Summary</td></tr>
                        </table>
                    </td>
                </tr>
                <tr style=" display: none;" id="accountSummary">
                    <td colspan="20" style="border: none;">
                        <table class="text-center" style="margin-top: -10px;">
                            <tr>
                                <td style="width: 33%; border: none">&nbsp;</td>
                                <td style="width: 34%; border: none;" id="reportAccountSummary">
                                    <table class="text-center" style="width: 80mm; margin: 0 auto; padding: 0px;">
                                        <tr><td colspan="2"><div class="collection-bg" style="width: 80mm;margin: 0 auto; color: #fff; padding: 5px; font-size: 1.5em; border-radius: 50px 50px 0px 0px;"  onclick="zamanEposBlockHideAndShow('accountSummary')"><?php echo $this->lang->line('account_summary') ?></div></td></tr>
                                        <tr>
                                            <td style="text-align: right;padding-right: 5mm;"><?php echo $this->lang->line('cash') ?></td>
                                            <td style="text-align: right;padding-right: 5mm;"><?php echo to_currency($aggregatedCashEarned - ($aggregateCashTipsTotal + $aggregatePaidBackTotal)) ?></td>
                                        </tr>
                                        <tr>
                                            <td style="text-align: right;padding-right: 5mm;"><?php echo $this->lang->line('eft') ?></td>
                                            <td style="text-align: right; padding-right: 5mm;"><?php echo to_currency($aggregatedEFTEarned - $aggregateCardTipsTotal) ?></td>
                                        </tr>
                                        <tr>
                                            <td style="text-align: right;padding-right: 5mm;"><?php echo $this->lang->line('online') ?></td>
                                            <td style="text-align: right; padding-right: 5mm;"><?php echo to_currency($aggregatedWebEarned) ?></td>
                                        </tr>
                                        <tr>
                                            <td style="text-align: right;padding-right: 5mm;"><?php echo $this->lang->line('cheque') ?></td>
                                            <td style="text-align: right; padding-right: 5mm;"><?php echo to_currency($aggregatedChequeEarned); ?></td>
                                        </tr>
                                        <tr>
                                            <td style="text-align: right;padding-right: 5mm;"><?php echo $this->lang->line('voucher') ?></td>
                                            <td style="text-align: right; padding-right: 5mm;"><?php echo to_currency($aggregatedVoucherDisposed) ?></td>
                                        </tr>
                                        <tr>
                                            <td style="font-size: 1.2em;text-align: right;padding-right: 5mm; border-bottom: 2px solid #000;"><?php echo $this->lang->line('total_e_fund') ?></td>
                                            <td style="font-size: 1.2em;text-align: right;padding-right: 5mm; border-bottom: 2px solid #000;"><?php echo to_currency(($aggregatedEFTEarned + $aggregatedChequeEarned + $aggregatedVoucherDisposed + $aggregatedWebEarned) - $aggregateCardTipsTotal); ?></td>
                                        </tr>
                                        <tr>
                                            <td style="width: 50%; font-size: 1.2em; text-align: right; padding-right: 5mm; "><strong><?php echo $this->lang->line('sale') . ' ' . $this->lang->line('total') ?></strong></td>
                                            <td style="width: 50%; font-size: 1.2em; text-align: right; padding-right: 5mm; "><strong><?php echo to_currency($aggregatedBusinessDone) ?></strong></td>
                                        </tr>
                                        <?php $otherSourceIncomeTotal = 0; ?>
                                        <?php $otherSourceIncomeTotalArray = array(); ?>
                                        <?php if (!empty($incomeData)): ?>
                                            <?php foreach ($incomeData as $source => $income): ?>
                                                <?php $otherSourceIncomeTotal += $income; ?>
                                                <?php $incomeLedgerTitle = get_title('incomeledger', array('id' => $source)); ?>
                                                <?php $otherSourceIncomeTotalArray[str_replace(' ', '_', $incomeLedgerTitle)] = $income; ?>
                                                <tr>
                                                    <td style="font-size: 1.2em;text-align: right;padding-right: 5mm;"><?php echo $incomeLedgerTitle; ?></td>
                                                    <td style="font-size: 1.2em;text-align: right;padding-right: 5mm;"><?php echo to_currency($income); ?></td>
                                                </tr>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                        <tr>
                                            <td style="text-align: right;padding-right: 5mm;"><?php echo $this->lang->line('cash_tips') ?></td>
                                            <td style="text-align: right;padding-right: 5mm;"><?php echo to_currency($aggregateCashTipsTotal); ?></td>
                                        </tr>
                                        <tr>
                                            <td style="text-align: right;padding-right: 5mm;  border-bottom: 2px solid #000;"><?php echo $this->lang->line('card_tips') ?></td>
                                            <td style="text-align: right;padding-right: 5mm;  border-bottom: 2px solid #000;"><?php echo to_currency($aggregateCardTipsTotal); ?></td>
                                        </tr>

                                        <tr>
                                            <td style="font-size: 1.2em;text-align: right;padding-right: 5mm;"><strong><?php echo $this->lang->line('total') ?></strong></td>
                                            <td style="font-size: 1.2em;text-align: right;padding-right: 5mm;"><strong><?php echo to_currency($aggregatedBusinessDone + $aggregateCardTipsTotal + $aggregateCashTipsTotal + $otherSourceIncomeTotal); ?></strong></td>
                                        </tr>
                                        <tr>
                                            <td style="text-align: right; padding-right: 5mm; border-bottom: 2px solid #000;" ><strong><?php echo $this->lang->line('cash_expense') ?></strong></td>
                                            <td style="text-align: right;padding-right: 5mm; border-bottom: 2px solid #000;"><strong><?php echo to_currency($expenseFromTill) ?> </strong></td>
                                        </tr>
                                        <tr>
                                            <?php $totalCashFund = $aggregatedCashEarned - $aggregatedCashOut; ?>
                                            <td style="font-size: 1.2em; text-align: left;padding-left: 5mm;" class="text-capitalize"><strong><?php echo $this->lang->line('cash_in_the_till') ?></strong></td>
                                            <td style="font-size: 1.2em;text-align: right;padding-right: 5mm;"><strong><?php echo to_currency($totalCashFund - $expenseFromTill); ?></strong></td>
                                        </tr>
                                        <tr><td colspan="2"> <div class="tab-item" onclick="printTransactionSummary()"><span class="icon icon-print"></span>&nbsp;<?php echo $this->lang->line('print') ?></div></td></tr>
                                    </table>
                                </td>
                                <td style="width: 33%; border: none">&nbsp;</td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
</div>
<?php
$transactionData = array(
    'cash' => to_currency_no_money($aggregatedCashEarned - ($aggregateCashTipsTotal + $aggregatePaidBackTotal)),
    'eft' => to_currency_no_money($aggregatedEFTEarned - $aggregateCardTipsTotal),
    'online' => to_currency_no_money($aggregatedWebEarned),
    'cheque' => to_currency_no_money($aggregatedChequeEarned),
    'voucher' => to_currency_no_money($aggregatedVoucherDisposed),
    'eFund' => to_currency_no_money(($aggregatedEFTEarned + $aggregatedChequeEarned + $aggregatedVoucherDisposed + $aggregatedWebEarned) - $aggregateCardTipsTotal),
    'saleTotal' => to_currency_no_money($aggregatedBusinessDone),
    'otherSourceOfIncome' => $otherSourceIncomeTotalArray,
    'CashTips' => to_currency_no_money($aggregateCashTipsTotal),
    'cardTips' => to_currency_no_money($aggregateCardTipsTotal),
    'total' => to_currency_no_money($aggregatedBusinessDone + $aggregateCashTipsTotal + $aggregateCardTipsTotal + $otherSourceIncomeTotal),
    'cashExpense' => to_currency_no_money($expenseFromTill > 0 ? $expenseFromTill : 0),
    'cashInTheTill' => to_currency_no_money($totalCashFund - $expenseFromTill),
    'statementDateFrom' => $statementDateFrom,
    'statementDateTo' => $statementDateTo,
);
//debugPrint($transactionData);
?>
<?php $this->load->view('order') ?>
<?php $this->load->view('settings/partials/footer') ?>
<script type="text/javascript">
    $('document').ready(function () {
        if ($('#reportDateFrom').val() === 'verified') {
            $('#reportDateFrom').val('');
        }
        $('#reportDateFrom').datetimepicker({
            timepicker: false,
            format: 'd-m-Y',
            maxDate: '<?php echo date('d/m/Y', strtotime('today')) ?>',
            formatDate: 'Y/m/d'
        });
        $('#reportDateTo').datetimepicker({
            timepicker: false,
            format: 'd-m-Y',
            maxDate: '<?php echo date('d/m/Y', strtotime('today')) ?>',
            formatDate: 'Y/m/d'
        });
    });
    function filterReport() {
        if (!$('.page-loader').is(":visible")) {
            var reportDateFrom = $.trim($('#reportDateFrom').val()) ? $('#reportDateFrom').val() : 0;
            var reportDateTo = $.trim($('#reportDateTo').val()) ? $('#reportDateTo').val() : 0;
            var reportReference = $.trim($('#reportReference').val()) ? $('#reportReference').val() : 0;
            var reportOrderSource = $.trim($('#reportOrderSource').val()) ? $('#reportOrderSource').val() : 0;
            var reportOrderType = $.trim($('#reportOrderType').val()) ? $('#reportOrderType').val() : 0;
            var reportOrderPayment = $.trim($('#reportOrderPayment').val()) ? $('#reportOrderPayment').val() : 0;
            var reportBranch = $.trim($('#reportBranch').val()) ? $('#reportBranch').val() : 0;

            var splited = [];
            if (reportReference !== 0) {
                splited = reportReference.split('/');
                reportReference = splited[0] + '-' + splited[1];
            }
            zamanEposNavigator('reportIndex', '<?php echo site_url('report/index/') ?>' + reportDateFrom + '/' + reportDateTo + '/' + reportReference + '/' + reportOrderSource + '/' + reportOrderType + '/' + reportOrderPayment + '/' + reportBranch, 'reportIndex');
        }
    }
    function printBill(id) {
        if (!$('.page-loader').is(":visible")) {
            var DetailedorderId = $('#detailedOrderId').val();
            var sid = Number(id) > 0 ? Number(id) : Number(DetailedorderId);
            $.ajax({
                url: '<?php echo site_url('api/printer') ?>',
                data: {
                    sid: sid,
                    type: 4
                },
                type: 'POST',
                dataType: 'json',
                beforeSend: function () {
                    $('.page-loader').show();
                },
                success: function (response) {
                    $('.page-loader').hide();
                    if (response.status) {
                        zamanEposPopupcloser();
                    } else {
                        warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                    }
                }
            });
        }
    }
    function deleteOrder(id) {
        if (!$('.page-loader').is(":visible")) {
            var DetailedorderId = $('#detailedOrderId').val();
            var sid = Number(id) > 0 ? Number(id) : Number(DetailedorderId);
            if (checkInternetConnection()) {
                $.confirm({
                    title: '<?php echo $this->lang->line('warning') ?>',
                    message: '<?php echo $this->lang->line('delete_order_msg') ?>',
                    buttons: {
                        '<?php echo $this->lang->line('yes') ?>': {
                            'class': 'primary',
                            'action': function () {
                                $.ajax({
                                    url: '<?php echo site_url('report/deleteOrder/') ?>' + sid,
                                    type: 'Get',
                                    dataType: 'json',
                                    beforeSend: function () {
                                        $('.page-loader').show();
                                    },
                                    success: function (response) {
                                        $('.page-loader').hide();
                                        if (response.status) {
                                            zamanEposPopupcloser();
                                            zamanEposNavigator('reportIndex', '<?php echo $refresh ?>', 'reportIndex');
                                        } else {
                                            warning('<?php echo $this->lang->line('error') ?>', 'Deleting order failed! Please try again', '<?php echo $this->lang->line('close') ?>');
                                        }
                                    }
                                });
                            }
                        },
                        '<?php echo $this->lang->line('no') ?>': {
                            'class': 'positive',
                            'action': function () {}
                        }
                    }
                });

            } else {
                warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
            }
        }
    }
    function printSelectedArea(div) {
        var filterStartDate = $("#reportDateFrom").val();
        var filterEndDate = $("#reportDateTo").val();
        if (!$.trim(filterStartDate)) {
            var dateObj = new Date();
            filterStartDate = dateObj.getDate() + '-' + (Number(dateObj.getMonth()) + 1) + '-' + dateObj.getFullYear();
        }
        if (!$.trim(filterEndDate)) {
            var dateObj = new Date();
            filterEndDate = dateObj.getDate() + '-' + (Number(dateObj.getMonth()) + 1) + '-' + dateObj.getFullYear();
        }
        var header = '<div>';
        header = "<p style='text-align:center; font-weight:bold; text-transform:uppercase; text-decoration:underline;font-size:2.5em;'><?php echo $this->config->item('general_name') ?></p>"
        header += "<p style='text-align:center; line-height:10px; margin:0 auto; padding:0px; font-weight:bold; font-size:1.5em; text-transform:uppercase;'>" + filterStartDate + " To " + filterEndDate + "</p>";
        header += '</div>';
        $("#" + div).printThis({
            header: header
        });
    }
    function refundOnlinePayment(charge, sid) {
        $.confirm({
            title: 'Refund Warning',
            message: 'Are you sure that you want to refund the amount',
            buttons: {
                'Yes': {
                    'class': 'positive',
                    'action': function () {
                        $.ajax({
                            url: '<?php echo site_url('report/refund') ?>',
                            type: 'POST',
                            dataType: 'json',
                            data: {'charge': charge, 'sid': sid},
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                $('.page-loader').hide();
                                if (response.status) {
                                    zamanEposNavigator('reportIndex', '<?php echo $refresh ?>', 'reportIndex');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('close') ?>')
                                }
                            }
                        });
                    }
                },
                'No': {
                    'class': 'negative',
                    'action': function () {}
                }
            }
        });
    }
    function printTransactionSummary() {
        var jsonString = '<?php echo json_encode($transactionData) ?>';
        var jsonData = JSON.parse(jsonString);
        if (Number(jsonData.total) > 0) {
            $.ajax({
                url: '<?php echo site_url('report/printTransaction/') ?>',
                type: 'POST',
                dataType: 'json',
                data: {
                    json: jsonData
                },
                beforeSend: function () {
                    $('.page-loader').show();
                },
                success: function (response) {
                    if (response.status) {
                        $('.page-loader').hide();
                    } else {
                        $('.page-loader').hide();
                        warning('<?php echo $this->lang->line('warning') ?>', 'Printing failed, please try again', '<?php echo $this->lang->line('close') ?>');
                    }

                }
            });
        } else {
            warning('<?php echo $this->lang->line('warning') ?>', '<?php echo $this->lang->line('empty_report_nothing_to_print') ?>', '<?php echo $this->lang->line('ok') ?>');
        }

    }
    function getDeletedOrderList() {
        var arr = [];
        $('input.is-order-checked:checkbox:checked').each(function () {
            arr.push($(this).val());
        });
        if (arr.length > 0) {
            $.ajax({
                url: '<?php echo site_url('report/reportBulkDelete') ?>',
                type: 'POST',
                dataType: 'json',
                data: {
                    ids: arr
                },
                beforeSend: function () {
                    $('.page-loader').show();
                },
                success: function (response) {
                    $('.page-loader').hide();
                    filterReport();
                }
            });
        } else {
            warning('No Orders', 'No orders checked,Please check the orders first to be deleted', 'Ok');
        }
    }
</script>