<?php

class Report_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function getReportData($dateFrom, $dateTo, $id, $source, $type, $branch) {
        $this->db->where('branch', $branch);
        if ($this->session->userdata('group') >= 6) {
            $this->db->where('owner', $this->session->userdata('owner'));
        }
        if ($this->session->userdata('group') == 5) {
            $this->db->where('team', $this->session->userdata('team'));
        }
        $this->db->where('isPaid', 3);
        $this->db->where('closingData  BETWEEN ' . $this->db->escape($dateFrom) . ' AND ' . $this->db->escape($dateTo));
        if ($id) {
            $idArr = explode('-', $id);
            $this->db->where('sid', (int) $idArr[0]);
            $this->db->where('orderId', $idArr[1]);
        }
        if ($source) {
            $this->db->where('source', $source);
        }
        if ($type) {
            $this->db->where('type', $type);
        }
        return $this->db->get('order');
    }

    public function getOnlineReportData($dateFrom, $dateTo, $id, $source, $type, $branch) {
        $this->db->where('branch', $branch);
        $this->db->where('closingData  BETWEEN ' . $this->db->escape($dateFrom) . ' AND ' . $this->db->escape($dateTo));
        if ($id) {
            $idArr = explode('-', $id);
            $this->db->where('sid', (int) $idArr[0]);
            $this->db->where('orderId', $idArr[1]);
        }
        if ($source) {
            $this->db->where('source', $source);
        }
        if ($type) {
            $this->db->where('type', $type);
        }
        return $this->db->get('order');
    }

    function deleteOrder($order_id) {
        $this->db->trans_start();
        //delete Order Row
        $this->db->delete('order', array('sid' => $order_id));
        //delete Printer Row
        $this->db->delete('printing', array('sid' => $order_id));
        $this->db->trans_complete();
        return $this->db->trans_status();
    }

    public function saveExpense($data, $id = NULL) {
        $this->_table_name = 'expense';
        $this->_primary_key = 'id';
        $data['date'] = date('Y-m-d');
        if ($id !== NULL && $id > 0) {
            $data['updated_by'] = 1;
        }
        return parent::save($data, $id);
    }

    public function saveIncome($data, $id = NULL) {
        $this->_table_name = 'income';
        $this->_primary_key = 'id';
        $data['date'] = date('Y-m-d');
        if ($id !== NULL && $id > 0) {
            $data['updated_by'] = 1;
        }
        return parent::save($data, $id);
    }

    function saveExpenseLedger($data, $id = null) {
        $this->_table_name = 'expenseledger';
        $this->_primary_key = 'id';
        return parent::save($data, $id);
    }

    function saveIncomeLedger($data, $id = null) {
        $this->_table_name = 'incomeledger';
        $this->_primary_key = 'id';
        return parent::save($data, $id);
    }

    public function getExpenseData($dateFrom, $dateTo) {
        $this->db->where('date  BETWEEN ' . $this->db->escape($dateFrom) . ' AND ' . $this->db->escape($dateTo));
        $this->db->where('branch', $this->session->userdata('branch'));
        return $this->db->get('expense');
    }

    public function getIncomeData($dateFrom, $dateTo) {
        $this->db->where('date  BETWEEN ' . $this->db->escape($dateFrom) . ' AND ' . $this->db->escape($dateTo));
        $this->db->where('branch', $this->session->userdata('branch'));
        return $this->db->get('income');
    }

    public function getIncomeDataInReport($dateFrom, $dateTo) {
        $this->db->where('date  BETWEEN ' . $this->db->escape($dateFrom) . ' AND ' . $this->db->escape($dateTo));
        $this->db->where('branch', $this->session->userdata('branch'));
        $result = $this->db->get('income')->result();
        $returnIncome = array();
        if (!empty($result)) {
            foreach ($result as $income) {
                if (array_key_exists($income->ledger, $returnIncome)) {
                    $returnIncome[$income->ledger] += $income->expenseAmount;
                } else {
                    $returnIncome[$income->ledger] = $income->expenseAmount;
                }
            }
        }
        return $returnIncome;
    }

    public function getExpenseTotal($dateFrom, $dateTo) {
        $this->db->select_sum('expenseAmount');
        $this->db->where('date  BETWEEN ' . $this->db->escape($dateFrom) . ' AND ' . $this->db->escape($dateTo));
        $this->db->where('withdrawnFromTill', 'yes');
        $this->db->where('withdrawnType', 'Cash');
        $this->db->where('branch', $this->session->userdata('branch'));
        if ($this->session->userdata('group') >= 5) {
            $this->db->where('tillTeam', $this->session->userdata('team'));
        }
        return $this->db->get('expense')->row()->expenseAmount;
    }

    public function checkledger($column, $value) {
        return $this->db->where(array($column => $value, 'branch' => $this->session->userdata('branch')))->count_all_results('expenseledger') > 0;
    }

    public function checkIncomeledger($column, $value) {
        return $this->db->where(array($column => $value, 'branch' => $this->session->userdata('branch')))->count_all_results('incomeledger') > 0;
    }

    public function get_booking($dateFrom, $dateTo, $branch,$type) {
        if($type==='created'){
            $this->db->where('created_at BETWEEN ' . $this->db->escape($dateFrom.' 00:00:00') . ' AND ' . $this->db->escape($dateTo.' 23:59:59'));
            $this->db->where('status', 2);
        }else{
           $this->db->where('date BETWEEN ' . $this->db->escape($dateFrom) . ' AND ' . $this->db->escape($dateTo));  
        }
       
        $this->db->where('branch', $branch);
        $this->db->order_by('date', 'DESC');
        return $this->db->get('booking');
    }

}
