<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane">
            <div class="content-inner">
                <div class="content-form" style="width: 80%; float: left; background: #087692; padding: 20px;">
                    <div class="block">
                        <?php echo form_open('page/save', array('id' => 'pageForm', 'enctype' => 'multipart/form-data')); ?>
                        <input type="hidden" name="id" value="<?php echo $page['id'] ?>">
                        <div class="block-inner">
                            <div class="form-group">
                                <label class="text-capitalize"><?php echo $this->lang->line('page') . ' ' . $this->lang->line('title') ?></label>
                                <input name="title" value="<?php echo $page['title'] ?>" class="form-control">
                            </div>
                            <div class="form-group">
                                <label><?php echo $this->lang->line('description') ?></label>
                                <textarea name="content" class="form-control"><?php echo $page['content'] ?></textarea>
                            </div>
                            <div class="form-group">
                                <label><?php echo $this->lang->line('meta_keywords') ?></label>
                                <textarea name="meta_keys" class="form-control"><?php echo $page['meta_keys'] ?></textarea>
                            </div>
                            <div class="form-group">
                                <label><?php echo $this->lang->line('meta_description') ?></label>
                                <textarea name="meta_desc" class="form-control"><?php echo $page['meta_desc'] ?></textarea>
                            </div>
                            <div class="form-group ">
                                <label class="text-capitalize"><?php echo $this->lang->line('page') . ' ' . $this->lang->line('image') ?></label>
                                <input type="file" name="image" class="form-control">
                            </div>
                            <div class="tab-group config-submit">
                                <button type="submit" onclick="savePage('pageForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
                            </div>
                            <?php echo form_close() ?>
                            <div class="form-group ">
                                <div class="block thumbnail" style="background: none;">
                                    <?php if (trim($page['image'])): ?>
                                        <img src="<?php echo EPOS_UPLOAD_PATH . 'page/' . $page['image'] ?>" alt="Image" style="width: 100%;">
                                        <div><span class="icon icon-trash text-right clearfix" onclick="removePageImage('image', '<?php echo $page['image'] ?>', 'page', './uploads/page/', '<?php echo site_url('page/removePageImage/' . $page['id']) ?>')">&nbsp;<?php echo $this->lang->line('remove') ?></span></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="content-sidebar-nav" style="width: 20%; float: right;">
                    <?php $this->load->view('page/page_nav')?>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="setting-general-keyboard text-center"></div>
<?php $this->load->view('settings/partials/footer') ?>
<script type="text/javascript">
    function savePage(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                if (response.status) {
                                    $('.page-loader').hide();
                                    warning('<?php echo $this->lang->line('success') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                    zamanEposNavigator('page', '<?php echo site_url('page/index/' . $page['id']) ?>', 'page');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                }
                            }
                        });
                    }
                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                rules: {
                    title: {required: true},
                    meta_keys: {required: true},
                    meta_desc: {required: true}
                },
                messages: {
                    title: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('page') . ' ' . $this->lang->line('title')) ?>',
                    meta_keys: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('meta_keywords')) ?>',
                    meta_desc: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('meta_description')) ?>'
                },
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
    function removePageImage(dbkey, dbimage, dbtable, path, url) {
        if (!$('.page-loader').is(":visible")) {
            if (checkInternetConnection()) {
                $.ajax({
                    url: url,
                    data: {dbkey: dbkey, image: dbimage, dbtable: dbtable, path: path},
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function () {
                        $('.page-loader').show();
                    },
                    success: function (response) {
                        if (response.status) {
                            $('.page-loader').hide();
                            warning('<?php echo $this->lang->line('success') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                            zamanEposNavigator('page', '<?php echo site_url('page/index/' . $page['id']) ?>', 'page');
                        } else {
                            warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                        }
                    }
                });
            } else {
                warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
            }

        }
    }
</script>
