<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane">
            <div class="content-inner">
                <div class="content-form" style="width: 80%; float: left; background: #087692; padding: 20px;">
                    <div class="block">
                        <?php echo form_open('page/saveUploadedGalleryImage', array('id' => 'galleryImageUploader', 'enctype' => 'multipart/form-data')); ?>
                        <div class="block-inner">
                            <input type="file" name="image" class="form-control">
                            <div class="tab-group config-submit">
                                <button type="submit" onclick="uploadGalleryImage('galleryImageUploader')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
                            </div>
                            <?php echo form_close() ?>
                        </div>
                    </div>
                    <div class="gallery-image-list">
                        <div class="employee-add-block">
                            <?php if (!empty($images)): ?>
                                <?php foreach ($images as $image): ?>
                                    <div class="one-fifth">
                                        <div class="block-inner" style="padding: 10px;">
                                            <div class="gallery-image">
                                                <img src="<?php echo EPOS_UPLOAD_PATH . 'gallery/' . $image->image ?>" style="max-width: 100%; min-width: 100%; min-height: 150px; max-height: 150px;">
                                            </div>
                                            <a href="javascript:void(0)" onclick="removeGalleryImage('<?php echo $image->id ?>', '<?php echo $image->image ?>')"><div class="remove-gallery-image text-center" style="width: 100%; background: #fff; padding: 10px; color: #000">Remove</div></a>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="content-sidebar-nav" style="width: 20%; float: right;">
                    <div class="block">
                          <?php $this->load->view('page/page_nav')?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="setting-general-keyboard text-center"></div>
<?php $this->load->view('settings/partials/footer') ?>
<script type="text/javascript">
    function uploadGalleryImage(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                $('.page-loader').hide();
                                if (response.status) {
                                    zamanEposNavigator('page', '<?php echo site_url('page/uploadGalleryImage') ?>', 'page');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                }
                            }
                        });
                    }
                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
    function removeGalleryImage(id, name) {
        $.ajax({
            url: '<?php echo site_url('page/removeGalleryImage') ?>',
            type: 'post',
            dataType: 'json',
            data: {id: id, image: name},
            success: function (response) {
                zamanEposNavigator('page', '<?php echo site_url('page/uploadGalleryImage') ?>', 'page');
            }
        });
    }
</script>
