<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Owner extends Epos_Template {
    function __construct() {
        parent::__construct();
        $this->load->model('Owner_Model');
        $this->load->model('report/Report_Model');
        if ($this->Owner_Model->isThisUserAnEposLogger() && (($this->cookies && !empty($this->cookies)) || ($this->session->userdata('group') == 2))) {
            return true;
        } else {
            redirect('user/login/index/' . $this->session->userdata('branch') . '/' . $this->session->userdata('team'));
        }
    }
    public function index($how = false) {
        $Y = date('Y');
        $M = date('m');
        $D = date('d');
        $fromDate = array($D, $M, $Y);
        $toDate = array($D, $M, $Y);
        $orderList = $this->Report_Model->getReportData($fromDate, $toDate, null, null, null)->result();
        $data['orderList'] = $orderList;
        $data['refresh'] = base_url(uri_string());
        $data['expenseFromTill'] = $this->Report_Model->getExpenseTotal($fromDate, $toDate);
        if ($how && $how === 'verified') {
            $this->render('index', $data);
        } else {
            $this->load->view('index', $data);
        }
    }

}
