<?php $status = array('2' => 'Inactive', '3' => 'active', '4' => 'deleted') ?>
<div class="pane-one-third category-list-block list-block">
    <div class="caption" onclick="zamanEposBlockHideAndShow('nattCategoryFormBlock')">
        <div class="caption-inner" style="padding: 9px">Add new topping category</div>
    </div>
    <div class="block-inner" id="nattCategoryFormBlock" style="display: none;">
        <?php echo form_open('menu/nattr/savecategory/', array('id' => 'menuNattrCategoryForm')); ?>
        <table>
            <tr><td colspan="3"><span class="btn btn-positive" onclick="resetForm('menuNattrCategoryForm')"><?php echo $this->lang->line('clear_form_add_new') ?></span></td></tr>
            <tr>
                <td><?php echo $this->lang->line('title') ?></td>
                <td>
                    <input value="<?php !empty($loaded_category) ? print $loaded_category['title'] : '' ?>"  type="text" data-error="#menuCategoryFormTitle" name="title" id="categoryTitle" class="form-control" placeholder="<?php echo $this->lang->line('title') ?>">
                    <div class="clearfix" id="menuCategoryFormTitle"></div>
                    <?php if (!empty($loaded_category)): ?>
                        <input type="hidden" name="id" value="<?php echo $loaded_category['id'] ?>">
                        <input type="hidden" id="updateCategory" value="yes">
                        <input type="hidden" id="oldCategoryTitle" value="<?php echo $loaded_category['title'] ?>">
                    <?php endif; ?>
                </td>
            </tr>
        </table>
        <div class="tab-group config-submit">
            <button type="submit" onclick="menuNattrCategoryForm('menuNattrCategoryForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save_category') ?></button>
        </div>
        <?php echo form_close() ?>
    </div>
    <?php if (!empty($nattrcategory)): ?>
        <div class="clearfix">
            <table class="report-table">
                <tr class="table-bg">
                    <th class="text-center"><?php echo $this->lang->line('title') ?></th>
                    <th class="text-center"><?php echo $this->lang->line('action') ?></th>
                </tr>
                <?php foreach ($nattrcategory as $anattrc): ?>
                    <tr>
                        <td class="text-center"><?php echo ucwords($anattrc->title) ?></td>
                        <td class="text-center"><span class="icon icon-pencil" onclick="zamanEposNavigator('menuIndex', '<?php echo site_url('menu/nattr/index/' . $anattrc->id) ?>', 'menuIndex')"></span>&nbsp;|&nbsp;<span class="icon icon-trash" style="color: #ff0000" onclick="deleteNattrCategory('<?php echo $anattrc->id ?>')"></span></td>
                    </tr>
                <?php endforeach; ?>
            </table>
        </div>
    <?php endif; ?>
</div>
<script type="text/javascript">
    function menuNattrCategoryForm(formId) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                if (checkInternetConnection()) {
                    $.ajax({
                        url: $('#' + formId).attr('action'),
                        data: formdata,
                        cache: false,
                        processData: false,
                        contentType: false,
                        type: 'POST',
                        dataType: 'json',
                        beforeSend: function () {
                            $('.page-loader').show();
                        },
                        success: function (response) {
                            if (response.status) {
                                $('.page-loader').hide();
                                zamanEposNavigator('', '<?php echo site_url('menu/nattr/index/') ?>' + response.category);
                            } else {
                                warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                            }
                        }
                    });
                } else {
                    warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                }
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {
                title: {
                    required: true,
                    remote: {
                        url: "<?php echo site_url('menu/nattr/checkcategory') ?>",
                        type: "post",
                        data: {
                            value: function () {
                                return $("#categoryTitle").val();
                            },
                            column: 'title',
                            old: function () {
                                if ($('#oldCategoryTitle').length > 0) {
                                    return $('#oldCategoryTitle').val();
                                } else {
                                    return 'none';
                                }
                            },
                            update: function () {
                                if ($('#updateCategory').length > 0) {
                                    return 'yes';
                                } else {
                                    return 'no';
                                }
                            }
                        }
                    }
                },
                price: {number: true, min: 0, required: true},
            },
            messages: {
                title: '<?php echo $this->lang->line('title_required_msg') ?>',
            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }
    function sortNattrCategory(id, position, func) {
        $.ajax({
            url: '<?php echo site_url('menu/nattr/sortcategory') ?>',
            type: 'post',
            dataType: 'json',
            data: {
                id: id,
                position: position,
                func: func
            },
            success: function (response) {
                if (response.status) {
                    zamanEposNavigator('', '<?php echo site_url('menu/nattr') ?>');
                } else {
                    warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                }
            }
        });
    }
    function deleteNattrCategory(id) {
        $.ajax({
            url: '<?php echo site_url('menu/nattr/deleteCategory/') ?>' + id,
            type: 'GET',
            dataType: 'json',
            success: function (response) {
                if (response.status) {
                    zamanEposNavigator('', '<?php echo site_url('menu/nattr') ?>');
                } else {
                    warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                }
            }
        });
    }
</script>