<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane category-list-block list-block">
            <div class="caption">
                <div class="caption-inner">Add New Modifier</div>
            </div>
            <div class="block-inner" id="categoryFormBlock">
                <?php echo form_open('menu/modifier/save', array('id' => 'modifierForm')); ?>
                <table>
                    <tr><td colspan="3"><span class="btn btn-positive" onclick="resetForm('modifierForm')"><?php echo $this->lang->line('clear_form_add_new') ?></span></td></tr>
                    <tr>
                        <td class="text-right"><?php echo $this->lang->line('title') ?></td>
                        <td>
                            <input value="<?php !empty($loaded_modifier) ? print $loaded_modifier['title'] : '' ?>"  type="text" data-error="#modifierFormTitle" name="title" id="categoryTitle" class="form-control" placeholder="<?php echo $this->lang->line('title') ?>">
                            <div class="clearfix" id="modifierFormTitle"></div>
                            <?php if (!empty($loaded_modifier)): ?>
                                <input type="hidden" name="id" value="<?php echo $loaded_modifier['id'] ?>">
                                <input type="hidden" id="updateCategory" value="yes">
                                <input type="hidden" id="oldCategoryTitle" value="<?php echo $loaded_modifier['title'] ?>">
                            <?php endif; ?>
                        </td>
                    </tr>
                </table>
                <div class="tab-group config-submit">
                    <button type="submit" onclick="saveModifierForm('modifierForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save_category') ?></button>
                </div>
                <?php echo form_close(); ?>
            </div>
            <?php if (!empty($modifiers)): ?>
                <div class="clearfix item-group">
                    <div class="menu-list special-modify-btn-groups">
                        <?php foreach ($modifiers as $amod): ?>
                            <div class="menu-button" onclick="zamanEposNavigator('', '<?php echo site_url('menu/modifier/index/' . $amod->id) ?>')"><div class="menu-button-inner"><?php echo $amod->title ?></div></div>
                            <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $this->load->view('menu/menu/menunav') ?>
<script type="text/javascript">
    function saveModifierForm(formId) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function () {
                        $('.page-loader').show();
                    },
                    success: function (response) {
                        if (response.status) {
                            $('.page-loader').hide();
                            zamanEposNavigator('', '<?php echo site_url('menu/modifier/index') ?>');
                        } else {
                            warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                        }
                    }
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {
                title: {
                    required: true,
                    remote: {
                        url: "<?php echo site_url('menu/modifier/checkme') ?>",
                        type: "post",
                        data: {
                            value: function () {
                                return $("#categoryTitle").val();
                            },
                            column: 'title',
                            old: function () {
                                if ($('#oldCategoryTitle').length > 0) {
                                    return $('#oldCategoryTitle').val();
                                } else {
                                    return 'none';
                                }
                            },
                            update: function () {
                                if ($('#updateCategory').length > 0) {
                                    return 'yes';
                                } else {
                                    return 'no';
                                }
                            }
                        }
                    }
                },
                status: {required: true}
            },
            messages: {
                title: '<?php echo $this->lang->line('title_required_msg') ?>',
            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }

</script>