<?php
$taxOption = array('0' => 'None', '2' => 'Default', '3' => 'Category', '4' => 'Menu', '5' => 'Selection');
$DiscountOption = array('0' => 'None', '2' => 'Default', '3' => 'Disc Plan', '4' => 'Category', '5' => 'Menu', '6' => 'Selection');
$menuStatus = array('3' => $this->lang->line('active'), '2' => $this->lang->line('inactive'));
$menuOnline = array('3' => $this->lang->line('yes'), '2' => $this->lang->line('no'));
?>
<?php if (!empty($loaded_menu)): ?>
    <div class="pane selection-list-block list-block">
        <div class="caption" onclick="zamanEposBlockHideAndShow('SelectionFormBlock')">
            <div class="caption-inner"><?php echo sprintf($this->lang->line('add_new_selection'), $loaded_menu['title']) ?></div>
        </div>
        <div class="block-inner" id="SelectionFormBlock" style="display: none;">
            <?php echo form_open('menu/selection/save/' . $loaded_category['id'] . '/' . $loaded_menu['id'], array('id' => 'menuSelectionForm')); ?>
            <?php if (!empty($loaded_selection)): ?>
                <input type="hidden" name="id" value="<?php echo $loaded_selection['id'] ?>">
                <input type="hidden" id="updateSelection" value="yes">
                <input type="hidden" id="oldSelectionTitle" value="<?php echo $loaded_selection['title'] ?>">
                <input type="hidden" id="oldSelectionCode" value="<?php echo $loaded_selection['code'] ?>">
            <?php endif; ?>
            <div class="pane" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('title') ?></div>
                <div class="form-group pane" style="border: none;">
                    <input data-error="#menuSelectionFormTitle" type="text" name="title" id="selectionTitle" value="<?php !empty($loaded_selection) ? print $loaded_selection['title'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('title') ?>">
                    <div class="clearfix" id="menuSelectionFormTitle"></div>
                </div>
            </div>
            <div class="pane" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('description') ?></div>
                <div class="form-group pane" style="border: none;">
                    <textarea name="content" class="form-control"><?php !empty($loaded_selection) ? print $loaded_selection['content'] : '' ?></textarea>
                </div>
            </div>
            <div class="pane" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('base_price') ?></div>
                <div class="form-group pane">
                    <input type="text" data-error="#menuSelectionFormBasePrice" name="base_price" value="<?php !empty($loaded_selection) ? print $loaded_selection['base_price'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('base_price') ?>">
                    <div class="clearfix" id="menuSelectionFormBasePrice"></div>
                </div>
            </div>
            <div class="pane" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('price_differ') ?></div>
                <div class="form-group pane">
                    <label><input type="checkbox" <?php !empty($loaded_selection) && ($loaded_selection ['in_price'] > 0 || $loaded_selection['out_price'] > 0) ? print'checked="checked"' : '' ?>  id="selectionPriceDiffer" onchange="ZamanEposCheckboxBlockHandler(this, 'selectionPriceDifferBlock')">&nbsp;<?php echo $this->lang->line('yes') ?></label>
                </div>
            </div>
            <div class="pane" id="selectionPriceDifferBlock" style="<?php !empty($loaded_selection) && ($loaded_selection ['in_price'] > 0 || $loaded_selection['out_price'] > 0) ? print'display:block' : print 'display:none' ?>">
                <div class="pane">
                    <div class="pane-one-third pane-form-label text-right"><?php echo $this->lang->line('in') ?>&nbsp;</div>
                    <div class="form-group pane">
                        <input  type="text" data-error="#menuSelectionFormInPrice" name="in_price" value="<?php !empty($loaded_selection) ? print $loaded_selection['in_price'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('in') ?>">
                        <div class="clearfix" id="menuSelectionFormInPrice"></div>
                    </div>
                </div>
                <div class="pane">
                    <div class="pane-one-third pane-form-label text-right"><?php echo $this->lang->line('out') ?>&nbsp;</div>
                    <div class="form-group pane">
                        <input type="text" data-error="#menuSelectionFormOutPrice" name="out_price" value="<?php !empty($loaded_selection) ? print $loaded_selection['out_price'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('out') ?>">
                        <div class="clearfix" id="menuSelectionFormOutPrice"></div>
                    </div>
                </div>
            </div>
            <div class="pane" style="border: none;">
                <div class="pane text-uppercase">Print inside</div>
                <div class="form-group pane">
                    <label><input data-error="#menuSelectionFormPrintOption" type="radio" name="printat" value="5" <?php !empty($loaded_selection) && $loaded_selection['printat'] == 5 ? print 'checked="checked"' : '' ?>>&nbsp;Main Dish</label>
                    <label><input data-error="#menuSelectionFormPrintOption" type="radio" name="printat" value="1" <?php !empty($loaded_selection) && $loaded_selection['printat'] == 1 ? print 'checked="checked"' : '' ?>>&nbsp;Papadam & Chutney</label>
                    <label><input data-error="#menuSelectionFormPrintOption" type="radio" name="printat" value="2" <?php !empty($loaded_selection) && $loaded_selection['printat'] == 2 ? print 'checked="checked"' : '' ?>>&nbsp;Appetizer</label>
                    <label><input data-error="#menuSelectionFormPrintOption" type="radio" name="printat" value="3" <?php !empty($loaded_selection) && $loaded_selection['printat'] == 3 ? print 'checked="checked"' : '' ?>>&nbsp;Starters</label>
                    <label><input data-error="#menuSelectionFormPrintOption" type="radio" name="printat" value="4" <?php !empty($loaded_selection) && $loaded_selection['printat'] == 4 ? print 'checked="checked"' : '' ?>>&nbsp;Tandoori Dish</label>
                    <label><input data-error="#menuSelectionFormPrintOption" type="radio" name="printat" value="6" <?php !empty($loaded_selection) && $loaded_selection['printat'] == 6 ? print 'checked="checked"' : '' ?>>&nbsp;Kids Meals</label>
                    <label><input data-error="#menuSelectionFormPrintOption" type="radio" name="printat" value="7" <?php !empty($loaded_selection) && $loaded_selection['printat'] == 7 ? print 'checked="checked"' : '' ?>>&nbsp;Side Dishes</label>
                    <label><input data-error="#menuSelectionFormPrintOption" type="radio" name="printat" value="8" <?php !empty($loaded_selection) && $loaded_selection['printat'] == 8 ? print 'checked="checked"' : '' ?>>&nbsp;Sundries</label>
                    <label><input data-error="#menuSelectionFormPrintOption" type="radio" name="printat" value="9" <?php !empty($loaded_selection) && $loaded_selection['printat'] == 9 ? print 'checked="checked"' : '' ?>>&nbsp;Rice</label>
                    <label><input data-error="#menuSelectionFormPrintOption" type="radio" name="printat" value="10" <?php !empty($loaded_selection) && $loaded_selection['printat'] == 10 ? print 'checked="checked"' : '' ?>>&nbsp;Naan</label>
                    <label><input data-error="#menuSelectionFormPrintOption" type="radio" name="printat" value="11" <?php !empty($loaded_selection) && $loaded_selection['printat'] == 11 ? print 'checked="checked"' : '' ?>>&nbsp;Set Meals</label>
                    <label><input data-error="#menuSelectionFormPrintOption" type="radio" name="printat" value="12" <?php !empty($loaded_selection) && $loaded_selection['printat'] == 12 ? print 'checked="checked"' : '' ?>>&nbsp;English Dish</label>
                    <label><input data-error="#menuSelectionFormPrintOption" type="radio" name="printat" value="13" <?php !empty($loaded_selection) && $loaded_selection['printat'] == 13 ? print 'checked="checked"' : '' ?>>&nbsp;Desserts</label>
                    <label><input data-error="#menuSelectionFormPrintOption" type="radio" name="printat" value="14" <?php !empty($loaded_selection) && $loaded_selection['printat'] == 14 ? print 'checked="checked"' : '' ?>>&nbsp;Drinks</label>
                    <label><input data-error="#menuSelectionFormPrintOption" type="radio" name="printat" value="16" <?php !empty($loaded_selection) && $loaded_selection['printat'] == 16 ? print 'checked="checked"' : '' ?>>&nbsp;Kebab</label>
                    <label><input data-error="#menuSelectionFormPrintOption" type="radio" name="printat" value="17" <?php !empty($loaded_selection) && $loaded_selection['printat'] == 17 ? print 'checked="checked"' : '' ?>>&nbsp;Pizza</label>
                    <label><input data-error="#menuSelectionFormPrintOption" type="radio" name="printat" value="18" <?php !empty($loaded_selection) && $loaded_selection['printat'] == 18 ? print 'checked="checked"' : '' ?>>&nbsp;Noodles</label>
                    <label><input data-error="#menuSelectionFormPrintOption" type="radio" name="printat" value="19" <?php !empty($loaded_selection) && $loaded_selection['printat'] == 19 ? print 'checked="checked"' : '' ?>>&nbsp;Soup</label>
                    <label><input data-error="#menuSelectionFormPrintOption" type="radio" name="printat" value="20" <?php !empty($loaded_selection) && $loaded_selection['printat'] == 20 ? print 'checked="checked"' : '' ?>>&nbsp;Sandwiches</label>
                    <label><input data-error="#menuSelectionFormPrintOption" type="radio" name="printat" value="21" <?php !empty($loaded_selection) && $loaded_selection['printat'] == 21 ? print 'checked="checked"' : '' ?>>&nbsp;Burgers</label>
                    <label><input data-error="#menuSelectionFormPrintOption" type="radio" name="printat" value="22" <?php !empty($loaded_selection) && $loaded_selection['printat'] == 22 ? print 'checked="checked"' : '' ?>>&nbsp;Wrap</label>
                    <div id="menuSelectionFormPrintOption" class="text-center pane"></div>
                </div>
            </div>     
            <div class="pane" style="border: none;">
                <div class="tab-group">
                    <div class="tab-item" style="padding: 5px" onclick="resetForm('menuSelectionForm')"><?php echo $this->lang->line('clear_form_add_new') ?></div>
                    <div class="tab-item" style="padding: 5px" onclick="showItemOption('hide-selection-option')"><?php echo $this->lang->line('more_option') ?></div>
                </div>
            </div>
            <div class="pane hide-selection-option" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('assign_to') ?></div>
                <div class="pane form-group">
                    <label><input type="checkbox" name="breakfast" value="yes" <?php !empty($loaded_selection) && $loaded_selection['breakfast'] == 'yes' ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('breakfast') ?></label>
                    <label><input type="checkbox" name="launch" value="yes" <?php !empty($loaded_selection) && $loaded_selection['launch'] == 'yes' ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('launch') ?></label>
                    <label><input type="checkbox" name="dinner" value="yes" <?php !empty($loaded_selection) && $loaded_selection['dinner'] == 'yes' ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('dinner') ?></label>
                </div>
            </div>
            <div class="pane hide-selection-option" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('code') ?></div>
                <div class="form-group pane">
                    <input data-error="#menuSelectionFormCode" type="text" name="code" id="selectionCode" value="<?php !empty($loaded_selection) ? print $loaded_selection['code'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('code') ?>">
                    <div class="clearfix" id="menuSelectionFormCode"></div>
                </div>
            </div>
            <div class="pane hide-selection-option" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('tax') ?>(<?php echo $this->lang->line('percent') ?>)</div>
                <div class="form-group pane">
                    <input type="text" data-error="#menuSelectionFormTax"  name="tax"  value="<?php !empty($loaded_selection) ? print $loaded_selection['tax'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('tax') ?>">
                    <div class="clearfix" id="menuSelectionFormTax"></div>
                </div>
            </div>
            <div class="pane hide-selection-option" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('tax') ?>&nbsp;<?php echo $this->lang->line('plan') ?></div>
                <div class="form-group pane">
                    <select class="form-control" name='tax_option' data-error="#menuSelectionFormTaxOption">
                        <option value='0' <?php !empty($loaded_selection) && $loaded_selection ['tax_option'] == '0' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('no_plan') ?></option>
                        <option value='5' <?php !empty($loaded_selection) && $loaded_selection ['tax_option'] == '5' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('selection_plan') ?></option>
                        <option value='4' <?php !empty($loaded_selection) && $loaded_selection ['tax_option'] == '4' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('menu_plan') ?></option>
                        <option value='3' <?php !empty($loaded_selection) && $loaded_selection ['tax_option'] == '3' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('category_plan') ?></option>
                        <option value='2' <?php !empty($loaded_selection) && $loaded_selection ['tax_option'] == '2' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('default_plan') ?></option>
                    </select>
                    <div class="clearfix" id="menuSelectionFormTaxOption"></div>
                </div>
            </div>
            <div class="pane hide-selection-option" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('discount') ?>(<?php echo $this->lang->line('percent') ?>)</div>
                <div class="form-group pane">
                    <input type="text" data-error="#menuSelectionFormDiscount" name="discount" value="<?php !empty($loaded_selection) ? print $loaded_selection['discount'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('discount') ?>">
                    <div class="clearfix" id="menuSelectionFormDiscount"></div>
                </div>
            </div>  
            <div class="pane hide-selection-option" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('discount') ?>&nbsp;<?php echo $this->lang->line('plan') ?></div>
                <div class="form-group pane">
                    <select class="form-control" name='discount_option' data-error="#menuSelectionFormDiscountOption">
                        <option value='0' <?php !empty($loaded_selection) && $loaded_selection ['discount_option'] == '0' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('no_plan') ?></option>
                        <option value='6' <?php !empty($loaded_selection) && $loaded_selection ['discount_option'] == '6' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('selection_plan') ?></option>
                        <option value='5' <?php !empty($loaded_selection) && $loaded_selection ['discount_option'] == '5' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('menu_plan') ?></option>
                        <option value='4' <?php !empty($loaded_selection) && $loaded_selection ['discount_option'] == '4' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('category_plan') ?></option>
                        <option value='3' <?php !empty($loaded_selection) && $loaded_selection ['discount_option'] == '3' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('discount_plan') ?></option>
                        <option value='2' <?php !empty($loaded_selection) && $loaded_selection ['discount_option'] == '2' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('default_plan') ?></option>
                    </select>
                    <div class="clearfix" id="menuSelectionFormDiscountOption"></div>
                </div>
            </div>  
            <div class="pane hide-selection-option" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('show') ?></div>
                <div class="form-group pane">
                    <label class="pane-form-label"><input type="checkbox" name="inline" value="3" <?php !empty($loaded_selection) && $loaded_selection['inline'] === '3' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('in') ?></label>
                    <label class="pane-form-label"><input type="checkbox" name="online" value="3" <?php !empty($loaded_selection) && $loaded_selection['online'] === '3' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('out') ?></label>
                </div>
            </div>
            <div class="pane hide-selection-option" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('status') ?></div>
                <div class="form-group pane">
                    <label><input type="radio" data-error="#menuSelectionFormStatus" name="status" value="3" <?php !empty($loaded_selection) && $loaded_selection['status'] === '3' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('active') ?></label>
                    <label><input type="radio" data-error="#menuSelectionFormStatus" name="status" value="2" <?php !empty($loaded_selection) && $loaded_selection['status'] === '2' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('inactive') ?></label>
                    <div class="clearfix" id="menuSelectionFormStatus"></div>
                </div>
            </div>    

            <div class="pane hide-selection-option" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('is_featured') ?></div>
                <div class="form-group pane">
                    <label><input data-error="#menuSelectionFormStatus" type="radio" name="featured" value="yes" <?php !empty($loaded_selection) && $loaded_selection['featured'] === 'yes' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('yes') ?></label>
                    <label><input data-error="#menuSelectionFormStatus" type="radio" name="featured" value="no" <?php !empty($loaded_selection) && $loaded_selection['featured'] === 'no' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('no') ?></label>
                    <div class="clearfix" id="menuSelectionFormStatus"></div>
                </div>
            </div>
            <div class="pane hide-selection-option" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('image') ?></div>
                <div class="form-group pane">
                    <div class="block thumbnail text-center">
                        <?php if (!empty($loaded_selection) && trim($loaded_selection['image'])): ?>
                            <img src="<?php echo EPOS_UPLOAD_PATH . 'menuselection/' . $loaded_selection['image'] ?>" alt="<?php echo $loaded_selection['title'] ?>">
                            <span class="icon icon-trash text-right clearfix" onclick="deleteImage('<?php echo $loaded_selection['id'] ?>', 'image', '<?php echo $loaded_selection['image'] ?>', 'menuselection', './uploads/menuselection/', '<?php echo site_url('menu/deleteImage') ?>')">&nbsp;<?php echo $this->lang->line('remove') ?></span>
                        <?php endif; ?>
                    </div>
                    <input type="file" name="image" class="form-control">
                </div>
            </div>  
            <div class="pane" style="border: none;">
                <div class="tab-group config-submit">
                    <button type="submit" onclick="menuSelectionForm('menuSelectionForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save_menu') ?></button>
                </div>
            </div>
            <?php echo form_close() ?>
        </div>
        <?php if (!empty($loaded_menu_selection)): ?>
            <div class="clearfix item-group">
                <div class="accordion-wrapper">
                    <?php foreach ($loaded_menu_selection as $lms): ?>
                        <div class="tab blue">
                            <input id="<?php echo 'selection-tab-' . $lms->id ?>" type="checkbox" name="tabs">
                            <label for="<?php echo 'selection-tab-' . $lms->id ?>"><?php echo ucwords($lms->title) ?></label>
                            <div class="tab-content">
                                <div class="tab-content-attr clearfix">
                                    <div class="pane" style="font-size: 12px;">
                                        <span><?php echo $this->lang->line('name') ?>:&nbsp;<?php echo $lms->title . '-' . $loaded_menu['title'] ?></span>,&nbsp;
                                        <span><?php echo $this->lang->line('status') ?>:&nbsp; <?php echo $menuStatus[$lms->status] ?></span>,&nbsp;
                                        <span><?php echo $this->lang->line('in') ?>:&nbsp; <?php echo $menuOnline[$lms->inline] ?></span>,&nbsp;
                                        <span><?php echo $this->lang->line('out') ?>:&nbsp; <?php echo $menuOnline[$lms->online] ?></span>,&nbsp;
                                        <span><?php echo $this->lang->line('base') ?>:&nbsp; <?php echo to_currency($lms->base_price) ?></span>,&nbsp;
                                        <span><?php echo $this->lang->line('in') ?>:&nbsp; <?php echo to_currency($lms->in_price) ?></span>,&nbsp;
                                        <span><?php echo $this->lang->line('out') ?>:&nbsp; <?php echo to_currency($lms->out_price) ?></span>,&nbsp;
                                        <span><?php echo $this->lang->line('tax') ?>:&nbsp;<?php echo $lms->tax ?>&nbsp;%</span>
                                        <span><?php echo $this->lang->line('t_plan') ?>:&nbsp; <?php echo $taxOption[$lms->tax_option] ?></span>
                                        <span><?php echo $this->lang->line('discount') ?>:&nbsp;<?php echo $lms->discount ?>&nbsp;%</span>
                                        <span><?php echo $this->lang->line('d_plan') ?>:&nbsp;<?php echo $DiscountOption[$lms->discount_option] ?></span>
                                    </div>
                                </div>
                                <div class="pane" style="border: none;">
                                    <div class="tab-group">
                                        <div class="tab-item" style="padding: 5px;" onclick="zamanEposNavigator('', '<?php echo site_url('menu/index/' . $lms->category . '/' . $lms->menu . '/' . $lms->id) ?>', 'menuIndex')"><span class="icon icon-pencil"></span></div>
                                        <div class="tab-item" style="padding: 5px;" onclick="sortSelection('<?php echo $lms->id ?>', '<?php echo $lms->position ?>', '<?php echo 'down' ?>')"><?php echo $this->lang->line('order') ?>&nbsp;<span class="icon icon-up-open-big"></span></div>
                                        <div class="tab-item" style="padding: 5px;" onclick="sortSelection('<?php echo $lms->id ?>', '<?php echo $lms->position ?>', '<?php echo 'up' ?>')"><?php echo $this->lang->line('order') ?>&nbsp;<span class="icon icon-down-open-big"></span></div>
                                        <?php if ($this->session->userdata('group') <= 4): ?>
                                            <div class="tab-item" style="padding: 5px;" onclick="deleteSelection('<?php echo$lms->id ?>', '<?php echo $lms->title . '-' . $loaded_menu['title'] ?>')"><span class="icon icon-trash"></span></div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="attr-block clearfix">
                                    <div class="caption"><?php echo $this->lang->line('additional_attribute') ?></div>
                                    <?php if ($lms->ctop == '2'): ?>
                                        <div class="text-center pane-one-fourth">
                                            <div class="checkbox"><label><input type="checkbox" <?php $lms->has_topping == 3 ? print'checked="checked"' : '' ?> class="hook-checkbox" id="menuToppings-<?php echo $lms->id ?>" onchange="menuAttr(this.id, '<?php echo $lms->id ?>', 'menuselection')"><?php echo $this->lang->line('toppings') ?></label></div>
                                            <button class="btn btn-positive icon icon-tools" <?php $lms->has_topping == 3 ? '' : print'style="display: none;"' ?> id="menuToppings-<?php echo $lms->id ?>-Btn" onclick="attrPopup('menuToppingPopup', '75%', '<?php echo $lms->category ?>', '<?php echo $lms->menu ?>', '<?php echo $lms->id ?>', '0', '<?php echo site_url('menu/topping') ?>')"><?php echo $this->lang->line('manage') ?></button>
                                        </div>
                                    <?php else: ?>
                                        <div class="text-center pane-one-fourth">
                                            <div class="checkbox"><label><input type="checkbox" <?php $lms->has_topping == 3 ? print'checked="checked"' : $lms->deal_type == '0' || $lms->deal_type == '3' ? '' : print 'disabled="disabled"'  ?> class="hook-checkbox" id="menuToppings-<?php echo $lms->id ?>" onchange="menuAttr(this.id, '<?php echo $lms->id ?>', 'menuselection')"><?php echo $this->lang->line('toppings') ?></label></div>
                                            <button class="btn btn-positive icon icon-tools" <?php $lms->has_topping == 3 ? '' : print'style="display: none;"' ?> id="menuToppings-<?php echo $lms->id ?>-Btn" onclick="attrPopup('menuToppingPopup', '75%', '<?php echo $lms->category ?>', '<?php echo $lms->menu ?>', '<?php echo $lms->id ?>', '0', '<?php echo site_url('menu/topping') ?>')"><?php echo $this->lang->line('manage') ?></button>
                                        </div>
                                    <?php endif; ?>
                                    <?php if ($lms->cmod == '2'): ?>
                                        <div class="text-center pane-one-fourth">
                                            <div class="checkbox"><label><input type="checkbox" <?php $lms->has_modifier == 3 ? print'checked="checked"' : '' ?> class="hook-checkbox" id="menuModifier-<?php echo $lms->id ?>" onchange="menuAttr(this.id, '<?php echo $lms->id ?>', 'menuselection')"><?php echo $this->lang->line('modifiers') ?></label></div>
                                            <button class="btn btn-positive icon icon-tools" <?php $lms->has_modifier == 3 ? '' : print'style="display: none;"' ?>  id="menuModifier-<?php echo $lms->id ?>-Btn" onclick="attrPopup('menuModifierPopup', '75%', '<?php echo $lms->category ?>', '<?php echo $lms->menu ?>', '<?php echo $lms->id ?>', '0', '<?php echo site_url('menu/itemmodifier') ?>')"><?php echo $this->lang->line('manage') ?></button>
                                        </div>
                                    <?php else: ?>
                                        <div class="text-center pane-one-fourth">
                                            <div class="checkbox"><label><input type="checkbox" <?php $lms->has_modifier == 3 ? print'checked="checked"' : $lms->deal_type == '0' || $lms->deal_type == '3' ? '' : print 'disabled="disabled"'  ?> class="hook-checkbox" id="menuModifier-<?php echo $lms->id ?>" onchange="menuAttr(this.id, '<?php echo $lms->id ?>', 'menuselection')"><?php echo $this->lang->line('modifiers') ?></label></div>
                                            <button class="btn btn-positive icon icon-tools" <?php $lms->has_modifier == 3 ? '' : print'style="display: none;"' ?>  id="menuModifier-<?php echo $lms->id ?>-Btn" onclick="attrPopup('menuModifierPopup', '75%', '<?php echo $lms->category ?>', '<?php echo $lms->menu ?>', '<?php echo $lms->id ?>', '0', '<?php echo site_url('menu/itemmodifier') ?>')"><?php echo $this->lang->line('manage') ?></button>
                                        </div>
                                    <?php endif; ?>
                                    <div class="text-center pane-one-fourth">
                                        <div class="checkbox"><label><input type="checkbox" <?php $lms->deal_type == 3 ? print'checked="checked"' : ($lms->deal_type == '0' || $lms->deal_type == '3') ? '' : print 'disabled="disabled"'  ?> class="hook-checkbox" id="fixedDeal-<?php echo $lms->id ?>" onchange="menuAttr(this.id, '<?php echo $lms->id ?>', 'menuselection')"><?php echo $this->lang->line('fixed_deal') ?></label></div>
                                        <button class="btn btn-positive icon icon-tools" <?php $lms->deal_type == 3 ? '' : print'style="display: none;"' ?> id="fixedDeal-<?php echo $lms->id ?>-Btn" onclick="attrPopup('menuFixedDealPopup', '75%', '<?php echo $lms->category ?>', '<?php echo $lms->menu ?>', '<?php echo $lms->id ?>', '0', '<?php echo site_url('menu/fixeddeal') ?>')"><?php echo $this->lang->line('manage') ?></button>
                                    </div>
                                    <div class="text-center pane-one-fourth">
                                        <div class="checkbox"><label><input type="checkbox" <?php $lms->deal_type == 2 ? print'checked="checked"' : $lms->has_topping == '0' && $lms->has_modifier == '0' && ($lms->deal_type == '0' || $lms->deal_type == '2') ? '' : print 'disabled="disabled"'  ?> class="hook-checkbox" id="customDeal-<?php echo $lms->id ?>" onchange="menuAttr(this.id, '<?php echo $lms->id ?>', 'menuselection')"><?php echo $this->lang->line('custom_deal') ?></label></div>
                                        <button class="btn btn-positive icon icon-tools" <?php $lms->deal_type == 2 ? '' : print'style="display: none;"' ?> id="customDeal-<?php echo $lms->id ?>-Btn" onclick="attrPopup('menuCustomDealPopup', '80%', '<?php echo $lms->category ?>', '<?php echo $lms->menu ?>', '<?php echo $lms->id ?>', '0', '<?php echo site_url('menu/customdeal') ?>')"><?php echo $this->lang->line('manage') ?></button>
                                    </div>
                                    <div class="loader loader-<?php echo $lms->id ?>" style="display: none;"></div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                    <?php if ($this->session->userdata('group') === '2'): ?>
                        <div class="tab-group config-submit">
                            <button onclick="deleteMenuSelection('<?php echo $loaded_menu['id'] ?>', '<?php echo $loaded_menu['title'] . ' - ' . $this->lang->line('selection') ?>')"><span class="icon icon-trash"></span>&nbsp;<?php echo sprintf($this->lang->line('delete_all_selections'), $loaded_menu['title']) ?></button>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
    <script type="text/javascript">
        function menuSelectionForm(formId) {
            if (!$('.page-loader').is(":visible")) {
                $('#' + formId).validate({
                    submitHandler: function () {
                        var myform = document.getElementById(formId);
                        var formdata = new FormData(myform);
                        if (checkInternetConnection()) {
                            $.ajax({
                                url: $('#' + formId).attr('action'),
                                data: formdata,
                                cache: false,
                                processData: false,
                                contentType: false,
                                type: 'POST',
                                dataType: 'json',
                                beforeSend: function () {
                                    $('.page-loader').show();
                                },
                                success: function (response) {
                                    if (response.status) {
                                        $('.page-loader').hide();
                                        zamanEposNavigator('', '<?php echo site_url('menu/index/') ?>' + response.category + '/' + response.menu, 'menuIndex');
                                    } else {
                                        warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                    }
                                }
                            });
                        } else {
                            warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                        }
                    },
                    errorClass: "has-error",
                    highlight: function (e) {
                        $(e).closest('.form-group').addClass('has-error');
                    },
                    unhighlight: function (e) {
                        $(e).closest('.form-group').removeClass('has-error');
                    },
                    rules: {
                        title: {
                            required: true,
                            remote: {
                                url: "<?php echo site_url('menu/selection/checkme') ?>",
                                type: "post",
                                data: {
                                    value: function () {
                                        return $("#selectionTitle").val();
                                    },
                                    column: 'title',
                                    old: function () {
                                        if ($('#oldSelectionTitle').length > 0) {
                                            return $('#oldSelectionTitle').val();
                                        } else {
                                            return 'none';
                                        }
                                    },
                                    update: function () {
                                        if ($('#updateSelection').length > 0) {
                                            return 'yes';
                                        } else {
                                            return 'no';
                                        }
                                    },
                                    category: '<?php echo $loaded_category['id'] ?>',
                                    menu: '<?php echo $loaded_menu['id'] ?>'
                                }
                            }
                        },
                        code: {
                            number: true,
                            min: 3000,
                            max: 3999,
                            remote: {
                                url: "<?php echo site_url('menu/selection/checkme') ?>",
                                type: "post",
                                data: {
                                    value: function () {
                                        return $("#selectionCode").val();
                                    },
                                    column: 'code',
                                    old: function () {
                                        if ($('#oldSelectionCode').length > 0) {
                                            return $('#oldSelectionCode').val();
                                        } else {
                                            return 'none';
                                        }
                                    },
                                    update: function () {
                                        if ($('#updateSelection').length > 0) {
                                            return 'yes';
                                        } else {
                                            return 'no';
                                        }
                                    },
                                    category: '<?php echo $loaded_category['id'] ?>',
                                    menu: '<?php echo $loaded_menu['id'] ?>'
                                }
                            }
                        },
                        base_price: {number: true, min: 0, required: '#selectionPriceDiffer:unchecked'},
                        in_price: {number: true, min: 0, required: '#selectionPriceDiffer:checked'},
                        out_price: {number: true, min: 0, required: '#selectionPriceDiffer:checked'},
                        tax: {number: true, min: 0},
                        tax_option: {required: true, number: true, min: 0, max: 5},
                        discount: {number: true, min: 0},
                        discount_option: {required: true, number: true, min: 0, max: 6},
                        status: {required: true},
                        printat: {required: true}
                    },
                    messages: {
                        title: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('title')) ?>',
                        code: '<?php echo sprintf($this->lang->line('invalid_value'), $this->lang->line('code')) ?>',
                        base_price: '<?php echo sprintf($this->lang->line('item_required_in_number'), $this->lang->line('base_price')) ?>',
                        in_price: '<?php echo sprintf($this->lang->line('item_required_in_number'), $this->lang->line('dine_in')) ?>',
                        out_price: '<?php echo sprintf($this->lang->line('item_required_in_number'), $this->lang->line('out_price')) ?>',
                        tax: '<?php echo sprintf($this->lang->line('invalid_value'), $this->lang->line('tax')) ?>',
                        tax_option: '<?php echo sprintf($this->lang->line('invalid_value'), $this->lang->line('applicable_tax_plan')) ?>',
                        discount: '<?php echo sprintf($this->lang->line('invalid_value'), $this->lang->line('title')) ?>',
                        discount_option: '<?php echo sprintf($this->lang->line('invalid_value'), $this->lang->line('applicable_discount_plan')) ?>',
                        online: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('show_online')) ?>',
                        status: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('status')) ?>',
                        printat: 'please select print inside option'
                    },
                    errorPlacement: function (error, element) {
                        errorPlacement(error, element);
                    }
                });
            }
        }
        function sortSelection(id, position, func) {
            if (!$('.page-loader').is(":visible")) {
                if (checkInternetConnection()) {
                    $.ajax({
                        url: '<?php echo site_url('menu/selection/sortme') ?>',
                        type: 'post',
                        dataType: 'json',
                        data: {id: id, position: position, func: func},
                        success: function (response) {
                            if (response.status) {
                                zamanEposNavigator('', '<?php echo site_url('menu/index/' . $loaded_category['id'] . '/' . $loaded_menu['id']) ?>', 'menuIndex');
                            } else {
                                warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                            }
                        }
                    });
                } else {
                    warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                }
            }
        }
        function deleteSelection(id, title) {
            if (!$('.page-loader').is(":visible")) {
                $.confirm({
                    title: '<?php echo $this->lang->line('warning') ?>',
                    message: '<?php echo $this->lang->line('delete_warning_message') ?>' + title,
                    buttons: {
                        '<span class="icon icon-check">&nbsp;<?php echo $this->lang->line('yes') ?></span>': {
                            'class': 'positive',
                            'action': function () {
                                if (checkInternetConnection()) {
                                    $.ajax({
                                        url: '<?php echo site_url('menu/selection/delete/') ?>' + id,
                                        type: 'GET',
                                        dataType: 'json',
                                        success: function (response) {
                                            if (response.status) {
                                                zamanEposNavigator('', '<?php echo site_url('menu/index/' . $loaded_category['id'] . '/' . $loaded_menu['id']) ?>', 'menuIndex');
                                            } else {
                                                warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                                            }
                                        }
                                    });
                                } else {
                                    warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                                }
                            }
                        },
                        '<span class="icon icon-cancel">&nbsp;<?php echo $this->lang->line('no') ?></span>': {
                            'class': 'negative',
                            'action': function () {
                            }
                        }
                    }
                });
            }
        }
        function deleteMenuSelection(id, title) {
            if (!$('.page-loader').is(":visible")) {
                $.confirm({
                    title: '<?php echo $this->lang->line('warning') ?>',
                    message: '<?php echo $this->lang->line('delete_warning_message_all') ?>' + title,
                    buttons: {
                        '<span class="icon icon-check">&nbsp;<?php echo $this->lang->line('yes') ?></span>': {
                            'class': 'positive',
                            'action': function () {
                                if (checkInternetConnection()) {
                                    $.ajax({
                                        url: '<?php echo site_url('menu/selection/deleteAll/') ?>' + id,
                                        type: 'GET',
                                        dataType: 'json',
                                        beforeSend: function (xhr) {
                                            $('.page-loader').show();
                                        },
                                        success: function (response) {
                                            $('.page-loader').hide();
                                            if (response.status) {
                                                zamanEposNavigator('', '<?php echo site_url('menu/index/' . $loaded_category['id']) ?>', 'menuIndex');
                                            } else {
                                                warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                                            }
                                        }
                                    });
                                } else {
                                    warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                                }
                            }
                        },
                        '<span class="icon icon-cancel">&nbsp;<?php echo $this->lang->line('no') ?></span>': {
                            'class': 'negative',
                            'action': function () {}
                        }
                    }
                });
            }
        }
    </script>
<?php endif; ?>