<?php
$taxOption = array('0' => 'None', '2' => 'Default', '3' => 'Category', '4' => 'Menu');
$DiscountOption = array('0' => 'None', '2' => 'Default', '3' => 'Disc Plan', '4' => 'Category', '5' => 'Menu',);
$menuStatus = array('3' => $this->lang->line('active'), '2' => $this->lang->line('inactive'));
$menuOnline = array('3' => $this->lang->line('yes'), '2' => $this->lang->line('no'));
?>
<?php if (!empty($loaded_category)): ?>
    <div class="pane menu-list-block list-block">
        <div class="caption" onclick="zamanEposBlockHideAndShow('menuFormBlock')">
            <div class="caption-inner">
                <?php echo sprintf($this->lang->line('add_new_menu'), $loaded_category['title']) ?>
            </div>
        </div>
        <div class="block-inner" id="menuFormBlock" style="display: none;">
            <?php echo form_open('menu/save/' . $loaded_category['id'], array('id' => 'menuForm')); ?>
            <?php if (!empty($loaded_menu)): ?>
                <input type="hidden" name="id" value="<?php echo $loaded_menu['id'] ?>">
                <input type="hidden" id="updateMenu" value="yes">
                <input type="hidden" id="oldMenuTitle" value="<?php echo $loaded_menu['title'] ?>">
                <input type="hidden" id="oldMenuCode" value="<?php echo $loaded_menu['code'] ?>">
            <?php endif; ?>
            <div class="pane" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('title') ?></div>
                <div class="form-group pane">
                    <input data-error="#menuFormTitle" type="text" name="title" id="menuTitle" value="<?php !empty($loaded_menu) ? print $loaded_menu['title'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('title') ?>">
                    <div id="menuFormTitle"></div>
                </div>
            </div>
            <div class="pane" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('description') ?></div>
                <div class="form-group pane">
                    <textarea name="content" class="form-control"><?php !empty($loaded_menu) ? print $loaded_menu['content'] : '' ?></textarea>
                </div>
            </div>  
            <div class="pane" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('base_price') ?></div>
                <div class="form-group pane">
                    <input type="text" data-error="#menuFormBasePrice" name="base_price" value="<?php !empty($loaded_menu) ? print $loaded_menu['base_price'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('base_price') ?>">
                    <div id="menuFormBasePrice"></div>
                </div>
            </div> 
            <div class="pane" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('price_differ') ?></div>
                <div class="form-group pane">
                    <label class="pane-form-label"><input type="checkbox" <?php !empty($loaded_menu) && ($loaded_menu ['in_price'] > 0 || $loaded_menu['out_price'] > 0) ? print'checked="checked"' : '' ?>  id="menuPriceDiffer" onchange="ZamanEposCheckboxBlockHandler(this, 'menuPriceDifferBlock')">&nbsp;<?php echo $this->lang->line('yes') ?></label>
                </div>
            </div>    
            <div class="pane" id="menuPriceDifferBlock" style="<?php !empty($loaded_menu) && ($loaded_menu ['in_price'] > 0 || $loaded_menu['out_price'] > 0) ? print'display:block' : print 'display:none' ?>">
                <div class="pane">
                    <div class="pane-one-third text-right pane-form-label"><?php echo $this->lang->line('in') ?>&nbsp;</div>
                    <div class="form-group pane">
                        <input  type="text" data-error="#menuFormInPrice" name="in_price" value="<?php !empty($loaded_menu) ? print $loaded_menu['in_price'] : '' ?>" class="form-control" style="width: 100%" placeholder="<?php echo $this->lang->line('in') ?>">
                        <div id="menuFormInPrice"></div>
                    </div>
                </div>
                <div class="pane">
                    <div class="pane-one-third text-right pane-form-label"><?php echo $this->lang->line('out') ?>&nbsp;</div>
                    <div class="form-group pane">
                        <input type="text" data-error="#menuFormOutPrice" name="out_price" value="<?php !empty($loaded_menu) ? print $loaded_menu['out_price'] : '' ?>" class="form-control" style="width: 100%" placeholder="<?php echo $this->lang->line('out') ?>">
                        <div id="menuFormOutPrice"></div>
                    </div>
                </div>
            </div>
            <div class="pane" style="border: none;">
                <div class="pane text-uppercase">Print inside</div>
                <div class="form-group pane">
                    <label><input data-error="#menuFormPrintOption" type="radio" name="printat" value="5" <?php !empty($loaded_menu) && $loaded_menu['printat'] == 5 ? print 'checked="checked"' : '' ?>>&nbsp;Main Dish</label>
                    <label><input data-error="#menuFormPrintOption" type="radio" name="printat" value="1" <?php !empty($loaded_menu) && $loaded_menu['printat'] == 1 ? print 'checked="checked"' : '' ?>>&nbsp;Papadam & Chutney</label>
                    <label><input data-error="#menuFormPrintOption" type="radio" name="printat" value="2" <?php !empty($loaded_menu) && $loaded_menu['printat'] == 2 ? print 'checked="checked"' : '' ?>>&nbsp;Appetizer</label>
                    <label><input data-error="#menuFormPrintOption" type="radio" name="printat" value="3" <?php !empty($loaded_menu) && $loaded_menu['printat'] == 3 ? print 'checked="checked"' : '' ?>>&nbsp;Starters</label>
                    <label><input data-error="#menuFormPrintOption" type="radio" name="printat" value="4" <?php !empty($loaded_menu) && $loaded_menu['printat'] == 4 ? print 'checked="checked"' : '' ?>>&nbsp;Tandoori Dish</label>
                    <label><input data-error="#menuFormPrintOption" type="radio" name="printat" value="6" <?php !empty($loaded_menu) && $loaded_menu['printat'] == 6 ? print 'checked="checked"' : '' ?>>&nbsp;Kids Meals</label>
                    <label><input data-error="#menuFormPrintOption" type="radio" name="printat" value="7" <?php !empty($loaded_menu) && $loaded_menu['printat'] == 7 ? print 'checked="checked"' : '' ?>>&nbsp;Side Dishes</label>
                    <label><input data-error="#menuFormPrintOption" type="radio" name="printat" value="8" <?php !empty($loaded_menu) && $loaded_menu['printat'] == 8 ? print 'checked="checked"' : '' ?>>&nbsp;Sundries</label>
                    <label><input data-error="#menuFormPrintOption" type="radio" name="printat" value="9" <?php !empty($loaded_menu) && $loaded_menu['printat'] == 9 ? print 'checked="checked"' : '' ?>>&nbsp;Rice</label>
                    <label><input data-error="#menuFormPrintOption" type="radio" name="printat" value="10" <?php !empty($loaded_menu) && $loaded_menu['printat'] == 10 ? print 'checked="checked"' : '' ?>>&nbsp;Bread</label>
                    <label><input data-error="#menuFormPrintOption" type="radio" name="printat" value="11" <?php !empty($loaded_menu) && $loaded_menu['printat'] == 11 ? print 'checked="checked"' : '' ?>>&nbsp;Set Meals</label>
                    <label><input data-error="#menuFormPrintOption" type="radio" name="printat" value="12" <?php !empty($loaded_menu) && $loaded_menu['printat'] == 12 ? print 'checked="checked"' : '' ?>>&nbsp;English Dish</label>
                    <label><input data-error="#menuFormPrintOption" type="radio" name="printat" value="13" <?php !empty($loaded_menu) && $loaded_menu['printat'] == 13 ? print 'checked="checked"' : '' ?>>&nbsp;Desserts</label>
                    <label><input data-error="#menuFormPrintOption" type="radio" name="printat" value="14" <?php !empty($loaded_menu) && $loaded_menu['printat'] == 14 ? print 'checked="checked"' : '' ?>>&nbsp;Drinks</label>
                    <label><input data-error="#menuFormPrintOption" type="radio" name="printat" value="16" <?php !empty($loaded_menu) && $loaded_menu['printat'] == 16 ? print 'checked="checked"' : '' ?>>&nbsp;Kebab</label>
                    <label><input data-error="#menuFormPrintOption" type="radio" name="printat" value="17" <?php !empty($loaded_menu) && $loaded_menu['printat'] == 17 ? print 'checked="checked"' : '' ?>>&nbsp;Pizza</label>
                    <label><input data-error="#menuFormPrintOption" type="radio" name="printat" value="18" <?php !empty($loaded_menu) && $loaded_menu['printat'] == 18 ? print 'checked="checked"' : '' ?>>&nbsp;Noodles</label>
                    <label><input data-error="#menuFormPrintOption" type="radio" name="printat" value="19" <?php !empty($loaded_menu) && $loaded_menu['printat'] == 19 ? print 'checked="checked"' : '' ?>>&nbsp;Soup</label>
                    <label><input data-error="#menuFormPrintOption" type="radio" name="printat" value="20" <?php !empty($loaded_menu) && $loaded_menu['printat'] == 20 ? print 'checked="checked"' : '' ?>>&nbsp;Sandwiches</label>
                    <label><input data-error="#menuFormPrintOption" type="radio" name="printat" value="21" <?php !empty($loaded_menu) && $loaded_menu['printat'] == 21 ? print 'checked="checked"' : '' ?>>&nbsp;Burgers</label>
                    <label><input data-error="#menuFormPrintOption" type="radio" name="printat" value="22" <?php !empty($loaded_menu) && $loaded_menu['printat'] == 22 ? print 'checked="checked"' : '' ?>>&nbsp;Wrap</label>
                    <div id="menuFormPrintOption" class="text-center pane"></div>
                </div>
            </div> 
            <div class="pane" style="border: none;">
                <div class="tab-group">
                    <div class="tab-item" style="padding: 5px" onclick="resetForm('menuForm')"><?php echo $this->lang->line('clear_form_add_new') ?></div>
                    <div class="tab-item" style="padding: 5px" onclick="showItemOption('hide-menu-option')"><?php echo $this->lang->line('more_option') ?></div>
                </div>
            </div>
            <div class="pane hide-menu-option" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('assign_to') ?></div>
                <div class="pane form-group">
                    <label><input type="checkbox" name="breakfast" value="yes" <?php !empty($loaded_menu) && $loaded_menu['breakfast'] == 'yes' ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('breakfast') ?></label>
                    <label><input type="checkbox" name="launch" value="yes" <?php !empty($loaded_menu) && $loaded_menu['launch'] == 'yes' ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('launch') ?></label>
                    <label><input type="checkbox" name="dinner" value="yes" <?php !empty($loaded_menu) && $loaded_menu['dinner'] == 'yes' ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('dinner') ?></label>
                </div>
            </div>
            <div class="pane hide-menu-option" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('code') ?></div>
                <div class="form-group pane">
                    <input data-error="#menuFormCode" type="text" name="code" id="menuCode" value="<?php !empty($loaded_menu) ? print $loaded_menu['code'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('code') ?>">
                    <div class="clearfix" id="menuFormCode"></div>
                </div>
            </div>
            <div class="pane hide-menu-option" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('tax') ?>(<?php echo $this->lang->line('percent') ?>)</div>
                <div class="form-group pane">
                    <input type="text" data-error="#menuFormTax" name="tax"  value="<?php !empty($loaded_menu) ? print $loaded_menu['tax'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('tax') ?>">
                    <div class="clearfix" id="menuFormTax"></div>
                </div>
            </div> 
            <div class="pane hide-menu-option" style="border: none;">
                <div class="pane-one-third text-right pane-form-label"><?php echo $this->lang->line('plan') ?>&nbsp;</div>
                <div class="form-group pane">
                    <select class="form-control" name='tax_option' data-error="#menuFormTaxOption">
                        <option value='0' <?php !empty($loaded_menu) && $loaded_menu ['tax_option'] == '0' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('no_plan') ?></option>
                        <option value='4' <?php !empty($loaded_menu) && $loaded_menu ['tax_option'] == '4' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('menu_plan') ?></option>
                        <option value='3' <?php !empty($loaded_menu) && $loaded_menu ['tax_option'] == '3' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('category_plan') ?></option>
                        <option value='2' <?php !empty($loaded_menu) && $loaded_menu ['tax_option'] == '2' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('default_plan') ?></option>
                    </select>
                    <div class="clearfix" id="menuFormTaxOption"></div>
                </div>
            </div> 
            <div class="pane hide-menu-option" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('discount') ?>(<?php echo $this->lang->line('percent') ?>)</div>
                <div class="form-group pane">
                    <input type="text" data-error="#menuFormDiscount" name="discount" value="<?php !empty($loaded_menu) ? print $loaded_menu['discount'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('discount') ?>">
                    <div class="clearfix" id="menuFormDiscount"></div>
                </div>
            </div>     
            <div class="pane hide-menu-option" style="border: none;">
                <div class="pane-one-third text-right pane-form-label"><?php echo $this->lang->line('plan') ?>&nbsp;</div>
                <div class="form-group pane">
                    <select class="form-control" name='discount_option' data-error="#menuFormDiscountOption">
                        <option value='0' <?php !empty($loaded_menu) && $loaded_menu ['discount_option'] == '0' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('no_plan') ?></option>
                        <option value='5' <?php !empty($loaded_menu) && $loaded_menu ['discount_option'] == '5' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('menu_plan') ?></option>
                        <option value='4' <?php !empty($loaded_menu) && $loaded_menu ['discount_option'] == '4' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('category_plan') ?></option>
                        <option value='3' <?php !empty($loaded_menu) && $loaded_menu ['discount_option'] == '3' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('discount_plan') ?></option>
                        <option value='2' <?php !empty($loaded_menu) && $loaded_menu ['discount_option'] == '2' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('default_plan') ?></option>
                    </select>
                    <div class="clearfix" id="menuFormDiscountOption"></div>
                </div>
            </div> 
            <div class="pane hide-menu-option" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('show') ?></div>
                <div class="form-group pane">
                    <label class="pane-form-label"><input type="checkbox" name="inline" value="3" <?php !empty($loaded_menu) && $loaded_menu['inline'] == '3' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('in') ?></label>
                    <label class="pane-form-label"><input type="checkbox" name="online" value="3" <?php !empty($loaded_menu) && $loaded_menu['online'] == '3' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('out') ?></label>
                </div>
            </div>
            <div class="pane hide-menu-option" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('status') ?></div>
                <div class="form-group pane">
                    <label><input data-error="#menuFormStatus" type="radio" name="status" value="3" <?php !empty($loaded_menu) && $loaded_menu['status'] == 3 ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('active') ?></label>
                    <label><input data-error="#menuFormStatus" type="radio" name="status" value="2" <?php !empty($loaded_menu) && $loaded_menu['status'] == 2 ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('inactive') ?></label>
                    <div class="clearfix" id="menuFormStatus"></div>
                </div>
            </div>  
            <div class="pane hide-menu-option" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('is_featured') ?></div>
                <div class="form-group pane">
                    <label><input data-error="#menuFormFeatured" type="radio" name="featured" value="yes" <?php !empty($loaded_menu) && $loaded_menu['featured'] == 'yes' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('yes') ?></label>
                    <label><input data-error="#menuFormFeatured" type="radio" name="featured" value="no" <?php !empty($loaded_menu) && $loaded_menu['featured'] == 'no' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('no') ?></label>
                    <div class="clearfix" id="menuFormFeatured"></div>
                </div>
            </div>   

            <div class="pane hide-menu-option" style="border: none;">
                <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('image') ?></div>
                <div class="form-group pane">
                    <div class="block thumbnail text-center">
                        <?php if (!empty($loaded_menu) && trim($loaded_menu['image'])): ?>
                            <img src="<?php echo EPOS_UPLOAD_PATH . 'menu/' . $loaded_menu['image'] ?>" alt="<?php echo $loaded_menu['title'] ?>">
                            <span class="icon icon-trash text-right clearfix" onclick="deleteImage('<?php echo $loaded_menu['id'] ?>', 'image', '<?php echo $loaded_menu['image'] ?>', 'menu', './uploads/menu/', '<?php echo site_url('menu/deleteImage') ?>')">&nbsp;<?php echo $this->lang->line('remove') ?></span>
                        <?php endif; ?>
                    </div>
                    <input type="file" name="image" class="form-control">
                </div>
            </div>
            <div class="pane" style="border: none;">
                <div class="tab-group config-submit">
                    <button type="submit" onclick="menuForm('menuForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save_menu') ?></button>
                </div>
            </div>
            <?php echo form_close() ?>
        </div>
        <div class="clearfix item-group">
            <div class="accordion-wrapper">
                <?php if (!empty($loaded_category_menus)): ?>
                    <?php foreach ($loaded_category_menus as $lcm): ?>
                        <div class="tab">
                            <input id="<?php echo 'menu-tab-' . $lcm->id ?>" type="checkbox" name="tabs">
                            <label for="<?php echo 'menu-tab-' . $lcm->id ?>"><?php echo ucwords($lcm->title) ?></label>
                            <div class="tab-content">
                                <div class="tab-content-attr clearfix">
                                    <div class="pane" style="font-size: 12px;">
                                        <span><?php echo $this->lang->line('name') ?>:<a href="javascript:void(0)"><?php echo $lcm->title ?></a></span>,&nbsp;
                                        <span><?php echo $this->lang->line('status') ?>:<a href="javascript:void(0)"><?php echo $menuStatus[$lcm->status] ?></a></span>,&nbsp;
                                        <span><?php echo $this->lang->line('in') ?>:<a href="javascript:void(0)"><?php echo $menuOnline[$lcm->inline] ?></a></span>,&nbsp;
                                        <span><?php echo $this->lang->line('out') ?>:<a href="javascript:void(0)"><?php echo $menuOnline[$lcm->online] ?></a></span>,&nbsp;
                                        <span><?php echo $this->lang->line('base') ?>:<a href="javascript:void(0)"><?php echo to_currency($lcm->base_price) ?></a></span>,&nbsp;
                                        <span><?php echo $this->lang->line('in') ?>:<a href="javascript:void(0)"><?php echo to_currency($lcm->in_price) ?></a></span>,&nbsp;
                                        <span><?php echo $this->lang->line('out') ?>:<a href="javascript:void(0)"><?php echo to_currency($lcm->out_price) ?></a></span>,&nbsp;
                                        <span><?php echo $this->lang->line('tax') ?>:<a href="javascript:void(0)"><?php echo $lcm->tax ?></a></span>,&nbsp;
                                        <span><?php echo $this->lang->line('t_plan') ?>:<a href="javascript:void(0)"><?php echo $taxOption[$lcm->tax_option] ?></a></span>,&nbsp;
                                        <span><?php echo $this->lang->line('discount') ?>:<a href="javascript:void(0)"><?php echo $lcm->discount ?></a>%</span>,&nbsp;
                                        <span><?php echo $this->lang->line('d_plan') ?>:<a href="javascript:void(0)"><?php echo $DiscountOption[$lcm->discount_option] ?></a></span>
                                    </div>

                                </div>
                                <div class="pane">
                                    <div class="tab-group">
                                        <div class="tab-item" style="padding: 5px;" onclick="zamanEposNavigator('', '<?php echo site_url('menu/index/' . $lcm->category . '/' . $lcm->id) ?>', 'menuIndex')"><span class="icon icon-pencil"></span></div>
                                        <div class="tab-item" style="padding: 5px;" onclick="sortMenu('<?php echo $lcm->id ?>', '<?php echo $lcm->position ?>', '<?php echo 'down' ?>')"><?php echo $this->lang->line('order') ?>&nbsp;<span class="icon icon-up-open-big"></span></div>
                                        <div class="tab-item" style="padding: 5px;" onclick="sortMenu('<?php echo $lcm->id ?>', '<?php echo $lcm->position ?>', '<?php echo 'up' ?>')"><?php echo $this->lang->line('order') ?>&nbsp;<span class="icon icon-down-open-big"></span></div>
                                        <?php if ($this->session->userdata('group') <= 4): ?>
                                            <div class="tab-item" style="padding: 5px;" onclick="deleteMenu('<?php echo $lcm->id ?>', '<?php echo $lcm->title ?>')"><span class="icon icon-trash"></span></div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <?php if (count_rows('menuselection', array('menu' => $lcm->id)) <= 0): ?>
                                    <div class="attr-block clearfix">
                                        <div class="caption"><?php echo $this->lang->line('additional_attribute') ?></div>
                                        <?php if ($lcm->ctop == '2'): ?>
                                            <div class="text-center pane-one-fourth">
                                                <div class="checkbox"><label><input type="checkbox" <?php $lcm->has_topping == 3 ? print'checked="checked"' : '' ?>  class="hook-checkbox" id="menuToppings-<?php echo $lcm->id ?>" onchange="menuAttr(this.id, '<?php echo $lcm->id ?>', 'menu')"><?php echo $this->lang->line('toppings') ?></span></label></div>
                                                <button class="btn btn-positive icon icon-tools" <?php $lcm->has_topping == 3 ? '' : print'style="display: none;"' ?> id="menuToppings-<?php echo $lcm->id ?>-Btn" onclick="attrPopup('menuToppingPopup', '75%', '<?php echo $lcm->category ?>', '<?php echo $lcm->id ?>', '0', '0', '<?php echo site_url('menu/topping') ?>')"><?php echo $this->lang->line('manage') ?></button>
                                            </div>
                                        <?php else: ?>
                                            <div class="text-center pane-one-fourth">
                                                <div class="checkbox"><label><input type="checkbox" <?php $lcm->has_topping == 3 ? print'checked="checked"' : $lcm->deal_type == '0' || $lcm->deal_type == '3' ? '' : print 'disabled="disabled"'  ?> class="hook-checkbox" id="menuToppings-<?php echo $lcm->id ?>" onchange="menuAttr(this.id, '<?php echo $lcm->id ?>', 'menu')"><?php echo $this->lang->line('toppings') ?></span></label></div>
                                                <button class="btn btn-positive icon icon-tools" <?php $lcm->has_topping == 3 ? '' : print'style="display: none;"' ?> id="menuToppings-<?php echo $lcm->id ?>-Btn" onclick="attrPopup('menuToppingPopup', '75%', '<?php echo $lcm->category ?>', '<?php echo $lcm->id ?>', '0', '0', '<?php echo site_url('menu/topping') ?>')"><?php echo $this->lang->line('manage') ?></button>
                                            </div>
                                        <?php endif; ?>
                                        <?php if ($lcm->cmod == '2'): ?>
                                            <div class="text-center pane-one-fourth">
                                                <div class="checkbox"><label><input type="checkbox" <?php $lcm->has_modifier == 3 ? print'checked="checked"' : '' ?> class="hook-checkbox" id="menuModifier-<?php echo $lcm->id ?>" onchange="menuAttr(this.id, '<?php echo $lcm->id ?>', 'menu')"><?php echo $this->lang->line('modifiers') ?></label></div>
                                                <button class="btn btn-positive icon icon-tools" <?php $lcm->has_modifier == 3 ? '' : print'style="display: none;"' ?>  id="menuModifier-<?php echo $lcm->id ?>-Btn" onclick="attrPopup('menuModifierPopup', '75%', '<?php echo $lcm->category ?>', '<?php echo $lcm->id ?>', '0', '0', '<?php echo site_url('menu/itemmodifier') ?>')"><?php echo $this->lang->line('manage') ?></button>
                                            </div>
                                        <?php else: ?>
                                            <div class="text-center pane-one-fourth">
                                                <div class="checkbox"><label><input type="checkbox" <?php $lcm->has_modifier == 3 ? print'checked="checked"' : $lcm->deal_type == '0' || $lcm->deal_type == '3' ? '' : print 'disabled="disabled"'  ?> class="hook-checkbox" id="menuModifier-<?php echo $lcm->id ?>" onchange="menuAttr(this.id, '<?php echo $lcm->id ?>', 'menu')"><?php echo $this->lang->line('modifiers') ?></label></div>
                                                <button class="btn btn-positive icon icon-tools" <?php $lcm->has_modifier == 3 ? '' : print'style="display: none;"' ?>  id="menuModifier-<?php echo $lcm->id ?>-Btn" onclick="attrPopup('menuModifierPopup', '75%', '<?php echo $lcm->category ?>', '<?php echo $lcm->id ?>', '0', '0', '<?php echo site_url('menu/itemmodifier') ?>')"><?php echo $this->lang->line('manage') ?></button>
                                            </div>
                                        <?php endif; ?>
                                        <div class="text-center pane-one-fourth">
                                            <div class="checkbox"><label><input type="checkbox" <?php $lcm->deal_type == 3 ? print'checked="checked"' : $lcm->deal_type == '0' || $lcm->deal_type == '3' ? '' : print 'disabled="disabled"'  ?> class="hook-checkbox" id="fixedDeal-<?php echo $lcm->id ?>" onchange="menuAttr(this.id, '<?php echo $lcm->id ?>', 'menu')"><?php echo $this->lang->line('fixed_deal') ?></label></div>
                                            <button class="btn btn-positive icon icon-tools" <?php $lcm->deal_type == 3 ? '' : print'style="display: none;"' ?> id="fixedDeal-<?php echo $lcm->id ?>-Btn" onclick="attrPopup('menuFixedDealPopup', '75%', '<?php echo $lcm->category ?>', '<?php echo $lcm->id ?>', '0', '0', '<?php echo site_url('menu/fixeddeal') ?>')"><?php echo $this->lang->line('manage') ?></button>
                                        </div>
                                        <div class="text-center pane-one-fourth">
                                            <div class="checkbox"><label><input type="checkbox" <?php $lcm->deal_type == 2 ? print'checked="checked"' : $lcm->has_topping == '0' && $lcm->has_modifier == '0' && ($lcm->deal_type == '2' || $lcm->deal_type == '0') ? '' : print 'disabled="disabled"'  ?> class="hook-checkbox" id="customDeal-<?php echo $lcm->id ?>" onchange="menuAttr(this.id, '<?php echo $lcm->id ?>', 'menu')"><?php echo $this->lang->line('custom_deal') ?></label></div>
                                            <button class="btn btn-positive icon icon-tools" <?php $lcm->deal_type == 2 ? '' : print'style="display: none;"' ?> id="customDeal-<?php echo $lcm->id ?>-Btn" onclick="attrPopup('menuCustomDealPopup', '80%', '<?php echo $lcm->category ?>', '<?php echo $lcm->id ?>', '0', '0', '<?php echo site_url('menu/customdeal') ?>')"><?php echo $this->lang->line('manage') ?></button>
                                        </div>
                                        <div class="loader loader-<?php echo $lcm->id ?>" style="display: none;"></div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                    <?php if ($this->session->userdata('group') === '2'): ?>
                        <div class="tab-group config-submit">
                            <button onclick="deleteAllMenus('<?php echo $loaded_category['id'] ?>', '<?php echo $loaded_category['title'] . ' - ' . $this->lang->line('menu') ?>')"><span class="icon icon-trash"></span>&nbsp;<?php echo sprintf($this->lang->line('delete_all_menus'), $loaded_category['title']) ?></button>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>

    </div>
    <script type="text/javascript">
        function menuForm(formId) {
            if (!$('.page-loader').is(":visible")) {
                $('#' + formId).validate({
                    submitHandler: function () {
                        var myform = document.getElementById(formId);
                        var formdata = new FormData(myform);
                        if (checkInternetConnection()) {
                            $.ajax({
                                url: $('#' + formId).attr('action'),
                                data: formdata,
                                cache: false,
                                processData: false,
                                contentType: false,
                                type: 'POST',
                                dataType: 'json',
                                beforeSend: function () {
                                    $('.page-loader').show();
                                },
                                success: function (response) {
                                    if (response.status) {
                                        $('.page-loader').hide();
                                        zamanEposNavigator('', '<?php echo site_url('menu/index/') ?>' + response.category + '/' + response.menu, 'menuIndex');
                                    } else {
                                        warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                    }
                                }
                            });
                        } else {
                            warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                        }
                    },
                    errorClass: "has-error",
                    highlight: function (e) {
                        $(e).closest('.form-group').addClass('has-error');
                    },
                    unhighlight: function (e) {
                        $(e).closest('.form-group').removeClass('has-error');
                    },
                    rules: {
                        title: {
                            required: true,
                            remote: {
                                url: "<?php echo site_url('menu/checkme') ?>",
                                type: "post",
                                data: {
                                    value: function () {
                                        return $("#menuTitle").val();
                                    },
                                    column: 'title',
                                    old: function () {
                                        if ($('#oldMenuTitle').length > 0) {
                                            return $('#oldMenuTitle').val();
                                        } else {
                                            return 'none';
                                        }
                                    },
                                    update: function () {
                                        if ($('#updateMenu').length > 0) {
                                            return 'yes';
                                        } else {
                                            return 'no';
                                        }
                                    },
                                    category: '<?php echo $loaded_category['id'] ?>'
                                }
                            }
                        },
                        code: {
                            number: true,
                            min: 1,
                            max: 999,
                            remote: {
                                url: "<?php echo site_url('menu/checkme') ?>",
                                type: "post",
                                data: {
                                    value: function () {
                                        return $("#menuCode").val();
                                    },
                                    column: 'code',
                                    old: function () {
                                        if ($('#oldMenuCode').length > 0) {
                                            return $('#oldMenuCode').val();
                                        } else {
                                            return 'none';
                                        }
                                    },
                                    update: function () {
                                        if ($('#updateMenu').length > 0) {
                                            return 'yes';
                                        } else {
                                            return 'no';
                                        }
                                    },
                                    category: '<?php echo $loaded_category['id'] ?>'
                                }
                            }
                        },
                        base_price: {number: true, min: 0, required: '#menuPriceDiffer:unchecked'},
                        in_price: {number: true, min: 0, required: '#menuPriceDiffer:checked'},
                        out_price: {number: true, min: 0, required: '#menuPriceDiffer:checked'},
                        tax: {number: true, min: 0},
                        tax_option: {required: true, number: true, min: 0, max: 4},
                        discount: {number: true, min: 0},
                        discount_option: {number: true, min: 0, max: 5},
                        printat: {required: true}
                    },
                    messages: {
                        title: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('title')) ?>',
                        code: '<?php echo sprintf($this->lang->line('invalid_value'), $this->lang->line('title')) ?>',
                        base_price: '<?php echo sprintf($this->lang->line('item_required_in_number'), $this->lang->line('base_price')) ?>',
                        in_price: '<?php echo sprintf($this->lang->line('item_required_in_number'), $this->lang->line('in')) ?>',
                        out_price: '<?php echo sprintf($this->lang->line('item_required_in_number'), $this->lang->line('out')) ?>',
                        tax: '<?php echo sprintf($this->lang->line('invalid_value'), $this->lang->line('tax')) ?>',
                        tax_option: '<?php echo sprintf($this->lang->line('invalid_value'), $this->lang->line('tax_option')) ?>',
                        discount: '<?php echo sprintf($this->lang->line('invalid_value'), $this->lang->line('discount')) ?>',
                        discount_option: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('discount_option')) ?>',
                        online: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('online')) ?>',
                        status: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('status')) ?>',
                        printat: 'please select print inside option'
                    },
                    errorPlacement: function (error, element) {
                        errorPlacement(error, element);
                    }
                });
            }
        }
        function sortMenu(id, position, func) {
            if (!$('.page-loader').is(":visible")) {
                if (checkInternetConnection()) {
                    $.ajax({
                        url: '<?php echo site_url('menu/sortme') ?>',
                        type: 'post',
                        dataType: 'json',
                        data: {id: id, position: position, func: func},
                        beforeSend: function (xhr) {
                            $('.page-loader').show();
                        },
                        success: function (response) {
                            $('.page-loader').hide();
                            if (response.status) {
                                zamanEposNavigator('', '<?php echo site_url('menu/index/' . $loaded_category['id']) ?>', 'menuIndex');
                            } else {
                                warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                            }
                        }
                    });
                } else {
                    warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                }
            }
        }
        function deleteMenu(id, title) {
            if (!$('.page-loader').is(":visible")) {
                $.confirm({
                    title: '<?php echo $this->lang->line('warning') ?>',
                    message: '<?php echo $this->lang->line('delete_warning_message') ?>' + title,
                    buttons: {
                        '<span class="icon icon-check">&nbsp;<?php echo $this->lang->line('yes') ?></span>': {
                            'class': 'positive',
                            'action': function () {
                                if (checkInternetConnection()) {
                                    $.ajax({
                                        url: '<?php echo site_url('menu/delete/') ?>' + id,
                                        type: 'GET',
                                        dataType: 'json',
                                        beforeSend: function (xhr) {
                                            $('.page-loader').show();
                                        },
                                        success: function (response) {
                                            $('.page-loader').hide();
                                            if (response.status) {
                                                zamanEposNavigator('', '<?php echo site_url('menu/index/' . $loaded_category['id']) ?>', 'menuIndex');
                                            } else {
                                                warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                                            }
                                        }
                                    });
                                } else {
                                    warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                                }
                            }
                        },
                        '<span class="icon icon-cancel">&nbsp;<?php echo $this->lang->line('no') ?></span>': {
                            'class': 'negative',
                            'action': function () {
                            }
                        }
                    }
                });
            }
        }
        function deleteAllMenus(id, title) {
            if (!$('.page-loader').is(":visible")) {
                $.confirm({
                    title: '<?php echo $this->lang->line('warning') ?>',
                    message: '<?php echo $this->lang->line('delete_warning_message_all') ?>' + title,
                    buttons: {
                        '<span class="icon icon-check">&nbsp;<?php echo $this->lang->line('yes') ?></span>': {
                            'class': 'positive',
                            'action': function () {
                                if (checkInternetConnection()) {
                                    $.ajax({
                                        url: '<?php echo site_url('menu/deleteAll/') ?>' + id,
                                        type: 'GET',
                                        dataType: 'json',
                                        beforeSend: function (xhr) {
                                            $('.page-loader').show();
                                        },
                                        success: function (response) {
                                            $('.page-loader').hide();
                                            if (response.status) {
                                                zamanEposNavigator('', '<?php echo site_url('menu/index/' . $loaded_category['id']) ?>', 'menuIndex');
                                            } else {
                                                warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                                            }
                                        }
                                    });
                                } else {
                                    warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                                }
                            }
                        },
                        '<span class="icon icon-cancel">&nbsp;<?php echo $this->lang->line('no') ?></span>': {
                            'class': 'negative',
                            'action': function () {}
                        }
                    }
                });
            }
        }
    </script>
<?php endif; ?>