<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Nattr_Model extends MY_Model {

    function __construct() {
        parent::__construct();
        $this->_order_by = 'position';
        $this->_primary_key = 'id';
        $this->_table_name = 'nattr';
    }

    public function save($data, $id = NULL) {
        if ($id !== NULL && $id > 0) {
            $data['updated_by'] = $this->session->userdata('owner');
        }
        return parent::save($data, $id);
    }

    public function checkme($column, $value, $update = 'no') {
        $category = $this->input->post('category');
        $old = $this->input->post('old');
        if ($update == 'yes') {
            if (trim(strtolower($old)) === trim(strtolower($value))) {
                return false;
            } else {
                return $this->attrtitleexist($column, $value, $category);
            }
        } else {
            return $this->attrtitleexist($column, $value, $category);
        }
    }

    public function attrtitleexist($column, $value, $category) {
        $this->db->where($column, $value);
        $this->db->where('nattrcategory', $category);
        $this->db->where('branch', $this->session->userdata('branch'));
        return $this->db->count_all_results($this->_table_name) > 0;
    }

    public function checkcategory($column, $value, $update = 'no') {
        if ($update == 'yes') {
            $old = $this->input->post('old');
            if (trim(strtolower($old)) === trim(strtolower($value))) {
                return false;
            } else {
                return $this->doesNattrCategoryExist('nattrcategory', $column, $value);
            }
        } else {
            return $this->doesNattrCategoryExist('nattrcategory', $column, $value);
        }
    }

     private function doesNattrCategoryExist($table, $column, $value) {
        return $this->db->where(array($column => $value, 'branch' => $this->session->userdata('branch')))->count_all_results($table) > 0;
    }
    public function savecategory($data, $id = NULL) {
        $this->_order_by = 'position';
        $this->_primary_key = 'id';
        $this->_table_name = 'nattrcategory';
        if ($id !== NULL && $id > 0) {
            $data['updated_by'] = $this->session->userdata('owner');
        }
        return $this->save($data, $id);
    }

}
