<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Menu_Model extends MY_Model {

    function __construct() {
        parent::__construct();
        $this->_order_by = 'position';
        $this->_primary_key = 'id';
        $this->_table_name = 'menu';
    }

    public function checkme($column, $value, $update = 'no') {
        $category = $this->input->post('category');
        $old = $this->input->post('old');
        if ($update == 'yes') {
            if (trim(strtolower($old)) === trim(strtolower($value))) {
                return false;
            } else {
                if ($column == 'title') {
                    return $this->menutitleexist($column, $value, $category);
                }
                if ($column == 'code') {
                    return $this->exists($this->_table_name, $column, $value);
                }
            }
        } else {
            if ($column == 'title') {
                return $this->menutitleexist($column, $value, $category);
            }
            if ($column == 'code') {
                return $this->exists($this->_table_name, $column, $value);
            }
        }
    }

    public function menutitleexist($column, $value, $category) {
        $this->db->where($column, $value);
        $this->db->where('category', $category);
        $this->db->where('branch', $this->session->userdata('branch'));
        return $this->db->count_all_results($this->_table_name) > 0;
    }

    public function save($data, $id = NULL) {
        if ($id !== NULL && $id > 0) {
            $data['updated_by'] = 1;
        }
        return parent::save($data, $id);
    }

    public function savetoppingshead($data, $id = NULL) {
        $this->_order_by = '';
        $this->_primary_key = 'id';
        $this->_table_name = 'menuattrcategory';
        if ($id !== NULL && $id > 0) {
            $data['updated_by'] = 1;
        }
        return parent::save($data, $id);
    }

    public function savemenutopping($data, $id = NULL) {
        $this->_order_by = '';
        $this->_primary_key = 'id';
        $this->_table_name = 'menuattr';
        if ($id !== NULL && $id > 0) {
            $data['updated_by'] = 1;
        }
        return parent::save($data, $id);
    }

    public function savemodifiershead($data, $id = NULL) {
        $this->_order_by = '';
        $this->_primary_key = 'id';
        $this->_table_name = 'modifiercategory';
        if ($id !== NULL && $id > 0) {
            $data['updated_by'] = 1;
        }
        return parent::save($data, $id);
    }

    public function savemenumodifier($data, $id = NULL) {
        $this->_order_by = '';
        $this->_primary_key = 'id';
        $this->_table_name = 'modifiermenu';
        if ($id !== NULL && $id > 0) {
            $data['updated_by'] = 1;
        }
        return parent::save($data, $id);
    }

    public function savemenuset($data, $id = NULL) {
        $this->_order_by = '';
        $this->_primary_key = 'id';
        $this->_table_name = 'menuset';
        if ($id !== NULL && $id > 0) {
            $data['updated_by'] = $this->session->userdata('owner');
        } else {
            $data['created_by'] = $this->session->userdata('owner');
        }
        return parent::save($data, $id);
    }

    public function savemenusetitems($data, $id = NULL) {
        $this->_order_by = '';
        $this->_primary_key = 'id';
        $this->_table_name = 'menusetitem';
        if ($id !== NULL && $id > 0) {
            $data['updated_by'] = $this->session->userdata('owner');
        } else {
            $data['branch']=$this->session->userdata('branch'); 
            $data['created_by'] = $this->session->userdata('owner');
        }
        return parent::save($data, $id);
    }

    public function deleteMenu($id) {
        return $this->delete($id);
    }

}
