<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Category_Model extends MY_Model {

    function __construct() {
        parent::__construct();
        $this->_order_by = 'position';
        $this->_primary_key = 'id';
        $this->_table_name = 'menucategory';
    }

    public function checkme($column, $value, $update = 'no') {
        if ($update == 'yes') {
            $old = $this->input->post('old');
            if (trim(strtolower($old)) === trim(strtolower($value))) {
                return false;
            } else {
                return $this->doesCategoryExist($this->_table_name, $column, $value);
            }
        } else {
            return $this->doesCategoryExist($this->_table_name, $column, $value);
        }
    }

    private function doesCategoryExist($table, $column, $value) {
        return $this->db->where(array($column => $value, 'branch' => $this->session->userdata('branch')))->count_all_results($table) > 0;
    }

    public function save($data, $id = NULL) {
        if ($id !== NULL && $id > 0) {
            $data['updated_by'] = 1;
        }
        return parent::save($data, $id);
    }

    public function deleteCategory($id) {
        return $this->delete($id);
    }

}
