<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Modifier extends Epos_Template {

    private $branch = 0;

    function __construct() {
        parent::__construct();
        $this->load->model('Modifier_Model');
        if ($this->Modifier_Model->isThisUserAnEposLogger() && (($this->cookies && !empty($this->cookies)) || ($this->session->userdata('group') == 2))) {
            $this->branch = $this->session->userdata('branch');
            return true;
        } else {
            redirect('user/login/index/' . $this->session->userdata('branch') . '/' . $this->session->userdata('team'));
        }
    }

    public function index($id = null) {
        $data['modifiers'] = $this->Modifier_Model->get_list('modifier', array('branch' => $this->session->userdata('branch')), null, null, 0, 'id', 'ASC')->result();
        $data['refresh'] = site_url('menu/modifier');
        if ($id && (int) $id > 0) {
            $data['refresh'] = site_url('menu/modifier/' . $id);
            $data['loaded_modifier'] = $this->Modifier_Model->get_single('modifier', array('id' => trim($id)))->row_array();
        }
        $this->load->view('menu/modifier/index', $data, false);
    }

    public function save() {
        $data = $this->preparePostedData();
        $insert_id = null;
        $result = true;
        if (!isset($data['id']) || $data['id'] == NULL) {
            $data['created_by'] = $this->session->userdata('owner');
            $data['branch'] = $this->session->userdata('branch');
            $data['status'] = 3;
            $insert_id = $this->Modifier_Model->save($data, NULL);
            if ($insert_id) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('name')) . ' has added  modifier ' . $data['title']
                );
                $this->Modifier_Model->posactivity($activity);
            }
            $result = $insert_id ? $this->Modifier_Model->save(array('position' => $insert_id), $insert_id) : false;
        } else {
            $id = $data['id'];
            unset($data['id']);
            $insert_id = $this->Modifier_Model->save($data, $id);
            if ($insert_id) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('name')) . ' has updated  modifier ' . $data['title']
                );
                $this->Modifier_Model->posactivity($activity);
            }
        }
        if ($insert_id && $this->config->item('znotifysystemupdate') === 'yes') {
            $this->Modifier_Model->notifyupdate('zamanDbEposModifier');
        }
        $message = $insert_id && $result ? $this->lang->line('data_saved_successfully') : $this->lang->line('data_saving_failed');
        echo json_encode(array('status' => $insert_id && $result, 'message' => $message, 'category' => $insert_id));
    }

    public function checkme() {
        $column = $this->input->post('column');
        $value = $this->input->post('value');
        $update = $this->input->post('update');
        $result = $this->Modifier_Model->checkme($column, $value, $update);
        if ($result) {
            echo json_encode(sprintf($this->lang->line('item_already_taken'), $value));
        } else {
            echo json_encode(true);
        }
    }

    public function sortme() {
        $func = $this->input->post('func');
        $id = $this->input->post('id');
        $position = $this->input->post('position');
        $newPosition = $position;
        if ($func == 'up') {
            $newPosition = $position + 1;
        }
        if ($func == 'down' && $position > 1) {
            $newPosition = $position - 1;
        }
        $MinMax = $this->Modifier_Model->get_min_max('modifier', 'position')->row();
        if (true === in_array($newPosition, range($MinMax->min, $MinMax->max))) {
            $s1 = $this->db->update('menucategory', array('position' => $position), array('position' => $newPosition));
            $s2 = $this->db->update('menucategory', array('position' => $newPosition), array('id' => $id));
            if ($s1 && $s2 && $this->config->item('znotifysystemupdate') === 'yes') {
                $this->Modifier_Model->notifyupdate('zamanDbEposModifier');
            }
            echo json_encode(array('status' => $s1 && $s2));
        }
    }

}
