<div style="display: none;">
    <div id="stripePaymentContentForm">
        <div class="popup-header toolbar-header">
            <div class="popup-title">Card details</div>
            <div class="popup-close-btn" onclick="zamanEposPopupcloser()"><span class="icon icon-cancel"></span></div>
        </div>
        <div class="popup-content">
            <form action="/charge" method="post" id="payment-form">
                <div class="form-row">
                    <label for="card-element">
                        Credit or debit card
                    </label>
                    <div id="card-element">
                        <!-- A Stripe Element will be inserted here. -->
                    </div>
                    <!-- Used to display form errors. -->
                    <div id="card-errors" role="alert"></div>
                </div>
                <button>Submit Payment</button>
            </form>
        </div>
    </div>
</div>
<script>
    function stripePaymentCollectorPopup() {
        $.colorbox({
            inline: true,
            scrolling: false,
            href: "#stripePaymentContentForm",
            width: '290px',
            maxWidth: "100%",
            height: 'auto',
            open: true,
            closeButton: false,
            transition: 'none',
            overlayClose: false,
            className: 'transparent-overlay',
            onOpen: function () {
            },
            onLoad: function () {

            },
            onComplete: function () {
                var stripe = Stripe('pk_test_g6do5S237ekq10r65BnxO6S0');
                var elements = stripe.elements();
                var style = {
                    base: {
                        color: '#32325d',
                        lineHeight: '18px',
                        fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
                        fontSmoothing: 'antialiased',
                        fontSize: '16px',
                        '::placeholder': {
                            color: '#aab7c4'
                        }
                    },
                    invalid: {
                        color: '#fa755a',
                        iconColor: '#fa755a'
                    }
                };
                var card = elements.create('card', {style: style});
                card.mount('#card-element');
                card.addEventListener('change', function (event) {
                    var displayError = document.getElementById('card-errors');
                    if (event.error) {
                        displayError.textContent = event.error.message;
                    } else {
                        displayError.textContent = '';
                    }
                });
                var form = document.getElementById('payment-form');
                form.addEventListener('submit', function (event) {
                    event.preventDefault();

                    stripe.createToken(card).then(function (result) {
                        if (result.error) {
                            var errorElement = document.getElementById('card-errors');
                            errorElement.textContent = result.error.message;
                        } else {
                            stripeTokenHandler(result.token);
                        }
                    });
                });
            },
            onCleanup: function () {
            },
            onClosed: function () {

            }
        });
    }
</script>
<style>
    .StripeElement {
        background-color: white;
        height: 40px;
        padding: 10px 12px;
        border-radius: 4px;
        border: 1px solid transparent;
        box-shadow: 0 1px 3px 0 #e6ebf1;
        -webkit-transition: box-shadow 150ms ease;
        transition: box-shadow 150ms ease;
    }

    .StripeElement--focus {
        box-shadow: 0 1px 3px 0 #cfd7df;
    }

    .StripeElement--invalid {
        border-color: #fa755a;
    }

    .StripeElement--webkit-autofill {
        background-color: #fefde5 !important;
    }
</style>