<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane content-configuration">
            <div class="caption">
                <?php $this->load->view('employee/nav') ?>
            </div>
            <?php echo form_open('employee/saveManager', array('id' => 'employeeManagerForm')); ?>
            <div class="manager-entry-block">
                <div class="pane-one-half"> 
                    <div class="form-group">
                        <label><?php echo $this->lang->line('add_new_manager') ?></label>
                        <?php if (!empty($thisManager)): ?>
                            <input type="hidden" name="id" value='<?php echo $thisManager['id'] ?>' />
                            <input type="hidden" id="updateDepartmentTitle" value="yes">
                            <input type="hidden" id="oldDepartmentTitle" value="<?php echo $thisManager['title'] ?>">
                            <input name="title"  id="departmentTitle" value="<?php echo $thisManager['title'] ?>" type="text" class="form-control" placeholder="Manager Name">
                        <?php else: ?>
                            <input name="title" id="departmentTitle" type="text" class="form-control" placeholder="Manager Name">
                        <?php endif; ?>
                    </div>
                </div>

                <div class="pane-one-half"> 
                    <div class="form-group">
                        <label><?php echo $this->lang->line('assign_department') ?></label>
                        <select name="dept" class="form-control" style="padding:6.5px 0px;">
                            <option><?php echo $this->lang->line('select') ?></option>
                            <?php if (!empty($departments)): ?>
                                <?php foreach ($departments as $aDept): ?>
                                    <option value="<?php echo $aDept->id ?>" <?php (isset($thisManager) && $aDept->id === $thisManager['dept']) ? print 'selected="selected"' : '' ?>><?php echo $aDept->title ?></option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                    </div>
                </div>
            </div>    
            <div class="tab-group config-submit">
                <button type="submit" onclick="saveManager('employeeManagerForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
            </div>
            <?php echo form_close(); ?>


            <table class="report-table text-center">
                <thead class="table-bg">
                    <tr>
                        <th><?php echo $this->lang->line('id') ?></th>
                        <th><?php echo $this->lang->line('manager') . ' ' . $this->lang->line('name') ?></th>
                        <th><?php echo $this->lang->line('department') . ' ' . $this->lang->line('name') ?></th>
                        <?php if ($this->session->userdata('group') <= 3): ?>
                            <th><?php echo $this->lang->line('branch') . ' ' . $this->lang->line('name') ?></th>
                        <?php endif; ?>
                        <th><?php echo $this->lang->line('edit') ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($managers)): ?>
                        <?php $index = 1; ?>
                        <?php foreach ($managers as $aDeptManager): ?>
                            <tr>
                                <td><?php echo $index ?></td>
                                <td><?php echo $aDeptManager->title ?></td>
                                <td><?php echo get_title('employeedept', array('id' => $aDeptManager->dept)) ?></td>
                                <?php if ($this->session->userdata('group') <= 3): ?>
                                    <td><?php echo get_title('branch', array('id' => $aDeptManager->branch)) ?></td>
                                <?php endif; ?>
                                <td><span class="icon icon-pencil" onclick="zamanEposNavigator('', '<?php echo site_url('employee/manager/' . $aDeptManager->id) ?>', '')"></span></td>
                            </tr>
                            <?php $index++ ?>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="<?php $this->session->userdata('group') <= '3' ? print 4 : print 3 ?>"><?php echo sprintf($this->lang->line('not_found'), $this->lang->line('manager')) ?></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
            <div class="setting-general-keyboard text-center"></div>
            <div class="clearfix padded-top-more text-right"><span class="icon icon-keyboard btn-keyboard-close" onclick="zamanToogleEposVirtualKeyboard('setting-general-keyboard')">&nbsp;<?php echo $this->lang->line('open_virtual_keyboard') ?></span></div>
        </div>
    </div>
</div>
<?php $this->load->view('settings/partials/footer') ?>
<script type="text/javascript">
    function saveManager(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                $('.page-loader').hide();
                                if (response.status) {
                                    zamanEposNavigator('', '<?php echo site_url('employee/manager') ?>', '');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                }
                            }
                        });
                    } else {
                        warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                    }
                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                ignore: ":hidden",
                rules: {
                    title: {
                        required: true,
                        alphanumeric: true,
                        remote: {
                            url: "<?php echo site_url('employee/checkManager') ?>",
                            type: "post",
                            data: {
                                value: function () {
                                    return $("#departmentTitle").val();
                                },
                                column: 'title',
                                old: function () {
                                    if ($('#oldDepartmentTitle').length > 0) {
                                        return $('#oldDepartmentTitle').val();
                                    } else {
                                        return 'none';
                                    }
                                },
                                update: function () {
                                    if ($('#updateDepartmentTitle').length > 0) {
                                        return 'yes';
                                    } else {
                                        return 'no';
                                    }
                                }
                            }
                        }
                    },
                    dept: {required: true, number: true, min: 1},
                    branch: {required: true, number: true, min: 1}
                },
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
</script>