<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane content-configuration">
            <div class="caption">
                <?php $this->load->view('employee/nav') ?>
            </div>
            <?php echo form_open('employee/saveEmployee', array('id' => 'employeeForm')); ?>
            <?php if (isset($thisEmployee) && !empty($thisEmployee)): ?>
                <input type="hidden" name="id" value="<?php echo $thisEmployee['id'] ?>"/>
            <?php endif; ?>
            <div class="employee-add-block">
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('first_name') ?></label>
                            <input name="first_name" type="text" value="<?php isset($thisEmployee) ? print $thisEmployee['first_name'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('first_name') ?>">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('last_name') ?></label>
                            <input name="last_name"  value="<?php isset($thisEmployee) ? print $thisEmployee['last_name'] : '' ?>" type="text" class="form-control" placeholder="<?php echo $this->lang->line('last_name') ?>">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('gender') ?></label>
                            <select name="gender" class="form-control">
                                <option><?php echo $this->lang->line('select') ?></option>
                                <option value="Male" <?php isset($thisEmployee) && $thisEmployee['gender'] === 'Male' ? print 'selected="selected"' : '' ?>>Male</option>
                                <option value="Female" <?php isset($thisEmployee) && $thisEmployee['gender'] === 'Female' ? print 'selected="selected"' : '' ?>>Female</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('dob') ?></label>
                            <input name="dob" value="<?php isset($thisEmployee) ? print $thisEmployee['dob'] : '' ?>" type="text" class="form-control" id="employeeDateOfBirth" placeholder="<?php echo $this->lang->line('dob') ?>">
                        </div>
                    </div>
                </div>
                <div class="clearfix"></div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('nid') ?></label>
                            <input name="nid" value="<?php isset($thisEmployee) ? print $thisEmployee['nid'] : '' ?>" type="text" class="form-control" placeholder="<?php echo $this->lang->line('nid') ?>">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('email_address') ?></label>
                            <input name="email" value="<?php isset($thisEmployee) ? print $thisEmployee['email'] : '' ?>" type="text" class="form-control" placeholder="<?php echo $this->lang->line('email_address') ?>">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('phone') ?></label>
                            <input name="phone" value="<?php isset($thisEmployee) ? print $thisEmployee['phone'] : '' ?>" type="text" class="form-control" placeholder="<?php echo $this->lang->line('phone') ?>">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('mobile') ?></label>
                            <input name="mobile" value="<?php isset($thisEmployee) ? print $thisEmployee['mobile'] : '' ?>" type="text" class="form-control" placeholder="<?php echo $this->lang->line('mobile') ?>">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('country') ?></label>
                            <input name="country" value="<?php isset($thisEmployee) ? print $thisEmployee['country'] : '' ?>" type="text" class="form-control" placeholder="<?php echo $this->lang->line('country') ?>">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('region') ?></label>
                            <input name="region" value="<?php isset($thisEmployee) ? print $thisEmployee['region'] : '' ?>" type="text" class="form-control" placeholder="<?php echo $this->lang->line('region') ?>">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('city') ?></label>
                            <input name="city" value="<?php isset($thisEmployee) ? print $thisEmployee['city'] : '' ?>" type="text" class="form-control" placeholder="<?php echo $this->lang->line('city') ?>">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('area') ?></label>
                            <input name="area" value="<?php isset($thisEmployee) ? print $thisEmployee['area'] : '' ?>" type="text" class="form-control" placeholder="<?php echo $this->lang->line('area') ?>">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('street_address') ?></label>
                            <input name="street" value="<?php isset($thisEmployee) ? print $thisEmployee['street'] : '' ?>" type="text" class="form-control" placeholder="<?php echo $this->lang->line('street_address') ?>">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label>Join date</label>
                            <input name="join_date" value="<?php isset($thisEmployee) ? print $thisEmployee['join_date'] : '' ?>" id="employeeJoiningDate" type="text" class="form-control" placeholder="Joining Date">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('post') ?></label>
                            <input name="post" value="<?php isset($thisEmployee) ? print $thisEmployee['post'] : '' ?>" type="text" class="form-control" placeholder="<?php echo $this->lang->line('post') ?>">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('salary_amount') ?> </label>
                            <input name="salary" value="<?php isset($thisEmployee) ? print $thisEmployee['salary'] : '' ?>" type="text" class="form-control" placeholder="<?php echo $this->lang->line('salary_amount') ?>">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('department') ?> </label>
                            <select name="dept" class="form-control" onchange="getDepartmentManager(this.value)">
                                <option value="0"><?php echo $this->lang->line('select') ?></option>
                                <?php if (!empty($departments)): ?>
                                    <?php foreach ($departments as $aDept): ?>
                                        <option value="<?php echo $aDept->id ?>" <?php (isset($thisEmployee) && $aDept->id === $thisEmployee['dept']) ? print 'selected="selected"' : '' ?>><?php echo $aDept->title ?></option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('manager') ?> </label>
                            <select name="manager"class="form-control" id="departmentManager">
                                <option><?php echo $this->lang->line('select') ?></option>
                                <?php if (!empty($managers)): ?>
                                    <?php foreach ($managers as $aDeptManager): ?>
                                        <option value="<?php echo $aDeptManager->id ?>" <?php (isset($thisEmployee) && $aDeptManager->id === $thisEmployee['manager']) ? print 'selected="selected"' : '' ?>><?php echo $aDeptManager->title ?></option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('photo') ?></label>
                            <input type="file" name="photo" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="form-group">
                        <label><?php echo $this->lang->line('status') ?></label>
                        <div class="radio-group">
                            <label><input type="radio" name="status" value="3" <?php !empty($thisEmployee) && $thisEmployee['status'] == '3' ? print'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('active') ?>&nbsp;</label>
                            <label><input type="radio" name="status" value="2" <?php !empty($thisEmployee) && $thisEmployee['status'] == '2' ? print'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('inactive') ?>&nbsp;</label>
                        </div>
                    </div>
                    <div class="block-inner">
                        <div class="block text-center">
                            <?php if (isset($thisEmployee) && trim($thisEmployee['photo'])) : ?>
                                <img src="<?php echo EPOS_UPLOAD_PATH . $thisEmployee['photo'] ?>">
                                <span class="icon icon-trash text-right clearfix" onclick="removeEmployeePhoto('photo', '<?php echo $thisEmployee['photo'] ?>', 'employee', './uploads/', '<?php echo site_url('employee/removeEmployeePhoto/' . $thisEmployee['id']) ?>')">&nbsp;<?php echo $this->lang->line('remove') ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-group config-submit">
                <button type="submit" onclick="saveEmployee('employeeForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
            </div>
            <div class="setting-general-keyboard text-center"></div>
            <div class="clearfix padded-top-more text-right"><span class="icon icon-keyboard btn-keyboard-close" onclick="zamanToogleEposVirtualKeyboard('setting-general-keyboard')">&nbsp;<?php echo $this->lang->line('open_virtual_keyboard') ?></span></div>
        </div>
    </div>
</div>
<?php $this->load->view('settings/partials/footer') ?>
<script>
    $(document).ready(function () {
        $('#employeeDateOfBirth').datetimepicker({
            timepicker: false,
            format: 'd/m/Y',
            maxDate: '<?php echo date('d/m/Y', strtotime('today')) ?>',
            formatDate: 'Y/m/d'
        });
        $('#employeeJoiningDate').datetimepicker({
            timepicker: false,
            format: 'd/m/Y',
            formatDate: 'Y/m/d'
        });
    });
    function getDepartmentManager(department) {
        if (!$('.page-loader').is(":visible")) {
            var branch = $('#employeeBranch').val();
            if (Number(department) > 0) {
                if (checkInternetConnection()) {
                    $.ajax({
                        url: '<?php echo site_url('employee/getDepartmentManager') ?>',
                        type: 'post',
                        dataType: 'json',
                        data: {dept: department,branch: branch},
                        beforeSend: function (xhr) {
                            $('.page-loader').show();
                        },
                        success: function (response) {
                            $('.page-loader').hide();
                            if (response.status) {
                                var items = response.managers;
                                var html = '<option value="0">Select Manager</option>';
                                items.forEach(function (item) {
                                    html += '<option value="' + item.id + '">' + item.title + '</option>';
                                });
                                $('#departmentManager').html(html);
                            } else {
                                $('#departmentManager').html('');
                            }
                        }
                    });
                } else {
                    warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                }
            } else {
                alert('Select branch and department');
                $('#departmentManager').html('');
            }
        }
    }
    function saveEmployee(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                $('.page-loader').hide();
                                if (response.status) {
                                    zamanEposNavigator('', '<?php echo site_url('employee') ?>', '');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                }
                            }
                        });
                    } else {
                        warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                    }
                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                ignore: ":hidden",
                rules: {
                    first_name: {required: true, alphanumeric: true},
                    last_name: {required: true, alphanumeric: true},
                    gender: {required: true},
                    email: {required: true},
                    phone: {required: true},
                    mobile: {required: true},
                    branch: {required: true, number: true, min: 1},
                    dept: {required: true, number: true, min: 1},
                    manager: {required: true, number: true, min: 1}
                },
                messages: {
                    gender: 'Please Select Gender Type',
                    dept: 'Department is required',
                    manager: 'Select Manager',
                    branch: 'Please select Branch'
                },
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
    function removeEmployeePhoto(dbkey, dbimage, dbtable, path, url) {
        if (!$('.page-loader').is(":visible")) {
            if (checkInternetConnection()) {
                $.ajax({
                    url: url,
                    data: {dbkey: dbkey, image: dbimage, dbtable: dbtable, path: path},
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function (xhr) {
                        $('.page-loader').show();
                    },
                    success: function (response) {
                        $('.page-loader').show();
                        if (response.status) {
                            zamanEposNavigator('', '<?php echo site_url('employee/add/') ?>' + response.id, '');
                        } else {
                            warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('close') ?>');
                        }
                    }
                });
            } else {
                warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
            }
        }
    }
</script>
