<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane content-configuration">
            <div class="caption">
                <div class="tab-group secondary-navigation">
                    <div class="tab-item" onclick="zamanEposNavigator('', '<?php echo site_url('customer/add') ?>')"><span class="icon icon-user-add">&nbsp;<?php echo $this->lang->line('add_new') . ' ' . $this->lang->line('customer') ?></span></div>
                </div>
            </div>
            <table class="text-center report-table">
                <tr>
                    <th style="width: 15%">
                        <input type="text" value="<?php echo $filter['name'] ?>" list="customerName" id="filterName" name="name" class="form-control" placeholder="<?php echo $this->lang->line('name') ?>">
                        <datalist id="customerName">
                            <?php if (!empty($customerOptions)): ?>
                                <?php foreach ($customerOptions as $co): ?>
                                    <option value="<?php echo $co->name ?>">
                                    <?php endforeach; ?>
                                <?php endif; ?>
                        </datalist>
                    </th>
                    <th style="width: 15%">
                        <input type="text" value="<?php echo $filter['phone'] ?>" id="filterPhone" list="customerPhone" placeholder="<?php echo $this->lang->line('phone') ?>" class="form-control">
                        <datalist id="customerPhone">
                            <?php if (!empty($customerOptions)): ?>
                                <?php foreach ($customerOptions as $co): ?>
                                    <option value="<?php echo $co->phone ?>">
                                    <?php endforeach; ?>
                                <?php endif; ?>
                        </datalist>
                    </th>
                    <th style="width: 15%">
                        <select name="status" id="filterStatus" class="form-control">
                            <option value="0"><?php echo $this->lang->line('status') ?></option>
                            <option value="3" <?php $filter['status'] == '3' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('active') ?></option>
                            <option value="2" <?php $filter['status'] == '2' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('inactive') ?></option>
                        </select>
                        <input type="text" placeholder="<?php echo $this->lang->line('status') ?>" class="form-control">
                    </th>
                    <th style="width: 15%">
                        <select name="city" id="filterCity" class="form-control" onchange="getCityAreas(this.value)">
                            <option value=""><?php echo $this->lang->line('city') ?></option>
                            <?php if (!empty($branchAdjacentCities)): ?>
                                <?php foreach ($branchAdjacentCities as $abac): ?>
                                    <option value="<?php echo $abac->title ?>" <?php $filter['city'] == $abac->title ? print 'selected="selected"' : '' ?>><?php echo $abac->title ?></option>
                                <?php endforeach; ?>
                            <?php endif ?>
                        </select>
                    </th>
                    <th style="width: 15%">
                        <select class="form-control" name="area" id="filterArea">
                            <option value=""><?php echo $this->lang->line('area') ?></option>
                        </select>
                    </th>
                    <th colspan="4" style="border: none;"><span class="btn btn-large btn-primary" style="width: 100%" onclick="filterCustomer()"><?php echo $this->lang->line('filter') ?></span></th>
                </tr>
                <tr class="table-bg">
                    <th><?php echo $this->lang->line('name') ?></th>
                    <th><?php echo $this->lang->line('phone') ?></th>
                    <th><?php echo $this->lang->line('email') ?></th>
                    <th><?php echo $this->lang->line('username') ?></th>
                    <th><?php echo $this->lang->line('status') ?></th>
                    <th><?php echo $this->lang->line('area') ?></th>
                    <th><?php echo $this->lang->line('city') ?></th>
                     <th>Want offers?</th>
                    <th><?php echo $this->lang->line('edit') ?></th>
                </tr>
                <?php if (!empty($customers)): ?>
                    <?php foreach ($customers as $acustomer): ?>
                        <tr>
                            <td><?php echo $acustomer->name ?></td>
                            <td><?php echo $acustomer->phone ?></td>
                            <td><?php echo $acustomer->email ?></td>
                            <td><?php echo $acustomer->username ?></td>
                            <td><?php echo $acustomer->status == '3' ? $this->lang->line('active') : $this->lang->line('inactive') ?></td>
                            <td><?php echo $acustomer->area ?></td>
                            <td><?php echo $acustomer->city ?></td>
                            <td><?php echo $acustomer->is_interested ?></td>
                            <td><span class="icon icon-pencil" onclick="zamanEposNavigator('', '<?php echo site_url('customer/add/' . $acustomer->id) ?>')"></span></td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </table>
        </div>
    </div>
</div>
<?php $this->load->view('settings/partials/footer') ?>
<script>
    function filterCustomer() {
        var id = 0;
        var name = $.trim($('#filterName').val()) ? $('#filterName').val() : 0;
        var phone = $.trim($('#filterPhone').val()) ? $('#filterPhone').val() : 0;
        var email = $.trim($('#filterEmail').val()) ? $('#filterEmail').val() : 0;
        var status = $.trim($('#filterStatus').val()) ? $('#filterStatus').val() : 0;
        var city = $.trim($('#filterCity').val()) ? $('#filterCity').val() : 0;
        var area = $.trim($('#filterArea').val()) ? $('#filterArea').val() : 0;
        zamanEposNavigator('Customer List', '<?php echo site_url('customer/index/') ?>' + id + '/' + name + '/' + phone + '/' + email + '/' + status + '/' + city + '/' + area);
    }
    function getCityAreas(city) {
        $('#cityAreaList').html('');
        if ($.trim(city)) {
            $.ajax({
                url: '<?php echo site_url('settings/getCityAreas') ?>',
                type: 'post',
                dataType: 'json',
                data: {
                    city: city
                },
                beforeSend: function (xhr) {
                    $('.page-loader').show();
                },
                success: function (response) {
                    $('.page-loader').hide();
                    if (response.status) {
                        var items = response.areas;
                        var html = '<option value=""><?php echo $this->lang->line('area') ?></option>';
                        items.forEach(function (item) {
                            html += '<option value="' + item.title + '">' + item.title + '</option>';
                        });
                        $('#filterArea').html(html);
                    }
                }
            });
        } else {
            var html = '<option value="0"><?php echo sprintf($this->lang->line('not_found'), $this->lang->line('area')) ?></option>';
            $('#filterArea').html(html);
        }
    }
</script>
