<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Myaccount_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function saveCustomer($data, $id = null) {
        $this->_table_name = 'customer';
        $this->_primary_key = 'id';
        return $this->save($data, $id);
    }

    public function saveCustomerAddress($data, $id = null) {
        $this->_table_name = 'customer_address';
        $this->_primary_key = 'id';
        return $this->save($data, $id);
    }

    public function checkAddressType($column, $value, $update = 'no') {
        if ($update == 'yes') {
            $old = $this->input->post('old');
            if (trim(strtolower($old)) === trim(strtolower($value))) {
                return false;
            } else {
                return $this->doesAddressExist('customer_address', $column, $value);
            }
        } else {
            return $this->doesAddressExist('customer_address', $column, $value);
        }
    }

    private function doesAddressExist($table, $column, $value) {
        return $this->db->where(array($column => $value, 'cid' => $this->session->userdata('customerId')))->count_all_results($table) > 0;
    }

    public function saveOrder($data, $id = null) {
        $this->_table_name = 'order';
        $this->_primary_key = 'sid';
        return $this->save($data, $id);
    }

}
