<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Online_Template extends MY_Controller {

    public $serviceTime;
    public $isTheCustomerLoggedIn = false;
    protected $page_title = '';
    protected $site_title = '';
    protected $page_meta_keywords = '';
    protected $page_meta_description = '';
    protected $body_class = array();
    protected $current_section = '';
    public $restaurantInfo;
    public $extranalLinks;
    public $cartTotal;
    public $processOrder = false;
    public $openingTime;
    public $collection = false;
    public $delivery = false;

    public function __construct() {
        parent::__construct();
        $this->template->set_layout('online');
        $this->serviceTime = serviceTime();
        $this->restaurantInfo = $this->session->userdata('branch') ? (array) getRestaurantInfo($this->session->userdata('branch')) : (array) getRestaurantInfo();
        $this->extranalLinks = $this->session->userdata('branch') ? (array) getExtranalLinks($this->session->userdata('branch')) : (array) getExtranalLinks();
        $this->isTheCustomerLoggedIn = $this->My_Model->isCustomerLoggedIn();
        $this->site_title = $this->config->item('general_name');
        $this->page_title = $this->config->item('general_name');
        $this->current_section = $this->page_title;
        $this->page_meta_keywords = $this->config->item('general_name');
        $this->page_meta_description = $this->config->item('general_name');
        $apiObj = $this->My_Model->get_single('apisetting', array('branch' => $this->session->userdata('branch')))->row();
        if (!empty($apiObj)) {
            $this->restaurantInfo['apiKey'] = $apiObj->apiKey;
            $this->restaurantInfo['captchaSiteKey'] = $apiObj->captchaSiteKey;
            $this->restaurantInfo['captchaSecretKey'] = $apiObj->captchaSecretKey;
        }
        $this->getOpeningTime();
    }

    public function getOpeningTime() {
        $serviceTime = $this->serviceTime;
        $todayServiceTime = array();
        if (!empty($serviceTime)) {
            foreach ($serviceTime as $st) {
                $manageSt = array(
                    'start' => $st[date('D')]->start,
                    'end' => $st[date('D')]->end,
                    'service' => $st[date('D')]->service
                );
                array_push($todayServiceTime, $manageSt);
            }
        }
        if (!empty($todayServiceTime)) {
            $choosenStart = $todayServiceTime[0]['start'];
            $choosenStartTimestamp = strtotime(date('h:i a', strtotime($choosenStart)));
            $nowTime = strtotime(date('h:i a'));
            foreach ($todayServiceTime as $time) {
                $thisStartTimestamp = strtotime(date('h:i a', strtotime($time['start'])));
                if ($thisStartTimestamp >= $nowTime && $thisStartTimestamp >= $choosenStartTimestamp) {
                    $choosenStart = $time['start'];
                }
                if (strpos($time['service'], 'online')) {
                    $this->collection = strpos($time['service'], 'collection') !== false;
                    $this->delivery = strpos($time['service'], 'delivery') !== false;
                }
            }
            $this->openingTime = $choosenStart;
        }
    }

    public function render($page, $data = array()) {
        $this->template
                ->set_metadata('keywords', $this->page_meta_keywords)
                ->set_metadata('description', $this->page_meta_description)
                ->set_metadata('canonical', site_url($this->uri->uri_string()), 'link')
                ->title($this->page_title, $this->site_title)
                ->set('current_section', $this->current_section)
                ->set('restaurantInfo', $this->restaurantInfo)
                ->set('extranalLinks', $this->extranalLinks)
                ->set('isTodayOpened', isTodayOpened())
                ->set('openingTime', $this->openingTime)
                ->set('hasCollection', $this->collection)
                ->set('hasDelivery', $this->delivery)
                ->set('processOrder', $this->processOrder)
                ->set('cartTotal', $this->cartTotal)
                ->set('body_class', implode(' ', $this->body_class))
                ->set_partial('header', 'components/header')
                ->set_partial('flash', 'components/flash')
                ->set_partial('footer', 'components/footer')
                ->build($page, $data);
    }

}
